/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.WsGenericAttributesModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class WsGenericAttributesPanel
extends WAPanel
implements TableModelListener {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WsGenericAttributesPanel.class);
    private JScrollPane spane = new JScrollPane();
    private JPanel panel = new JPanel();
    private WsGenericAttributesModel data_model;
    private WATable data_table;
    private CMetadata m_metadata = null;
    private boolean titleViewable = true;
    private boolean borderViewable = false;
    private boolean titleInBorder = false;
    private boolean inDDE = false;
    protected EventListenerList listenerList = new EventListenerList();

    public WsGenericAttributesPanel(CMetadata metaObject) {
        this(metaObject, true, false, false);
    }

    public WsGenericAttributesPanel(CMetadata metaObject, boolean showTitle, boolean titleAsBorder, boolean showBorder) {
        try {
            this.m_metadata = metaObject;
            this.titleViewable = showTitle;
            this.borderViewable = showBorder;
            this.titleInBorder = titleAsBorder;
            this.initialize();
            this.layoutWidgets();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void initialize() {
        this.setHelpTopic("advanced_tab");
        this.setHelpProduct("shared");
        this.data_model = new WsGenericAttributesModel(this.m_metadata);
        this.data_table = new WATable(this.data_model);
        this.data_table.setSelectionMode(0);
        this.data_table.setAutoResizeMode(1);
        this.data_table.setCellSelectionEnabled(true);
        this.data_table.getTableHeader().setReorderingAllowed(true);
        this.data_model.addTableModelListener(this);
    }

    @Override
    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        if (this.titleViewable) {
            if (this.borderViewable) {
                if (this.titleInBorder) {
                    this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), bundle.getString("WsGenericGeneralPropertyTab.attrname.txt")));
                } else {
                    this.setBorder(new EtchedBorder(Color.white, new Color(134, 134, 134)));
                }
            } else {
                JLabel nameLabel = new JLabel(bundle.getString("WsGenericGeneralPropertyTab.attrname.txt"));
                nameLabel.setToolTipText(bundle.getString("WsGenericGeneralPropertyTab.attr.ToolTip.txt"));
                nameLabel.setDisplayedMnemonic(bundle.getString("WsGenericGeneralPropertyTab.attr.mnem").charAt(0));
                nameLabel.setLabelFor(this.data_table);
                this.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
        this.data_table.setPreferredScrollableViewportSize(new Dimension(350, 125));
        this.spane.getViewport().add(this.data_table);
        this.spane.setPreferredSize(new Dimension(350, 125));
        this.panel.setLayout(new GridBagLayout());
        this.panel.setToolTipText(bundle.getString("WsGenericGeneralPropertyTab.attr.ToolTip.txt"));
        this.panel.add((Component)this.spane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.panel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.data_table.setVisible(true);
        this.spane.setVisible(true);
        this.panel.setVisible(true);
        this.data_table.repaint();
    }

    @Override
    public boolean validateData() {
        try {
            int rows = this.data_model.getRowCount();
            Map attrs = this.m_metadata.getAttrs();
            boolean updated_attr = false;
            for (int i = 0; i < rows; ++i) {
                String value = (String)this.data_model.getValueAt(i, 1);
                String name = (String)this.data_model.getValueAt(i, 0);
                String oldvalue = (String)attrs.get(name);
                if (value == null || oldvalue == null || value.compareTo(oldvalue) == 0) continue;
                this.setValue(name, value);
                updated_attr = true;
            }
            if (updated_attr) {
                MdEvent mod = new MdEvent((Object)this);
                this.m_metadata.fireMdObjectModified(mod);
                mod = null;
            }
            return true;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
            return false;
        }
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        this.inDDE = true;
        if (bSaveToModel) {
            int rows = this.data_model.getRowCount();
            Map attrs = this.m_metadata.getAttrs();
            for (int i = 0; i < rows; ++i) {
                String value = (String)this.data_model.getValueAt(i, 1);
                String name = (String)this.data_model.getValueAt(i, 0);
                String oldvalue = (String)attrs.get(name);
                if (value == null || oldvalue == null || value.compareTo(oldvalue) == 0) continue;
                this.setValue(name, value);
            }
            this.setDataChanged(false);
        } else {
            this.data_model.setupModel();
        }
        this.inDDE = false;
        return true;
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
    }

    @Override
    public void setEditable(boolean bEditable) {
        this.data_model.setModelEditable(bEditable);
    }

    private void setValue(String name, String value) throws RemoteException {
        if (this.m_metadata != null) {
            String methodname = "set" + name;
            try {
                Object[] args = new Object[]{value};
                Class[] classes = new Class[]{String.class};
                Method method = this.m_metadata.getClass().getMethod(methodname, classes);
                try {
                    method.invoke((Object)this.m_metadata, args);
                }
                catch (InvocationTargetException e) {
                    Workspace.getDefaultLogger().error((Object)("WsGenericAttributesPanel::setValue - Error calling method on object: " + this.m_metadata.getFQID()), e);
                }
                catch (IllegalAccessException e) {
                    Workspace.getDefaultLogger().error((Object)("WsGenericAttributesPanel::setValue - Access error on method: " + methodname + "on object: " + this.m_metadata.getFQID()), e);
                }
            }
            catch (NoSuchMethodException e) {
                Workspace.getDefaultLogger().error("WsGenericAttributesPanel::setValue: Can't set attribute " + name + " on object");
            }
        }
    }

    @Override
    public boolean hasDataChanged() {
        try {
            int rows = this.data_model.getRowCount();
            Map attrs = this.m_metadata.getAttrs();
            boolean updated_attr = false;
            for (int i = 0; i < rows; ++i) {
                String value = (String)this.data_model.getValueAt(i, 1);
                String name = (String)this.data_model.getValueAt(i, 0);
                String oldvalue = (String)attrs.get(name);
                if (value == null || oldvalue == null || value.compareTo(oldvalue) == 0) continue;
                this.setValue(name, value);
                updated_attr = true;
            }
            if (updated_attr) {
                return true;
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        return false;
    }

    public void MdObjectModified(MdEvent e) {
        Object source = e.getSource();
        if (source instanceof CMetadata) {
            try {
                String FQID = ((CMetadata)source).getFQID();
                if (FQID.equals(this.m_metadata.getFQID()) && !this.inDDE) {
                    this.inDDE = true;
                    this.data_model.setupModel();
                    this.inDDE = false;
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (!e.getSource().equals(this.data_model) && !this.inDDE) {
            this.data_model.setupModel();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.inDDE) {
            this.inDDE = true;
            this.fireStateChanged(new ChangeEvent(this));
            this.setDataChanged(true);
            this.inDDE = false;
        }
    }

    public void fireStateChanged(ChangeEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }
}

