/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.workspace.WAPasswordField;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.visuals.WsEngineSpecificPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class WsDB2UDBPanel
extends WsEngineSpecificPanel {
    private static final long serialVersionUID = 1L;
    protected WATextField m_userField = new WATextField();
    protected WAPasswordField m_passwordField = new WAPasswordField();
    protected WATextField m_schemaField = new WATextField();
    protected JLabel userLabel;
    protected JLabel passLabel;
    protected JLabel schemaLabel;
    private static WAdminResource bundle = WAdminResource.getBundle(WsDB2UDBPanel.class);

    public WsDB2UDBPanel() {
        this._initialize();
        this._layoutWidgets();
    }

    @Override
    protected void _initialize() {
        super._initialize();
        this.userLabel = new JLabel(bundle.getString("Label.Username.txt"));
        this.passLabel = new JLabel(bundle.getString("Label.Password.txt"));
        this.schemaLabel = new JLabel(bundle.getString("WsDB2UDBPanel.Label.schema.txt"));
        this.userLabel.setDisplayedMnemonic(bundle.getString("Label.Username.mnem").charAt(0));
        this.passLabel.setDisplayedMnemonic(bundle.getString("Label.Password.mnem").charAt(0));
        this.schemaLabel.setDisplayedMnemonic(bundle.getString("WsDB2UDBPanel.Label.schema.mnem").charAt(0));
        this.m_userField.setToolTipText(bundle.getString("UsernameToolTip.txt"));
        this.m_passwordField.setToolTipText(bundle.getString("PasswordToolTip.txt"));
        this.m_schemaField.setToolTipText(bundle.getString("WsDB2UDBPanel.schemaToolTip.txt"));
    }

    protected void _layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(bundle.getString("ConnectionBorder.txt")));
        this.add((Component)this.userLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.m_userField, new GridBagConstraints(1, 0, 6, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.passLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.m_passwordField, new GridBagConstraints(1, 1, 6, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.schemaLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.m_schemaField, new GridBagConstraints(1, 2, 6, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.standoptlabel, new GridBagConstraints(0, 4, 7, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.m_optionsPanel, new GridBagConstraints(0, 5, 7, 2, 1.0, 1.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    public void disableDB2UDBPanel() {
        this.m_userField.setEditable(false);
        this.m_passwordField.setEditable(false);
        this.m_schemaField.setEditable(false);
    }

    public void enableDB2UDBPanel() {
        this.m_userField.setEditable(true);
        this.m_passwordField.setEditable(true);
        this.m_schemaField.setEditable(true);
    }

    public void setupPanel(String userName, String password, String schema) {
        this.m_userField.setText(userName);
        this.m_passwordField.setText(password);
        this.m_schemaField.setText(schema);
    }

    public String getUsernameParams() {
        return this.m_userField.getText();
    }

    public String getPassParams() {
        return new String(this.m_passwordField.getPassword());
    }

    public String getSchemaParams() {
        if (this.m_schemaField.getText().equals("")) {
            return " ";
        }
        return " DATASRC=" + this.m_schemaField.getText();
    }
}

