/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsStatusBarUtilities;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class WsAppServerPanel
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WsAppServerPanel.class);
    public static final String APPSERVER_CHANGED = "AppServerChanged";
    public static String Local = bundle.getString("WsAppServerPanel.Label.Local");
    private static String DEFAULT_SERVER = bundle.getString("WsAppServerPanel.Label.Default.txt");
    private JLabel m_lblDescription;
    private JSeparator m_sepDescription;
    private WAComboBox m_cmbServers;
    private JLabel m_lblServers;
    private WsAbstractAction m_actTestConnection;
    private JButton m_btnTestConnection;
    private ServerContextInterface[] m_servers;
    private String m_sServerName;
    private String m_sServerFQID;
    private String m_sOriginalFQID;
    private ServerContextInterface m_oServer;
    private boolean m_bShowTestButton;
    private boolean m_bUpdateDefault;
    private boolean m_bWillSetDataChanged;
    private boolean m_bDisplayLocal;
    private boolean m_bDisplayDefault;
    private ItemListener m_lsnrAppServerSelection;
    private WsAppServer m_wsAppServer;
    private ChildServerInterface m_detachedServer;
    private MdObjectStore m_returnStore;

    public WsAppServerPanel() {
        this((String)null);
    }

    public WsAppServerPanel(String sDescription) {
        this(sDescription, true);
    }

    public WsAppServerPanel(String sDescription, boolean bShowTestButton) {
        this.setUpdateDefault(false);
        this.setWillSetDataChanged(true);
        this.m_bShowTestButton = bShowTestButton;
        this.setDisplayLocal(false);
        this.setHelpProduct("shared");
        this.setHelpTopic("server_tab");
        this.initialize(sDescription);
    }

    protected void initialize(String sDescription) {
        if (sDescription != null) {
            this.m_lblDescription = new JLabel(sDescription);
            this.m_sepDescription = new JSeparator();
        }
        this.m_cmbServers = new WAComboBox();
        this.m_cmbServers.setPrototypeDisplayValue("THIS IS JUST FOR SIZING m_cmbServers COMPONENT     ");
        this.m_lsnrAppServerSelection = new cAppServerSelectionListener();
        this.m_cmbServers.addItemListener(this.m_lsnrAppServerSelection);
        this.listenForDataChangesTo(this.m_cmbServers);
        this.m_lblServers = WsUIUtilities.createLabelAndToolTipForComponent(this.m_cmbServers, bundle, "WsAppServerPanel.Label.Server");
        this.m_actTestConnection = new cTestAction();
        this.m_btnTestConnection = new JButton(this.m_actTestConnection);
        this.m_btnTestConnection.setVisible(this.m_bShowTestButton);
        this.setLayout(new GridBagLayout());
        if (sDescription != null) {
            this.add((Component)this.m_lblDescription, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.m_sepDescription, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 10, 0), 0, 0));
        }
        this.add((Component)this.m_lblServers, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_cmbServers, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.m_btnTestConnection, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setUpdateDefault(boolean bUpdate) {
        this.m_bUpdateDefault = bUpdate;
    }

    public boolean willUpdateDefault() {
        return this.m_bUpdateDefault;
    }

    public void setWillSetDataChanged(boolean bWillSetDataChanged) {
        this.m_bWillSetDataChanged = bWillSetDataChanged;
    }

    public boolean willSetDataChanged() {
        return this.m_bWillSetDataChanged;
    }

    public void setDisplayLocal(boolean bDisplayLocal) {
        this.m_bDisplayLocal = bDisplayLocal;
    }

    public boolean displayLocal() {
        return this.m_bDisplayLocal;
    }

    public void setDisplayDefault(boolean bDisplayDefault) {
        this.m_bDisplayDefault = bDisplayDefault;
    }

    public boolean isDisplayDefault() {
        return this.m_bDisplayDefault;
    }

    public void setSelectedServerFQID(String sFQID) {
        this.m_sServerFQID = sFQID;
    }

    public String getSelectedServerFQID() {
        if (this.m_bDisplayLocal && this.isLocalHostSelected()) {
            return null;
        }
        return this.m_sServerFQID;
    }

    public ServerContext getSelectedServer() {
        if (this.m_returnStore == null) {
            throw new IllegalStateException("A return store must be specified using the setReturnStore method.");
        }
        try {
            ServerContext mdSC = (ServerContext)Workspace.getMdFactory().createComplexMetadataObject(this.m_returnStore, this.m_sServerName, "ServerContext", this.m_sServerFQID);
            return mdSC;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
            return null;
        }
    }

    public void setReturnStore(MdObjectStore store) {
        this.m_returnStore = store;
    }

    public WsAppServer getAppServer() {
        ServerContextInterface oServer = this.getSelectedOMRServerObject();
        if (oServer == null) {
            return null;
        }
        if (this.m_wsAppServer != null) {
            try {
                String selectedServerFQID = oServer.getIdentifier();
                String currentServerFQID = this.m_wsAppServer.getServerFQID();
                if (currentServerFQID.compareTo(selectedServerFQID) != 0) {
                    this.m_wsAppServer = WsAppServer.createAppServer(oServer);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage(ex);
            }
        } else {
            this.m_wsAppServer = WsAppServer.createAppServer(oServer);
        }
        return this.m_wsAppServer;
    }

    public boolean isLocalHostSelected() {
        String sSelectedItem;
        Object selectedItem = this.m_cmbServers.getSelectedItem();
        return selectedItem instanceof String && (sSelectedItem = (String)selectedItem).equalsIgnoreCase(Local);
    }

    public void setServerComboBoxToolTipText(String sToolTipText) {
        this.m_cmbServers.setToolTipText(sToolTipText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test() {
        block18: {
            ServerContextInterface oServer = this.getSelectedOMRServerObject();
            if (oServer == null) {
                return false;
            }
            WsAppServer srvr = WsAppServer.createAppServer(oServer);
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
            try {
                srvr.validateDefinition();
                if (this.m_bUpdateDefault && !oServer.getIdentifier().equals(this.m_sOriginalFQID)) {
                    srvr.removeCredentials();
                }
                try {
                    srvr.test();
                    MessageUtil.displayMessage(bundle.getString("WsAppServerPanel.ConnectionOK.txt"), 1);
                    boolean bl = true;
                    return bl;
                }
                catch (WsAppServerFailException ex) {
                    block17: {
                        try {
                            if (ex.hasDetailMessage()) {
                                MessageUtil.displayDetailsMessage(ex.getLocalizedMessage(), 0, ex.getDetailMessage());
                                break block17;
                            }
                            MessageUtil.displayMessage(ex.getMessage(), 0);
                        }
                        catch (WsAppServerFailException ex2) {
                            MessageUtil.displayMessage(bundle.getString("WsAppServerPanel.InvalidServerDefinition.txt"), 0);
                            break block18;
                        }
                        catch (MdException ex3) {
                            MessageUtil.displayMetadataExceptionMessage(ex3, "Reading");
                            break block18;
                        }
                        catch (RemoteException re) {
                            Workspace.handleRemoteException(re);
                            break block18;
                        }
                        catch (ServiceException se) {
                            MessageUtil.displayServiceExceptionMessage(se);
                            break block18;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    this.getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
                    srvr.dispose();
                }
            }
            finally {
                this.getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
                srvr.dispose();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateData() {
        if (this.m_cmbServers.getItemCount() == 0) {
            return true;
        }
        ServerContextInterface oServer = this.getSelectedOMRServerObject();
        if (oServer == null && this.m_bDisplayLocal) {
            return true;
        }
        if (oServer == null && !this.m_bDisplayLocal) {
            return false;
        }
        WsAppServer srvr = WsAppServer.createAppServer(oServer);
        try {
            srvr.validateDefinition();
            if (this.m_bUpdateDefault && !oServer.getIdentifier().equals(this.m_sOriginalFQID)) {
                srvr.removeCredentials();
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        catch (ServiceException re) {
            MessageUtil.displayServiceExceptionMessage(re);
        }
        catch (WsAppServerFailException e) {
            String sMessage = bundle.getString("WsAppServerPanel.InvalidServerSelectionConfirmation.txt");
            int eAnswer = MessageUtil.displayMessage(sMessage, 2, 0);
            if (eAnswer != 1) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            srvr.dispose();
        }
        return true;
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            this.populateStore();
            this.moveDataToView();
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    @Override
    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        try {
            if (this.m_detachedServer == null) {
                this.m_detachedServer = Workspace.getWorkspace().getUserContext().getAuthServer().newChild(true);
            }
            this.m_servers = WsAppServer.getAppServers((ServerInterface)this.m_detachedServer);
            Collections.sort(Arrays.asList(this.m_servers), new cServerComparator());
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        this.setStorePopulated(true);
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_cmbServers.removeAllItems();
        if (this.m_bDisplayDefault) {
            this.m_cmbServers.addItem(DEFAULT_SERVER);
        }
        if (this.m_bDisplayLocal) {
            this.m_cmbServers.addItem(Local);
        }
        for (int index = 0; index < this.m_servers.length; ++index) {
            this.m_cmbServers.addItem(new DisplayableOMRServerContext(this.m_servers[index].getName(), this.m_servers[index]));
        }
        if (this.m_cmbServers.getItemCount() > 0) {
            String defaultAppServerFQID = WsAppServer.getDefaultAppServerFQID();
            int iServer = -1;
            if (this.m_sServerFQID != null) {
                iServer = this.findServer(this.m_sServerFQID);
            }
            if (iServer == -1) {
                iServer = this.findServer(defaultAppServerFQID);
                if (this.m_bDisplayDefault && iServer != -1) {
                    iServer = this.m_cmbServers.getIndexOf(DEFAULT_SERVER);
                }
            }
            if (iServer == -1) {
                iServer = 0;
            }
            this.m_cmbServers.setSelectedIndex(iServer);
            this.m_actTestConnection.setEnabled(!this.isLocalHostSelected());
            ServerContextInterface oServer = this.getSelectedOMRServerObject();
            try {
                if (oServer != null) {
                    this.m_sOriginalFQID = oServer.getIdentifier();
                }
            }
            catch (ServiceException se) {
                MessageUtil.displayServiceExceptionMessage(se);
            }
        } else {
            this.m_actTestConnection.setEnabled(false);
        }
        this.setListeningForChanges(this.m_bWillSetDataChanged);
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        this.m_oServer = this.getSelectedOMRServerObject();
        if (this.m_oServer == null) {
            return;
        }
        try {
            this.m_sServerName = this.m_oServer.getName();
            this.m_sServerFQID = this.m_oServer.getIdentifier();
            if (this.m_bUpdateDefault) {
                WsAppServer.setDefaultAppServerFQID(this.m_sServerFQID);
                if (WsStatusBarUtilities.isAppserverPanelShown()) {
                    WsStatusBarUtilities.updateAppserverPanel();
                }
            }
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage(se);
        }
    }

    private int findServer(String sFQID) {
        for (int iServer = 0; iServer < this.m_cmbServers.getItemCount(); ++iServer) {
            Object item = this.m_cmbServers.getItemAt(iServer);
            if (sFQID.equalsIgnoreCase(Local) && item instanceof String) {
                String serverFQID = (String)item;
                if (!serverFQID.equalsIgnoreCase(sFQID)) continue;
                return iServer;
            }
            if (!(item instanceof DisplayableOMRServerContext)) continue;
            ServerContextInterface oServer = ((DisplayableOMRServerContext)item).getOMRServerContext();
            try {
                if (!oServer.getIdentifier().equals(sFQID)) continue;
                return iServer;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
                continue;
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage(ex);
            }
        }
        return -1;
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        try {
            if (this.m_detachedServer != null) {
                this.m_detachedServer.rollback();
            }
            Workspace.getMdFactory().dumpDetailHashMap();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_cmbServers.setEnabled(bEditable);
    }

    protected ServerContext getSelectedServerObject() {
        try {
            ServerContextInterface serverContext = this.getSelectedOMRServerObject();
            if (serverContext == null) {
                return null;
            }
            return (ServerContext)serverContext.getRepositoryEntity();
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
            return null;
        }
    }

    protected ServerContextInterface getSelectedOMRServerObject() {
        Object selectedItem = this.m_cmbServers.getSelectedItem();
        if (selectedItem == null || selectedItem.equals(Local)) {
            return null;
        }
        try {
            if (!(selectedItem instanceof DisplayableOMRServerContext)) {
                return null;
            }
            String selectedServerID = ((DisplayableOMRServerContext)selectedItem).getOMRServerContext().getIdentifier();
            for (int index = 0; index < this.m_servers.length; ++index) {
                if (!this.m_servers[index].getIdentifier().equals(selectedServerID)) continue;
                return this.m_servers[index];
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage(se);
        }
        return null;
    }

    private class DisplayableOMRServerContext {
        private ServerContextInterface m_serverContext;
        private String m_name;

        public DisplayableOMRServerContext(String name, ServerContextInterface serverContext) {
            this.m_name = name;
            this.m_serverContext = serverContext;
        }

        public ServerContextInterface getOMRServerContext() {
            return this.m_serverContext;
        }

        public String toString() {
            return this.m_name;
        }
    }

    private class cAppServerSelectionListener
    implements ItemListener {
        private cAppServerSelectionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            WsAppServerPanel.this.firePropertyChange(WsAppServerPanel.APPSERVER_CHANGED, WsAppServerPanel.this.m_wsAppServer, WsAppServerPanel.this.getSelectedServerObject());
            WsAppServerPanel.this.m_actTestConnection.setEnabled(!WsAppServerPanel.this.m_bDisplayLocal || !WsAppServerPanel.this.isLocalHostSelected());
        }
    }

    private class cTestAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cTestAction() {
            super(bundle, "WsAppServerPanel.Action.TestConnection", false, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsAppServerPanel.this.test();
        }
    }

    private class cServerComparator
    implements Comparator {
        private cServerComparator() {
        }

        public int compare(Object object1, Object object2) {
            ServerContextInterface server1 = (ServerContextInterface)object1;
            ServerContextInterface server2 = (ServerContextInterface)object2;
            try {
                return server1.getName().compareTo(server2.getName());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
                return 0;
            }
        }
    }
}

