/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.app.PickList;
import com.sas.app.Plugin;
import com.sas.app.Repository;
import com.sas.app.RepositoryException;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.LegalNoticeDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class WsAboutBox
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected JPanel m_pnlMain;
    protected JLabel m_lblTitle;
    protected JScrollPane m_scrENVinfo;
    protected JScrollPane m_scrPRSinfo;
    protected JScrollPane m_scrJARinfo;
    protected String m_sVJRPluginName;
    protected JLabel m_lblIcon;
    protected JButton m_btnOk;
    protected JButton m_btnLegal;
    protected Vector m_vEnvironmentInfo;
    protected Vector m_vManifestInfo;
    private WAdminResource m_parentbundle;
    private static final WAdminResource m_bundle = WAdminResource.getBundle(WsAboutBox.class);
    protected static Color SAS_BLUE = new Color(0, 49, 156);
    protected static Color DRK_BLUE = new Color(26, 8, 128);
    private String m_sCopyright;
    private String m_sThirdPartyNotices;
    private String m_sVersion;
    String[] m_sEnvArray = new String[]{m_bundle.getString("WsAboutBox.label.versioninfo.txt"), m_bundle.getString("WsAboutBox.label.OSVersion.txt"), m_bundle.getString("WsAboutBox.label.Architecture.txt"), m_bundle.getString("WsAboutBox.label.JREVersion.txt"), m_bundle.getString("WsAboutBox.label.JREPath.txt"), m_bundle.getString("WsAboutBox.label.ServerVersion.txt"), m_bundle.getString("WsAboutBox.label.CurrentUser.txt"), m_bundle.getString("WsAboutBox.label.UserHome.txt"), m_bundle.getString("WsAboutBox.label.WorkingDir.txt")};
    String[] m_sKeyArray = new String[]{m_bundle.getString("WsAboutBox.label.Extension-Name.txt"), m_bundle.getString("WsAboutBox.label.Main-Class.txt"), m_bundle.getString("WsAboutBox.label.Implementation-Version.txt"), m_bundle.getString("WsAboutBox.label.Implementation-Title.txt"), m_bundle.getString("WsAboutBox.label.Implementation-Vendor.txt"), m_bundle.getString("WsAboutBox.label.Implementation-Vendor-Id.txt"), m_bundle.getString("WsAboutBox.label.Specification-Version.txt"), m_bundle.getString("WsAboutBox.label.Specification-Title.txt"), m_bundle.getString("WsAboutBox.label.Specification-Vendor.txt"), m_bundle.getString("WsAboutBox.label.Manifest-Version.txt")};

    public WsAboutBox(ImageIcon icon, String title, WAdminResource bundle, String sJarName) {
        this(Workspace.getWorkspace(), icon, title, sJarName);
        this.m_parentbundle = bundle;
    }

    public WsAboutBox(JFrame frmParent, Icon icon, String title, String sVJRPluginName, String sVersion) {
        super(frmParent, title, true);
        this.m_lblIcon = new JLabel();
        this.m_lblIcon.setIcon(icon);
        this.m_sVJRPluginName = sVJRPluginName;
        this.m_sVersion = sVersion;
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.initialize();
        this.layoutWidgets();
        this.pack();
        this.center();
    }

    public WsAboutBox(JFrame frmParent, Icon icon, String title, String sVJRPluginName) {
        this(frmParent, icon, title, sVJRPluginName, null);
    }

    public void setCopyright(String sCopyright) {
        this.m_sCopyright = sCopyright;
    }

    public String getCopyright() {
        return this.m_sCopyright;
    }

    public void setThirdPartyNotices(String sNotices) {
        this.m_sThirdPartyNotices = sNotices;
    }

    public String getThirdPartyNotices() {
        return this.m_sThirdPartyNotices;
    }

    protected void initialize() {
        this.m_pnlMain = new JPanel();
        this.m_lblTitle = new JLabel();
        this.m_btnOk = new JButton(m_bundle.getString("Common.OK.txt"));
        this.m_btnOk.addActionListener(this);
        this.m_btnOk.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.m_btnOk.getActionMap().put("cancel", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WsAboutBox.this.dispose();
            }
        });
        this.m_btnLegal = new JButton(m_bundle.getString("Common.LegalNotices.txt"));
        this.m_btnLegal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String copyright = WsAboutBox.this.m_parentbundle != null ? WsAboutBox.this.m_parentbundle.getString("aboutDialog.copyright.txt") : WsAboutBox.this.m_sCopyright;
                String thirdParty = WsAboutBox.this.m_parentbundle != null ? WsAboutBox.this.m_parentbundle.getRawString("aboutDialog.thirdPartyInfo.txt") : WsAboutBox.this.m_sThirdPartyNotices;
                LegalNoticeDialog legalDialog = new LegalNoticeDialog(WsAboutBox.this, copyright, thirdParty);
                legalDialog.setVisible(true);
            }
        });
        this.m_scrENVinfo = new JScrollPane();
        this.m_scrENVinfo.setBackground(SystemColor.control);
        this.m_scrENVinfo.getViewport().setBackground(SystemColor.control);
        this.m_scrENVinfo.setBorder(BorderFactory.createTitledBorder(m_bundle.getString("WsAboutBox.label.ENVinfo.txt")));
        this.m_vEnvironmentInfo = this.getEnvironmentInfo();
        JList tmpList = new JList(this.m_vEnvironmentInfo);
        tmpList.setBackground(SystemColor.control);
        this.m_scrENVinfo.getViewport().add(tmpList);
        this.m_scrPRSinfo = new JScrollPane();
        this.m_scrPRSinfo.setBackground(SystemColor.control);
        this.m_scrPRSinfo.getViewport().setBackground(SystemColor.control);
        this.m_scrPRSinfo.setBorder(BorderFactory.createTitledBorder(m_bundle.getString("WsAboutBox.label.PRSinfo.txt")));
        Manifest wadminManifest = null;
        Plugin[] loadVJRPlugins = new Plugin[]{};
        try {
            loadVJRPlugins = Repository.getDefaultRepository().find(new PickList((Reader)new FileReader(new File(Workspace.getWorkspace().getInstallDir() + File.separatorChar + "picklist"))));
            for (int i = 0; i < loadVJRPlugins.length; ++i) {
                if (!loadVJRPlugins[i].getName().equals(this.m_sVJRPluginName)) continue;
                wadminManifest = loadVJRPlugins[i].getBundleManifest();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_vManifestInfo = wadminManifest == null ? this.setDummyManifestInfo() : this.getManifestInfo(wadminManifest);
        tmpList = new JList(this.m_vManifestInfo);
        tmpList.setBackground(SystemColor.control);
        if (this.m_vManifestInfo.size() > 0) {
            this.m_scrPRSinfo.getViewport().add(tmpList);
        }
        this.m_scrJARinfo = new JScrollPane();
        this.m_scrJARinfo.setBackground(SystemColor.control);
        this.m_scrJARinfo.getViewport().setBackground(SystemColor.control);
        this.m_scrJARinfo.setBorder(BorderFactory.createTitledBorder(m_bundle.getString("WsAboutBox.label.JARinfo.txt")));
        Vector jarlist = this.getJarfileInfo(loadVJRPlugins);
        tmpList = new JList(jarlist);
        tmpList.setBackground(SystemColor.control);
        if (jarlist.size() > 0) {
            this.m_scrJARinfo.getViewport().add(tmpList);
        }
        Font fntLabel = this.m_lblTitle.getFont();
        Font fntTitle = fntLabel.deriveFont(0, (float)((double)fntLabel.getSize() * 1.5));
        this.m_lblTitle.setFont(fntTitle);
    }

    protected void layoutWidgets() {
        this.m_pnlMain.setLayout(new GridBagLayout());
        this.m_pnlMain.add((Component)this.m_lblIcon, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlMain.add((Component)this.m_scrENVinfo, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.m_pnlMain.add((Component)this.m_scrPRSinfo, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.m_pnlMain.add((Component)this.m_scrJARinfo, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.m_pnlMain.add((Component)this.m_btnOk, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.m_pnlMain.add((Component)this.m_btnLegal, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 10, 10), 0, 0));
        this.m_pnlMain.setPreferredSize(new Dimension(this.m_lblIcon.getPreferredSize().width, this.m_pnlMain.getPreferredSize().height));
        this.setContentPane(this.m_pnlMain);
        this.getRootPane().setDefaultButton(this.m_btnOk);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_btnOk) {
            this.dispose();
        }
    }

    private Vector getEnvironmentInfo() {
        Vector<String> vecEnvInfo = new Vector<String>();
        for (int i = 0; i < this.m_sEnvArray.length; ++i) {
            String strEnvKey = this.m_sEnvArray[i];
            if (strEnvKey.compareTo(m_bundle.getString("WsAboutBox.label.versioninfo.txt")) == 0) {
                if (this.m_sVersion != null) {
                    vecEnvInfo.addElement(this.m_sVersion);
                    continue;
                }
                vecEnvInfo.addElement(strEnvKey + m_bundle.getString("Common.Equal.txt") + Workspace.getWorkspace().getApplicationVersionNumber());
                continue;
            }
            if (strEnvKey.compareTo(m_bundle.getString("WsAboutBox.label.OSVersion.txt")) == 0) {
                vecEnvInfo.addElement(strEnvKey + m_bundle.getString("Common.Equal.txt") + System.getProperty("os.name") + " " + System.getProperty("os.version"));
                continue;
            }
            if (strEnvKey.compareTo(m_bundle.getString("WsAboutBox.label.Architecture.txt")) == 0) {
                vecEnvInfo.addElement(strEnvKey + m_bundle.getString("Common.Equal.txt") + System.getProperty("os.arch"));
                continue;
            }
            if (strEnvKey.compareTo(m_bundle.getString("WsAboutBox.label.JREVersion.txt")) == 0) {
                vecEnvInfo.addElement(strEnvKey + m_bundle.getString("Common.Equal.txt") + System.getProperty("java.version"));
                continue;
            }
            if (strEnvKey.compareTo(m_bundle.getString("WsAboutBox.label.JREPath.txt")) == 0) {
                vecEnvInfo.addElement(strEnvKey + m_bundle.getString("Common.Equal.txt") + System.getProperty("java.home"));
                continue;
            }
            if (strEnvKey.compareTo(m_bundle.getString("WsAboutBox.label.ServerVersion.txt")) == 0) {
                String strVersion = m_bundle.getString("WsAboutBox.NoConnection.txt");
                if (Workspace.getWorkspace().getCMRHandle() != null) {
                    strVersion = Integer.toString(Workspace.getMetadataServerVersionNumber());
                }
                vecEnvInfo.addElement(strEnvKey + m_bundle.getString("Common.Equal.txt") + strVersion);
                continue;
            }
            if (strEnvKey.compareTo(m_bundle.getString("WsAboutBox.label.CurrentUser.txt")) == 0) {
                vecEnvInfo.addElement(strEnvKey + m_bundle.getString("Common.Equal.txt") + System.getProperty("user.name"));
                continue;
            }
            if (strEnvKey.compareTo(m_bundle.getString("WsAboutBox.label.UserHome.txt")) == 0) {
                vecEnvInfo.addElement(strEnvKey + m_bundle.getString("Common.Equal.txt") + System.getProperty("user.home"));
                continue;
            }
            if (strEnvKey.compareTo(m_bundle.getString("WsAboutBox.label.WorkingDir.txt")) != 0) continue;
            vecEnvInfo.addElement(strEnvKey + m_bundle.getString("Common.Equal.txt") + System.getProperty("user.dir"));
        }
        return vecEnvInfo;
    }

    private Vector setDummyManifestInfo() {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < this.m_sKeyArray.length; ++i) {
            result.addElement(this.m_sKeyArray[i] + m_bundle.getString("Common.Equal.txt") + m_bundle.getString("Common.Null.txt"));
        }
        return result;
    }

    private Vector getManifestInfo(Manifest mf) {
        Vector<String> result = new Vector<String>();
        try {
            if (null == mf) {
                for (int i = 0; i < this.m_sKeyArray.length; ++i) {
                    result.addElement(this.m_sKeyArray[i] + m_bundle.getString("Common.Equal.txt") + m_bundle.getString("Common.Null.txt"));
                }
                return result;
            }
            Attributes attr = mf.getMainAttributes();
            Vector<String> vOtherKeyValues = new Vector<String>();
            if (!attr.isEmpty()) {
                for (int i = 0; i < this.m_sKeyArray.length; ++i) {
                    result.addElement("");
                }
                String keystr = null;
                Set<Object> ks = attr.keySet();
                Iterator<Object> ki = ks.iterator();
                while (ki.hasNext()) {
                    boolean bKeyMatch = false;
                    Object keyobj = ki.next();
                    keystr = keyobj.toString();
                    for (int i = 0; i < this.m_sKeyArray.length; ++i) {
                        if (!keystr.equals(this.m_sKeyArray[i])) continue;
                        result.set(i, keystr + m_bundle.getString("Common.Equal.txt") + attr.getValue(keystr));
                        bKeyMatch = true;
                        break;
                    }
                    if (bKeyMatch) continue;
                    vOtherKeyValues.addElement(keystr + m_bundle.getString("Common.Equal.txt") + attr.getValue(keystr));
                }
                for (int i = result.size() - 1; i >= 0; --i) {
                    if (!result.elementAt(i).toString().equals("")) continue;
                    result.remove(i);
                }
                if (vOtherKeyValues.size() > 0) {
                    Iterator OKVit = vOtherKeyValues.iterator();
                    while (OKVit.hasNext()) {
                        result.addElement(OKVit.next().toString());
                    }
                }
                return result;
            }
        }
        catch (Exception ex) {
            Workspace.getDefaultLogger().error((Object)"", ex);
        }
        return result;
    }

    private Vector getJarfileInfo(Plugin[] loadVJRPlugins) {
        Vector<Object> result = new Vector<Object>();
        Vector tmpinfo = new Vector();
        boolean jarsFound = false;
        for (int i = 0; i < loadVJRPlugins.length; ++i) {
            try {
                tmpinfo = this.getManifestInfo(loadVJRPlugins[i].getBundleManifest());
                Vector<Object> c = new Vector<Object>();
                c.add(loadVJRPlugins[i].getName());
                c.add(tmpinfo);
                result.addElement(c);
                jarsFound = true;
                continue;
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        if (!jarsFound) {
            result.addElement(m_bundle.formatString("WsAboutBox.NoJars.txt", new File("").toString()));
        }
        return result;
    }

    private void center() {
        Dimension szDialog = this.getPreferredSize();
        Dimension szParent = this.getParent().getSize();
        Dimension szScreen = this.getToolkit().getScreenSize();
        Point ptParent = this.getParent().getLocation();
        int x = ptParent.x + (szParent.width - szDialog.width) / 2;
        int y = ptParent.y + (szParent.height - szDialog.height) / 2;
        x = Math.max(0, Math.min(x, szScreen.width - szDialog.width));
        y = Math.max(0, Math.min(y, szScreen.height - szDialog.height));
        this.setLocation(x, y);
    }

    class FileExtension
    implements FilenameFilter {
        private String m_extension;

        public FileExtension(String ext) {
            this.m_extension = ext;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.m_extension);
        }
    }
}

