/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.workspace.WAdminResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class ToggleButtonPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected String title;
    protected Border border;
    protected Border wrappedBorder;
    protected int titlePosition;
    protected JToggleButton m_toggleButton;
    protected JPanel m_interiorPanel;
    protected JPanel m_filler;
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    private static final WAdminResource bundle = WAdminResource.getBundle(ToggleButtonPanel.class);

    public ToggleButtonPanel(String metTitle, JToggleButton toggleButton) {
        this(null, metTitle, 2, false, toggleButton);
    }

    public ToggleButtonPanel(Border methBorder, JToggleButton toggleButton) {
        this(methBorder, "", 2, false, toggleButton);
    }

    public ToggleButtonPanel(Border methBorder, String methTitle, JToggleButton toggleButton) {
        this(methBorder, methTitle, 2, false, toggleButton);
    }

    public ToggleButtonPanel(Border methBorder, String methTitle, int methTitlePosition, JToggleButton toggleButton) {
        this(methBorder, methTitle, methTitlePosition, false, toggleButton);
    }

    public ToggleButtonPanel(String methTitle, int methTitlePosition, JToggleButton toggleButton) {
        this(null, methTitle, methTitlePosition, false, toggleButton);
    }

    public ToggleButtonPanel(String methTitle, boolean initialstate, JToggleButton toggleButton) {
        this(null, methTitle, 2, initialstate, toggleButton);
    }

    public ToggleButtonPanel(Border methBorder, String methTitle, int methTitlePosition, boolean initialState, JToggleButton toggleButton) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBorder(methBorder);
        this.titlePosition = methTitlePosition;
        this.m_toggleButton = toggleButton;
        this.m_toggleButton.setText(methTitle);
        this.m_toggleButton.setSelected(initialState);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 12, 0, 0);
        gbc.gridy = methTitlePosition < 4 ? 0 : 2;
        gridBagLayout.setConstraints(this.m_toggleButton, gbc);
        this.add(this.m_toggleButton);
        this.m_interiorPanel = new JPanel();
        this.m_interiorPanel.setLayout(new BorderLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = methTitlePosition < 4 ? 2 : 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 0, 0);
        gridBagLayout.setConstraints(this.m_interiorPanel, gbc);
        this.add(this.m_interiorPanel);
        this.m_toggleButton.addItemListener(new ToggleButtonHandler());
        this.setState();
    }

    public JPanel getInteriorPanel() {
        return this.m_interiorPanel;
    }

    public JToggleButton getToggleButton() {
        return this.m_toggleButton;
    }

    @Override
    public void setBorder(Border newBorder) {
        this.border = newBorder;
        if (this.border == null) {
            this.border = UIManager.getBorder("TitledBorder.border");
        }
        this.wrappedBorder = new ToggleButtonBorder();
        super.setBorder(this.wrappedBorder);
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public void setToggleButtonPosition(int methTitlePosition) {
        switch (methTitlePosition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.titlePosition = methTitlePosition;
                break;
            }
            default: {
                throw new IllegalArgumentException(bundle.formatString("ToggleButtonPanel.InternalError.msg.txt", new Integer(methTitlePosition).toString()));
            }
        }
    }

    public void setTitlePosition(int methTitlePosition) {
        switch (methTitlePosition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.titlePosition = methTitlePosition;
                break;
            }
            default: {
                throw new IllegalArgumentException(bundle.formatString("ToggleButtonPanel.InternalError.msg.txt", new Integer(methTitlePosition).toString()));
            }
        }
    }

    public void setState() {
        boolean enableState = this.m_toggleButton.isSelected();
        Component[] kids = this.m_interiorPanel.getComponents();
        for (int i = 0; i < kids.length; ++i) {
            this._setState(kids[i], enableState);
        }
    }

    protected void _setState(Component comp, boolean state) {
        comp.setEnabled(state);
        if (comp instanceof Container) {
            Container container = (Container)comp;
            Component[] kids = container.getComponents();
            for (int i = 0; i < kids.length; ++i) {
                this._setState(kids[i], state);
            }
        }
    }

    private class ToggleButtonBorder
    extends AbstractBorder {
        private static final long serialVersionUID = 1L;
        private int yoffset = 0;

        ToggleButtonBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return ToggleButtonPanel.this.border.getBorderInsets(c);
        }

        @Override
        public boolean isBorderOpaque() {
            return ToggleButtonPanel.this.border.isBorderOpaque();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Insets myBorderInsets = ToggleButtonPanel.this.border.getBorderInsets(c);
            switch (ToggleButtonPanel.this.titlePosition) {
                case 1: {
                    this.yoffset = ToggleButtonPanel.this.m_toggleButton.getHeight();
                    break;
                }
                default: {
                    this.yoffset = ToggleButtonPanel.this.m_toggleButton.getHeight() / 2 + myBorderInsets.top;
                    break;
                }
                case 3: {
                    this.yoffset = 0;
                    break;
                }
                case 4: {
                    this.yoffset = 0;
                    break;
                }
                case 5: {
                    this.yoffset = ToggleButtonPanel.this.m_toggleButton.getHeight() / 2 + myBorderInsets.bottom;
                    break;
                }
                case 6: {
                    this.yoffset = ToggleButtonPanel.this.m_toggleButton.getHeight();
                }
            }
            if (ToggleButtonPanel.this.titlePosition < 4) {
                ToggleButtonPanel.this.border.paintBorder(c, g, x, y + this.yoffset, width, height - this.yoffset);
            } else {
                ToggleButtonPanel.this.border.paintBorder(c, g, x, y, width, height - this.yoffset);
            }
        }
    }

    class ToggleButtonHandler
    implements ItemListener {
        ToggleButtonHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            ToggleButtonPanel.this.setState();
        }
    }
}

