/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

public class TableCellEditorManager
implements TableCellEditor {
    protected Hashtable m_editors;
    protected TableCellEditor m_editor;
    protected TableCellEditor m_defaultEditor;
    protected JTable m_table;

    public TableCellEditorManager(JTable table) {
        this.m_table = table;
        this.m_editors = new Hashtable();
        this.m_defaultEditor = new DefaultCellEditor(new JTextField());
    }

    public void setEditorAt(int row, TableCellEditor editor) {
        this.m_editors.put(new Integer(row), editor);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.m_editor = (TableCellEditor)this.m_editors.get(new Integer(row));
        if (this.m_editor == null) {
            this.m_editor = this.m_defaultEditor;
        }
        return this.m_editor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    protected void selectEditor(MouseEvent e) {
        int row = e == null ? this.m_table.getSelectionModel().getAnchorSelectionIndex() : this.m_table.rowAtPoint(e.getPoint());
        this.m_editor = (TableCellEditor)this.m_editors.get(new Integer(row));
        if (this.m_editor == null) {
            this.m_editor = this.m_defaultEditor;
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_editor.getCellEditorValue();
    }

    @Override
    public boolean stopCellEditing() {
        return this.m_editor.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.m_editor.cancelCellEditing();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        this.selectEditor((MouseEvent)anEvent);
        return this.m_editor.isCellEditable(anEvent);
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.m_editor.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.m_editor.removeCellEditorListener(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        this.selectEditor((MouseEvent)anEvent);
        return this.m_editor.shouldSelectCell(anEvent);
    }

    public Object getCellEditorValue(int row) {
        this.m_editor = (TableCellEditor)this.m_editors.get(new Integer(row));
        return this.m_editor.getCellEditorValue();
    }

    public boolean stopCellEditing(int row) {
        this.m_editor = (TableCellEditor)this.m_editors.get(new Integer(row));
        return this.m_editor.stopCellEditing();
    }

    public void cancelCellEditing(int row) {
        this.m_editor = (TableCellEditor)this.m_editors.get(new Integer(row));
        this.m_editor.cancelCellEditing();
    }

    public boolean isCellEditable(EventObject anEvent, int row) {
        this.m_editor = (TableCellEditor)this.m_editors.get(new Integer(row));
        return this.m_editor.isCellEditable(anEvent);
    }

    public void addCellEditorListener(CellEditorListener l, int row) {
        this.m_editor = (TableCellEditor)this.m_editors.get(new Integer(row));
        this.m_editor.addCellEditorListener(l);
    }

    public void removeCellEditorListener(CellEditorListener l, int row) {
        this.m_editor = (TableCellEditor)this.m_editors.get(new Integer(row));
        this.m_editor.removeCellEditorListener(l);
    }

    public boolean shouldSelectCell(EventObject anEvent, int row) {
        this.m_editor = (TableCellEditor)this.m_editors.get(new Integer(row));
        return this.m_editor.shouldSelectCell(anEvent);
    }
}

