/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPasswordField;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JLabel;

public class PasswordDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(PasswordDialog.class);
    protected cPasswordPanel m_pnlPassword;
    protected ArrayList m_placeToPutTheNewPassword;

    public PasswordDialog(String strOldPassword, String strNewPassword, ArrayList placeToPutTheNewPassword) {
        super(Workspace.getWorkspace(), bundle.getString("PasswordDialog.Title.txt"), true);
        this.m_pnlPassword = new cPasswordPanel(strOldPassword, strNewPassword, placeToPutTheNewPassword);
        this.setMainPanel(this.m_pnlPassword);
        this.m_placeToPutTheNewPassword = placeToPutTheNewPassword;
    }

    @Override
    public boolean onCancel() {
        if (super.onCancel()) {
            this.m_placeToPutTheNewPassword.add(0, "");
            return true;
        }
        return false;
    }

    class cPasswordPanel
    extends WAPanel {
        private static final long serialVersionUID = 1L;
        protected WAPasswordField m_oldPassword;
        protected WAPasswordField m_newPassword;
        protected WAPasswordField m_confirmPassword;
        protected String m_strOldPassword;
        protected String m_strNewPassword;
        protected String s_newPassword;

        public cPasswordPanel(String strOldPassword, String strNewPassword, ArrayList placeToPutTheNewPassword) {
            this.m_strOldPassword = strOldPassword;
            this.m_strNewPassword = strNewPassword;
            this.initialize();
            this.layoutWidgets();
        }

        @Override
        public void initialize() {
            this.m_oldPassword = new WAPasswordField();
            this.m_oldPassword.setColumns(20);
            if (this.m_strOldPassword != null) {
                this.m_oldPassword.setText(this.m_strOldPassword);
                this.m_oldPassword.setEditable(false);
                this.m_oldPassword.setEnabled(false);
            }
            this.m_newPassword = new WAPasswordField();
            this.m_newPassword.setColumns(20);
            if (this.m_strNewPassword != null) {
                this.m_newPassword.setText(this.m_strNewPassword);
                this.m_newPassword.setEditable(true);
                this.m_newPassword.setEnabled(true);
            }
            this.m_confirmPassword = new WAPasswordField();
            this.m_confirmPassword.setColumns(20);
        }

        @Override
        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_confirmPassword, new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
            this.m_confirmPassword.setToolTipText(bundle.getString("PasswordDialog.ConfirmPasswordToolTip.txt"));
            JLabel tempLabel = new JLabel(bundle.getString("PasswordDialog.Label.ConfirmNewPassword.txt"));
            tempLabel.setDisplayedMnemonic(bundle.getString("PasswordDialog.Label.ConfirmNewPassword.mnem").charAt(0));
            tempLabel.setLabelFor(this.m_confirmPassword);
            this.add((Component)tempLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0));
            tempLabel = new JLabel(bundle.getString("PasswordDialog.Label.OldPassword.txt"));
            tempLabel.setLabelFor(this.m_oldPassword);
            this.add((Component)tempLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0));
            this.add((Component)this.m_oldPassword, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
            tempLabel = new JLabel(bundle.getString("PasswordDialog.Label.NewPassword.txt"));
            tempLabel.setDisplayedMnemonic(bundle.getString("PasswordDialog.Label.NewPassword.mnem").charAt(0));
            tempLabel.setLabelFor(this.m_newPassword);
            this.add((Component)tempLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0));
            this.add((Component)this.m_newPassword, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
            this.m_newPassword.setToolTipText(bundle.getString("PasswordDialog.NewPasswordToolTip.txt"));
        }

        @Override
        public boolean doDataExchange(boolean saveToModel) {
            if (saveToModel) {
                PasswordDialog.this.m_placeToPutTheNewPassword.add(0, this.s_newPassword);
                MessageUtil.displayMessage(bundle.getString("PasswordDialog.Msg.PasswordChanged.txt"), 1);
            }
            return true;
        }

        @Override
        public boolean validateData() {
            this.s_newPassword = String.valueOf(this.m_newPassword.getPassword()).trim();
            String s_confirmPassword = String.valueOf(this.m_confirmPassword.getPassword()).trim();
            if (this.s_newPassword.equals("") && s_confirmPassword.equals("")) {
                MessageUtil.displayMessage(bundle.getString("PasswordDialog.Msg.NoBlankPassword.txt"), 0);
                this.m_newPassword.setEditable(true);
                this.m_newPassword.setEnabled(true);
                this.m_newPassword.requestFocus();
                return false;
            }
            if (this.s_newPassword.equals(s_confirmPassword)) {
                return true;
            }
            MessageUtil.displayMessage(bundle.getString("PasswordDialog.Msg.NoMatch.txt"), 0);
            this.m_newPassword.setEditable(true);
            this.m_newPassword.setEnabled(true);
            this.m_confirmPassword.setText(null);
            this.m_newPassword.requestFocus();
            return false;
        }

        @Override
        public boolean hasDataChanged() {
            return false;
        }
    }
}

