/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.TransformationStep;
import com.sas.visuals.util.XMLUtility;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OptionsPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(OptionsPanel.class);
    public static final String DEFAULT_PROTOTYPE_TYPE = "StandardOptions";
    public static final String DEFAULT_PROTOTYPE_FILENAME = "Options_Standard_Template.xml";
    public static final String DEFAULT_GENERATEDTRANSFORM_PROTOTYPE_TYPE = "GenericTransformation";
    public static final String DEFAULT_GENERATEDTRANSFORM_PROTOTYPE_FILENAME = "Options_GenericTransformation_Template.xml";
    public static final String DEFAULT_HELP_ID = "options_tab";
    protected OptionsTableModel m_optionsModel;
    protected WsTable m_optionsTable;
    protected JScrollPane m_tableScrollPane;
    protected String m_prototypeType;
    protected boolean m_fModelInitialized = false;
    protected String m_prototypeFileName;
    protected String m_XML = null;
    protected boolean m_usePropertySet = true;
    protected String m_helpId;
    private String m_role;

    public OptionsPanel(CMetadata metadata) {
        this(DEFAULT_PROTOTYPE_TYPE, DEFAULT_PROTOTYPE_FILENAME, metadata, DEFAULT_HELP_ID);
    }

    public OptionsPanel(CMetadata metadata, String prototypeType) {
        this(prototypeType, DEFAULT_PROTOTYPE_FILENAME, metadata, DEFAULT_HELP_ID);
    }

    public OptionsPanel(CMetadata metadata, String prototypeType, String helpId) {
        this(prototypeType, DEFAULT_PROTOTYPE_FILENAME, metadata, helpId);
    }

    public OptionsPanel(String prototypeType, String prototypeFileName, CMetadata metadata) {
        this(prototypeType, prototypeFileName, metadata, DEFAULT_HELP_ID);
    }

    public OptionsPanel(String prototypeType, String prototypeFileName, CMetadata metadata, String helpId) {
        this.m_prototypeType = prototypeType;
        this.m_prototypeFileName = prototypeFileName;
        this.m_helpId = helpId != null ? helpId : DEFAULT_HELP_ID;
        this.setHelpTopic(this.m_helpId);
        this.m_optionsModel = new OptionsTableModel(metadata);
        this.m_optionsModel.addTableModelListener(new cTableModelListener());
        this.m_role = "OPTIONS";
        this.initialize();
    }

    public OptionsPanel(CMetadata metadata, String prototypeType, String xml, String helpId) {
        this.m_prototypeType = prototypeType;
        this.m_prototypeFileName = DEFAULT_PROTOTYPE_FILENAME;
        this.m_XML = xml;
        if (helpId != null && helpId.trim().length() > 0) {
            this.m_helpId = helpId;
        }
        this.setHelpTopic(this.m_helpId);
        this.m_optionsModel = new OptionsTableModel(metadata);
        this.m_optionsModel.addTableModelListener(new cTableModelListener());
        this.m_role = "OPTIONS";
        this.initialize();
    }

    @Override
    protected void initialize() {
        this.m_optionsTable = new WsTable(this.m_optionsModel);
        this.m_optionsTable.setSortingEnabled(false);
        this.m_optionsTable.setSelectionMode(0);
        this.m_optionsTable.setCellSelectionEnabled(true);
        this.m_optionsTable.setRowsReorderable(false);
        this.m_optionsTable.setRowHoldingEnabled(false);
        this.m_optionsTable.setRowHeaderVisible(false);
        this.m_optionsTable.setColumnsReorderable(false);
        this.m_optionsTable.setColumnHoldingEnabled(false);
        this.m_optionsTable.setColumnHidingEnabled(false);
        this.m_optionsTable.setAutoResizeMode(3);
        this.m_optionsTable.setPopupMenuEnabled(false);
        this.m_optionsTable.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.m_optionsTable.setUndoManager(this.waum);
        this.m_tableScrollPane = new JScrollPane((Component)((Object)this.m_optionsTable));
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_tableScrollPane, "Center");
        this.setToolTipText(bundle.getString("OptionsTable.ToolTip.txt"));
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        try {
            this.setListeningForChanges(false);
            this.m_optionsModel.moveDataToModel();
            if (this.m_optionsModel.getRowCount() > 0) {
                this.m_optionsTable.selectCell(0, 1);
            }
        }
        finally {
            this.setListeningForChanges(true);
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        this.m_optionsModel.moveDataToStore();
        this.setDataChanged(false);
    }

    @Override
    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.m_optionsModel.populateStore();
        this.setStorePopulated(true);
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            this.populateStore();
            this.moveDataToView();
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    @Override
    public boolean validateData() {
        return this.m_optionsTable.stopCellEditing();
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_optionsTable.setEditable(editable);
    }

    public void setPrototypeType(String type) {
        this.m_prototypeType = type;
    }

    public void setPrototypeFileName(String filename) {
        this.m_prototypeFileName = filename;
    }

    public void setHelpMapID(String helpId) {
        if (helpId != null) {
            this.m_helpId = helpId;
        }
        this.setHelpTopic(this.m_helpId);
    }

    public void setXML(String xml) {
        this.m_XML = xml;
    }

    public String getRole() {
        return this.m_role;
    }

    public void setRole(String role) {
        this.m_role = role;
    }

    public void setUsePropertySet(boolean value) {
        this.m_usePropertySet = value;
    }

    public void setValue(String option, String value) {
        int row = this.findRow(option);
        if (row >= 0) {
            this.m_optionsModel.setValueAt(value, row, 1);
        }
    }

    public String getValue(String option) {
        int rowIndex = this.findRow(option);
        return rowIndex >= 0 ? (String)this.m_optionsModel.getValueAt(rowIndex, 1) : "";
    }

    public int findRow(String option) {
        for (int rowIndex = 0; rowIndex < this.m_optionsModel.getRowCount(); ++rowIndex) {
            String name = (String)this.m_optionsModel.getValueAt(rowIndex, 0);
            if (!name.equalsIgnoreCase(option)) continue;
            return rowIndex;
        }
        return -1;
    }

    public void selectOptionValueCell(String option) {
        int rowIndex = this.findRow(option);
        this.m_optionsTable.setCellSelectionInterval(rowIndex, 1, rowIndex, 1);
    }

    @Override
    public void setWAUndoManager(WAUndoManager mgrUndo) {
        super.setWAUndoManager(mgrUndo);
        this.m_optionsTable.setUndoManager(mgrUndo);
    }

    public boolean getDataChanged() {
        return this.hasDataChanged();
    }

    protected class cTableModelListener
    implements TableModelListener {
        protected cTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (OptionsPanel.this.isListeningForChanges()) {
                OptionsPanel.this.setDataChanged(true);
            }
        }
    }

    protected class OptionValuesTableColumn
    extends WsEnumeratedTableColumn {
        public OptionValuesTableColumn(int index, String name, int width) {
            super(index, name, width);
        }

        @Override
        public TableCellEditor createCellEditor() {
            OptionValuesCellEditor editor = new OptionValuesCellEditor();
            return editor;
        }

        @Override
        public void setPossibleValues(String[] saValues) {
            this.m_saValues = saValues;
            if (this.m_sDefault == null) {
                this.m_sDefault = saValues[0];
            }
            if (this.m_edtCell != null) {
                OptionValuesCellEditor editor = (OptionValuesCellEditor)this.m_edtCell;
                JComboBox comboBox = (JComboBox)editor.getComponent();
                comboBox.removeAllItems();
                for (int valueIndex = 0; valueIndex < saValues.length; ++valueIndex) {
                    comboBox.addItem(saValues[valueIndex]);
                }
            }
        }

        public void populate(JTable table, int row, int column) {
            TableModel model = table.getModel();
            ArrayList valuesList = (ArrayList)model.getValueAt(row, 6);
            if (valuesList == null || valuesList.size() <= 0) {
                return;
            }
            String[] values = valuesList.toArray(new String[0]);
            this.setPossibleValues(values);
            this.setDefaultValue(values[0]);
        }

        public boolean hasValues(JTable table, int row, int column) {
            TableModel model = table.getModel();
            ArrayList valuesList = (ArrayList)model.getValueAt(row, 6);
            return valuesList != null && valuesList.size() > 0;
        }

        protected class OptionValuesCellEditor
        extends WsDefaultCellEditor {
            private static final long serialVersionUID = 1L;
            protected WAComboBox m_comboBox = new WAComboBox();
            protected WATextField m_textField;
            protected WsDefaultCellEditor.cEditorDelegate m_textFieldDelegate;
            protected WsDefaultCellEditor.cEditorDelegate m_comboBoxDelegate = new WsDefaultCellEditor.cComboBoxDelegate(this.m_comboBox);

            public OptionValuesCellEditor() {
                this.initialize(this.m_comboBox, this.m_comboBoxDelegate);
                this.m_textField = new WATextField();
                this.m_textFieldDelegate = new WsDefaultCellEditor.cTextFieldDelegate(this.m_textField);
                this.initialize(this.m_textField, this.m_textFieldDelegate);
                this.m_cmpEditor = this.m_textField;
                this.m_delegate = this.m_textFieldDelegate;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean bSelected, int iRow, int iColumn) {
                if (OptionValuesTableColumn.this.hasValues(table, iRow, iColumn)) {
                    this.m_cmpEditor = this.m_comboBox;
                    this.m_delegate = this.m_comboBoxDelegate;
                } else {
                    this.m_cmpEditor = this.m_textField;
                    this.m_delegate = this.m_textFieldDelegate;
                }
                super.notify(table, iRow, iColumn);
                OptionValuesTableColumn.this.populate(table, iRow, iColumn);
                this.m_delegate.setValue(value);
                return this.m_cmpEditor;
            }
        }
    }

    protected class OptionsTableModel
    extends WsAbstractTableModel {
        private static final long serialVersionUID = 1L;
        public static final int NAME_COLUMN = 0;
        public static final int VALUE_COLUMN = 1;
        public static final int DESCRIPTION_COLUMN = 2;
        public static final int ORIGINAL_VALUE_COLUMN = 3;
        public static final int PROTOTYPE_PROPERTY_COLUMN = 4;
        public static final int METADATA_PROPERTY_COLUMN = 5;
        public static final int CHOICES_COLUMN = 6;
        protected static final int NAME_COLUMN_WIDTH = 75;
        protected static final int VALUE_COLUMN_WIDTH = 75;
        protected static final int VISIBLE_COLUMNS = 2;
        protected static final int HIDDEN_COLUMNS = 5;
        protected CMetadata m_metadata;
        protected List m_options;
        protected List m_prototypes;

        public OptionsTableModel(CMetadata metadata) {
            this.m_metadata = metadata;
            this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
            this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("OptionsTableModel.Name.txt"), 75);
            this.m_aColumns[0].setEditable(false);
            this.m_aColumns[1] = new OptionValuesTableColumn(1, bundle.getString("OptionsTableModel.Value.txt"), 75);
            this.m_aColumns[2] = new WsStringTableColumn(2);
            this.m_aColumns[2].setEditable(false);
            this.m_aColumns[3] = new WsStringTableColumn(3);
            this.m_aColumns[3].setEditable(false);
            this.m_aColumns[4] = new WsMetadataTableColumn();
            this.m_aColumns[5] = new WsMetadataTableColumn();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getHiddenColumnCount() {
            return 5;
        }

        @Override
        public String getToolTipAt(int row, int column) {
            return (String)this.getValueAt(row, 2);
        }

        @Override
        public void populateStore() throws MdException, RemoteException {
            if (this.isStorePopulated()) {
                return;
            }
            this.m_prototypes = this.getPrototypes(this.m_metadata);
            if (this.m_prototypes == null || this.m_prototypes.size() <= 0) {
                if (!this.loadXML()) {
                    return;
                }
                this.m_prototypes = this.getPrototypes(this.m_metadata);
            }
            if (this.m_prototypes == null || this.m_prototypes.size() <= 0) {
                MessageUtil.displayMessage(bundle.getString("OptionsPanel.NoOptions.msg.txt"), 0);
                return;
            }
            this.setStorePopulated(true);
        }

        public boolean loadXML() {
            String xmlString;
            if (OptionsPanel.this.m_XML == null) {
                String location = bundle.getString("ImageLocation.notrans");
                if (OptionsPanel.this.m_prototypeFileName == null) {
                    MessageUtil.displayMessage(bundle.formatString("OptionsPanel.MissingPrototypeFilename.msg.txt", OptionsPanel.this.m_prototypeType), 0);
                    return false;
                }
                try {
                    String fileName = location + OptionsPanel.this.m_prototypeFileName;
                    Locale loc = Locale.getDefault();
                    URL url = XMLUtility.urlFromFile((String)fileName, (Locale)loc);
                    Document doc = Workspace.getMdFactory().getOMIUtil().parseXML(url);
                    xmlString = Workspace.getMdFactory().getUtil().createStringForNode((Node)doc);
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
                    return false;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException(re);
                    return false;
                }
                catch (IOException e) {
                    MessageUtil.displayMessage(e.getLocalizedMessage());
                    return false;
                }
            } else {
                xmlString = OptionsPanel.this.m_XML;
            }
            try {
                String reposId = "_ReposID_";
                int reposIndex = xmlString.lastIndexOf("_ReposID_");
                String strPrototypeXML = xmlString.substring(0, reposIndex) + Workspace.getWorkspace().getDefaultRepository().getFQID() + xmlString.substring(reposIndex + "_ReposID_".length());
                Workspace.getMdFactory().getOMIUtil().DoRequest(strPrototypeXML, false);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
                return false;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
            return true;
        }

        public List getPrototypes(CMetadata metadata) throws MdException, RemoteException {
            StringBuffer options = new StringBuffer();
            options.append("<XMLSELECT ");
            options.append("Search=\"*[@MetadataType='");
            options.append(OptionsPanel.this.m_prototypeType + "']\"/>");
            options.append("<TEMPLATES>");
            options.append("<Prototype ");
            options.append("Id=\"\" ");
            options.append("Name=\"\" ");
            options.append("MetadataType=\"\">");
            options.append("<Properties/>");
            options.append("</Prototype>");
            options.append("<Property ");
            options.append("Id=\"\" ");
            options.append("Name=\"\" ");
            options.append("Desc=\"\" ");
            options.append("PropertyName=\"\" ");
            options.append("IsRequired=\"\" ");
            options.append("IsVisible=\"\" ");
            options.append("IsUpdateable=\"\" ");
            options.append("DefaultValue=\"\">");
            options.append("<OwningType/>");
            options.append("</Property>");
            options.append("<PropertyType ");
            options.append("Id=\"\" ");
            options.append("SQLType=\"\">");
            options.append("<StoredConfiguration/>");
            options.append("</PropertyType>");
            options.append("<TextStore ");
            options.append("Id=\"\" ");
            options.append("TextType=\"\" ");
            options.append("StoredText=\"\"/>");
            options.append("<DeployedComponent ");
            options.append("Id=\"\"/>");
            options.append("</TEMPLATES>");
            boolean goToServer = this.m_metadata.getObjectStore().isGoToServerForMetadata();
            metadata.getObjectStore().setGoToServerForMetadata(true);
            List prototypes = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(metadata.getObjectStore(), Workspace.getWorkspace().getDefaultRepository().getFQID(), "Prototype", 8588, options.toString());
            metadata.getObjectStore().setGoToServerForMetadata(goToServer);
            return prototypes;
        }

        @Override
        public void moveDataToModel() throws MdException, RemoteException {
            int rowCount;
            if (this.m_prototypes == null || this.m_prototypes.isEmpty()) {
                MessageUtil.displayMessage(bundle.getString("OptionsPanel.NoOptions.msg.txt"), 0);
                return;
            }
            this.clear();
            Prototype prototype = (Prototype)this.m_prototypes.get(0);
            AssociationList options = prototype.getProperties();
            for (int optionIndex = 0; optionIndex < options.size(); ++optionIndex) {
                if (!(options.get(optionIndex) instanceof Property)) continue;
                Property metadataProperty = (Property)options.get(optionIndex);
                List validValues = this.getValidValues(metadataProperty);
                String name = metadataProperty.getName();
                String description = metadataProperty.getDesc() != null ? metadataProperty.getDesc() : "";
                Property prototypeProperty = this.getProperty(metadataProperty);
                String value = "";
                if (prototypeProperty != null) {
                    value = prototypeProperty.getDefaultValue();
                } else if (metadataProperty.getDefaultValue() != null) {
                    value = metadataProperty.getDefaultValue();
                }
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(0, name);
                row.add(1, value);
                row.add(2, description);
                row.add(3, value);
                row.add(4, metadataProperty);
                row.add(5, prototypeProperty);
                row.add(6, validValues);
                this.m_lData.add(row);
            }
            for (int prototypeIndex = 1; prototypeIndex < this.m_prototypes.size(); ++prototypeIndex) {
                prototype = (Prototype)this.m_prototypes.get(prototypeIndex);
                if (prototype == null) continue;
                prototype.delete();
            }
            if (this.m_metadata instanceof TransformationStep && ((TransformationStep)this.m_metadata).getTransformations(false).size() == 1) {
                List macroOptions = this.getMacroOptions((TransformationStep)this.m_metadata);
                for (int macroOptionIndex = 0; macroOptions != null && macroOptionIndex < macroOptions.size(); ++macroOptionIndex) {
                    Property property = (Property)macroOptions.get(macroOptionIndex);
                    ArrayList<Object> row = new ArrayList<Object>();
                    row.add(0, property.getName());
                    row.add(1, property.getDefaultValue());
                    row.add(2, property.getDesc());
                    row.add(3, property.getDefaultValue());
                    row.add(4, property);
                    row.add(5, property);
                    row.add(6, new ArrayList());
                    this.m_lData.add(row);
                }
            }
            if ((rowCount = this.m_lData.size()) > 0) {
                this.fireTableRowsInserted(0, rowCount - 1);
            }
        }

        public List getValidValues(Property option) throws MdException, RemoteException {
            ArrayList<String> values = new ArrayList<String>();
            PropertyType owningType = option.getOwningType();
            TextStore storedConfiguration = (TextStore)owningType.getStoredConfiguration();
            if (storedConfiguration == null) {
                return null;
            }
            String storedText = storedConfiguration.getStoredText();
            Document document = Workspace.getMdFactory().getOMIUtil().parseXML(storedText);
            if (!document.hasChildNodes()) {
                return null;
            }
            NodeList level2Nodes = document.getFirstChild().getChildNodes();
            if (level2Nodes == null) {
                return null;
            }
            for (int level2Index = 0; level2Index < level2Nodes.getLength(); ++level2Index) {
                NodeList level3Nodes;
                Node level2Node = level2Nodes.item(level2Index);
                if (!level2Node.getNodeName().equalsIgnoreCase("Enumeration") || (level3Nodes = level2Node.getChildNodes()) == null) continue;
                for (int level3Index = 0; level3Index < level3Nodes.getLength(); ++level3Index) {
                    NamedNodeMap attributeMap;
                    Node nameNode;
                    Node level3Node = level3Nodes.item(level3Index);
                    if (!level3Node.hasAttributes() || (nameNode = (attributeMap = level3Node.getAttributes()).getNamedItem("name")) == null) continue;
                    values.add(nameNode.getNodeValue());
                }
            }
            return values;
        }

        Property getProperty(Property option) throws MdException, RemoteException {
            OptionsPropertyHandler opHandler = new OptionsPropertyHandler((Root)this.m_metadata, OptionsPanel.this.m_usePropertySet, OptionsPanel.this.m_role);
            AssociationList properties = opHandler.getPropertyList();
            if (properties == null) {
                return null;
            }
            Property property = null;
            for (int propertyIndex = 0; propertyIndex < properties.size(); ++propertyIndex) {
                property = (Property)properties.get(propertyIndex);
                if (!option.getPropertyName().equalsIgnoreCase(property.getPropertyName())) continue;
                return property;
            }
            return null;
        }

        public List getMacroOptions(TransformationStep step) throws MdException, RemoteException {
            ClassifierMap classifierMap = (ClassifierMap)step.getTransformations(false).get(0);
            AssociationList propertySets = classifierMap.getPropertySets();
            PropertySet macroSet = null;
            for (int propertySetIndex = 0; propertySetIndex < propertySets.size(); ++propertySetIndex) {
                PropertySet propertySet = (PropertySet)propertySets.get(propertySetIndex);
                if (!propertySet.getSetRole().equals("MACROOPTIONS")) continue;
                macroSet = propertySet;
                break;
            }
            if (macroSet == null) {
                return null;
            }
            AssociationList properties = macroSet.getProperties();
            ArrayList<Property> macroOptions = new ArrayList<Property>();
            for (int propertyIndex = 0; propertyIndex < properties.size(); ++propertyIndex) {
                Property property = (Property)properties.get(propertyIndex);
                String role = property.getPropertyRole();
                if (!role.equals("OPTION") || role.indexOf("INPUTS") != -1 || role.indexOf("OUTPUTS") != -1) continue;
                macroOptions.add(property);
            }
            return macroOptions.size() > 0 ? macroOptions : null;
        }

        @Override
        public void moveDataToStore() throws MdException, RemoteException {
            for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                String oldValue;
                String newValue = (String)this.getValueAt(rowIndex, 1);
                if (newValue.equals(oldValue = (String)this.getValueAt(rowIndex, 3))) continue;
                Property prototypeProperty = (Property)this.getValueAt(rowIndex, 4);
                Property property = (Property)this.getValueAt(rowIndex, 5);
                if (this.m_metadata instanceof TransformationStep && ((TransformationStep)this.m_metadata).getTransformations(false).size() == 1 || !newValue.equals(prototypeProperty.getDefaultValue())) {
                    if (property != null) {
                        property.setDefaultValue(newValue);
                        continue;
                    }
                    property = (Property)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_metadata.getObjectStore(), null, prototypeProperty.getName(), "Property", this.m_metadata.getRepositoryID(), null);
                    property.setDefaultValue(newValue);
                    property.setPropertyName(prototypeProperty.getPropertyName());
                    if (OptionsPanel.this.m_usePropertySet) {
                        OptionsPropertyHandler opHandler = new OptionsPropertyHandler((Root)this.m_metadata, OptionsPanel.this.m_usePropertySet, OptionsPanel.this.m_role);
                        property.setAssociatedObject((Root)opHandler.createPropertySet());
                    } else {
                        property.setAssociatedObject((Root)this.m_metadata);
                    }
                    String propertyRole = prototypeProperty.getPropertyRole();
                    if (propertyRole != null && propertyRole.length() > 0 && !propertyRole.equalsIgnoreCase("INPUT")) {
                        property.setPropertyRole(propertyRole);
                    }
                    PropertyType propertyType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_metadata.getObjectStore(), null, prototypeProperty.getOwningType().getName(), "PropertyType", this.m_metadata.getRepositoryID(), null);
                    MdStoreUtil.copyObjectAttributes((CMetadata)prototypeProperty.getOwningType(), (CMetadata)propertyType);
                    property.setOwningType(propertyType);
                    property.setUseValueOnly(prototypeProperty.getUseValueOnly());
                    property.setDelimiter(prototypeProperty.getUseValueOnly() == 0 ? "=" : "");
                    this.setValueAt(property, rowIndex, 5);
                    this.setValueAt(property.getDefaultValue(), rowIndex, 3);
                    continue;
                }
                if (!newValue.equals(prototypeProperty.getDefaultValue()) || property == null) continue;
                property.delete();
                this.setValueAt(null, rowIndex, 5);
            }
        }
    }
}

