/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPasswordField;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class LogonView
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected JLabel m_usernameLabel;
    protected JTextField m_usernameText;
    protected JLabel m_passwordLabel;
    protected JPasswordField m_passwordText;
    private static final WAdminResource bundle = WAdminResource.getBundle(LogonView.class);

    public LogonView() {
        this._initialize();
        this._layoutWidgets();
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) {
        return false;
    }

    @Override
    public boolean validateData() {
        if (this.getPassword().trim().toLowerCase().indexOf("{sas") == 0) {
            MessageUtil.displayMessage(bundle.getString("LogonView.PasswordError.txt"), 0);
            return false;
        }
        return true;
    }

    public String getUserName() {
        return this.m_usernameText.getText();
    }

    public String getPassword() {
        return String.valueOf(this.m_passwordText.getPassword());
    }

    public void setUserName(String userName) {
        this.m_usernameText.setText(userName);
    }

    public void setPassword(String password) {
        this.m_passwordText.setText(password);
        String.valueOf(this.m_passwordText.getPassword());
    }

    @Override
    public void setEditable(boolean bEditable) {
        this.m_usernameLabel.setEnabled(bEditable);
        this.m_usernameText.setEnabled(bEditable);
        this.m_usernameText.setEditable(bEditable);
        this.m_passwordLabel.setEnabled(bEditable);
        this.m_passwordText.setEnabled(bEditable);
        this.m_passwordText.setEditable(bEditable);
    }

    protected void _initialize() {
        this.setHelpProduct("shared");
        this.setHelpTopic("newlogin");
        this.m_usernameText = new WATextField(25);
        this.m_usernameLabel = new JLabel(bundle.getString("LogonView.UserName.txt"));
        this.m_usernameLabel.setDisplayedMnemonic(bundle.getString("LogonView.UserName.mnem").charAt(0));
        this.m_usernameLabel.setLabelFor(this.m_usernameText);
        this.m_passwordText = new WAPasswordField();
        this.m_passwordLabel = new JLabel(bundle.getString("LogonView.Password.txt"));
        this.m_passwordLabel.setDisplayedMnemonic(bundle.getString("LogonView.Password.mnem").charAt(0));
        this.m_passwordLabel.setLabelFor(this.m_passwordText);
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_usernameLabel, gbc);
        this.add(this.m_usernameLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_usernameText, gbc);
        this.add(this.m_usernameText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_passwordLabel, gbc);
        this.add(this.m_passwordLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_passwordText, gbc);
        this.add(this.m_passwordText);
    }
}

