/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.workspace.AppServer;
import com.sas.workspace.AppServerException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPasswordField;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsMessagesPropertyTab;
import com.sas.workspace.WsStatusBarUtilities;
import com.sas.workspace.visuals.PasswordDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class AppServerPanel
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(AppServerPanel.class);
    protected WAPanel m_dcPanel;
    protected WAComboBox m_dcField;
    protected WATextField m_userField;
    protected WAPasswordField m_passwordField;
    protected JCheckBox m_checkBoxDefaultServer;
    protected boolean m_initializedOnce = false;
    protected boolean m_fDisplayMessages = true;
    protected String m_sLastErrorMessage = null;
    protected ServerContext m_objDCInitialValue;
    protected String m_strUserFieldInitialValue = "";
    protected String m_strPasswordFieldInitialValue = "";
    protected String m_strPortFieldInitialValue;
    protected String m_strMachineFieldInitialValue;
    protected boolean m_OKToWriteChanges = true;
    protected Workspace m_workspace;
    protected WorkspaceFile m_wsFile;
    protected AppServer m_appServer;
    protected ServerContext m_dc;
    protected TCPIPConnection m_iomConn;
    protected Login m_login;
    protected String m_strInfo;
    protected boolean m_fBorder = false;
    protected JButton m_test;
    protected boolean m_testButton = true;
    protected ArrayList m_reposDCList;
    public static String DefaultServerId = "AppServer.Default";
    public static String ServerUser = "AppServerUser.";
    public static String ServerPassword = "AppServerPassword.";
    protected boolean m_writeMetadata = false;
    protected ArrayList m_passwordList = new ArrayList();
    protected ArrayList m_userList = new ArrayList();
    protected boolean fReinitializing = false;
    protected boolean fInitialized = false;
    private boolean m_bUpdateDefault = true;

    public AppServerPanel(AppServer appServer, boolean fBorder) {
        this.m_fBorder = fBorder;
        this.m_workspace = Workspace.getWorkspace();
        this.m_wsFile = this.m_workspace.getAppDefaultsFile();
        this.m_appServer = appServer;
        this.setHelpTopic("options_sasserver_tab");
        this.initialize();
        this.layoutWidgets();
    }

    public AppServerPanel(AppServer appServer, boolean fBorder, boolean testbutton) {
        this.m_fBorder = fBorder;
        this.m_testButton = testbutton;
        this.m_workspace = Workspace.getWorkspace();
        this.m_wsFile = this.m_workspace.getAppDefaultsFile();
        this.m_appServer = appServer;
        this.setHelpTopic("options_sasserver_tab");
        this.initialize();
        this.layoutWidgets();
    }

    public void setUpdateDefault(boolean bUpdateDefault) {
        this.m_bUpdateDefault = bUpdateDefault;
    }

    public boolean isUpdateDefault() {
        return this.m_bUpdateDefault;
    }

    public void setAppSever(AppServer appServer) {
        this.m_appServer = appServer;
    }

    public AppServer getAppServer() {
        return this.m_appServer;
    }

    @Override
    protected void initialize() {
        this.m_dcPanel = new WAPanel();
        this.m_dcField = new WAComboBox();
        this.m_dcField.setToolTipText(bundle.getString("AppServerPanel.ServernameToolTip.txt"));
        WATextField sizingField = new WATextField("THIS IS JUST FOR SIZING M_DCFIELD COMPONENT     ");
        this.m_dcField.setPreferredSize(sizingField.getPreferredSize());
        this.m_userField = new WATextField(20);
        this.m_userField.setEditable(true);
        this.m_userField.setToolTipText(bundle.getString("AppServerPanel.UsernameToolTip.txt"));
        this.m_passwordField = new WAPasswordField(20);
        this.m_passwordField.setToolTipText(bundle.getString("AppServerPanel.PasswordToolTip.txt"));
        this.m_checkBoxDefaultServer = new JCheckBox(bundle.getString("AppServerPanel.Useasdefault.txt"));
        this.m_checkBoxDefaultServer.setToolTipText(bundle.getString("AppServerPanel.DefaultToolTip.txt"));
        this.m_checkBoxDefaultServer.setMnemonic(bundle.getString("AppServerPanel.Default.mnem").charAt(0));
        this.m_checkBoxDefaultServer.setSelected(false);
        if (this.m_testButton) {
            this.m_test = new JButton(bundle.getString("AppServerPanel.TestConnection.txt"));
            this.m_test.setToolTipText(bundle.getString("AppServerPanel.TestConnectionToolTip.txt"));
            this.m_test.setMnemonic(bundle.getString("AppServerPanel.TestConnection.mnem").charAt(0));
        }
        super.initialize();
    }

    public void setShowMessageBoxes(boolean fState) {
        this.m_fDisplayMessages = fState;
    }

    public String getLastErrorMessage() {
        return this.m_sLastErrorMessage;
    }

    public boolean test() {
        this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.m_appServer.testConnection();
        }
        catch (AppServerException asE) {
            this.m_userField.requestFocus();
            if (this.m_fDisplayMessages) {
                MessageUtil.displayMessage(asE.getMessage(), 0);
            }
            this.m_sLastErrorMessage = asE.getMessage();
            this.getTopLevelAncestor().setCursor(null);
            return false;
        }
        this.getTopLevelAncestor().setCursor(null);
        return true;
    }

    @Override
    public boolean validateData() {
        String errMsg = null;
        if (this.m_dcField.getItemCount() == 0) {
            return true;
        }
        if (this.m_dcField.getSelectedIndex() == -1) {
            this.m_dcField.requestFocus();
            errMsg = bundle.getString("AppServerPanel.Msg.InvDC.txt");
        }
        if (errMsg != null) {
            if (this.m_fDisplayMessages) {
                MessageUtil.displayMessage(errMsg, 0);
            }
            this.m_sLastErrorMessage = errMsg;
            return false;
        }
        return true;
    }

    @Override
    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (!saveToModel) {
            boolean resetChangedFlag = true;
            if (this.m_wsFile.getPropertyString(DefaultServerId).length() == 0) {
                resetChangedFlag = false;
            }
            if (!this.fInitialized) {
                this.initializeData();
                this.fInitialized = true;
            } else {
                this.reinitializeData();
            }
            if (resetChangedFlag) {
                this.setDataChanged(false);
            }
        } else {
            if (this.m_dc == null) {
                return true;
            }
            String dcId = this.m_dc.getFQID();
            if (this.hasDataChanged()) {
                this.m_writeMetadata = false;
                String strUser = this.m_userField.getText().trim();
                boolean userChanged = false;
                if (strUser.compareTo(this.m_strUserFieldInitialValue) != 0) {
                    userChanged = true;
                }
                char[] pass = this.m_passwordField.getPassword();
                String strPass = this.m_strPasswordFieldInitialValue;
                boolean passChanged = false;
                if (pass.length != strPass.length()) {
                    strPass = String.valueOf(pass);
                    passChanged = true;
                } else {
                    for (int ii = 0; ii < pass.length; ++ii) {
                        if (pass[ii] == strPass.charAt(ii)) continue;
                        strPass = String.valueOf(pass);
                        passChanged = true;
                        break;
                    }
                }
                if (passChanged) {
                    ArrayList newPwList = new ArrayList();
                    PasswordDialog pd = new PasswordDialog(this.m_strPasswordFieldInitialValue, strPass, newPwList);
                    pd.show();
                    String newPW = (String)newPwList.get(0);
                    if (newPW == "") {
                        strPass = this.m_strPasswordFieldInitialValue;
                        passChanged = false;
                    } else {
                        strPass = newPW;
                    }
                }
                if (userChanged || passChanged) {
                    strPass = strPass.trim();
                    strPass = Workspace.getMdFactory().getUtil().encrypt(strPass);
                    this.m_wsFile.setPropertyString(ServerUser + dcId, strUser);
                    this.m_wsFile.setPropertyString(ServerPassword + dcId, strPass);
                    this.m_writeMetadata = true;
                }
                if (this.m_writeMetadata && this.m_OKToWriteChanges) {
                    this.m_appServer.updateMetadataAll();
                }
                if (this.m_checkBoxDefaultServer.isSelected() && this.m_bUpdateDefault) {
                    this.m_wsFile.setPropertyString(DefaultServerId, dcId);
                    if (WsStatusBarUtilities.isAppserverPanelShown()) {
                        WsStatusBarUtilities.updateAppserverPanel();
                    }
                }
            }
        }
        return true;
    }

    private void initializeData() {
        this.setupData();
        this.setupListeners();
        try {
            int index = 0;
            if (this.m_dc != null) {
                index = this.m_dcField.getIndexOf(this.m_dc);
            }
            this.m_dcField.setSelectedIndex(index);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", e);
        }
    }

    protected void reinitializeData() {
        this.fReinitializing = true;
        this.m_reposDCList.clear();
        this.m_appServer.clearReposServerContexts();
        this.m_dc = null;
        this.setupData();
        this.fReinitializing = false;
        int index = -1;
        if (this.m_dc != null) {
            index = this.m_dcField.getIndexOf(this.m_dc);
        }
        try {
            if (index > -1) {
                this.m_dcField.setSelectedIndex(index);
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", e);
        }
    }

    private void setupData() {
        this.m_reposDCList = this.m_appServer.getReposServerContexts();
        if (this.m_reposDCList.size() == 0) {
            if (this.m_test != null) {
                this.m_test.setEnabled(false);
            }
            return;
        }
        if (this.m_test != null) {
            this.m_test.setEnabled(true);
        }
        String defSCId = "";
        defSCId = this.m_wsFile.getPropertyString(DefaultServerId);
        this.m_dc = this.m_appServer.getServerContext();
        if (this.m_dc == null) {
            if (defSCId.length() > 0) {
                try {
                    this.m_dc = this.m_appServer.setServerContext(defSCId);
                }
                catch (AppServerException asE) {
                    String strMsg = bundle.getString("AppServerPanel.Msg.NoDC.fmt.txt") + "  " + asE.getMessage();
                    WsMessagesPropertyTab.getInstance().addMessage(strMsg);
                    this.m_sLastErrorMessage = strMsg;
                    this.m_wsFile.setPropertyString(DefaultServerId, "");
                    this.m_wsFile.setPropertyString("Changed", "true");
                    this.m_wsFile.saveExisting();
                    this.m_dc = null;
                }
                if (this.m_dc != null) {
                    boolean found = false;
                    for (int j = 0; j < this.m_reposDCList.size(); ++j) {
                        try {
                            if (!this.m_dc.getId().equals(((CMetadata)this.m_reposDCList.get(j)).getId())) continue;
                            found = true;
                            break;
                        }
                        catch (RemoteException re) {
                            Workspace.handleRemoteException(re);
                        }
                    }
                    if (!found) {
                        this.m_dc = null;
                        String strMsg = bundle.getString("AppServerPanel.Msg.NoDC.fmt.txt");
                        Workspace.getWorkspace().getMessagesWindow().addMessage(strMsg);
                        this.m_sLastErrorMessage = strMsg;
                    }
                }
            }
            if (this.m_dc == null && this.m_reposDCList.size() > 0) {
                this.m_dc = (ServerContext)this.m_reposDCList.get(0);
                try {
                    defSCId = this.m_dc.getFQID();
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException(re);
                }
                this.m_appServer.setServerContext(defSCId);
            }
        }
        this.m_dcField.removeAllItems();
        this.m_dcField.setSorted(true);
        for (int i = 0; i < this.m_reposDCList.size(); ++i) {
            ServerContext dcObj = (ServerContext)this.m_reposDCList.get(i);
            this.m_dcField.addItem(dcObj);
        }
        this.m_objDCInitialValue = this.m_dc;
        try {
            if (defSCId.length() > 0 && this.m_dc != null && defSCId.equals(this.m_dc.getFQID())) {
                this.m_checkBoxDefaultServer.setSelected(true);
            } else {
                this.m_checkBoxDefaultServer.setSelected(false);
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
    }

    private void setupListeners() {
        this.m_dcField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!AppServerPanel.this.fReinitializing) {
                    AppServerPanel.this.m_dc = (ServerContext)AppServerPanel.this.m_dcField.getSelectedItem();
                    if (AppServerPanel.this.m_dc != null) {
                        AppServerPanel.this.m_appServer.setServerContext(AppServerPanel.this.m_dc);
                        AppServerPanel.this.setConnectionFields();
                        AppServerPanel.this.m_appServer.setLogin(AppServerPanel.this.m_userField.getText(), new String(AppServerPanel.this.m_passwordField.getPassword()));
                        AppServerPanel.this.m_checkBoxDefaultServer.setSelected(true);
                    }
                }
            }
        });
        if (this.m_testButton) {
            this.m_test.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean bdataOK = AppServerPanel.this.validateData();
                    if (bdataOK) {
                        AppServerPanel.this.m_appServer.setLogin(AppServerPanel.this.m_userField.getText(), new String(AppServerPanel.this.m_passwordField.getPassword()));
                        if (AppServerPanel.this.test()) {
                            MessageUtil.displayMessage(bundle.getString("AppServerPanel.ConnectionOK.txt"), 1);
                        }
                    }
                }
            });
        }
    }

    private void setConnectionFields() {
        try {
            String defSCId = this.m_wsFile.getPropertyString(DefaultServerId);
            if (defSCId.length() > 0 && this.m_dc != null && defSCId.equals(this.m_dc.getFQID())) {
                this.m_checkBoxDefaultServer.setSelected(true);
            } else {
                this.m_checkBoxDefaultServer.setSelected(false);
            }
            String defId = this.m_dc.getFQID();
            this.m_userField.setText(this.m_wsFile.getPropertyString(ServerUser + defId));
            this.m_passwordField.setText(Workspace.getMdFactory().getUtil().decrypt(this.m_wsFile.getPropertyString(ServerPassword + defId)));
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
    }

    @Override
    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        JLabel tempLabel = new JLabel(bundle.getString("AppServerPanel.Label.Servername.txt"));
        tempLabel.setDisplayedMnemonic(bundle.getString("AppServerPanel.Label.Servername.mnem").charAt(0));
        tempLabel.setLabelFor(this.m_dcField);
        this.add((Component)tempLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_dcField, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.m_dcPanel.setLayout(new GridBagLayout());
        this.listenForDataChangesTo(this.m_dcField);
        this.add((Component)this.m_dcPanel, new GridBagConstraints(0, 1, 5, 4, 0.0, 1.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        if (this.m_testButton) {
            this.add((Component)this.m_test, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        }
    }

    public void setWrite(boolean fWrite) {
        this.m_OKToWriteChanges = fWrite;
    }

    public boolean getChangeState() {
        return this.m_writeMetadata;
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        if (this.m_appServer != null) {
            this.m_appServer.termAppServer();
        }
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_dcField.setEnabled(bEditable);
        this.m_userField.setEditable(bEditable);
        this.m_passwordField.setEditable(bEditable);
        this.m_checkBoxDefaultServer.setEnabled(bEditable);
        if (this.m_testButton) {
            this.m_test.setEnabled(bEditable);
        }
    }
}

