/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.tree;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.tree.WsNodeFactory;
import com.sas.workspace.tree.WsNodeFilter;
import com.sas.workspace.tree.WsTreeModel;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WsDefaultTreeModel
extends DefaultTreeModel
implements WsTreeModel {
    private static final long serialVersionUID = 1L;
    private WsNodeFilter m_filter;
    private WsNodeFactory m_factory;
    private MdObjectStore m_store;
    private ArrayList m_lRepositories;
    private Comparator m_cmp = this.createDefaultComparator();
    private String m_sName = "DefaultTreeModel";

    public WsDefaultTreeModel(WsTreeNode root) {
        super(root, true);
    }

    protected Comparator createDefaultComparator() {
        return new DefaultComparator();
    }

    protected List createDefaultRepositoryList() {
        ArrayList<Root> lKeep = new ArrayList<Root>();
        try {
            List vecRepositories = Workspace.getMdFactory().getOMIUtil().getRepositories();
            ArrayList lRepositories = new ArrayList(vecRepositories);
            Root mdoProject = (Root)Workspace.getWorkspace().getProjectRepository();
            if (mdoProject == null) {
                return lRepositories;
            }
            String sProjectFQID = mdoProject != null ? mdoProject.getFQID() : null;
            for (int iRepository = 0; iRepository < lRepositories.size(); ++iRepository) {
                Root mdoRepository = (Root)lRepositories.get(iRepository);
                if (mdoRepository.getFQID().equals(sProjectFQID)) continue;
                lKeep.add(mdoRepository);
            }
        }
        catch (MdException vecRepositories) {
        }
        catch (RemoteException ex2) {
            Workspace.handleRemoteException(ex2);
        }
        return lKeep;
    }

    public void setName(String sName) {
        this.m_sName = sName;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setNodeFilter(WsNodeFilter filter) {
        this.m_filter = filter;
    }

    @Override
    public WsNodeFilter getNodeFilter() {
        return this.m_filter;
    }

    public void setNodeFactory(WsNodeFactory factory) {
        this.m_factory = factory;
    }

    @Override
    public WsNodeFactory getNodeFactory() {
        return this.m_factory;
    }

    public void setStore(MdObjectStore store) {
        this.m_store = store;
    }

    public MdObjectStore getStore() {
        return this.m_store;
    }

    public void setRepositories(List lRepositories) {
        this.m_lRepositories = new ArrayList(lRepositories);
    }

    @Override
    public List getRepositories() {
        return (List)this.m_lRepositories.clone();
    }

    public void setComparator(Comparator cmp) {
        this.m_cmp = cmp;
    }

    public Comparator getComparator() {
        return this.m_cmp;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object value) {
        WsTreeNode node = (WsTreeNode)path.getLastPathComponent();
        node.rename((String)value);
    }

    @Override
    public void setRoot(TreeNode node) {
        super.setRoot(node);
        if (node instanceof WsTreeNode) {
            ((WsTreeNode)node).setTreeModel(this);
        }
    }

    @Override
    public void addChild(final WsTreeNode nodeNew, final WsTreeNode nodeParent) {
        if (SwingUtilities.isEventDispatchThread()) {
            int iChild;
            int nChildren = nodeParent.getChildCount();
            if (nodeParent.isSorted()) {
                WsTreeNode nodeChild;
                for (iChild = 0; iChild < nChildren && this.m_cmp.compare(nodeChild = (WsTreeNode)nodeParent.getChildAt(iChild), nodeNew) <= 0; ++iChild) {
                }
            } else {
                iChild = nChildren;
            }
            nodeNew.setTreeModel(this);
            this.insertNodeInto(nodeNew, nodeParent, iChild);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        WsDefaultTreeModel.this.addChild(nodeNew, nodeParent);
                    }
                });
            }
            catch (InterruptedException ex) {
                Workspace.getDefaultLogger().error((Object)"", ex);
            }
            catch (InvocationTargetException ex) {
                Workspace.getDefaultLogger().error((Object)"", ex);
            }
        }
    }

    @Override
    public void removeChild(final WsTreeNode nodeChild) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.removeNodeFromParent(nodeChild);
            nodeChild.setTreeModel(null);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        WsDefaultTreeModel.this.removeChild(nodeChild);
                    }
                });
            }
            catch (InterruptedException ex) {
                Workspace.getDefaultLogger().error((Object)"", ex);
            }
            catch (InvocationTargetException ex) {
                Workspace.getDefaultLogger().error((Object)"", ex);
            }
        }
    }

    @Override
    public void removeAllChildren(WsTreeNode nodeParent) {
        int nChildren = this.getChildCount(nodeParent);
        for (int iChildren = nChildren - 1; iChildren >= 0; --iChildren) {
            this.removeChild((WsTreeNode)nodeParent.getChildAt(iChildren));
        }
    }

    @Override
    public void resortChild(WsTreeNode nodeChild) {
        WsTreeNode nodeParent = (WsTreeNode)nodeChild.getParent();
        if (nodeParent.isSorted()) {
            this.removeChild(nodeChild);
            this.addChild(nodeChild, nodeParent);
        } else {
            this.nodeChanged(nodeChild);
        }
    }

    @Override
    public void nodeChanged(final TreeNode node) {
        if (SwingUtilities.isEventDispatchThread()) {
            super.nodeChanged(node);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WsDefaultTreeModel.this.nodeChanged(node);
                }
            });
        }
    }

    public Enumeration getBreadthFirstEnumeration() {
        return ((DefaultMutableTreeNode)this.root).breadthFirstEnumeration();
    }

    public Enumeration getDepthFirstEnumeration() {
        return ((DefaultMutableTreeNode)this.root).depthFirstEnumeration();
    }

    @Override
    public WsDataTreeNode find(Root mdo) throws MdException, RemoteException {
        return null;
    }

    protected WsDataTreeNode findInChildren(WsTreeNode node, String sFQID) {
        node.expand();
        for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
            WsTreeNode nodeChild = (WsTreeNode)node.getChildAt(iChild);
            if (!(nodeChild instanceof WsDataTreeNode) || !sFQID.equals(nodeChild.getFQID())) continue;
            return (WsDataTreeNode)nodeChild;
        }
        return null;
    }

    @Override
    public Root acquirePermanentObject(String sName, String sType, String sFQID, String sChangeState, String sLockedBy) throws MdException, RemoteException {
        Root mdoNew = this.m_store != null ? (Root)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, sName, sType, sFQID) : (Root)Workspace.getMdFactory().createSimpleMetadataObject(sName, sType, sFQID);
        mdoNew.setChangeState(sChangeState);
        mdoNew.setLockedBy(sLockedBy);
        return mdoNew;
    }

    @Override
    public Root acquirePermanentObject(Root mdo) {
        if (this.m_store != null) {
            return mdo;
        }
        try {
            Root mdoNew = (Root)Workspace.getMdFactory().createSimpleMetadataObject((CMetadata)mdo);
            mdoNew.setChangeState(mdo.getChangeState());
            mdoNew.setLockedBy(mdo.getLockedBy());
            return mdoNew;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
    }

    @Override
    public Root acquireComplexObject(Root mdo) {
        if (this.m_store != null) {
            return mdo;
        }
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "WsDefaultTreeModel:acquireComplexObject");
            return (Root)Workspace.getMdFactory().createComplexMetadataObject(store, (CMetadata)mdo);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
    }

    @Override
    public void disposeComplexObject(Root mdo) {
        try {
            if (this.m_store == null) {
                mdo.getObjectStore().dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    @Override
    public MdObjectStore acquireStore() {
        if (this.m_store != null) {
            return this.m_store;
        }
        try {
            return Workspace.getMdFactory().createObjectStore(null, "WsDefaultTreeModel:acquireStore");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
    }

    @Override
    public void disposeStore(MdObjectStore store) {
        if (this.m_store != null) {
            return;
        }
        try {
            store.dispose();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    private static class DefaultComparator
    implements Comparator {
        private DefaultComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((WsTreeNode)o1).getName().compareToIgnoreCase(((WsTreeNode)o2).getName());
        }
    }
}

