/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.decorators;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.models.DecoratableIcon;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.decorators.AbstractDecoratorElement;
import java.rmi.RemoteException;
import java.util.List;

public class DeploymentDecorator
extends AbstractDecoratorElement {
    private static final WAdminResource bundle = WAdminResource.getBundle(DeploymentDecorator.class);
    public static final String DISTUDIO_JFJOBROLE = "SCHEDULER_JOB";

    @Override
    public boolean decorateIcon(DecoratableIcon icon, SimpleObject simpleObject) throws ServiceException, RemoteException {
        Filter filter = new Filter();
        filter.setOMRTemplate("<Templates><Job><JFJobs></JFJobs><TransformationSources/></Job><JFJob Id=\"\" TransformRole=\"\"></JFJob><ClassifierMap PublicType=\"\"/></Templates>");
        filter.setOMRFlags(-2147483644);
        String sKey = simpleObject.getID() + "/" + simpleObject.getMetadataType();
        BrowseMetadataInterface job = this.m_server.browseFetch(sKey, (FilterInterface)filter);
        if (this.decorateForScheduledJob(job)) {
            icon.setSEDecoration(bundle.getIcon("Decorator.Deployed.image"));
            return true;
        }
        List lSources = (List)job.get("TransformRole");
        if (lSources != null) {
            for (int i = 0; i < lSources.size(); ++i) {
                BrowseMetadataInterface source = (BrowseMetadataInterface)lSources.get(i);
                if (!"StoredProcess".equals(source.getSmartType())) continue;
                icon.setSEDecoration(bundle.getIcon("Decorator.Deployed.image"));
                return true;
            }
        }
        return false;
    }

    private boolean decorateForScheduledJob(BrowseMetadataInterface oJob) {
        boolean bDIStudioJFJob = false;
        List alJFJobs = (List)oJob.get("JFJobs");
        if (alJFJobs == null) {
            return bDIStudioJFJob;
        }
        for (int i = 0; i < alJFJobs.size(); ++i) {
            BrowseMetadataInterface jfJob = (BrowseMetadataInterface)alJFJobs.get(i);
            String sTransformRole = (String)jfJob.get("TransformRole");
            if (!DeploymentDecorator.isDIStudioJFJob(sTransformRole)) continue;
            bDIStudioJFJob = true;
        }
        return bDIStudioJFJob;
    }

    public static boolean isDIStudioJFJob(String sTransformRole) {
        if (sTransformRole.trim().length() == 0) {
            return true;
        }
        return sTransformRole.compareToIgnoreCase(DISTUDIO_JFJOBROLE) == 0;
    }
}

