/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.imsmc.visuals;

import com.sas.swing.visuals.util.Util;
import com.sas.workspace.imsmc.ApplicationProperty;
import com.sas.workspace.imsmc.ApplicationResource;
import com.sas.workspace.imsmc.visuals.BaseDialog;
import com.sas.workspace.imsmc.visuals.ImageHandler;
import com.sas.workspace.imsmc.visuals.MultipleButtonDialog;
import com.sas.workspace.imsmc.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MessageBox
extends BaseDialog {
    private static final long serialVersionUID = 277393395757644792L;
    protected String m_message;
    protected int m_icon;
    protected boolean m_addCheckboxForHidingThisMessageForever = false;
    protected JCheckBox m_hideThisForever = null;
    public static final int NONE_SELECTED = -1;
    public static final int YES = 1;
    public static final int YESALL = 2;
    public static final int NO = 3;
    protected static ApplicationResource bundle = new ApplicationResource(MessageBox.class);

    public MessageBox() {
        this._init();
    }

    public MessageBox(Frame parentFrame) {
        super(parentFrame, true);
        this._init();
    }

    public MessageBox(Frame parentFrame, String title) {
        super(parentFrame, title, true);
        this._init();
    }

    public MessageBox(Frame parentFrame, String title, boolean showCheckBox) {
        super(parentFrame, title, true);
        this.m_addCheckboxForHidingThisMessageForever = showCheckBox;
        this._init();
    }

    public MessageBox(Dialog parentDialog) {
        super(parentDialog, true);
        this._init();
    }

    public MessageBox(Dialog parentDialog, String title) {
        super(parentDialog, title, true);
        this._init();
    }

    public MessageBox(Dialog parentDialog, String title, boolean showCheckBox) {
        super(parentDialog, title, true);
        this.m_addCheckboxForHidingThisMessageForever = showCheckBox;
        this._init();
    }

    public boolean checkboxSelected() {
        boolean ret = false;
        if (this.m_hideThisForever != null) {
            ret = this.m_hideThisForever.isSelected();
        }
        return ret;
    }

    private void _init() {
        this.setButtonAlignment(2);
        this.m_message = "";
        this.m_icon = -1;
        if (this.m_addCheckboxForHidingThisMessageForever) {
            String resource = bundle.getString("MessageBox.DontShowMeThisAgain.txt");
            this.m_hideThisForever = new JCheckBox(Util.getLabelWithoutMnemonic((String)resource));
            int index = Util.getDisplayedMnemonicIndex((String)resource);
            if (index > -1) {
                int mnemonic = Util.getDisplayedMnemonic((String)resource);
                this.m_hideThisForever.setMnemonic(mnemonic);
                this.m_hideThisForever.setDisplayedMnemonicIndex(index);
            }
        }
    }

    public void setMessage(String message) {
        if (message != null && message.length() > 0) {
            this.m_message = message;
        }
    }

    public void setIcon(int iconType) {
        this.m_icon = iconType;
    }

    @Override
    public void buildDialog() {
        if (!this.isDialogBuilt()) {
            JPanel dialogPanel = new JPanel(new BorderLayout(11, 11));
            this.setDialogPanel(dialogPanel);
            ImageIcon icon = null;
            switch (this.m_icon) {
                case 2: {
                    icon = ImageHandler.getImageIcon(bundle, "Warn.gif");
                    break;
                }
                case 0: {
                    icon = ImageHandler.getImageIcon(bundle, "Error.gif");
                    break;
                }
                case 1: {
                    icon = ImageHandler.getImageIcon(bundle, "Inform.gif");
                    break;
                }
                case 3: {
                    icon = ImageHandler.getImageIcon(bundle, "Question.gif");
                }
            }
            if (icon != null) {
                dialogPanel.add((Component)new JLabel(icon), "West");
            }
            if (this.m_message != null && this.m_message.length() != 0) {
                dialogPanel.add((Component)new JLabel(this.m_message), "Center");
            }
            if (this.m_hideThisForever != null) {
                int leftOffset = 0;
                if (icon != null) {
                    leftOffset = icon.getIconWidth() + 10;
                }
                this.m_hideThisForever.setBorder(BorderFactory.createEmptyBorder(10, leftOffset, 0, 0));
                dialogPanel.add((Component)this.m_hideThisForever, "South");
            }
            if (0 < this.m_buttonDefault && this.m_buttonDefault <= 6) {
                this.setFirstFocus(this.m_buttons[this.m_buttonDefault]);
            }
            super.buildDialog();
        }
    }

    public static void showMessageBox(Component parent, String title, String message) {
        MessageBox.showMessageBox(parent, title, message, 2, null);
    }

    public static void showMessageBox(Component parent, String title, String message, int iconType) {
        MessageBox.showMessageBox(parent, title, message, iconType, null);
    }

    public static void showMessageBox(Component parent, String title, String message, int iconType, String appDefaultKeyName) {
        MessageBox dialog = null;
        boolean shouldShowThisMessage = true;
        if (appDefaultKeyName != null) {
            shouldShowThisMessage = ApplicationProperty.getBooleanProperty(appDefaultKeyName, shouldShowThisMessage);
        }
        if (shouldShowThisMessage) {
            Dialog parentDlg = WindowUtil.getParentDialog(parent);
            dialog = parentDlg != null ? new MessageBox(parentDlg, title, appDefaultKeyName != null) : new MessageBox(WindowUtil.getParentFrame(parent), title, appDefaultKeyName != null);
            dialog.setMessage(message);
            dialog.setIcon(iconType);
            dialog.setButtonShown(2, false);
            dialog.show();
            if (dialog.checkboxSelected()) {
                ApplicationProperty.setBooleanValue(appDefaultKeyName, false);
            }
        }
    }

    public static boolean showYesNoMessageBoxWithCheckbox(Component parent, String title, String message, int iconType, boolean yesIsDefault, String appDefaultKeyName) {
        MultipleButtonDialog dialog = null;
        boolean shouldShowThisMessage = true;
        if (appDefaultKeyName != null) {
            shouldShowThisMessage = ApplicationProperty.getBooleanProperty(appDefaultKeyName, shouldShowThisMessage);
        }
        if (shouldShowThisMessage) {
            Dialog parentDlg = WindowUtil.getParentDialog(parent);
            dialog = parentDlg != null ? new MultipleButtonDialog(parentDlg, title, shouldShowThisMessage) : new MultipleButtonDialog(WindowUtil.getParentFrame(parent), title, shouldShowThisMessage);
            dialog.setMessage(message);
            dialog.setIcon(iconType);
            dialog.setButtonText(1, bundle.getString("MessageBox.Button.Yes.txt"));
            dialog.setButtonShown(2, false);
            dialog.setButtonText(3, bundle.getString("MessageBox.Button.No.txt"));
            dialog.setButtonShown(3, true);
            dialog.setButtonDefault(yesIsDefault ? 1 : 3);
            dialog.addShortKeyAccelerators();
            dialog.show();
            if (dialog.checkboxSelected()) {
                ApplicationProperty.setBooleanValue(appDefaultKeyName, false);
            }
            return dialog.getButtonHit() == 1;
        }
        return false;
    }

    public static int showYesNoMessageBox(Component parent, String title, String message) {
        return MessageBox.showYesNoMessageBox(parent, title, message, 2, true);
    }

    public static int showYesNoMessageBox(Component parent, String title, String message, int iconType, boolean yesIsDefault) {
        MultipleButtonDialog dialog = null;
        Dialog parentDlg = WindowUtil.getParentDialog(parent);
        dialog = parentDlg != null ? new MultipleButtonDialog(parentDlg, title) : new MultipleButtonDialog(WindowUtil.getParentFrame(parent), title);
        dialog.setMessage(message);
        dialog.setIcon(iconType);
        dialog.setButtonText(1, bundle.getString("MessageBox.Button.Yes.txt"));
        dialog.setButtonShown(2, false);
        dialog.setButtonText(3, bundle.getString("MessageBox.Button.No.txt"));
        dialog.setButtonShown(3, true);
        dialog.setButtonDefault(yesIsDefault ? 1 : 3);
        dialog.addShortKeyAccelerators();
        dialog.show();
        return dialog.getButtonHit();
    }

    public static int showYesYesallNoMessageBox(Component parent, String title, String message) {
        return MessageBox.showYesYesallNoMessageBox(parent, title, message, 2, 1);
    }

    public static int showYesYesallNoMessageBox(Component parent, String title, String message, int iconType, int defaultButton) {
        MultipleButtonDialog dialog = null;
        Dialog parentDlg = WindowUtil.getParentDialog(parent);
        dialog = parentDlg != null ? new MultipleButtonDialog(parentDlg, title) : new MultipleButtonDialog(WindowUtil.getParentFrame(parent), title);
        dialog.setMessage(message);
        dialog.setIcon(iconType);
        dialog.setButtonText(1, bundle.getString("MessageBox.Button.Yes.txt"));
        dialog.setButtonText(2, bundle.getString("MessageBox.Button.YesToAll.txt"));
        dialog.setButtonText(3, bundle.getString("MessageBox.Button.No.txt"));
        dialog.setButtonShown(3, true);
        dialog.setButtonDefault(defaultButton);
        dialog.addShortKeyAccelerators();
        dialog.show();
        return dialog.getButtonHit();
    }
}

