/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.imsmc.visuals;

import com.sas.services.util.XMLUtil;
import com.sas.swing.util.SASJavaHelp;
import com.sas.workspace.Workspace;
import com.sas.workspace.imsmc.ApplicationResource;
import com.sas.workspace.imsmc.visuals.BaseComboBox;
import com.sas.workspace.imsmc.visuals.BaseDialog;
import com.sas.workspace.imsmc.visuals.GridBagPanel;
import com.sas.workspace.imsmc.visuals.LoggingOptionsPackageDescriptor;
import com.sas.workspace.imsmc.visuals.MessageBox;
import com.sas.workspace.imsmc.visuals.WindowUtil;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTextField;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingOptionsDialog
extends BaseDialog {
    private static final long serialVersionUID = -6271721535829072624L;
    protected Vector m_levelList = null;
    protected Vector m_packageList = null;
    protected Vector m_LOPD = null;
    protected BaseComboBox m_defaultLogging = null;
    protected JTextField m_outputFile = null;
    protected JButton m_browseButton = null;
    protected BaseComboBox m_log1Package = null;
    protected BaseComboBox m_log1Level = null;
    protected BaseComboBox m_log2Package = null;
    protected BaseComboBox m_log2Level = null;
    protected BaseComboBox m_log3Package = null;
    protected BaseComboBox m_log3Level = null;
    protected BaseComboBox m_log4Package = null;
    protected BaseComboBox m_log4Level = null;
    protected JTextField m_package1 = null;
    protected JTextField m_package2 = null;
    protected JTextField m_package3 = null;
    protected JTextField m_package4 = null;
    protected String m_DefaultLogName;
    static ApplicationResource bundle = new ApplicationResource(LoggingOptionsDialog.class);
    private static String sFatal = bundle.getString("LoggingOptionsDialog.DebugLevelfatal.txt");
    private static String sError = bundle.getString("LoggingOptionsDialog.DebugLevelerror.txt");
    private static String sWarn = bundle.getString("LoggingOptionsDialog.DebugLevelwarn.txt");
    private static String sInfo = bundle.getString("LoggingOptionsDialog.DebugLevelinfo.txt");
    private static String sDebug = bundle.getString("LoggingOptionsDialog.DebugLeveldebug.txt");
    private static Logger LOGGER = LogManager.getLogger(LoggingOptionsDialog.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggingOptionsDialog(JFrame parent, SASJavaHelp javaHelp, String appDefaultLogName, Vector loggingOptionsPackageDescriptors) {
        super((Frame)parent, true);
        this.m_DefaultLogName = appDefaultLogName;
        this.m_LOPD = loggingOptionsPackageDescriptors;
        if (this.m_LOPD == null) {
            this.m_LOPD = new Vector();
            this.m_LOPD.add(new LoggingOptionsPackageDescriptor("storedProcess", bundle.getString("LoggingOptionsDialog.DebugComponentstoredprocess.txt"), "com.sas.iquery.dataretrieval.StoredProcessHandler"));
            this.m_LOPD.add(new LoggingOptionsPackageDescriptor("metadata", bundle.getString("LoggingOptionsDialog.DebugComponentmetadata.txt"), "com.sas.metadata"));
            this.m_LOPD.add(new LoggingOptionsPackageDescriptor("mapStudio", bundle.getString("LoggingOptionsDialog.DebugComponentmapstudio.txt"), "com.sas.apps.mapStudio"));
            this.m_LOPD.add(new LoggingOptionsPackageDescriptor("iquery", bundle.getString("LoggingOptionsDialog.DebugComponentiquery.txt"), "com.sas.iquery"));
        }
        try {
            WindowUtil.busyOn(this);
            this.setTitle(bundle.getString("LoggingOptionsDialog.DialogTitle.txt"));
            if (javaHelp != null) {
                this.setHelpID(javaHelp, "diagsettings", "about");
            }
            this.init();
        }
        finally {
            WindowUtil.busyOff(this);
        }
    }

    public LoggingOptionsDialog(JFrame parent, SASJavaHelp javaHelp, String appDefaultLogName) {
        this(parent, javaHelp, appDefaultLogName, null);
    }

    private BaseComboBox makeLevelCombo() {
        if (this.m_levelList == null) {
            this.m_levelList = new Vector();
            this.m_levelList.add(sFatal);
            this.m_levelList.add(sError);
            this.m_levelList.add(sWarn);
            this.m_levelList.add(sInfo);
            this.m_levelList.add(sDebug);
        }
        BaseComboBox ret = new BaseComboBox(this.m_levelList);
        ret.setSelectedIndex(1);
        return ret;
    }

    private BaseComboBox makePackageCombo() {
        if (this.m_packageList == null) {
            this.m_packageList = new Vector();
            for (int i = 0; i < this.m_LOPD.size(); ++i) {
                this.m_packageList.add(((LoggingOptionsPackageDescriptor)this.m_LOPD.elementAt(i)).getLocalizedName());
            }
            this.m_packageList.add("");
        }
        BaseComboBox ret = new BaseComboBox(this.m_packageList);
        ret.setSelectedItem("");
        return ret;
    }

    private void init() {
        GridBagPanel mainPanel = new GridBagPanel();
        int gridy = 1;
        mainPanel.addLabel(0, gridy, bundle.getString("LoggingOptionsDialog.ExplanationGeneral.txt"), 5, 1, 1.0, 0.0, 17, 2);
        mainPanel.addLabel(0, ++gridy, bundle.getString("LoggingOptionsDialog.oneParen.txt"));
        mainPanel.addLabel(1, gridy, bundle.getString("LoggingOptionsDialog.ExplanationDefault.txt"), 4, 1, 1.0, 0.0, 17, 2);
        mainPanel.addLabel(1, ++gridy, bundle.getString("LoggingOptionsDialog.DefaultLoggingLabel.txt"));
        this.m_defaultLogging = this.makeLevelCombo();
        mainPanel.addComponent(1, ++gridy, this.m_defaultLogging, 1, 1, 1.0, 0.0, 17, 2);
        mainPanel.addLabel(0, ++gridy, bundle.getString("LoggingOptionsDialog.twoParen.txt"));
        mainPanel.addLabel(1, gridy, bundle.getString("LoggingOptionsDialog.ExplanationPairs.txt"), 4, 1, 1.0, 0.0, 17, 2);
        mainPanel.addLabel(1, ++gridy, bundle.getString("LoggingOptionsDialog.AreaOrPackageLabel.txt"));
        mainPanel.addLabel(3, gridy, bundle.getString("LoggingOptionsDialog.PackageLabel.txt"));
        mainPanel.addLabel(4, gridy, bundle.getString("LoggingOptionsDialog.LevelLabel.txt"));
        this.m_log1Package = this.makePackageCombo();
        mainPanel.addComponent(1, ++gridy, this.m_log1Package, 1, 1, 1.0, 0.0, 17, 2);
        mainPanel.addLabel(2, gridy, bundle.getString("LoggingOptionsDialog.or.txt"));
        this.m_package1 = mainPanel.addTextField(3, gridy, null);
        this.m_log1Level = this.makeLevelCombo();
        mainPanel.addComponent(4, gridy, this.m_log1Level, 1, 1, 1.0, 0.0, 17, 2);
        this.m_log2Package = this.makePackageCombo();
        mainPanel.addComponent(1, ++gridy, this.m_log2Package, 1, 1, 1.0, 0.0, 17, 2);
        mainPanel.addLabel(2, gridy, bundle.getString("LoggingOptionsDialog.or.txt"));
        this.m_package2 = mainPanel.addTextField(3, gridy, null);
        this.m_log2Level = this.makeLevelCombo();
        mainPanel.addComponent(4, gridy, this.m_log2Level, 1, 1, 1.0, 0.0, 17, 2);
        this.m_log3Package = this.makePackageCombo();
        mainPanel.addComponent(1, ++gridy, this.m_log3Package, 1, 1, 1.0, 0.0, 17, 2);
        mainPanel.addLabel(2, gridy, bundle.getString("LoggingOptionsDialog.or.txt"));
        this.m_package3 = mainPanel.addTextField(3, gridy, null);
        this.m_log3Level = this.makeLevelCombo();
        mainPanel.addComponent(4, gridy, this.m_log3Level, 1, 1, 1.0, 0.0, 17, 2);
        this.m_log4Package = this.makePackageCombo();
        mainPanel.addComponent(1, ++gridy, this.m_log4Package, 1, 1, 1.0, 0.0, 17, 2);
        mainPanel.addLabel(2, gridy, bundle.getString("LoggingOptionsDialog.or.txt"));
        this.m_package4 = mainPanel.addTextField(3, gridy, null);
        this.m_log4Level = this.makeLevelCombo();
        mainPanel.addComponent(4, gridy, this.m_log4Level, 1, 1, 1.0, 0.0, 17, 2);
        mainPanel.addLabel(0, ++gridy, bundle.getString("LoggingOptionsDialog.threeParen.txt"), 1, 1, 1.0, 0.0, 16, 2);
        mainPanel.addLabel(1, gridy, bundle.getString("LoggingOptionsDialog.ExplanationOutputFile.txt"), 4, 1, 1.0, 0.0, 17, 2);
        mainPanel.addLabel(1, ++gridy, bundle.getString("LoggingOptionsDialog.LoggingOutputFileLabel.txt"));
        this.m_outputFile = mainPanel.addTextField(1, ++gridy, this.m_DefaultLogName, 3, 1, 1, 0, 10, 2);
        this.m_browseButton = mainPanel.addButton(4, gridy, bundle.getString("Common.Browse....txt"), 1, 1, 1, 0, 10, 0, 0, 0, 6, 6);
        ++gridy;
        this.setDialogPanel(mainPanel);
        this.m_browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filepath = LoggingOptionsDialog.this.getLoggingFile();
                int pathindex = filepath.lastIndexOf(System.getProperty("file.separator"));
                if (pathindex > 0) {
                    filepath = filepath.substring(0, pathindex);
                }
                JFileChooser chooser = new JFileChooser(filepath);
                chooser.setDialogTitle(bundle.getString("LoggingOptionsDialog.BrowseDialogTitle.txt"));
                int returnVal = chooser.showOpenDialog(LoggingOptionsDialog.this);
                if (returnVal == 0) {
                    String fileSelected = chooser.getSelectedFile().getAbsolutePath();
                    LOGGER.debug("You chose log file: " + fileSelected);
                    LoggingOptionsDialog.this.m_outputFile.setText(fileSelected);
                }
            }
        });
    }

    private String getClause(JComboBox areacombo, JTextField textarea, JComboBox levelcombo) {
        String ret = "";
        if ((ret = ret + textarea.getText().trim()).trim().length() == 0) {
            String areatext = this.getTokenString(areacombo);
            if (areatext.trim().length() > 0) {
                ret = ret + areatext;
                ret = ret + ",";
                ret = ret + this.getLevelString(levelcombo);
            }
        } else {
            ret = ret + ",";
            ret = ret + this.getLevelString(levelcombo);
        }
        return ret;
    }

    private String getTokenString(JComboBox pkgcombo) {
        String pkgtext = pkgcombo.getSelectedItem().toString();
        String retval = "";
        for (int i = 0; i < this.m_LOPD.size(); ++i) {
            LoggingOptionsPackageDescriptor lopd = (LoggingOptionsPackageDescriptor)this.m_LOPD.elementAt(i);
            if (!pkgtext.equals(lopd.getLocalizedName())) continue;
            return lopd.getTokenName();
        }
        return retval;
    }

    private String getLevelString(JComboBox levelcombo) {
        String leveltext = levelcombo.getSelectedItem().toString();
        String retval = "";
        retval = leveltext.equals(sFatal) ? "FATAL" : (leveltext.equals(sError) ? "ERROR" : (leveltext.equals(sWarn) ? "WARN" : (leveltext.equals(sInfo) ? "INFO" : "DEBUG")));
        return retval;
    }

    public String getLoggingFile() {
        String retValue = this.m_outputFile.getText().trim();
        if (retValue.length() == 0) {
            retValue = this.m_DefaultLogName;
        }
        if (retValue.indexOf(System.getProperty("file.separator")) < 0) {
            retValue = System.getProperty("user.home") + System.getProperty("file.separator") + retValue;
        }
        return retValue;
    }

    public String getPatternString() {
        String outfile;
        String retval = "";
        String currentsel = null;
        currentsel = this.getLevelString(this.m_defaultLogging);
        if (currentsel.trim().length() > 0) {
            if (retval.trim().length() > 0) {
                retval = retval + ",";
            }
            retval = retval + "DEFAULT,";
            retval = retval + currentsel.trim();
        }
        if ((outfile = this.getLoggingFile()).length() > 0) {
            if (retval.trim().length() > 0) {
                retval = retval + ",";
            }
            retval = retval + "LOGFILE,";
            retval = retval + outfile;
        }
        if ((currentsel = this.getClause(this.m_log1Package, this.m_package1, this.m_log1Level)).trim().length() > 0) {
            if (retval.trim().length() > 0) {
                retval = retval + ",";
            }
            retval = retval + currentsel.trim();
        }
        if ((currentsel = this.getClause(this.m_log2Package, this.m_package2, this.m_log2Level)).trim().length() > 0) {
            if (retval.trim().length() > 0) {
                retval = retval + ",";
            }
            retval = retval + currentsel.trim();
        }
        if ((currentsel = this.getClause(this.m_log3Package, this.m_package3, this.m_log3Level)).trim().length() > 0) {
            if (retval.trim().length() > 0) {
                retval = retval + ",";
            }
            retval = retval + currentsel.trim();
        }
        if ((currentsel = this.getClause(this.m_log4Package, this.m_package4, this.m_log4Level)).trim().length() > 0) {
            if (retval.trim().length() > 0) {
                retval = retval + ",";
            }
            retval = retval + currentsel.trim();
        }
        LOGGER.debug("Returned pattern string:" + retval);
        return retval;
    }

    @Override
    public void onOK() {
        File logfile = new File(this.getLoggingFile());
        if (!logfile.exists() || logfile.canWrite()) {
            super.onOK();
        } else {
            MessageBox.showMessageBox(this, bundle.getString("LoggingOptionsDialogErrorTitle.txt"), bundle.getString("LoggingOptionsDialog.LoggingOutputFileError.txt"));
        }
    }

    private static Vector getWords(String userInput) {
        Vector<String> words = new Vector<String>();
        String leftovers = userInput;
        while (leftovers.indexOf(",") > -1) {
            int equal = leftovers.indexOf(",");
            String word = leftovers.substring(0, equal);
            leftovers = leftovers.substring(equal + 1, leftovers.length());
            words.addElement(word);
        }
        if (leftovers.trim().length() > 0) {
            words.addElement(leftovers.trim());
        }
        return words;
    }

    public void setDebuggingBasedOnPattern(String userInput) {
        this.setDebuggingBasedOnPattern(userInput, false);
    }

    public void setDebuggingBasedOnPattern(String userInput, boolean useWorkSpaceLogger) {
        Vector words = LoggingOptionsDialog.getWords(userInput);
        String layoutPattern = "%d [%t] %-5p %c - %m%n";
        String outputFile = "IMS_Log.log";
        String defaultLoggingLevel = "ERROR";
        Vector<String> debug = new Vector<String>();
        Vector<String> info = new Vector<String>();
        Vector<String> warn = new Vector<String>();
        Vector<String> error = new Vector<String>();
        Vector<String> fatal = new Vector<String>();
        int cursor = 0;
        while (cursor < words.size()) {
            String value;
            String actionOrPackage = (String)words.elementAt(cursor);
            if (++cursor >= words.size()) {
                return;
            }
            if (actionOrPackage.equalsIgnoreCase("DEFAULT")) {
                value = (String)words.elementAt(cursor);
                ++cursor;
                defaultLoggingLevel = LoggingOptionsDialog.getLevelForWord(value);
                continue;
            }
            if (actionOrPackage.equalsIgnoreCase("LOGFILE")) {
                value = (String)words.elementAt(cursor);
                ++cursor;
                outputFile = value;
                continue;
            }
            String pkg = this.getPackageNameForToken(actionOrPackage);
            String value2 = (String)words.elementAt(cursor);
            ++cursor;
            if ((value2 = LoggingOptionsDialog.getLevelForWord(value2)).equals("DEBUG")) {
                debug.addElement(pkg);
                continue;
            }
            if (value2.equals("INFO")) {
                info.addElement(pkg);
                continue;
            }
            if (value2.equals("WARN")) {
                warn.addElement(pkg);
                continue;
            }
            if (value2.equals("ERROR")) {
                error.addElement(pkg);
                continue;
            }
            if (value2.equals("FATAL")) {
                fatal.addElement(pkg);
                continue;
            }
            throw new RuntimeException("Impossible debug value of " + value2);
        }
        if (useWorkSpaceLogger) {
            try {
                Vector<String> defaultPackage = new Vector<String>();
                defaultPackage.add("com.sas");
                if (defaultLoggingLevel.equals("DEBUG")) {
                    Workspace.setLoggingPriorities(defaultPackage, Level.DEBUG.intLevel());
                } else if (defaultLoggingLevel.equals("INFO")) {
                    Workspace.setLoggingPriorities(defaultPackage, Level.INFO.intLevel());
                } else if (defaultLoggingLevel.equals("WARN")) {
                    Workspace.setLoggingPriorities(defaultPackage, Level.WARN.intLevel());
                } else if (defaultLoggingLevel.equals("ERROR")) {
                    Workspace.setLoggingPriorities(defaultPackage, Level.ERROR.intLevel());
                } else if (defaultLoggingLevel.equals("FATAL")) {
                    Workspace.setLoggingPriorities(defaultPackage, Level.FATAL.intLevel());
                } else {
                    throw new RuntimeException("Impossible default logging value of " + defaultLoggingLevel);
                }
                Workspace.setLoggingPriorities(debug, Level.DEBUG.intLevel());
                Workspace.setLoggingPriorities(info, Level.INFO.intLevel());
                Workspace.setLoggingPriorities(warn, Level.WARN.intLevel());
                Workspace.setLoggingPriorities(error, Level.ERROR.intLevel());
                Workspace.setLoggingPriorities(fatal, Level.FATAL.intLevel());
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", e);
                return;
            }
        }
        String loggerDeploymentString = LoggingOptionsDialog.generateLoggingXML(defaultLoggingLevel, outputFile, layoutPattern, debug, info, warn, error, fatal);
        try {
            File tempLoggingInstructions = File.createTempFile("SAS-logging-", ".xml");
            tempLoggingInstructions.deleteOnExit();
            String loggingInstructionsFilename = tempLoggingInstructions.getCanonicalPath();
            FileOutputStream fos = new FileOutputStream(loggingInstructionsFilename);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(loggerDeploymentString);
            osw.close();
            fos.close();
            System.setProperty("com.sas.services.logging.configurationURL", "file:" + loggingInstructionsFilename);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", e);
            return;
        }
    }

    private String getPackageNameForToken(String word) {
        String retval = word;
        for (int i = 0; i < this.m_LOPD.size(); ++i) {
            LoggingOptionsPackageDescriptor lopd = (LoggingOptionsPackageDescriptor)this.m_LOPD.elementAt(i);
            if (!word.equals(lopd.getTokenName())) continue;
            return lopd.getPackage();
        }
        return retval;
    }

    private static String getLevelForWord(String word) {
        String retval = "";
        if (word.toUpperCase().charAt(0) == 'D') {
            retval = "DEBUG";
        } else if (word.toUpperCase().charAt(0) == 'I') {
            retval = "INFO";
        } else if (word.toUpperCase().charAt(0) == 'W') {
            retval = "WARN";
        } else if (word.toUpperCase().charAt(0) == 'E') {
            retval = "ERROR";
        } else if (word.toUpperCase().charAt(0) == 'F') {
            retval = "FATAL";
        } else {
            throw new RuntimeException("illegal arg " + word);
        }
        return retval;
    }

    private static String generateLoggingXML(String defaultLoggingLevel, String outputFile, String layoutPattern, Vector debug, Vector info, Vector warn, Vector error, Vector fatal) {
        String word;
        int i;
        String retval = "";
        retval = retval + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n";
        retval = retval + "<LoggingService>\n\n";
        retval = retval + "  <!-- LOG CONTEXTS - WHAT TO LOG                                           -->\n\n";
        retval = retval + "  <!-- Default for all subsystems outside of IMS                            -->\n";
        retval = retval + "  <RootLoggingContext priority = \"" + defaultLoggingLevel + "\">\n";
        retval = retval + "    <OutputRef outputID = \"SAS\" />\n";
        retval = retval + "  </RootLoggingContext>\n\n";
        retval = retval + "  <LoggingContext name     = \"com.sas\"\n";
        retval = retval + "                  priority = \"" + defaultLoggingLevel + "\"\n";
        retval = retval + "                  chained  = \"false\">\n";
        retval = retval + "    <OutputRef outputID = \"SAS\" />\n";
        retval = retval + "  </LoggingContext>\n\n";
        for (i = 0; i < debug.size(); ++i) {
            word = ((String)debug.elementAt(i)).trim();
            retval = retval + "  <LoggingContext name     = \"" + word + "\"\n";
            retval = retval + "                  priority = \"DEBUG\"\n";
            retval = retval + "                  chained  = \"false\">\n";
            retval = retval + "    <OutputRef outputID = \"SAS\" />\n";
            retval = retval + "  </LoggingContext>\n";
            retval = retval + "\n";
        }
        for (i = 0; i < info.size(); ++i) {
            word = ((String)info.elementAt(i)).trim();
            retval = retval + "  <LoggingContext name     = \"" + word + "\"\n";
            retval = retval + "                  priority = \"INFO\"\n";
            retval = retval + "                  chained  = \"false\">\n";
            retval = retval + "    <OutputRef outputID = \"SAS\" />\n";
            retval = retval + "  </LoggingContext>\n";
            retval = retval + "\n";
        }
        for (i = 0; i < warn.size(); ++i) {
            word = ((String)warn.elementAt(i)).trim();
            retval = retval + "  <LoggingContext name     = \"" + word + "\"\n";
            retval = retval + "                  priority = \"WARN\"\n";
            retval = retval + "                  chained  = \"false\">\n";
            retval = retval + "    <OutputRef outputID = \"SAS\" />\n";
            retval = retval + "  </LoggingContext>\n";
            retval = retval + "\n";
        }
        for (i = 0; i < error.size(); ++i) {
            word = ((String)error.elementAt(i)).trim();
            retval = retval + "  <LoggingContext name     = \"" + word + "\"\n";
            retval = retval + "                  priority = \"ERROR\"\n";
            retval = retval + "                  chained  = \"false\">\n";
            retval = retval + "    <OutputRef outputID = \"SAS\" />\n";
            retval = retval + "  </LoggingContext>\n";
            retval = retval + "\n";
        }
        for (i = 0; i < fatal.size(); ++i) {
            word = ((String)fatal.elementAt(i)).trim();
            retval = retval + "  <LoggingContext name     = \"" + word + "\"\n";
            retval = retval + "                  priority = \"FATAL\"\n";
            retval = retval + "                  chained  = \"false\">\n";
            retval = retval + "    <OutputRef outputID = \"SAS\" />\n";
            retval = retval + "  </LoggingContext>\n";
            retval = retval + "\n";
        }
        retval = retval + "  <!-- OUTPUT SPECIFICATIONS - HOW/WHERE TO DISPLAY LOGS                    -->\n";
        retval = retval + "  <!--                                                                      -->\n";
        retval = retval + "  <!-- The layoutPatterns include 'percent' codes. These include:           -->\n";
        retval = retval + "  <!-- c: the logging context. Followed by {n}, only includes the n         -->\n";
        retval = retval + "  <!--    right-most parts of the logging context. For instance, if {2} is  -->\n";
        retval = retval + "  <!--    used for context com.sas.apps.citation.util, 'citation.util' is   -->\n";
        retval = retval + "  <!--    included in the output.                                           -->\n";
        retval = retval + "  <!-- d: date/time stamp. Typically followed by {ABSOLUTE}, {DATE} or      -->\n";
        retval = retval + "  <!--    {ISO8601}.                                                        -->\n";
        retval = retval + "  <!-- m: the message.                                                      -->\n";
        retval = retval + "  <!-- n: newline in OS-appropriate form.                                   -->\n";
        retval = retval + "  <!-- p: priority \"DEBUG\" ... \"ERROR\"                                      -->\n";
        retval = retval + "  <!-- s: session context. Very useful for debugging multi-session code,    -->\n";
        retval = retval + "  <!--    but adds a long string to the output.                             -->\n";
        retval = retval + "  <!-- t: thread id.                                                        -->\n\n";
        retval = retval + "  <!-- u: user name. Useful for debugging multi-user code.                  -->\n\n";
        retval = retval + "  <Output id            = \"SAS\"\n";
        retval = retval + "          type          = \"File\"\n";
        retval = retval + "          layoutPattern = \"" + layoutPattern + "\">\n";
        retval = retval + "    <param name  = \"File\"\n";
        String tmpOutputFile = XMLUtil.normalize((String)outputFile);
        retval = retval + "           value = \"" + tmpOutputFile + "\" />\n";
        retval = retval + "    <param name  = \"Append\"\n";
        retval = retval + "           value = \"true\" />\n";
        retval = retval + "  </Output>\n";
        retval = retval + "\n";
        retval = retval + "</LoggingService>\n";
        retval = retval + "\n";
        return retval;
    }
}

