/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class WsWindowsDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WsWindowsDialog.class);

    public WsWindowsDialog() {
        super(Workspace.getWorkspace(), bundle.getString("WsWindowsDialog.WindowTitle.txt"), true);
        this.setMainPanel(new cMainPanel());
        this.setLocationRelativeTo(Workspace.getWorkspace());
    }

    @Override
    public boolean onOK() {
        boolean brc = super.onOK();
        if (brc) {
            JInternalFrame frm = ((cMainPanel)this.getMainPanel()).getSelectedFrame();
            Workspace.getWorkspace().getDesktopWindowHandle().activateFrame(frm);
        }
        return brc;
    }

    protected class cMainPanel
    extends WAPanel {
        private static final long serialVersionUID = 1L;
        protected JLabel m_lblWindows;
        protected JList m_lstWindows;
        protected JScrollPane m_scrWindows;
        protected JInternalFrame m_frmSelected;

        public cMainPanel() {
            this.initialize();
            this.layoutWidgets();
        }

        public JInternalFrame getSelectedFrame() {
            return this.m_frmSelected;
        }

        @Override
        public boolean doDataExchange(boolean bSaveToModel) {
            if (bSaveToModel) {
                int iFrame = this.m_lstWindows.getSelectedIndex();
                this.m_frmSelected = Workspace.getWorkspace().getDesktopWindowHandle().getAllFrames()[iFrame];
            } else {
                JInternalFrame[] aFrames = Workspace.getWorkspace().getDesktopWindowHandle().getAllFrames();
                int nFrames = aFrames.length;
                String[] aTitles = new String[nFrames];
                for (int iFrame = 0; iFrame < nFrames; ++iFrame) {
                    aTitles[iFrame] = aFrames[iFrame].getTitle();
                }
                this.m_lstWindows.setListData(aTitles);
                this.m_lstWindows.setSelectedIndex(0);
            }
            return true;
        }

        @Override
        public boolean validateData() {
            return true;
        }

        @Override
        protected void initialize() {
            this.m_lstWindows = new JList();
            this.m_lstWindows.setSelectionMode(0);
            this.m_scrWindows = new JScrollPane(this.m_lstWindows);
            this.m_scrWindows.setPreferredSize(new Dimension(200, 300));
            this.m_lblWindows = new JLabel(bundle.getString("WsWindowsDialog.ListLabel.txt"));
            this.m_lblWindows.setDisplayedMnemonic(bundle.getString("WsWindowsDialog.ListLabel.mnem").charAt(0));
            this.m_lblWindows.setLabelFor(this.m_lstWindows);
        }

        @Override
        protected void layoutWidgets() {
            this.setLayout(new BorderLayout(0, 5));
            this.add((Component)this.m_lblWindows, "North");
            this.add((Component)this.m_scrWindows, "Center");
        }
    }
}

