/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsStringTableColumn;
import java.text.MessageFormat;

public class WsUniqueNameTableColumn
extends WsStringTableColumn {
    private static WAdminResource bundle = WAdminResource.getBundle(WsUniqueNameTableColumn.class);
    protected String m_sFormat;
    protected WsAbstractTableModel m_mdlTable;
    protected boolean m_bCaseSensitive;

    public WsUniqueNameTableColumn(WsAbstractTableModel mdlTable, int iModelIndex) {
        this(mdlTable, iModelIndex, 75);
    }

    public WsUniqueNameTableColumn(WsAbstractTableModel mdlTable, int iModelIndex, int cxWidth) {
        this(mdlTable, iModelIndex, "", cxWidth);
    }

    public WsUniqueNameTableColumn(WsAbstractTableModel mdlTable, int iModelIndex, String sName, int cxWidth) {
        this(mdlTable, iModelIndex, sName, cxWidth, Integer.MAX_VALUE);
    }

    public WsUniqueNameTableColumn(WsAbstractTableModel mdlTable, int iModelIndex, String sName, int cxWidth, int nMaximum) {
        super(iModelIndex, sName, cxWidth, nMaximum);
        this.m_mdlTable = mdlTable;
        this.m_sFormat = bundle.getString("Common.Untitled.fmt");
        this.setColumnClass(String.class);
    }

    @Override
    public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
        String sValue = (String)oValue;
        if (sValue.trim().length() == 0) {
            String sMessage = bundle.formatString("WsUniqueNameTableColumn.NoTextError.fmt", this.getName());
            MessageUtil.displayMessage(sMessage, 0);
            return false;
        }
        if (!this.validateNameUniqueness(sValue, iRow)) {
            String sMessage = bundle.formatString("WsUniqueNameTableColumn.NotUniqueError.fmt", this.getName(), sValue);
            MessageUtil.displayMessage(sMessage, 0);
            return false;
        }
        return true;
    }

    @Override
    public Object createDefaultValue() {
        int nInstances = this.m_mdlTable.getRowInstanceCount();
        String sName = this.generateName(nInstances);
        while (!this.validateNameUniqueness(sName, -1)) {
            this.m_mdlTable.setRowInstanceCount(++nInstances);
            sName = this.generateName(nInstances);
        }
        return sName;
    }

    protected String generateName(int nInstances) {
        Object[] args = new Object[]{new Integer(nInstances)};
        return MessageFormat.format(this.m_sFormat, args);
    }

    protected boolean validateNameUniqueness(String sTestName, int iTestRow) {
        int nRows = this.m_mdlTable.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            boolean bEquals;
            if (iRow == iTestRow) continue;
            String sName = (String)this.m_mdlTable.getValueAt(iRow, this.getModelIndex());
            boolean bl = bEquals = this.m_bCaseSensitive ? sTestName.equals(sName) : sTestName.equalsIgnoreCase(sName);
            if (!bEquals) continue;
            return false;
        }
        return true;
    }

    public void setFormatString(String sFormat) {
        this.m_sFormat = sFormat;
    }

    public String getFormatString() {
        return this.m_sFormat;
    }

    public void setCaseSensitive(boolean bCaseSensitive) {
        this.m_bCaseSensitive = bCaseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.m_bCaseSensitive;
    }
}

