/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.DNDObject;
import com.sas.workspace.WsDefaultTreeCellRenderer;
import com.sas.workspace.WsTree;
import com.sas.workspace.WsTreeNode;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class WsTreeUI
extends BasicTreeUI {
    private DragGestureListener m_lsnrDragGesture;
    private DragGestureRecognizer m_rcnzrDragGesture;
    private DragSourceListener m_lsnrDragSource;

    public static ComponentUI createUI(JComponent cmp) {
        return new WsTreeUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.m_lsnrDragSource = this.createDragSourceListener();
        this.m_lsnrDragGesture = this.createDragGestureListener();
        this.m_rcnzrDragGesture = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.tree, 3, this.m_lsnrDragGesture);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        DragSource.getDefaultDragSource().removeDragSourceListener(this.m_lsnrDragSource);
        this.m_rcnzrDragGesture.removeDragGestureListener(this.m_lsnrDragGesture);
    }

    @Override
    protected MouseListener createMouseListener() {
        return new cMouseListener();
    }

    @Override
    protected TreeSelectionListener createTreeSelectionListener() {
        return new cTreeSelectionListener();
    }

    @Override
    protected TreeCellRenderer createDefaultCellRenderer() {
        return new WsDefaultTreeCellRenderer();
    }

    protected DragGestureListener createDragGestureListener() {
        return new cDragGestureListener();
    }

    protected DragSourceListener createDragSourceListener() {
        return new cDragSourceListener();
    }

    @Override
    protected boolean shouldPaintExpandControl(TreePath path, int iRow, boolean bExpanded, boolean bHasBeenExpanded, boolean bLeaf) {
        if (this.tree instanceof WsTree && !((WsTree)this.tree).areExpandControlsVisible()) {
            return false;
        }
        return super.shouldPaintExpandControl(path, iRow, bExpanded, bHasBeenExpanded, bLeaf);
    }

    @Override
    protected boolean isToggleEvent(MouseEvent ev) {
        if (this.tree instanceof WsTree && !((WsTree)this.tree).isExpandActionEnabled()) {
            return false;
        }
        return super.isToggleEvent(ev);
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle rClip, Insets insets, Rectangle rBounds, TreePath path, int iRow, boolean bExpanded, boolean bHasBeenExpanded, boolean bLeaf) {
        if (this.tree instanceof WsTree && ((WsTree)this.tree).isDrawLines()) {
            super.paintHorizontalPartOfLeg(g, rClip, insets, rBounds, path, iRow, bExpanded, bHasBeenExpanded, bLeaf);
        }
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics g, Rectangle rClip, Insets insets, TreePath path) {
        if (this.tree instanceof WsTree && ((WsTree)this.tree).isDrawLines()) {
            super.paintVerticalPartOfLeg(g, rClip, insets, path);
        }
    }

    protected class cDragSourceListener
    implements DragSourceListener {
        protected cDragSourceListener() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
        }

        @Override
        public void dragExit(DragSourceEvent e) {
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
        }
    }

    protected class cDragGestureListener
    implements DragGestureListener {
        protected cDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent event) {
            if (!(WsTreeUI.this.tree instanceof WsTree)) {
                return;
            }
            WsTree treeWS = (WsTree)WsTreeUI.this.tree;
            if (!treeWS.isDraggingEnabled()) {
                return;
            }
            if (WsTreeUI.this.tree.isEditing()) {
                return;
            }
            WsTreeNode[] aSelectedNodes = treeWS.getSelectedNodes();
            if (aSelectedNodes.length != 0) {
                DNDObject oDrag = new DNDObject();
                for (int iSelectedNode = 0; iSelectedNode < aSelectedNodes.length; ++iSelectedNode) {
                    if (!aSelectedNodes[iSelectedNode].isDragSource()) {
                        return;
                    }
                    Object obj = aSelectedNodes[iSelectedNode].getDragObject();
                    if (obj == null) continue;
                    oDrag.add(obj);
                }
                DragSource.getDefaultDragSource().startDrag(event, null, oDrag, WsTreeUI.this.m_lsnrDragSource);
            }
        }
    }

    protected class cMouseListener
    extends BasicTreeUI.MouseHandler {
        protected cMouseListener() {
            super(WsTreeUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!WsTreeUI.this.tree.isEnabled()) {
                return;
            }
            if (WsTreeUI.this.tree.isEditing() && !WsTreeUI.this.tree.stopEditing()) {
                return;
            }
            if (e.isPopupTrigger()) {
                this.triggerPopup(e);
                return;
            }
            if (WsTreeUI.this.tree.getSelectionCount() > 1 && !e.isControlDown() && !e.isShiftDown() && this.isPointOnSelectedPath(e.getPoint())) {
                WsTreeUI.this.tree.requestFocus();
            } else {
                super.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!WsTreeUI.this.tree.isEnabled()) {
                return;
            }
            if (e.isPopupTrigger()) {
                this.triggerPopup(e);
                return;
            }
            if (WsTreeUI.this.tree.getSelectionCount() > 1 && !e.isControlDown() && !e.isShiftDown() && this.isPointOnSelectedPath(e.getPoint())) {
                MouseEvent ePressed = new MouseEvent((Component)e.getSource(), 501, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), false, e.getButton());
                super.mousePressed(ePressed);
            }
            if (e.getClickCount() == 2 && WsTreeUI.this.tree instanceof WsTree) {
                TreePath[] aSelectedPaths;
                WsTree treeWS = (WsTree)WsTreeUI.this.tree;
                TreePath path = WsTreeUI.this.tree.getPathForLocation(e.getX(), e.getY());
                if (WsTreeUI.this.tree.isPathSelected(path) && (aSelectedPaths = WsTreeUI.this.tree.getSelectionPaths()).length == 1) {
                    WsTreeNode node = (WsTreeNode)aSelectedPaths[0].getLastPathComponent();
                    AbstractAction actUserDefault = treeWS.getUserDefaultAction();
                    if (actUserDefault != null) {
                        if (actUserDefault.isEnabled()) {
                            actUserDefault.actionPerformed(new ActionEvent(treeWS, 1, "default"));
                        }
                    } else if (treeWS.isDefaultActionEnabled()) {
                        node.doDefaultAction();
                    }
                }
            }
            super.mouseReleased(e);
        }

        protected boolean isPointOnSelectedPath(Point pt) {
            TreePath path = WsTreeUI.this.tree.getPathForLocation(pt.x, pt.y);
            return path != null && WsTreeUI.this.tree.isPathSelected(path);
        }

        protected void triggerPopup(MouseEvent e) {
            if (WsTreeUI.this.tree instanceof WsTree) {
                if (!e.isShiftDown() && !e.isControlDown()) {
                    TreePath path = WsTreeUI.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (!WsTreeUI.this.tree.isPathSelected(path)) {
                        WsTreeUI.this.tree.setSelectionPath(path);
                    }
                }
                ((WsTree)WsTreeUI.this.tree).showPopupMenu(e);
            }
        }
    }

    protected class cTreeSelectionListener
    extends BasicTreeUI.TreeSelectionHandler {
        protected cTreeSelectionListener() {
            super(WsTreeUI.this);
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (WsTreeUI.this.tree instanceof WsTree) {
                WsTree treeWS = (WsTree)WsTreeUI.this.tree;
                if (treeWS.getSelectionCount() == 1) {
                    treeWS.setActiveNode(treeWS.getSelectedNode());
                } else {
                    treeWS.setActiveNode(null);
                }
                treeWS.updateActions();
            }
            super.valueChanged(e);
        }
    }
}

