/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.CMetadata;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTreeModel;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.tree.WsTreeModel;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;

public class WsTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WsTreeNode.class);
    protected boolean m_bDropTarget = false;
    protected boolean m_bDragSource = true;
    private Object m_oDrag;
    protected boolean m_bRenameable = false;
    protected boolean m_bDeleteable = false;
    protected boolean m_bIsExpanded = false;
    protected boolean m_bHasExpanded = false;
    protected String m_sName;
    protected WorkspaceTreeModel m_Model;
    private WsTreeModel m_mdlTree;
    protected boolean m_bSorted = true;
    protected Icon m_icon;

    public WsTreeNode(String sName) {
        this(sName, null);
    }

    public WsTreeNode(String sName, Icon icon) {
        super(sName);
        this.m_icon = icon;
        this.m_sName = sName;
    }

    public void setModel(WorkspaceTreeModel model) {
        this.m_Model = model;
        this.m_mdlTree = model;
    }

    public WorkspaceTreeModel getModel() {
        return this.m_Model;
    }

    public void setTreeModel(WsTreeModel mdl) {
        this.m_mdlTree = mdl;
        if (mdl == null || mdl instanceof WorkspaceTreeModel) {
            this.m_Model = (WorkspaceTreeModel)mdl;
        }
    }

    public WsTreeModel getTreeModel() {
        return this.m_mdlTree;
    }

    public String getName() {
        return this.m_sName;
    }

    public void updateName(String sName) {
        this.setName(sName);
    }

    public void rename(String sName) {
        this.updateName(sName);
    }

    public boolean isValidName(String sName) {
        if (sName.trim().length() == 0) {
            MessageUtil.displayMessage(bundle.getString("WsTreeNode.Error.NoName.txt"), 0);
            return false;
        }
        return true;
    }

    public void setName(String sName) {
        if (this.m_sName.equals(sName)) {
            return;
        }
        this.m_sName = sName;
        if (this.m_mdlTree == null) {
            return;
        }
        WsTreeNode nodeParent = (WsTreeNode)this.getParent();
        if (nodeParent.isSorted()) {
            this.m_mdlTree.resortChild(this);
        } else {
            this.m_mdlTree.nodeChanged(this);
        }
    }

    public void addPopupMenuItems(JPopupMenu mnuPopup) {
    }

    public Icon getIcon(boolean bExpanded) {
        return this.getIcon();
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public void setIcon(Icon icon) {
        this.m_icon = icon;
        if (this.m_mdlTree != null) {
            this.m_mdlTree.nodeChanged(this);
        }
    }

    public String getToolTip() {
        return null;
    }

    public CMetadata getMetadata() {
        return null;
    }

    public void updateMetadata(CMetadata oMetadata) {
    }

    public String getFQID() {
        return null;
    }

    public void setDragObject(Object oDrag) {
        this.m_oDrag = oDrag;
    }

    public Object getDragObject() {
        return this.m_oDrag;
    }

    public boolean hasExpanded() {
        return this.m_bHasExpanded;
    }

    public void setHasExpanded(boolean bHasExpanded) {
        this.m_bHasExpanded = bHasExpanded;
    }

    public void expand() {
        if (!this.hasExpanded()) {
            this.addChildren();
            this.setHasExpanded(true);
        }
    }

    public boolean isExpanded() {
        return this.m_bIsExpanded;
    }

    public void setIsExpanded(boolean bIsExpanded) {
        this.m_bIsExpanded = bIsExpanded;
    }

    public boolean isEditable() {
        return this.m_bDeleteable && this.m_bRenameable;
    }

    public void setIsEditable(boolean bIsEditable) {
        this.m_bRenameable = bIsEditable;
        this.m_bDeleteable = bIsEditable;
    }

    public boolean isDeleteable() {
        return this.m_bDeleteable;
    }

    public boolean isReallyDeleteable() {
        return this.m_bDeleteable;
    }

    public boolean isReallyDestroyable() {
        return this.m_bDeleteable;
    }

    public boolean isReallyCMDeleteable() {
        return this.m_bDeleteable;
    }

    public void setDeleteable(boolean bDeleteable) {
        this.m_bDeleteable = bDeleteable;
    }

    public boolean isRenameable() {
        return this.m_bRenameable;
    }

    public void setRenameable(boolean bRenameable) {
        this.m_bRenameable = bRenameable;
    }

    public boolean isDropTarget() {
        return this.m_bDropTarget;
    }

    public boolean isDropTarget(DropTargetDragEvent e) {
        return this.m_bDropTarget;
    }

    public boolean isDropTarget(DropTargetDropEvent e) {
        return this.m_bDropTarget;
    }

    public void setDropTarget(boolean bDropTarget) {
        this.m_bDropTarget = bDropTarget;
    }

    public void drop(DropTargetDropEvent e) {
        Workspace.getDefaultLogger().debug("dropped on " + this.m_sName);
    }

    public boolean isDragSource() {
        return this.m_bDragSource;
    }

    public void setDragSource(boolean bDragSource) {
        this.m_bDragSource = bDragSource;
    }

    public void setSorted(boolean bSorted) {
        this.m_bSorted = bSorted;
    }

    public boolean isSorted() {
        return this.m_bSorted;
    }

    public void addChildren() {
        System.out.println("AddChildren: " + this.m_sName);
    }

    public void removeChildren() {
        this.m_mdlTree.removeAllChildren(this);
    }

    public boolean equals(WsTreeNode node) {
        return this.m_sName.equals(node.m_sName);
    }

    public int hashcode() {
        return super.hashCode();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
    }

    public JPopupMenu getPopupMenu(WAdminResource aBundle) {
        return new JPopupMenu();
    }

    public void doDefaultAction() {
    }

    public void delete() {
    }

    @Override
    public String toString() {
        return this.m_sName;
    }

    public boolean isValidAncestorFor(CMetadata oMetadata) {
        return false;
    }

    public boolean isValidParentFor(CMetadata oMetadata) {
        return false;
    }

    public void addChild(WsTreeNode nodeChild) {
        this.m_mdlTree.addChild(nodeChild, this);
    }

    public WsTreeNode createChild(CMetadata oMetadata) {
        return new WsDataTreeNode(oMetadata);
    }

    public WsTreeNode createChild(String sName) {
        return new WsTreeNode(sName);
    }

    public void removeChild(WsTreeNode nodeChild) {
        this.m_mdlTree.removeChild(nodeChild);
    }

    @Override
    public Object clone() {
        WsTreeNode nodeClone = (WsTreeNode)super.clone();
        if (this.children != null) {
            nodeClone.children = (Vector)this.children.clone();
        }
        return nodeClone;
    }
}

