/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAdminResource;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

public class WsTitledPageFormat
extends PageFormat
implements Printable {
    private static final WAdminResource bundle = WAdminResource.getBundle(WsTitledPageFormat.class);
    private String m_sTitle;
    private Font m_font;
    private double m_cyText;

    public WsTitledPageFormat(String sTitle) {
        this(sTitle, new Font("Sans Serif", 0, 12));
    }

    public WsTitledPageFormat(String sTitle, Font font) {
        this.m_sTitle = sTitle;
        this.m_font = font;
        this.m_cyText = (double)this.m_font.getSize() * 2.0;
    }

    @Override
    public double getImageableHeight() {
        double cyImage = super.getImageableHeight() - 2.0 * this.m_cyText;
        return Math.max(cyImage, 0.0);
    }

    @Override
    public double getImageableY() {
        double yImage = super.getImageableY() + this.m_cyText;
        return Math.max(yImage, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print(Graphics g, PageFormat page, int iPage) throws PrinterException {
        if (page != this) {
            throw new PrinterException("Invalid use of TitlePageFormat");
        }
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            int xPage = (int)page.getImageableX();
            int yPage = (int)super.getImageableY();
            int cxPage = (int)page.getImageableWidth();
            int cyPage = (int)super.getImageableHeight();
            g2d.translate(xPage, yPage);
            g2d.setClip(0, 0, cxPage, cyPage);
            g2d.setPaint(Color.black);
            g2d.setFont(this.m_font);
            FontMetrics fm = g2d.getFontMetrics();
            Rectangle2D rHeader = fm.getStringBounds(this.m_sTitle, g2d);
            int xHeader = (cxPage - (int)rHeader.getWidth()) / 2;
            int yHeader = fm.getAscent() + fm.getLeading();
            g2d.drawString(this.m_sTitle.toString(), xHeader, yHeader);
            String sFooter = bundle.formatString("WsTitledPageFormat.Footer.fmt.txt", new Integer(iPage + 1));
            Rectangle2D rFooter = fm.getStringBounds(sFooter, g2d);
            int xFooter = (cxPage - (int)rFooter.getWidth()) / 2;
            int yFooter = cyPage - fm.getDescent() - fm.getLeading();
            g2d.drawString(sFooter.toString(), xFooter, yFooter);
        }
        finally {
            g2d.dispose();
        }
        return 0;
    }
}

