/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WsComponentPrinter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.print.PageFormat;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;

public class WsTextPrinter
extends WsComponentPrinter {
    private JTextComponent m_txt;
    private boolean m_bReset;
    private Color m_clrText;
    private Color m_clrBackground;
    private Color m_clrSelectionText;
    private Color m_clrSelectionBackground;
    private boolean m_bLineWrap;
    private boolean m_bWordWrap;

    public WsTextPrinter(JTextComponent txt, PageFormat page) {
        this(txt, page, false);
    }

    public WsTextPrinter(JTextComponent txt, PageFormat page, boolean bAsIs) {
        super(txt, page);
        this.m_txt = txt;
        if (!bAsIs) {
            this.m_clrText = txt.getForeground();
            this.m_clrBackground = txt.getBackground();
            this.m_clrSelectionText = txt.getSelectedTextColor();
            this.m_clrSelectionBackground = txt.getSelectionColor();
            this.m_bReset = true;
            txt.setForeground(Color.black);
            txt.setBackground(Color.white);
            txt.setSelectedTextColor(Color.black);
            txt.setSelectionColor(Color.white);
            if (txt instanceof JTextArea) {
                this.m_bLineWrap = ((JTextArea)txt).getLineWrap();
                this.m_bWordWrap = ((JTextArea)txt).getWrapStyleWord();
                ((JTextArea)txt).setLineWrap(true);
                ((JTextArea)txt).setWrapStyleWord(true);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.m_bReset) {
            this.m_txt.setForeground(this.m_clrText);
            this.m_txt.setBackground(this.m_clrBackground);
            this.m_txt.setSelectedTextColor(this.m_clrSelectionText);
            this.m_txt.setSelectionColor(this.m_clrSelectionBackground);
            if (this.m_txt instanceof JTextArea) {
                ((JTextArea)this.m_txt).setLineWrap(this.m_bLineWrap);
                ((JTextArea)this.m_txt).setWrapStyleWord(this.m_bWordWrap);
            }
        }
    }

    @Override
    protected Dimension getPrintableDimensions() {
        Dimension dimPrint = this.m_txt.getSize();
        if (dimPrint.width == 0 && dimPrint.height == 0) {
            if (this.m_txt instanceof JTextPane || this.m_txt instanceof JTextArea && ((JTextArea)this.m_txt).getLineWrap()) {
                Dimension dim = new Dimension((int)this.m_page.getImageableWidth(), (int)this.m_page.getImageableHeight());
                this.m_txt.setSize(dim);
            }
            dimPrint = this.m_txt.getPreferredSize();
            this.m_txt.setSize(dimPrint);
        }
        return dimPrint;
    }

    @Override
    protected int getPageHeight() {
        int cyPage = super.getPageHeight();
        if (this.m_txt instanceof JTextArea) {
            int cyRow = this.m_txt.getFontMetrics(this.m_txt.getFont()).getHeight();
            cyPage = cyPage / cyRow * cyRow;
        }
        return cyPage;
    }
}

