/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.swing.visuals.tableview.OriginComponent;
import com.sas.swing.visuals.tableview.RowHeader;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.workspace.WsComponentPrinter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class WsTablePrinter
extends WsComponentPrinter {
    private JTable m_tbl;
    private JTableHeader m_hdrColumn;
    private RowHeader m_hdrRow;
    private OriginComponent m_hdrOrigin;
    private List m_lPageRects;
    private int m_cxRowHeader;
    private int m_cyColumnHeader;
    private boolean m_bRestore;
    private Color m_clrForeground;
    private Color m_clrBackground;
    private Color m_clrForegroundSelection;
    private Color m_clrBackgroundSelection;
    private Color m_clrBackgroundParent;

    public WsTablePrinter(JTable tbl, PageFormat page) {
        this(tbl, page, true);
    }

    public WsTablePrinter(JTable tbl, PageFormat page, boolean bAsIs) {
        super(tbl, page);
        this.m_tbl = tbl;
        this.m_hdrColumn = tbl.getTableHeader();
        if (tbl instanceof TableView) {
            this.m_hdrRow = ((TableView)tbl).getRowHeader();
            this.m_hdrOrigin = (OriginComponent)((TableView)tbl).getOriginComponent();
        }
        if (!bAsIs) {
            this.m_clrForeground = tbl.getForeground();
            this.m_clrBackground = tbl.getBackground();
            this.m_clrForegroundSelection = tbl.getSelectionForeground();
            this.m_clrBackgroundSelection = tbl.getSelectionBackground();
            this.m_clrBackgroundParent = tbl.getParent().getBackground();
            this.m_bRestore = true;
            tbl.setForeground(Color.black);
            tbl.setBackground(Color.white);
            tbl.setSelectionForeground(Color.black);
            tbl.setSelectionBackground(Color.white);
            tbl.getParent().setBackground(Color.white);
        }
    }

    @Override
    public void dispose() {
        if (this.m_bRestore) {
            this.m_tbl.setForeground(this.m_clrForeground);
            this.m_tbl.setBackground(this.m_clrBackground);
            this.m_tbl.setSelectionForeground(this.m_clrForegroundSelection);
            this.m_tbl.setSelectionBackground(this.m_clrBackgroundSelection);
            this.m_tbl.getParent().setBackground(this.m_clrBackgroundParent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print(Graphics g, PageFormat page, int iPage) throws PrinterException {
        if (page instanceof Printable) {
            ((Printable)((Object)page)).print(g, page, iPage);
        }
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            int xPage = (int)page.getImageableX();
            int yPage = (int)page.getImageableY();
            g2d.translate(xPage, yPage);
            Rectangle rPage = (Rectangle)this.m_lPageRects.get(iPage);
            if (this.m_hdrOrigin != null) {
                this.m_hdrOrigin.printAll((Graphics)g2d);
            }
            if (this.m_hdrRow != null) {
                g2d.setClip(0, this.m_cyColumnHeader, this.m_cxRowHeader, rPage.height);
                g2d.translate(0, -(rPage.y - this.m_cyColumnHeader));
                this.m_hdrRow.printAll((Graphics)g2d);
                g2d.translate(0, rPage.y - this.m_cyColumnHeader);
            }
            if (this.m_hdrColumn != null) {
                g2d.setClip(this.m_cxRowHeader, 0, rPage.width, this.m_cyColumnHeader);
                g2d.translate(-(rPage.x - this.m_cxRowHeader), 0);
                this.m_hdrColumn.printAll(g2d);
                g2d.translate(rPage.x - this.m_cxRowHeader, 0);
            }
            g2d.setClip(this.m_cxRowHeader, this.m_cyColumnHeader, rPage.width, rPage.height);
            g2d.translate(-(rPage.x - this.m_cxRowHeader), -(rPage.y - this.m_cyColumnHeader));
            this.m_tbl.printAll(g2d);
            g2d.translate(rPage.x - this.m_cxRowHeader, rPage.y - this.m_cyColumnHeader);
        }
        finally {
            g2d.dispose();
        }
        return 0;
    }

    @Override
    protected void calculateNumberOfPages() {
        int cxTable = this.m_tbl.getWidth();
        int cyTable = this.m_tbl.getHeight();
        if (cxTable == 0 && cyTable == 0) {
            this.m_tbl.setSize(this.m_tbl.getPreferredSize());
            cxTable = this.m_tbl.getWidth();
            cyTable = this.m_tbl.getHeight();
        }
        int cxPage = (int)this.m_page.getImageableWidth();
        int cyPage = (int)this.m_page.getImageableHeight();
        this.m_cxRowHeader = this.m_hdrRow == null ? 0 : this.m_hdrRow.getWidth();
        this.m_cyColumnHeader = this.m_hdrColumn == null ? 0 : this.m_hdrColumn.getHeight();
        cxPage -= this.m_cxRowHeader;
        cyPage -= this.m_cyColumnHeader;
        TableColumnModel mdlColumns = this.m_tbl.getColumnModel();
        ArrayList<Integer> lPageWidths = new ArrayList<Integer>();
        int cxPageCurrent = 0;
        for (int iColumn = 0; iColumn < this.m_tbl.getColumnCount(); ++iColumn) {
            int cxColumn = mdlColumns.getColumn(iColumn).getWidth();
            if (cxPageCurrent + cxColumn > cxPage) {
                lPageWidths.add(new Integer(cxPageCurrent));
                cxPageCurrent = 0;
            }
            cxPageCurrent += cxColumn;
        }
        lPageWidths.add(new Integer(cxPageCurrent));
        ArrayList<Integer> lPageHeights = new ArrayList<Integer>();
        int cyPageCurrent = 0;
        for (int iRow = 0; iRow < this.m_tbl.getRowCount(); ++iRow) {
            int cyRow = this.m_tbl.getRowHeight(iRow);
            if (cyPageCurrent + cyRow > cyPage) {
                lPageHeights.add(new Integer(cyPageCurrent));
                cyPageCurrent = 0;
            }
            cyPageCurrent += cyRow;
        }
        lPageHeights.add(new Integer(cyPageCurrent));
        int nPagesX = lPageWidths.size();
        int nPagesY = lPageHeights.size();
        this.m_nPages = nPagesX * nPagesY;
        this.m_lPageRects = new ArrayList(this.m_nPages);
        int yPage = 0;
        for (int iPageY = 0; iPageY < nPagesY; ++iPageY) {
            cyPageCurrent = (Integer)lPageHeights.get(iPageY);
            int xPage = 0;
            for (int iPageX = 0; iPageX < nPagesX; ++iPageX) {
                cxPageCurrent = (Integer)lPageWidths.get(iPageX);
                this.m_lPageRects.add(new Rectangle(xPage, yPage, cxPageCurrent, cyPageCurrent));
                xPage += cxPageCurrent;
            }
            yPage += cyPageCurrent;
        }
    }
}

