/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.swing.visuals.tableview.ColumnHeader;
import com.sas.swing.visuals.tableview.HoldInterface;
import com.sas.swing.visuals.tableview.OriginComponent;
import com.sas.swing.visuals.tableview.RowHeader;
import com.sas.swing.visuals.tableview.TableRowModel;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.workspace.WATableCellRenderer;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultRowHeader;
import com.sas.workspace.WsDefaultTableColumnHeader;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsShuttleSorter;
import com.sas.workspace.WsSorterInterface;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsTableUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.TableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class WsTable
extends TableView {
    private static final long serialVersionUID = 1L;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    private static WAdminResource bundle = WAdminResource.getBundle(WsTable.class);
    protected boolean m_bEditable;
    protected boolean m_bSortingEnabled;
    private boolean m_bKeepSortedEnabled;
    protected boolean m_bColumnHidingEnabled;
    protected boolean m_bColumnHoldingEnabled;
    protected boolean m_bRowHoldingEnabled;
    protected Color m_clrNonEditableCellBackground;
    protected Color m_clrEditableCellBackground;
    private Color m_clrNonFocusSelectionBackground;
    private Color m_clrNonFocusSelectionForeground;
    protected boolean m_bOriginPopupMenuEnabled;
    protected boolean m_bColumnHeaderPopupMenuEnabled;
    protected boolean m_bRowHeaderPopupMenuEnabled;
    protected boolean m_bTablePopupMenuEnabled;
    protected boolean m_bViewportPopupMenuEnabled;
    protected boolean m_bHeaderTooltipsEnabled;
    protected WsPopupMenuRequestListener m_lsnrOriginPopupMenuRequest;
    protected WsPopupMenuRequestListener m_lsnrColumnHeaderPopupMenuRequest;
    protected WsPopupMenuRequestListener m_lsnrRowHeaderPopupMenuRequest;
    protected WsPopupMenuRequestListener m_lsnrTablePopupMenuRequest;
    protected WsPopupMenuRequestListener m_lsnrViewportPopupMenuRequest;
    protected UndoManager m_mgrUndo;
    private WsSorterInterface m_sorter;
    private Action m_actDelete;
    private Action m_actDefault;
    protected MouseListener m_lsnrViewportMouse;
    protected WsTableRowModelListener m_lsnrRowModel;
    protected WsAbstractAction m_actHideColumn;
    protected WsAbstractAction m_actShowColumns;
    protected WsAbstractAction m_actShowAllColumns;
    protected WsAbstractAction m_actSortAscending;
    protected WsAbstractAction m_actSortDescending;
    protected WsAbstractAction m_actSortOriginal;
    protected WsAbstractAction m_actHoldColumnLeft;
    protected WsAbstractAction m_actHoldColumnRight;
    protected WsAbstractAction m_actReleaseColumns;
    protected WsAbstractAction m_actReleaseAllColumns;
    protected WsAbstractAction m_actHoldRowTop;
    protected WsAbstractAction m_actHoldRowBottom;
    protected WsAbstractAction m_actReleaseRows;
    protected WsAbstractAction m_actReleaseAllRows;
    protected int m_iPopupMenuRow;
    protected int m_iPopupMenuColumn;
    protected int[] m_aSortColumns;
    protected int[] m_aSortDirections;

    public WsTable(WsAbstractTableModel mdl) {
        super((TableModel)mdl);
    }

    public String getUIClassID() {
        String sUIClassID = "WsTableUI";
        if (!UIManager.getDefaults().containsKey(sUIClassID)) {
            UIManager.put(sUIClassID, WsTableUI.class.getName());
        }
        return sUIClassID;
    }

    protected TableUI createUI() {
        return new WsTableUI();
    }

    public void setEditable(boolean bEditable) {
        this.m_bEditable = bEditable;
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    public void setSortingEnabled(boolean bEnabled) {
        this.m_bSortingEnabled = bEnabled;
    }

    public boolean isSortingEnabled() {
        return this.m_bSortingEnabled;
    }

    public void setKeepSortedEnabled(boolean bEnabled) {
        this.m_bKeepSortedEnabled = bEnabled;
    }

    public boolean isKeepSortedEnabled() {
        return this.m_bKeepSortedEnabled;
    }

    public void setColumnHidingEnabled(boolean bEnabled) {
        this.m_bColumnHidingEnabled = bEnabled;
    }

    public boolean isColumnHidingEnabled() {
        return this.m_bColumnHidingEnabled;
    }

    public void setColumnHoldingEnabled(boolean bEnabled) {
        this.m_bColumnHoldingEnabled = bEnabled;
    }

    public boolean isColumnHoldingEnabled() {
        return this.m_bColumnHidingEnabled;
    }

    public void setRowHoldingEnabled(boolean bEnabled) {
        this.m_bRowHoldingEnabled = bEnabled;
    }

    public boolean isRowHoldingEnabled() {
        return this.m_bRowHoldingEnabled;
    }

    public void setColumnsReorderable(boolean bReorderable) {
        this.getColumnHeader().setReorderingAllowed(bReorderable);
    }

    public boolean isColumnsReorderable() {
        return this.getColumnHeader().getReorderingAllowed();
    }

    public void setColumnHeaderToolTipsEnabled(boolean bTooltipsEnabled) {
        this.m_bHeaderTooltipsEnabled = bTooltipsEnabled;
    }

    public boolean isColumnHeaderToolTipsEnabled() {
        return this.m_bHeaderTooltipsEnabled;
    }

    public void setNonEditableCellBackground(Color clrNonEditableCellBackground) {
        this.m_clrNonEditableCellBackground = clrNonEditableCellBackground;
        this.repaint();
    }

    public Color getNonEditableCellBackground() {
        if (this.m_clrNonEditableCellBackground == null) {
            return this.getBackground();
        }
        return this.m_clrNonEditableCellBackground;
    }

    public void setEditableCellBackground(Color clrEditableCellBackground) {
        this.m_clrEditableCellBackground = clrEditableCellBackground;
        this.repaint();
    }

    public Color getEditableCellBackground() {
        if (this.m_clrEditableCellBackground == null) {
            return this.getBackground();
        }
        return this.m_clrEditableCellBackground;
    }

    public void setNonFocusSelectionBackground(Color clrNonFocusSelectionBackground) {
        if (clrNonFocusSelectionBackground == null) {
            Color clrBackground = UIManager.getColor("Table.background");
            int red = (SystemColor.controlShadow.getRed() + clrBackground.getRed()) / 2;
            int green = (SystemColor.controlShadow.getGreen() + clrBackground.getGreen()) / 2;
            int blue = (SystemColor.controlShadow.getBlue() + clrBackground.getBlue()) / 2;
            clrNonFocusSelectionBackground = new Color(red, green, blue);
        }
        this.m_clrNonFocusSelectionBackground = clrNonFocusSelectionBackground;
        this.repaint();
    }

    public Color getNonFocusSelectionBackground() {
        return this.m_clrNonFocusSelectionBackground;
    }

    public void setNonFocusSelectionForeground(Color clrNonFocusSelectionForeground) {
        if (clrNonFocusSelectionForeground == null) {
            clrNonFocusSelectionForeground = this.getForeground();
        }
        this.m_clrNonFocusSelectionForeground = clrNonFocusSelectionForeground;
        this.repaint();
    }

    public Color getNonFocusSelectionForeground() {
        return this.m_clrNonFocusSelectionForeground;
    }

    public void setColumnHeaderPopupMenuEnabled(boolean bEnabled) {
        this.m_bColumnHeaderPopupMenuEnabled = bEnabled;
    }

    public boolean isColumnHeaderPopupMenuEnabled() {
        return this.m_bColumnHeaderPopupMenuEnabled;
    }

    public void setRowHeaderPopupMenuEnabled(boolean bEnabled) {
        this.m_bRowHeaderPopupMenuEnabled = bEnabled;
    }

    public boolean isRowHeaderPopupMenuEnabled() {
        return this.m_bRowHeaderPopupMenuEnabled;
    }

    public void setTablePopupMenuEnabled(boolean bEnabled) {
        this.m_bTablePopupMenuEnabled = bEnabled;
    }

    public boolean isTablePopupMenuEnabled() {
        return this.m_bTablePopupMenuEnabled;
    }

    public void setOriginPopupMenuEnabled(boolean bEnabled) {
        this.m_bOriginPopupMenuEnabled = bEnabled;
    }

    public boolean isOriginPopupMenuEnabled() {
        return this.m_bOriginPopupMenuEnabled;
    }

    public void setViewportPopupMenuEnabled(boolean bEnabled) {
        this.m_bViewportPopupMenuEnabled = bEnabled;
    }

    public boolean isViewportPopupMenuEnabled() {
        return this.m_bViewportPopupMenuEnabled;
    }

    public void setColumnHeaderPopupMenuRequestListener(WsPopupMenuRequestListener lsnrPopupMenuRequest) {
        this.m_lsnrColumnHeaderPopupMenuRequest = lsnrPopupMenuRequest;
    }

    public WsPopupMenuRequestListener getColumnHeaderPopupMenuRequestListener() {
        return this.m_lsnrColumnHeaderPopupMenuRequest;
    }

    public void setRowHeaderPopupMenuRequestListener(WsPopupMenuRequestListener lsnrPopupMenuRequest) {
        this.m_lsnrRowHeaderPopupMenuRequest = lsnrPopupMenuRequest;
    }

    public WsPopupMenuRequestListener getRowHeaderPopupMenuRequestListener() {
        return this.m_lsnrRowHeaderPopupMenuRequest;
    }

    public void setTablePopupMenuRequestListener(WsPopupMenuRequestListener lsnrPopupMenuRequest) {
        this.m_lsnrTablePopupMenuRequest = lsnrPopupMenuRequest;
    }

    public WsPopupMenuRequestListener getTablePopupMenuRequestListener() {
        return this.m_lsnrTablePopupMenuRequest;
    }

    public void setOriginPopupMenuRequestListener(WsPopupMenuRequestListener lsnrPopupMenuRequest) {
        this.m_lsnrOriginPopupMenuRequest = lsnrPopupMenuRequest;
    }

    public WsPopupMenuRequestListener getOriginPopupMenuRequestListener() {
        return this.m_lsnrOriginPopupMenuRequest;
    }

    public void setViewportPopupMenuRequestListener(WsPopupMenuRequestListener lsnrPopupMenuRequest) {
        this.m_lsnrViewportPopupMenuRequest = lsnrPopupMenuRequest;
    }

    public WsPopupMenuRequestListener getViewportPopupMenuRequestListener() {
        return this.m_lsnrViewportPopupMenuRequest;
    }

    public void setPopupMenuRow(int iRow) {
        this.m_iPopupMenuRow = iRow;
    }

    public int getPopupMenuRow() {
        return this.m_iPopupMenuRow;
    }

    public void setPopupMenuColumn(int iCol) {
        this.m_iPopupMenuColumn = iCol;
    }

    public int getPopupMenuColumn() {
        return this.m_iPopupMenuColumn;
    }

    public void setUndoManager(UndoManager mgrUndo) {
        this.m_mgrUndo = mgrUndo;
    }

    public UndoManager getUndoManager() {
        return this.m_mgrUndo;
    }

    public void setDeleteKeyAction(Action actDelete) {
        this.m_actDelete = actDelete;
    }

    public Action getDeleteKeyAction() {
        return this.m_actDelete;
    }

    public void setDefaultAction(Action actDefault) {
        this.m_actDefault = actDefault;
    }

    public Action getDefaultAction() {
        return this.m_actDefault;
    }

    public void setMouseBlockSelectionEnabled(boolean bEnabled) {
        ((WsTableUI)((Object)this.getUI())).setMouseBlockSelectionEnabled(bEnabled);
    }

    public boolean isMouseBlockSelectionEnabled() {
        return ((WsTableUI)((Object)this.getUI())).isMouseBlockSelectionEnabled();
    }

    public void setMultipleSelectionDragEnabled(boolean bEnabled) {
        ((WsTableUI)((Object)this.getUI())).setMultipleSelectionDragEnabled(bEnabled);
    }

    public boolean isMultipleSelectionDragEnabled() {
        return ((WsTableUI)((Object)this.getUI())).isMultipleSelectionDragEnabled();
    }

    public void setSorter(WsSorterInterface sorter) {
        this.m_sorter = sorter;
    }

    public WsSorterInterface getSorter() {
        return this.m_sorter;
    }

    public boolean isOriginalOrder() {
        return ((WsDefaultTableRowModel)this.getRowModel()).isOriginalOrder();
    }

    protected void initializeLocalVars() {
        this.setAutoResizeMode(0);
        this.setColumnAutoResizeMode(0);
        super.initializeLocalVars();
        this.setEditable(true);
        this.setSortingEnabled(true);
        this.setColumnHidingEnabled(true);
        this.setColumnHoldingEnabled(true);
        this.setRowHoldingEnabled(true);
        this.setNonFocusSelectionBackground(null);
        this.setNonFocusSelectionForeground(null);
        this.setTablePopupMenuEnabled(true);
        this.setOriginPopupMenuEnabled(true);
        this.setRowHeaderPopupMenuEnabled(true);
        this.setColumnHeaderPopupMenuEnabled(true);
        this.setViewportPopupMenuEnabled(true);
        this.setPopupMenuRow(-1);
        this.setPopupMenuColumn(-1);
        this.m_aSortColumns = null;
        this.m_aSortDirections = null;
        this.setCellSelectionEnabled(true);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.getRowHeader().setResizingAllowed(false);
        this.createActions();
        this.createListeners();
        this.installListeners();
        this.setDefaultRenderer(Object.class, new WATableCellRenderer());
        this.setSorter(new WsShuttleSorter());
    }

    protected RowHeader createDefaultRowHeader() {
        return new WsDefaultRowHeader(this.getRowModel());
    }

    protected TableRowModel createDefaultRowModel() {
        return new WsDefaultTableRowModel(this);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new WsDefaultTableColumnHeader(this.getColumnModel());
    }

    protected JComponent createDefaultOriginComponent() {
        OriginComponent cmp = (OriginComponent)super.createDefaultOriginComponent();
        cmp.setHeaderValue((Object)bundle.getString("WsDefaultTableHeader.Origin.txt"));
        cmp.setAction(this.createDefaultOriginAction());
        return cmp;
    }

    protected void configureEnclosingScrollPane() {
        JScrollPane scr = this.getScrollPane();
        if (scr == null) {
            return;
        }
        JViewport viewport = scr.getViewport();
        if (viewport == null || viewport.getView() != this) {
            return;
        }
        viewport.setBackground(this.getBackground());
        viewport.addMouseListener(this.m_lsnrViewportMouse);
        super.configureEnclosingScrollPane();
    }

    protected void unconfigureEnclosingScrollPane() {
        JScrollPane scr = this.getScrollPane();
        if (scr == null) {
            return;
        }
        JViewport viewport = scr.getViewport();
        if (viewport == null || viewport.getView() != this) {
            return;
        }
        viewport.setBackground(UIManager.getColor("Viewport.background"));
        viewport.removeMouseListener(this.m_lsnrViewportMouse);
        super.unconfigureEnclosingScrollPane();
    }

    public void showPopup(int iRow, int iCol) {
        Rectangle rCell = this.getCellRect(iRow, iCol, true);
        Point ptCell = new Point(rCell.x, rCell.y);
        this.showPopup(iRow, iCol, ptCell);
    }

    public void showPopup(Point pt) {
        int iCol = this.getComponentOrientation().isLeftToRight() && pt.x > this.getCellAreaWidth() ? this.getColumnCount() : (!this.getComponentOrientation().isLeftToRight() && pt.x < 0 ? this.getColumnCount() : this.columnAtPoint(pt));
        int iRow = pt.y > this.getCellAreaHeight() ? this.getRowCount() : this.rowAtPoint(pt);
        this.showPopup(iRow, iCol, pt);
    }

    protected void showPopup(int iRow, int iCol, Point pt) {
        if (!this.isPopupMenuEnabled()) {
            return;
        }
        if (!this.stopCellEditing()) {
            return;
        }
        if (iRow == -1 && iCol == -1) {
            this.firePopupMenuRequest(this.isOriginPopupMenuEnabled(), this.getOriginPopupMenuRequestListener(), this.getOriginComponent(), iRow, iCol, pt);
        } else if (iRow == -1 && iCol >= 0) {
            this.firePopupMenuRequest(this.isColumnHeaderPopupMenuEnabled(), this.getColumnHeaderPopupMenuRequestListener(), this.getTableHeader(), iRow, iCol, pt);
        } else if (iRow >= 0 && iCol == -1) {
            this.firePopupMenuRequest(this.isRowHeaderPopupMenuEnabled(), this.getRowHeaderPopupMenuRequestListener(), (Component)this.getRowHeader(), iRow, iCol, pt);
        } else if (iRow == this.getRowCount() || iCol == this.getColumnCount()) {
            JScrollPane scr = this.getScrollPane();
            if (scr == null) {
                return;
            }
            this.firePopupMenuRequest(this.isViewportPopupMenuEnabled(), this.getViewportPopupMenuRequestListener(), scr.getViewport(), iRow, iCol, pt);
        } else {
            this.firePopupMenuRequest(this.isTablePopupMenuEnabled(), this.getTablePopupMenuRequestListener(), (Component)((Object)this), iRow, iCol, pt);
        }
    }

    private void firePopupMenuRequest(boolean bEnabled, WsPopupMenuRequestListener lsnr, Component cmp, int iRow, int iCol, Point pt) {
        if (!bEnabled || lsnr == null) {
            return;
        }
        this.setPopupMenuRow(iRow);
        this.setPopupMenuColumn(iCol);
        pt = SwingUtilities.convertPoint((Component)((Object)this), pt, cmp);
        MouseEvent e = new MouseEvent(cmp, 501, 0L, 0, pt.x, pt.y, 1, true);
        lsnr.popupMenuRequested(e);
    }

    public void moveRow(int iFrom, int iTo) {
        if (!this.stopCellEditing()) {
            return;
        }
        super.moveRow(iFrom, iTo);
        this.clearSortMemory();
    }

    public int getRowCount() {
        TableRowModel mdlRows = this.getRowModel();
        if (mdlRows instanceof WsDefaultTableRowModel) {
            return mdlRows.getRowCount();
        }
        return super.getRowCount();
    }

    public boolean isCellEditable(int iRow, int iCol) {
        if (!this.m_bEditable) {
            return false;
        }
        return super.isCellEditable(iRow, iCol);
    }

    public void createDefaultColumnsFromModel() {
        WsAbstractTableModel mdl = (WsAbstractTableModel)this.getModel();
        if (mdl != null) {
            int iColumn;
            TableColumnModel mdlColumns = this.getColumnModel();
            int nColumns = mdlColumns.getColumnCount();
            for (iColumn = 0; iColumn < nColumns; ++iColumn) {
                mdlColumns.removeColumn(mdlColumns.getColumn(0));
            }
            nColumns = mdl.getColumnCount();
            for (iColumn = 0; iColumn < nColumns; ++iColumn) {
                mdlColumns.addColumn(mdl.getColumn(iColumn).getTableColumn());
            }
        }
    }

    public boolean editCellAt(int iRow, int iCol) {
        boolean brc = super.editCellAt(iRow, iCol);
        if (brc) {
            Component cmpEditor = this.getEditorComponent();
            cmpEditor.requestFocus();
        }
        return brc;
    }

    public void editingStopped(ChangeEvent e) {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            Object oNewValue = editor.getCellEditorValue();
            Object oOldValue = this.getValueAt(this.editingRow, this.editingColumn);
            if (!oOldValue.equals(oNewValue)) {
                if (this.validateValueAt(oNewValue, this.editingRow, this.editingColumn)) {
                    this.undoableSetValueAt(oNewValue, this.editingRow, this.editingColumn);
                    this.removeEditor();
                } else {
                    int iRow = this.editingRow;
                    int iCol = this.editingColumn;
                    this.removeEditor();
                    this.editCellAt(iRow, iCol);
                }
            } else {
                this.removeEditor();
            }
        }
    }

    public void removeEditor() {
        super.removeEditor();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WsTable.this.requestFocus();
            }
        });
    }

    public JPopupMenu createColumnHeaderPopupMenu() {
        JPopupMenu mnuPopup = new JPopupMenu();
        this.addColumnHeaderMenuItems(mnuPopup);
        return mnuPopup;
    }

    public void addColumnHeaderMenuItems(JPopupMenu mnuPopup) {
        int iColumn = this.getPopupMenuColumn();
        int nColumns = this.getColumnCount();
        boolean bValidColumn = 0 <= iColumn && iColumn < nColumns;
        boolean bHeldColumn = false;
        if (bValidColumn) {
            ColumnHeader mgrHold = this.getColumnHeader();
            bHeldColumn = mgrHold.isHeld(this.convertColumnIndexToModel(iColumn));
        }
        if (this.m_bColumnHidingEnabled) {
            this.m_actHideColumn.setEnabled(bValidColumn && !bHeldColumn && nColumns > 1);
            mnuPopup.add(this.m_actHideColumn);
            mnuPopup.add(this.createShowColumnsSubmenu());
        }
        if (this.m_bColumnHoldingEnabled) {
            this.m_actHoldColumnLeft.setEnabled(bValidColumn && !bHeldColumn && nColumns > 1);
            this.m_actHoldColumnRight.setEnabled(bValidColumn && !bHeldColumn && nColumns > 1);
            this.addSeparatorIfNeeded(mnuPopup);
            mnuPopup.add(this.m_actHoldColumnLeft);
            mnuPopup.add(this.m_actHoldColumnRight);
            mnuPopup.add(this.createReleaseColumnsSubmenu());
        }
        if (this.m_bSortingEnabled) {
            this.m_actSortAscending.setEnabled(bValidColumn);
            this.m_actSortDescending.setEnabled(bValidColumn);
            this.addSeparatorIfNeeded(mnuPopup);
            mnuPopup.add(this.m_actSortAscending);
            mnuPopup.add(this.m_actSortDescending);
            mnuPopup.add(this.m_actSortOriginal);
        }
    }

    protected JMenu createShowColumnsSubmenu() {
        JMenu mnuShow = new JMenu(this.m_actShowColumns);
        List lHiddenColumns = this.getHiddenColumns();
        int nHiddenColumns = lHiddenColumns.size();
        if (nHiddenColumns == 0) {
            mnuShow.setEnabled(false);
        } else {
            for (int iHiddenColumn = 0; iHiddenColumn < nHiddenColumns; ++iHiddenColumn) {
                TableColumn col = (TableColumn)lHiddenColumns.get(iHiddenColumn);
                mnuShow.add(this.createShowColumnAction((String)col.getHeaderValue(), col.getModelIndex()));
            }
            mnuShow.addSeparator();
            mnuShow.add(this.m_actShowAllColumns);
        }
        return mnuShow;
    }

    protected JMenu createReleaseColumnsSubmenu() {
        JMenu mnuRelease = new JMenu(this.m_actReleaseColumns);
        HoldInterface mgrHold = (HoldInterface)this.getTableHeader();
        List lHeldColumns = mgrHold.getHeldIndices();
        int nHeldColumns = lHeldColumns.size();
        if (nHeldColumns == 0) {
            mnuRelease.setEnabled(false);
        } else {
            for (int iHeldColumn = 0; iHeldColumn < nHeldColumns; ++iHeldColumn) {
                int iModelColumnIndex = (Integer)lHeldColumns.get(iHeldColumn);
                TableColumn col = this.findColumn(this.getColumnModel(), iModelColumnIndex);
                mnuRelease.add(this.createReleaseColumnAction((String)col.getHeaderValue(), iModelColumnIndex));
            }
            mnuRelease.addSeparator();
            mnuRelease.add(this.m_actReleaseAllColumns);
        }
        return mnuRelease;
    }

    public JPopupMenu createRowHeaderPopupMenu() {
        JPopupMenu mnuPopup = new JPopupMenu();
        this.addRowHeaderMenuItems(mnuPopup);
        return mnuPopup;
    }

    public void addRowHeaderMenuItems(JPopupMenu mnuPopup) {
        boolean bEnable;
        int iRow = this.getPopupMenuRow();
        boolean bl = bEnable = 0 <= iRow && iRow < this.getRowCount();
        if (this.m_bRowHoldingEnabled) {
            boolean bEnableHold = bEnable;
            if (bEnable) {
                RowHeader mgrHold = this.getRowHeader();
                bEnableHold = !mgrHold.isHeld(this.convertRowIndexToModel(iRow));
            }
            this.m_actHoldRowTop.setEnabled(bEnableHold);
            this.m_actHoldRowBottom.setEnabled(bEnableHold);
            this.addSeparatorIfNeeded(mnuPopup);
            mnuPopup.add(this.m_actHoldRowTop);
            mnuPopup.add(this.m_actHoldRowBottom);
            mnuPopup.add(this.createReleaseRowsSubmenu());
        }
    }

    protected JMenu createReleaseRowsSubmenu() {
        JMenu mnuRelease = new JMenu(this.m_actReleaseRows);
        RowHeader mgrHold = this.getRowHeader();
        List lHeldRows = mgrHold.getHeldIndices();
        int nHeldRows = lHeldRows.size();
        if (nHeldRows == 0) {
            mnuRelease.setEnabled(false);
        } else {
            for (int iHeldRow = 0; iHeldRow < nHeldRows; ++iHeldRow) {
                int iModelRowIndex = (Integer)lHeldRows.get(iHeldRow);
                mnuRelease.add(this.createReleaseRowAction(iModelRowIndex));
            }
            mnuRelease.addSeparator();
            mnuRelease.add(this.m_actReleaseAllRows);
        }
        return mnuRelease;
    }

    protected void addSeparatorIfNeeded(JPopupMenu mnuPopup) {
        if (mnuPopup.getComponentCount() != 0) {
            mnuPopup.addSeparator();
        }
    }

    public boolean validateValueAt(Object oValue, int iRow, int iCol) {
        WsAbstractTableModel mdl = (WsAbstractTableModel)this.getModel();
        return mdl.validateValueAt(oValue, this.convertRowIndexToModel(iRow), this.convertColumnIndexToModel(iCol));
    }

    public void undoableSetValueAt(Object oValue, int iRow, int iCol) {
        Object oOldValue = this.getValueAt(iRow, iCol);
        this.setValueAt(oValue, iRow, iCol);
        if (this.m_mgrUndo != null) {
            this.m_mgrUndo.addEdit(this.createSetValueUndoable(iRow, iCol, oValue, oOldValue));
        }
    }

    public void undoableInsertNewRowAfterLastSelectedRow() {
        this.undoableInsertNewRow(this.getLastSelectedRow());
    }

    public void undoableInsertNewRow(int iRow) {
        if (!this.stopCellEditing()) {
            return;
        }
        this.m_mgrUndo.addEdit(this.undoableInsertNewRowImpl(iRow));
        WsAbstractTableModel mdl = (WsAbstractTableModel)this.getModel();
        int iCol = this.convertColumnIndexToView(mdl.getDefaultEditColumnIndex());
        if (iCol == -1) {
            iCol = 0;
        }
        this.editCellAt(iRow + 1, iCol);
    }

    public UndoableEdit undoableInsertNewRowImpl(int iRow) {
        WsAbstractTableModel mdl = (WsAbstractTableModel)this.getModel();
        List lRowValues = mdl.createDefaultRowValues();
        this.insertRowImpl(iRow, lRowValues);
        this.selectRow(iRow + 1);
        return this.createInsertNewRowUndoable(iRow, lRowValues);
    }

    public void undoableInsertRowAfterLastSelectedRow(List lRowValues) {
        this.undoableInsertRow(this.getLastSelectedRow(), lRowValues);
    }

    public void undoableInsertRow(int iAfterRow, List lRowValues) {
        if (!this.stopCellEditing()) {
            return;
        }
        this.clearSelection();
        CompoundEdit undo = new CompoundEdit();
        undo.addEdit(this.createClearSelectionUndoable(false, true));
        undo.addEdit(this.undoableInsertRowImpl(iAfterRow, lRowValues));
        undo.end();
        this.m_mgrUndo.addEdit(undo);
    }

    public void undoableInsertRowsAfterLastSelectedRow(List lRowValueLists) {
        this.undoableInsertRows(this.getLastSelectedRow(), lRowValueLists);
    }

    public void undoableInsertRows(int iAfterRow, List lRowValueLists) {
        if (!this.stopCellEditing()) {
            return;
        }
        CompoundEdit undo = new CompoundEdit();
        undo.addEdit(this.createClearSelectionUndoable(false, true));
        this.clearSelection();
        for (int i = 0; i < lRowValueLists.size(); ++i) {
            undo.addEdit(this.undoableInsertRowImpl(iAfterRow + i, (List)lRowValueLists.get(i)));
        }
        this.changeCurrentCell(iAfterRow + 1, 0);
        undo.end();
        this.m_mgrUndo.addEdit(undo);
    }

    public void undoableInsertRows(int iAfterRow, List lRowValueLists, UndoableEdit undo) {
        if (!this.stopCellEditing()) {
            return;
        }
        undo.addEdit(this.createClearSelectionUndoable(false, true));
        this.clearSelection();
        for (int i = 0; i < lRowValueLists.size(); ++i) {
            undo.addEdit(this.undoableInsertRowImpl(iAfterRow + i, (List)lRowValueLists.get(i)));
        }
    }

    private UndoableEdit undoableInsertRowImpl(int iRow, List lRowValues) {
        this.insertRowImpl(iRow, lRowValues);
        this.addRowToSelection(iRow + 1);
        return this.createInsertRowUndoable(iRow, lRowValues);
    }

    protected void insertRowImpl(int iRow, List lRowValues) {
        this.cancelCellEditing();
        WsAbstractTableModel mdl = (WsAbstractTableModel)this.getModel();
        mdl.insertRow(iRow, lRowValues);
    }

    public int getLastSelectedRow() {
        int[] aSelectedRows = this.getCellSelectionEnabled() ? this.getSelectedRowsFromSelectedCells() : this.getSelectedRows();
        if (aSelectedRows.length == 0) {
            return this.getRowCount() - 1;
        }
        return aSelectedRows[aSelectedRows.length - 1];
    }

    public void undoableDeleteSelectedRows() {
        int[] aSelectedRows = this.getCellSelectionEnabled() ? this.getSelectedRowsFromSelectedCells() : this.getSelectedRows();
        if (aSelectedRows.length == 0) {
            throw new UnsupportedOperationException("Delete of selected rows when no rows are selected");
        }
        CompoundEdit undoMultiDelete = new CompoundEdit();
        for (int iSelectedRow = aSelectedRows.length - 1; iSelectedRow >= 0; --iSelectedRow) {
            undoMultiDelete.addEdit(this.undoableDeleteRowImpl(aSelectedRows[iSelectedRow]));
        }
        int iRow = aSelectedRows[aSelectedRows.length - 1] - (aSelectedRows.length - 1);
        if (iRow < this.getRowCount()) {
            this.selectRow(iRow);
        } else if (this.getRowCount() > 0) {
            this.selectRow(iRow - 1);
        }
        undoMultiDelete.addEdit(this.createClearSelectionUndoable());
        undoMultiDelete.end();
        this.m_mgrUndo.addEdit(undoMultiDelete);
    }

    public void undoableDeleteSelectedRows(UndoableEdit undo) {
        int[] aSelectedRows = this.getCellSelectionEnabled() ? this.getSelectedRowsFromSelectedCells() : this.getSelectedRows();
        if (aSelectedRows.length == 0) {
            throw new UnsupportedOperationException("Delete of selected rows when no rows are selected");
        }
        for (int iSelectedRow = aSelectedRows.length - 1; iSelectedRow >= 0; --iSelectedRow) {
            undo.addEdit(this.undoableDeleteRowImpl(aSelectedRows[iSelectedRow]));
        }
        int iRow = aSelectedRows[aSelectedRows.length - 1] - (aSelectedRows.length - 1);
        if (iRow < this.getRowCount()) {
            this.selectRow(iRow);
        } else if (this.getRowCount() > 0) {
            this.selectRow(iRow - 1);
        }
        undo.addEdit(this.createClearSelectionUndoable());
    }

    public void undoableDeleteRow(int iRow) {
        this.m_mgrUndo.addEdit(this.undoableDeleteRowImpl(iRow));
    }

    protected UndoableEdit undoableDeleteRowImpl(int iRow) {
        iRow = this.convertRowIndexToModel(iRow);
        WsAbstractTableModel mdl = (WsAbstractTableModel)this.getModel();
        List lRowValues = mdl.getRowValues(iRow);
        this.deleteRowImpl(iRow);
        return this.createDeleteRowUndoable(iRow, lRowValues);
    }

    protected void deleteRowImpl(int iRow) {
        this.cancelCellEditing();
        WsAbstractTableModel mdl = (WsAbstractTableModel)this.getModel();
        mdl.deleteRow(iRow);
    }

    public void undoableMoveSelectedRows(int eDir) {
        if (!this.stopCellEditing()) {
            return;
        }
        int[] aSelectedRows = this.getCellSelectionEnabled() ? this.getSelectedRowsFromSelectedCells() : this.getSelectedRows();
        if (aSelectedRows.length == 0) {
            throw new UnsupportedOperationException("Move of selected rows when no rows are selected");
        }
        CompoundEdit undoMultiMove = new CompoundEdit();
        undoMultiMove.addEdit(this.createClearSelectionUndoable(false, true));
        if (eDir == -1) {
            for (int iSelectedRow = 0; iSelectedRow < aSelectedRows.length; ++iSelectedRow) {
                int iRow = aSelectedRows[iSelectedRow];
                undoMultiMove.addEdit(this.undoableMoveRowImpl(iRow, iRow + eDir, true));
            }
        } else {
            for (int iSelectedRow = aSelectedRows.length - 1; iSelectedRow >= 0; --iSelectedRow) {
                int iRow = aSelectedRows[iSelectedRow];
                undoMultiMove.addEdit(this.undoableMoveRowImpl(iRow, iRow + eDir, true));
            }
        }
        undoMultiMove.addEdit(this.createClearSelectionUndoable(true, false));
        undoMultiMove.end();
        this.m_mgrUndo.addEdit(undoMultiMove);
    }

    public void undoableMoveRow(int iFrom, int iTo) {
        if (!this.stopCellEditing()) {
            return;
        }
        this.m_mgrUndo.addEdit(this.undoableMoveRowImpl(iFrom, iTo, true));
    }

    protected UndoableEdit undoableMoveRowImpl(int iFrom, int iTo, boolean bMulti) {
        this.moveRowImpl(iFrom, iTo);
        return this.createMoveRowUndoable(iFrom, iTo, bMulti);
    }

    protected void moveRowImpl(int iFrom, int iTo) {
        this.cancelCellEditing();
        super.moveRow(iFrom, iTo);
    }

    public void undoableSetRowValues(int iRow, List lRowValues) {
        if (!this.stopCellEditing()) {
            return;
        }
        CompoundEdit undo = new CompoundEdit();
        undo.addEdit(this.createClearSelectionUndoable(true, true));
        this.clearSelection();
        undo.addEdit(this.undoableSetRowValuesImpl(iRow, lRowValues));
        undo.end();
        this.m_mgrUndo.addEdit(undo);
    }

    public void undoableSetRowsValues(int[] iaRows, List[] laRowValues) {
        if (!this.stopCellEditing()) {
            return;
        }
        CompoundEdit undo = new CompoundEdit();
        undo.addEdit(this.createClearSelectionUndoable(true, true));
        this.clearSelection();
        for (int i = 0; i < iaRows.length; ++i) {
            undo.addEdit(this.undoableSetRowValuesImpl(iaRows[i], laRowValues[i]));
        }
        undo.end();
        this.m_mgrUndo.addEdit(undo);
    }

    protected UndoableEdit undoableSetRowValuesImpl(int iRow, List lRowValues) {
        List lOldRowValues = this.getRowValues(iRow);
        this.setRowValues(iRow, lRowValues);
        this.addRowToSelection(iRow);
        return this.createSetRowValuesUndoable(iRow, lRowValues, lOldRowValues);
    }

    private void setRowValues(int iRow, List lRowValues) {
        this.cancelCellEditing();
        iRow = this.convertRowIndexToModel(iRow);
        WsAbstractTableModel mdl = (WsAbstractTableModel)this.getModel();
        mdl.setRowValues(iRow, lRowValues);
    }

    private List getRowValues(int iRow) {
        iRow = this.convertRowIndexToModel(iRow);
        WsAbstractTableModel mdl = (WsAbstractTableModel)this.getModel();
        return mdl.getRowValues(iRow);
    }

    public void sort(int iColumn) {
        int iModelColumn = this.convertColumnIndexToModel(iColumn);
        int eDirection = this.m_aSortColumns == null || this.m_aSortColumns.length != 1 || this.m_aSortColumns[0] != iModelColumn ? 1 : (this.m_aSortDirections[0] == 1 ? -1 : 1);
        this.sort(iColumn, eDirection);
    }

    public void sort(int iColumn, int eDirection) {
        int[] aColumns = new int[1];
        int[] aDirections = new int[1];
        aColumns[0] = iColumn;
        aDirections[0] = eDirection;
        this.sort(aColumns, aDirections);
    }

    public void sort(int[] aColumns, int[] aDirections) {
        if (this.getRowModel() instanceof WsDefaultTableRowModel) {
            int[] aModelColumns;
            if (!this.stopCellEditing()) {
                return;
            }
            if (aColumns == null) {
                aModelColumns = null;
            } else {
                int nColumns = aColumns.length;
                aModelColumns = new int[nColumns];
                for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                    aModelColumns[iColumn] = this.convertColumnIndexToModel(aColumns[iColumn]);
                }
            }
            if (this.m_mgrUndo != null) {
                WsDefaultTableRowModel mdl = (WsDefaultTableRowModel)this.getRowModel();
                UndoableEdit undo = this.createSortUndoable(mdl.getRowMappings(), aModelColumns, aDirections);
                this.m_mgrUndo.addEdit(undo);
            }
            this.sortImpl(aModelColumns, aDirections);
        }
    }

    public void resort() {
        if (this.m_aSortColumns != null && this.m_aSortDirections != null) {
            this.sortImpl(this.m_aSortColumns, this.m_aSortDirections);
        }
    }

    public void resetToOriginalOrder() {
        this.sort(null, null);
    }

    protected void sortImpl(int[] aColumns, int[] aDirections) {
        this.cancelCellEditing();
        this.clearSelection();
        this.m_aSortColumns = aColumns;
        this.m_aSortDirections = aDirections;
        WsDefaultTableRowModel mdl = (WsDefaultTableRowModel)this.getRowModel();
        mdl.sort(aColumns, aDirections);
    }

    public int[] getSortColumns() {
        int[] aViewColumns;
        if (this.m_aSortColumns == null) {
            aViewColumns = null;
        } else {
            int nColumns = this.m_aSortColumns.length;
            aViewColumns = new int[nColumns];
            for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                aViewColumns[iColumn] = this.convertColumnIndexToView(this.m_aSortColumns[iColumn]);
            }
        }
        return aViewColumns;
    }

    public int[] getSortDirections() {
        return this.m_aSortDirections;
    }

    public void clearSortMemory() {
        this.m_aSortColumns = null;
        this.m_aSortDirections = null;
        this.getColumnHeader().repaint();
    }

    public boolean isSorted() {
        return this.m_aSortColumns != null;
    }

    public void hideRows(int[] aModelRows) {
        ((WsDefaultTableRowModel)this.getRowModel()).hideRows(aModelRows);
    }

    public void hideAllRows() {
        int nRows = this.getRowCount();
        int[] aRows = new int[nRows];
        for (int iRow = 0; iRow < nRows; ++iRow) {
            aRows[iRow] = this.convertRowIndexToModel(iRow);
        }
        this.hideRows(aRows);
    }

    public void showRows(int[] aModelRows) {
        ((WsDefaultTableRowModel)this.getRowModel()).showRows(aModelRows);
    }

    protected TableColumn findColumn(TableColumnModel mdlColumns, int iModelIndex) {
        int nColumns = mdlColumns.getColumnCount();
        for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
            TableColumn col = mdlColumns.getColumn(iColumn);
            if (col.getModelIndex() != iModelIndex) continue;
            return col;
        }
        return null;
    }

    protected TableColumn findColumn(List lColumns, int iModelIndex) {
        int nColumns = lColumns.size();
        for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
            TableColumn col = (TableColumn)lColumns.get(iColumn);
            if (col.getModelIndex() != iModelIndex) continue;
            return col;
        }
        return null;
    }

    public void removeColumn(int iModelColumn) {
        TableColumn col = this.findColumn(this.getColumnModel(), iModelColumn);
        if (col != null) {
            this.removeColumn(col);
        }
    }

    public void sizeColumnsToFit() {
        this.getColumnHeader().sizeColumnsToFit();
    }

    public void saveSettings(String sSettingsPrefix) {
        String sColumnSettingsPrefix;
        int iColumn;
        WorkspaceFile fileAppDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        TableColumnModel mdlVisibleColumns = this.getColumnModel();
        int nVisibleColumns = mdlVisibleColumns.getColumnCount();
        for (iColumn = 0; iColumn < nVisibleColumns; ++iColumn) {
            String sColumnSettingsPrefix2 = sSettingsPrefix + ".Column." + Integer.toString(iColumn) + ".";
            TableColumn mdlColumn = mdlVisibleColumns.getColumn(iColumn);
            fileAppDefaults.setPropertyInt(sColumnSettingsPrefix2 + "index", mdlColumn.getModelIndex());
            fileAppDefaults.setPropertyInt(sColumnSettingsPrefix2 + "width", mdlColumn.getWidth());
            fileAppDefaults.setPropertyBoolean(sColumnSettingsPrefix2 + "visible", true);
        }
        List lHiddenColumns = this.getHiddenColumns();
        int nHiddenColumns = lHiddenColumns.size();
        for (iColumn = 0; iColumn < nHiddenColumns; ++iColumn) {
            String sColumnSettingsPrefix3 = sSettingsPrefix + ".Column." + Integer.toString(nVisibleColumns + iColumn) + ".";
            TableColumn mdlColumn = (TableColumn)lHiddenColumns.get(iColumn);
            fileAppDefaults.setPropertyInt(sColumnSettingsPrefix3 + "index", mdlColumn.getModelIndex());
            fileAppDefaults.setPropertyInt(sColumnSettingsPrefix3 + "width", mdlColumn.getWidth());
            fileAppDefaults.setPropertyBoolean(sColumnSettingsPrefix3 + "visible", false);
        }
        int nColumns = nVisibleColumns + nHiddenColumns;
        fileAppDefaults.setPropertyInt(sSettingsPrefix + ".ColumnCount", nColumns);
        iColumn = nColumns;
        while (true) {
            int iModelColumn;
            if ((iModelColumn = fileAppDefaults.getPropertyInt((sColumnSettingsPrefix = sSettingsPrefix + ".Column." + Integer.toString(iColumn) + ".") + "index", -1)) == -1) break;
            fileAppDefaults.removeProperty(sColumnSettingsPrefix + "index");
            fileAppDefaults.removeProperty(sColumnSettingsPrefix + "width");
            fileAppDefaults.removeProperty(sColumnSettingsPrefix + "visible");
            ++iColumn;
        }
        fileAppDefaults.removeProperty(sColumnSettingsPrefix + "index");
    }

    public void restoreSettings(String sSettingsPrefix) {
        TableColumn col;
        int iKeptColumn;
        TableColumn col2;
        int iColumn;
        WorkspaceFile fileAppDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        TableColumnModel mdlVisibleColumns = this.getColumnModel();
        int nVisibleColumns = mdlVisibleColumns.getColumnCount();
        List lHiddenColumns = this.getHiddenColumns();
        int nHiddenColumns = lHiddenColumns.size();
        int nColumns = nVisibleColumns + nHiddenColumns;
        TableColumn[] aKeptColumns = new TableColumn[nColumns];
        int[] iaAddedColumns = new int[nColumns];
        for (iColumn = 0; iColumn < nVisibleColumns; ++iColumn) {
            col2 = mdlVisibleColumns.getColumn(0);
            mdlVisibleColumns.removeColumn(col2);
            aKeptColumns[iColumn] = col2;
            iaAddedColumns[iColumn] = -1;
        }
        for (iColumn = 0; iColumn < nHiddenColumns; ++iColumn) {
            col2 = (TableColumn)lHiddenColumns.get(0);
            lHiddenColumns.remove(0);
            aKeptColumns[nVisibleColumns + iColumn] = col2;
            iaAddedColumns[nVisibleColumns + iColumn] = -1;
        }
        int nSavedColumns = fileAppDefaults.getPropertyInt(sSettingsPrefix + ".ColumnCount", nColumns);
        for (int iSavedColumn = 0; iSavedColumn < nSavedColumns; ++iSavedColumn) {
            String sColumnSettingsPrefix = sSettingsPrefix + ".Column." + iSavedColumn + ".";
            int iModelColumn = -1;
            if (iSavedColumn < nColumns) {
                iModelColumn = aKeptColumns[iSavedColumn].getModelIndex();
            }
            if ((iModelColumn = fileAppDefaults.getPropertyInt(sColumnSettingsPrefix + "index", iModelColumn)) == -1) continue;
            for (iKeptColumn = 0; iKeptColumn < nColumns && aKeptColumns[iKeptColumn].getModelIndex() != iModelColumn; ++iKeptColumn) {
            }
            if (iKeptColumn >= nColumns || iaAddedColumns[iKeptColumn] != -1) continue;
            col = aKeptColumns[iKeptColumn];
            col.setPreferredWidth(fileAppDefaults.getPropertyInt(sColumnSettingsPrefix + "width", col.getWidth()));
            if (fileAppDefaults.getPropertyBoolean(sColumnSettingsPrefix + "visible", iKeptColumn < nVisibleColumns)) {
                iaAddedColumns[iKeptColumn] = mdlVisibleColumns.getColumnCount();
                mdlVisibleColumns.addColumn(col);
                continue;
            }
            iaAddedColumns[iKeptColumn] = nVisibleColumns + lHiddenColumns.size();
            lHiddenColumns.add(col);
        }
        int nVisibleColumnsSoFar = 0;
        int nHiddenColumnsSoFar = 0;
        for (iKeptColumn = 0; iKeptColumn < nColumns; ++iKeptColumn) {
            if (iaAddedColumns[iKeptColumn] >= nVisibleColumns) {
                ++nHiddenColumnsSoFar;
                continue;
            }
            if (iaAddedColumns[iKeptColumn] >= 0) {
                ++nVisibleColumnsSoFar;
                continue;
            }
            col = aKeptColumns[iKeptColumn];
            if (iKeptColumn >= nVisibleColumns) {
                lHiddenColumns.add(nHiddenColumnsSoFar, col);
                ++nHiddenColumnsSoFar;
                continue;
            }
            int iNewColumn = mdlVisibleColumns.getColumnCount();
            mdlVisibleColumns.addColumn(col);
            mdlVisibleColumns.moveColumn(iNewColumn, nVisibleColumnsSoFar);
            ++nVisibleColumnsSoFar;
        }
    }

    public void saveSortSettings(WorkspaceFile appDefaults, String sSettingsPrefix) {
        sSettingsPrefix = sSettingsPrefix + ".Sort";
        int nSortColumns = this.m_aSortColumns != null ? this.m_aSortColumns.length : 0;
        appDefaults.setPropertyInt(sSettingsPrefix + ".ColumnCount", nSortColumns);
        for (int iColumn = 0; iColumn < nSortColumns; ++iColumn) {
            appDefaults.setPropertyInt(sSettingsPrefix + ".Column" + iColumn + ".index", this.m_aSortColumns[iColumn]);
            appDefaults.setPropertyInt(sSettingsPrefix + ".Column" + iColumn + ".direction", this.m_aSortDirections[iColumn]);
        }
    }

    public void restoreSortSettings(WorkspaceFile appDefaults, String sSettingsPrefix) {
        int nColumns = appDefaults.getPropertyInt((sSettingsPrefix = sSettingsPrefix + ".Sort") + ".ColumnCount", 0);
        if (nColumns == 0) {
            this.sort(null, null);
        } else {
            int[] aIndexes = new int[nColumns];
            int[] aDirections = new int[nColumns];
            for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                aIndexes[iColumn] = appDefaults.getPropertyInt(sSettingsPrefix + ".Column" + iColumn + ".index", iColumn);
                aDirections[iColumn] = appDefaults.getPropertyInt(sSettingsPrefix + ".Column" + iColumn + ".direction", 1);
            }
            this.sort(aIndexes, aDirections);
        }
    }

    public void showColumn(int iModelIndex, int iPosition) {
        int nColumns;
        TableColumnModel mdlVisibleColumns;
        List lHiddenColumns = this.getHiddenColumns();
        TableColumn col = this.findColumn(lHiddenColumns, iModelIndex);
        if (col != null) {
            mdlVisibleColumns = this.getColumnModel();
            lHiddenColumns.remove(col);
            mdlVisibleColumns.addColumn(col);
            nColumns = mdlVisibleColumns.getColumnCount();
            if (iPosition == -1) {
                iPosition = nColumns - 1;
            }
        } else {
            throw new IllegalArgumentException("Column not hidden (" + iModelIndex + ")");
        }
        HoldInterface hiColumns = (HoldInterface)this.getTableHeader();
        int nHeldLeft = hiColumns.getHeldIndices(10).size();
        int nHeldRight = hiColumns.getHeldIndices(11).size();
        iPosition = Math.min(Math.max(nHeldLeft, iPosition), nColumns - 1 - nHeldRight);
        mdlVisibleColumns.moveColumn(nColumns - 1, iPosition);
    }

    public void showAllColumns(int iPosition) {
        List lHiddenColumns = this.getHiddenColumns();
        int nColumns = lHiddenColumns.size();
        for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
            TableColumn col = (TableColumn)lHiddenColumns.get(0);
            this.showColumn(col.getModelIndex(), iPosition);
            if (iPosition == -1) continue;
            ++iPosition;
        }
    }

    public void selectCell(int iRow, int iCol) {
        if (!this.getCellSelectionEnabled()) {
            return;
        }
        this.changeSelection(iRow, iCol, false, false);
    }

    public void selectRow(int iRow) {
        this.changeSelection(iRow, this.getColumnCount() - 1, false, false);
        this.changeSelection(iRow, 0, false, true);
        this.changeCurrentCell(iRow, 0);
    }

    public void selectRows(int[] iaRows) {
        this.clearSelection();
        for (int iRow = iaRows.length - 1; iRow >= 0; --iRow) {
            this.addRowToSelection(iaRows[iRow]);
        }
    }

    public void selectRows(int iStartRow, int iEndRow) {
        this.changeSelection(iEndRow, this.getColumnCount() - 1, false, false);
        this.changeSelection(iStartRow, 0, false, true);
        this.changeCurrentCell(iStartRow, 0);
    }

    public void addCellToSelection(int iRow, int iColumn) {
        if (!this.isCellSelected(iRow, iColumn)) {
            this.changeSelection(iRow, iColumn, true, false);
        }
        this.changeCurrentCell(iRow, iColumn);
    }

    public void addRowToSelection(int iRow) {
        int iLastCol = this.getColumnCount() - 1;
        if (this.isCellSelected(iRow, iLastCol)) {
            this.changeSelection(iRow, iLastCol, true, false);
        }
        this.changeSelection(iRow, iLastCol, true, false);
        this.changeSelection(iRow, 0, false, true);
        this.changeCurrentCell(iRow, 0);
    }

    public void removeRowFromSelection(int iRow) {
        if (this.getCellSelectionEnabled()) {
            this.removeCellSelectionInterval(iRow, 0, iRow, this.getColumnCount() - 1);
        } else {
            this.removeRowSelectionInterval(iRow, iRow);
        }
    }

    public boolean isCellSelectedInRow(int iRow) {
        if (this.getCellSelectionEnabled()) {
            ListSelectionModel mdlSelection = this.getSelectionModel();
            int nCols = this.getColumnCount();
            int iStart = iRow * nCols;
            int iNext = iStart + nCols;
            for (int iCell = iStart; iCell < iNext; ++iCell) {
                if (!mdlSelection.isSelectedIndex(iCell)) continue;
                return true;
            }
            return false;
        }
        return this.isRowSelected(iRow);
    }

    public boolean isEntireRowSelected(int iRow) {
        if (this.getCellSelectionEnabled()) {
            ListSelectionModel mdlSelection = this.getSelectionModel();
            int nCols = this.getColumnCount();
            int iStart = iRow * nCols;
            int iNext = iStart + nCols;
            for (int iCell = iStart; iCell < iNext; ++iCell) {
                if (mdlSelection.isSelectedIndex(iCell)) continue;
                return false;
            }
            return true;
        }
        return this.isRowSelected(iRow);
    }

    public int[] getSelectedRowsFromSelectedCells() {
        if (this.getCellSelectionEnabled()) {
            ListSelectionModel mdlSelection = this.getSelectionModel();
            int iMin = mdlSelection.getMinSelectionIndex();
            int iMax = mdlSelection.getMaxSelectionIndex();
            if (iMin == -1 || iMax == -1) {
                return new int[0];
            }
            int nCols = this.getColumnCount();
            int iMinRow = iMin / nCols;
            int iMaxRow = iMax / nCols;
            int iStart = iMinRow * nCols;
            int iStartNext = iStart + nCols;
            int[] aSelectedRows = new int[1 + (iMaxRow - iMinRow)];
            int nSelectedRows = 0;
            for (int iRow = iMinRow; iRow <= iMaxRow; ++iRow) {
                for (int i = iStart; i < iStartNext; ++i) {
                    if (!mdlSelection.isSelectedIndex(i)) continue;
                    aSelectedRows[nSelectedRows++] = iRow;
                    break;
                }
                iStart = iStartNext;
                iStartNext += nCols;
            }
            int[] aReturnSelectedRows = new int[nSelectedRows];
            System.arraycopy(aSelectedRows, 0, aReturnSelectedRows, 0, nSelectedRows);
            return aReturnSelectedRows;
        }
        return this.getSelectedRows();
    }

    public void convertRowIndexesToModel(int[] aRows) {
        int nRows = aRows.length;
        for (int iRow = 0; iRow < nRows; ++iRow) {
            aRows[iRow] = this.convertRowIndexToModel(aRows[iRow]);
        }
    }

    public void convertRowIndexesToView(int[] aRows) {
        int nRows = aRows.length;
        for (int iRow = 0; iRow < nRows; ++iRow) {
            aRows[iRow] = this.convertRowIndexToView(aRows[iRow]);
        }
    }

    public boolean stopCellEditing() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        return !this.isEditing();
    }

    public void cancelCellEditing() {
        if (this.isEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
    }

    public void createActions() {
        this.m_actHideColumn = this.createHideColumnAction();
        this.m_actShowColumns = this.createShowColumnsAction();
        this.m_actShowAllColumns = this.createShowAllColumnsAction();
        this.m_actSortAscending = this.createSortAscendingAction();
        this.m_actSortDescending = this.createSortDescendingAction();
        this.m_actSortOriginal = this.createSortOriginalAction();
        this.m_actHoldColumnLeft = this.createHoldColumnLeftAction();
        this.m_actHoldColumnRight = this.createHoldColumnRightAction();
        this.m_actReleaseColumns = this.createReleaseColumnsAction();
        this.m_actReleaseAllColumns = this.createReleaseAllColumnsAction();
        this.m_actHoldRowTop = this.createHoldRowTopAction();
        this.m_actHoldRowBottom = this.createHoldRowBottomAction();
        this.m_actReleaseRows = this.createReleaseRowsAction();
        this.m_actReleaseAllRows = this.createReleaseAllRowsAction();
    }

    protected WsAbstractAction createHideColumnAction() {
        return new cHideColumnAction();
    }

    protected WsAbstractAction createShowColumnsAction() {
        return new cShowColumnsAction();
    }

    protected AbstractAction createShowColumnAction(String sColumn, int iModelIndex) {
        return new cShowColumnAction(sColumn, iModelIndex);
    }

    protected WsAbstractAction createShowAllColumnsAction() {
        return new cShowAllColumnsAction();
    }

    protected WsAbstractAction createHoldColumnLeftAction() {
        return new cHoldColumnLeftAction();
    }

    protected WsAbstractAction createHoldColumnRightAction() {
        return new cHoldColumnRightAction();
    }

    protected WsAbstractAction createReleaseColumnsAction() {
        return new cReleaseColumnsAction();
    }

    protected AbstractAction createReleaseColumnAction(String sColumn, int iModelIndex) {
        return new cReleaseColumnAction(sColumn, iModelIndex);
    }

    protected WsAbstractAction createReleaseAllColumnsAction() {
        return new cReleaseAllColumnsAction();
    }

    protected WsAbstractAction createHoldRowTopAction() {
        return new cHoldRowTopAction();
    }

    protected WsAbstractAction createHoldRowBottomAction() {
        return new cHoldRowBottomAction();
    }

    protected WsAbstractAction createReleaseRowsAction() {
        return new cReleaseRowsAction();
    }

    protected AbstractAction createReleaseRowAction(int iModelIndex) {
        return new cReleaseRowAction(iModelIndex);
    }

    protected WsAbstractAction createReleaseAllRowsAction() {
        return new cReleaseAllRowsAction();
    }

    protected WsAbstractAction createSortAscendingAction() {
        return new cSortAscendingAction();
    }

    protected WsAbstractAction createSortDescendingAction() {
        return new cSortDescendingAction();
    }

    protected WsAbstractAction createSortOriginalAction() {
        return new cSortOriginalAction();
    }

    protected Action createDefaultOriginAction() {
        return new cDefaultOriginAction();
    }

    protected void createListeners() {
        this.m_lsnrViewportMouse = this.createViewportMouseListener();
        this.m_lsnrRowModel = this.createTableRowModelListener();
        this.setTablePopupMenuRequestListener(this.createDefaultTablePopupMenuRequestListener());
        this.setOriginPopupMenuRequestListener(this.createDefaultOriginPopupMenuRequestListener());
        this.setRowHeaderPopupMenuRequestListener(this.createDefaultRowHeaderPopupMenuRequestListener());
        this.setColumnHeaderPopupMenuRequestListener(this.createDefaultColumnHeaderPopupMenuRequestListener());
        this.setViewportPopupMenuRequestListener(this.createDefaultViewportPopupMenuRequestListener());
    }

    protected void installListeners() {
        WsDefaultTableRowModel mdl = (WsDefaultTableRowModel)this.getRowModel();
        mdl.addRowModelListener(this.m_lsnrRowModel);
    }

    protected void uninstallListeners() {
        WsDefaultTableRowModel mdl = (WsDefaultTableRowModel)this.getRowModel();
        mdl.removeRowModelListener(this.m_lsnrRowModel);
    }

    protected MouseListener createViewportMouseListener() {
        return new cViewportMouseListener();
    }

    protected WsTableRowModelListener createTableRowModelListener() {
        return new cTableRowModelListener();
    }

    protected WsPopupMenuRequestListener createDefaultColumnHeaderPopupMenuRequestListener() {
        return new cDefaultColumnHeaderPopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createDefaultRowHeaderPopupMenuRequestListener() {
        return new cDefaultRowHeaderPopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createDefaultTablePopupMenuRequestListener() {
        return new cDefaultTablePopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createDefaultOriginPopupMenuRequestListener() {
        return new cDefaultOriginPopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createDefaultViewportPopupMenuRequestListener() {
        return new cDefaultViewportPopupMenuRequestListener();
    }

    protected UndoableEdit createInsertNewRowUndoable(int iRow, List lRowValues) {
        return new cInsertNewRowUndoable(iRow, lRowValues);
    }

    protected UndoableEdit createInsertRowUndoable(int iRow, List lRowValues) {
        return new cInsertRowUndoable(iRow, lRowValues);
    }

    protected UndoableEdit createDeleteRowUndoable(int iRow, List lRowValues) {
        return new cDeleteRowUndoable(iRow, lRowValues);
    }

    protected UndoableEdit createSetRowValuesUndoable(int iRow, List lNewValues, List lOldValues) {
        return new cSetRowValuesUndoable(iRow, lNewValues, lOldValues);
    }

    public UndoableEdit createClearSelectionUndoable() {
        return new cClearSelectionUndoable();
    }

    public UndoableEdit createClearSelectionUndoable(boolean bClearOnUndo, boolean bClearOnRedo) {
        return new cClearSelectionUndoable(bClearOnUndo, bClearOnRedo);
    }

    public UndoableEdit createSelectRowsUndoable(int iStartRow, int iEndRow) {
        return new cSelectRowsUndoable(iStartRow, iEndRow);
    }

    public UndoableEdit createSelectRowUndoable(int iRow, boolean bSelectOnUndo) {
        return this.createSelectRowsUndoable(new int[]{iRow}, bSelectOnUndo);
    }

    public UndoableEdit createSelectRowsUndoable(int[] aRows, boolean bSelectOnUndo) {
        return new SelectRowsUndoable(aRows, bSelectOnUndo);
    }

    public UndoableEdit createMoveRowUndoable(int iFrom, int iTo, boolean bClearSelection) {
        return new cMoveRowUndoable(iFrom, iTo, bClearSelection);
    }

    public UndoableEdit createSetValueUndoable(int iRow, int iCol, Object oNew, Object oOld) {
        return new cSetValueUndoable(iRow, iCol, oNew, oOld);
    }

    public UndoableEdit createSortUndoable(int[] aPreviousRowIndexes, int[] aSortColumns, int[] aSortDirections) {
        return new cSortUndoable(aPreviousRowIndexes, aSortColumns, aSortDirections);
    }

    protected class cSortUndoable
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        private int[] m_aPreviousRowIndexes;
        private int[] m_aUndoSortColumns;
        private int[] m_aUndoSortDirections;

        public cSortUndoable(int[] aPreviousRowIndexes, int[] aSortColumns, int[] aSortDirections) {
            this.m_aPreviousRowIndexes = aPreviousRowIndexes;
            this.m_aUndoSortColumns = aSortColumns;
            this.m_aUndoSortDirections = aSortDirections;
        }

        @Override
        public void undo() {
            super.undo();
            WsTable.this.cancelCellEditing();
            WsTable.this.clearSelection();
            ((WsDefaultTableRowModel)WsTable.this.getRowModel()).setRowMappings(this.m_aPreviousRowIndexes);
            WsTable.this.clearSortMemory();
        }

        @Override
        public void redo() {
            super.redo();
            WsTable.this.clearSelection();
            WsTable.this.sortImpl(this.m_aUndoSortColumns, this.m_aUndoSortDirections);
        }
    }

    protected class cSetValueUndoable
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        int m_iRow;
        int m_iCol;
        Object m_oNew;
        Object m_oOld;

        public cSetValueUndoable(int iRow, int iCol, Object oNew, Object oOld) {
            this.m_iRow = iRow;
            this.m_iCol = iCol;
            this.m_oNew = oNew;
            this.m_oOld = oOld;
        }

        @Override
        public void undo() {
            super.undo();
            WsTable.this.setValueAt(this.m_oOld, this.m_iRow, this.m_iCol);
            WsTable.this.selectCell(this.m_iRow, this.m_iCol);
        }

        @Override
        public void redo() {
            super.redo();
            WsTable.this.setValueAt(this.m_oNew, this.m_iRow, this.m_iCol);
            WsTable.this.selectCell(this.m_iRow, this.m_iCol);
        }
    }

    protected class cMoveRowUndoable
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        int m_iFrom;
        int m_iTo;
        boolean m_bClearSelection;

        public cMoveRowUndoable(int iFrom, int iTo, boolean bClearSelection) {
            this.m_iFrom = iFrom;
            this.m_iTo = iTo;
            this.m_bClearSelection = bClearSelection;
        }

        @Override
        public void undo() {
            super.undo();
            WsTable.this.moveRowImpl(this.m_iTo, this.m_iFrom);
            if (this.m_bClearSelection) {
                WsTable.this.clearSelection();
            }
            WsTable.this.addRowToSelection(this.m_iFrom);
        }

        @Override
        public void redo() {
            super.redo();
            WsTable.this.moveRowImpl(this.m_iFrom, this.m_iTo);
            if (this.m_bClearSelection) {
                WsTable.this.clearSelection();
            }
            WsTable.this.addRowToSelection(this.m_iTo);
        }
    }

    private class SelectRowsUndoable
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        private int[] m_aRows;
        private boolean m_bSelectOnUndo;

        public SelectRowsUndoable(int[] aRows, boolean bSelectOnUndo) {
            this.m_aRows = (int[])aRows.clone();
            this.m_bSelectOnUndo = bSelectOnUndo;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_bSelectOnUndo) {
                WsTable.this.selectRows(this.m_aRows);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_bSelectOnUndo) {
                WsTable.this.selectRows(this.m_aRows);
            }
        }
    }

    protected class cSelectRowsUndoable
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        int m_iStartRow;
        int m_iEndRow;

        public cSelectRowsUndoable(int iStartRow, int iEndRow) {
            this.m_iStartRow = iStartRow;
            this.m_iEndRow = iEndRow;
        }

        @Override
        public void undo() {
            super.undo();
            WsTable.this.clearSelection();
        }

        @Override
        public void redo() {
            super.redo();
            WsTable.this.selectRows(this.m_iStartRow, this.m_iEndRow);
        }
    }

    protected class cClearSelectionUndoable
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        boolean m_bClearOnUndo;
        boolean m_bClearOnRedo;

        public cClearSelectionUndoable() {
            this(true, false);
        }

        public cClearSelectionUndoable(boolean bClearOnUndo, boolean bClearOnRedo) {
            this.m_bClearOnUndo = bClearOnUndo;
            this.m_bClearOnRedo = bClearOnRedo;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_bClearOnUndo) {
                WsTable.this.clearSelection();
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_bClearOnRedo) {
                WsTable.this.clearSelection();
            }
        }
    }

    protected class cSetRowValuesUndoable
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        int m_iRow;
        List m_lNewValues;
        List m_lOldValues;

        public cSetRowValuesUndoable(int iRow, List lNewValues, List lOldValues) {
            this.m_iRow = iRow;
            this.m_lNewValues = lNewValues;
            this.m_lOldValues = lOldValues;
        }

        @Override
        public void undo() {
            super.undo();
            WsTable.this.setRowValues(this.m_iRow, this.m_lOldValues);
            WsTable.this.addRowToSelection(this.m_iRow);
        }

        @Override
        public void redo() {
            super.redo();
            WsTable.this.setRowValues(this.m_iRow, this.m_lNewValues);
            WsTable.this.addRowToSelection(this.m_iRow);
        }
    }

    protected class cDeleteRowUndoable
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        List m_lRowValues;
        int m_iRow;

        public cDeleteRowUndoable(int iRow, List lRowValues) {
            this.m_iRow = iRow;
            this.m_lRowValues = lRowValues;
        }

        @Override
        public void undo() {
            super.undo();
            WsTable.this.insertRowImpl(this.m_iRow - 1, this.m_lRowValues);
            WsTable.this.addRowToSelection(this.m_iRow);
        }

        @Override
        public void redo() {
            super.redo();
            WsTable.this.deleteRowImpl(this.m_iRow);
        }
    }

    protected class cInsertRowUndoable
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        List m_lRowValues;
        int m_iRow;

        public cInsertRowUndoable(int iRow, List lRowValues) {
            this.m_iRow = iRow;
            this.m_lRowValues = lRowValues;
        }

        @Override
        public void undo() {
            super.undo();
            WsTable.this.deleteRowImpl(this.m_iRow + 1);
        }

        @Override
        public void redo() {
            super.redo();
            WsTable.this.insertRowImpl(this.m_iRow, this.m_lRowValues);
            WsTable.this.addRowToSelection(this.m_iRow + 1);
        }
    }

    protected class cInsertNewRowUndoable
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        List m_lRowValues;
        int m_iRow;

        public cInsertNewRowUndoable(int iRow, List lRowValues) {
            this.m_iRow = iRow;
            this.m_lRowValues = lRowValues;
        }

        @Override
        public void undo() {
            super.undo();
            WsTable.this.deleteRowImpl(this.m_iRow + 1);
        }

        @Override
        public void redo() {
            super.redo();
            WsTable.this.insertRowImpl(this.m_iRow, this.m_lRowValues);
            WsTable.this.selectRow(this.m_iRow + 1);
        }
    }

    protected class cDefaultViewportPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cDefaultViewportPopupMenuRequestListener() {
        }

        @Override
        public void popupMenuRequested(MouseEvent e) {
            Workspace.getDefaultLogger().debug("viewport popup");
        }
    }

    protected class cDefaultOriginPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cDefaultOriginPopupMenuRequestListener() {
        }

        @Override
        public void popupMenuRequested(MouseEvent e) {
            Workspace.getDefaultLogger().debug("origin popup");
        }
    }

    protected class cDefaultTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cDefaultTablePopupMenuRequestListener() {
        }

        @Override
        public void popupMenuRequested(MouseEvent e) {
            Workspace.getDefaultLogger().debug("table popup");
        }
    }

    protected class cDefaultRowHeaderPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cDefaultRowHeaderPopupMenuRequestListener() {
        }

        @Override
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = WsTable.this.createRowHeaderPopupMenu();
            if (mnuPopup.getComponentCount() != 0) {
                mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }

    protected class cDefaultColumnHeaderPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cDefaultColumnHeaderPopupMenuRequestListener() {
        }

        @Override
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = WsTable.this.createColumnHeaderPopupMenu();
            if (mnuPopup.getComponentCount() != 0) {
                mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }

    protected class cTableRowModelListener
    implements WsTableRowModelListener {
        protected cTableRowModelListener() {
        }

        @Override
        public void rowDragged(TableRowModelEvent e) {
            if (WsTable.this.m_mgrUndo != null) {
                WsTable.this.m_mgrUndo.addEdit(WsTable.this.createMoveRowUndoable(e.getFromIndex(), e.getToIndex(), true));
            }
        }

        @Override
        public void rowsHidden(WsTableRowModelEvent e) {
            int[] aRows = e.getRows();
            Arrays.sort(aRows);
            int nRows = aRows.length;
            for (int iRow = nRows - 1; iRow >= 0; --iRow) {
                TableModelEvent evt = new TableModelEvent(WsTable.this.getModel(), aRows[iRow], aRows[iRow], -1, -1);
                WsTable.this.tableChanged(evt);
            }
        }

        @Override
        public void rowsShown(WsTableRowModelEvent e) {
            int[] aRows = e.getRows();
            int nRows = aRows.length;
            int nModelRows = WsTable.this.getRowCount();
            for (int iRow = nModelRows - nRows; iRow < nModelRows; ++iRow) {
                TableModelEvent evt = new TableModelEvent(WsTable.this.getModel(), iRow, iRow, -1, 1);
                WsTable.this.tableChanged(evt);
            }
        }

        @Override
        public void rowsRemapped(ChangeEvent e) {
            TableModelEvent evt = new TableModelEvent(WsTable.this.getModel(), 0, WsTable.this.getRowCount() - 1, -1, 0);
            WsTable.this.tableChanged(evt);
        }
    }

    protected class cViewportMouseListener
    extends MouseAdapter {
        protected cViewportMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!WsTable.this.stopCellEditing()) {
                return;
            }
            WsTable.this.clearSelection();
            if (e.isPopupTrigger()) {
                this.triggerPopupMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.triggerPopupMenu(e);
            }
        }

        protected void triggerPopupMenu(MouseEvent e) {
            Point pt = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), (Component)((Object)WsTable.this));
            WsTable.this.showPopup(pt);
        }
    }

    protected class cDefaultOriginAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        protected cDefaultOriginAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTable.this.sort(null, null);
        }
    }

    protected class cSortOriginalAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cSortOriginalAction() {
            super(bundle, "WsTable.SortOriginal", false, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTable.this.sort(null, null);
        }
    }

    protected class cSortDescendingAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cSortDescendingAction() {
            super(bundle, "WsTable.SortDescending", false, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTable.this.sort(WsTable.this.getPopupMenuColumn(), -1);
        }
    }

    protected class cSortAscendingAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cSortAscendingAction() {
            super(bundle, "WsTable.SortAscending", false, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTable.this.sort(WsTable.this.getPopupMenuColumn(), 1);
        }
    }

    protected class cReleaseAllRowsAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cReleaseAllRowsAction() {
            super(bundle, "WsTable.ReleaseAllRows", false, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RowHeader mgrHold = WsTable.this.getRowHeader();
            mgrHold.releaseAll();
            WsTable.this.revalidate();
            WsTable.this.getTableHeader().repaint();
            WsTable.this.repaint();
        }
    }

    protected class cReleaseRowAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        int m_iModelIndex;

        public cReleaseRowAction(int iModelIndex) {
            super(bundle.formatString("WsTable.RowMenuItem.fmt", new Integer(iModelIndex + 1)));
            this.m_iModelIndex = iModelIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RowHeader mgrHold = WsTable.this.getRowHeader();
            mgrHold.release(this.m_iModelIndex);
            WsTable.this.revalidate();
            WsTable.this.getTableHeader().repaint();
            WsTable.this.repaint();
        }
    }

    protected class cReleaseRowsAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cReleaseRowsAction() {
            super(bundle, "WsTable.ReleaseRows", false, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class cHoldRowBottomAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cHoldRowBottomAction() {
            super(bundle, "WsTable.HoldRowBottom", false, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RowHeader mgrHold = WsTable.this.getRowHeader();
            mgrHold.hold(WsTable.this.convertRowIndexToModel(WsTable.this.getPopupMenuRow()), 3);
        }
    }

    protected class cHoldRowTopAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cHoldRowTopAction() {
            super(bundle, "WsTable.HoldRowTop", false, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RowHeader mgrHold = WsTable.this.getRowHeader();
            mgrHold.hold(WsTable.this.convertRowIndexToModel(WsTable.this.getPopupMenuRow()), 1);
        }
    }

    protected class cReleaseAllColumnsAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cReleaseAllColumnsAction() {
            super(bundle, "WsTable.ReleaseAllColumns", false, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HoldInterface mgrHold = (HoldInterface)WsTable.this.getTableHeader();
            mgrHold.releaseAll();
            WsTable.this.revalidate();
            WsTable.this.getTableHeader().repaint();
            WsTable.this.repaint();
        }
    }

    protected class cReleaseColumnAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        int m_iModelIndex;

        public cReleaseColumnAction(String sColumn, int iModelIndex) {
            super(sColumn);
            this.m_iModelIndex = iModelIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HoldInterface mgrHold = (HoldInterface)WsTable.this.getTableHeader();
            mgrHold.release(this.m_iModelIndex);
            WsTable.this.revalidate();
            WsTable.this.getTableHeader().repaint();
            WsTable.this.repaint();
        }
    }

    protected class cReleaseColumnsAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cReleaseColumnsAction() {
            super(bundle, "WsTable.ReleaseColumns", false, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class cHoldColumnRightAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cHoldColumnRightAction() {
            super(bundle, "WsTable.HoldColumnRight", false, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HoldInterface mgrHold = (HoldInterface)WsTable.this.getTableHeader();
            mgrHold.hold(WsTable.this.convertColumnIndexToModel(WsTable.this.getPopupMenuColumn()), 4);
        }
    }

    protected class cHoldColumnLeftAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cHoldColumnLeftAction() {
            super(bundle, "WsTable.HoldColumnLeft", false, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HoldInterface mgrHold = (HoldInterface)WsTable.this.getTableHeader();
            mgrHold.hold(WsTable.this.convertColumnIndexToModel(WsTable.this.getPopupMenuColumn()), 2);
        }
    }

    protected class cShowAllColumnsAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cShowAllColumnsAction() {
            super(bundle, "WsTable.ShowAllColumns", false, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int iPosition = WsTable.this.getPopupMenuColumn();
            WsTable.this.showAllColumns(iPosition);
        }
    }

    protected class cShowColumnAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        int m_iModelIndex;

        public cShowColumnAction(String sColumn, int iModelIndex) {
            super(sColumn);
            this.m_iModelIndex = iModelIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int iPosition = WsTable.this.getPopupMenuColumn();
            WsTable.this.showColumn(this.m_iModelIndex, iPosition);
        }
    }

    protected class cShowColumnsAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cShowColumnsAction() {
            super(bundle, "WsTable.ShowColumns", false, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class cHideColumnAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cHideColumnAction() {
            super(bundle, "WsTable.HideColumn", false, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTable.this.hideColumn(WsTable.this.convertColumnIndexToModel(WsTable.this.getPopupMenuColumn()));
        }
    }
}

