/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.swing.visuals.tableview.TableView;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WATextField;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsDefaultTableCellRenderer;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class WsStringTableColumn
extends WsAbstractTableColumn {
    protected int m_nMaximum;
    protected String m_sDefault;
    protected String[] m_saValues;
    protected boolean m_bSorted;
    private int m_iIconColumn;

    public WsStringTableColumn() {
        this(0);
    }

    public WsStringTableColumn(int iModelIndex) {
        this(iModelIndex, 75);
    }

    public WsStringTableColumn(int iModelIndex, int cxWidth) {
        this(iModelIndex, "", cxWidth);
    }

    public WsStringTableColumn(int iModelIndex, String sName, int cxWidth) {
        this(iModelIndex, sName, cxWidth, Integer.MAX_VALUE);
    }

    public WsStringTableColumn(int iModelIndex, String sName, int cxWidth, int nMaximum) {
        this(iModelIndex, sName, cxWidth, nMaximum, "");
    }

    public WsStringTableColumn(int iModelIndex, String sName, int cxWidth, String sDefault) {
        this(iModelIndex, sName, cxWidth, Integer.MAX_VALUE, sDefault);
    }

    public WsStringTableColumn(int iModelIndex, String sName, int cxWidth, int nMaximum, String sDefault) {
        this(iModelIndex, sName, cxWidth, nMaximum, null, sDefault);
    }

    public WsStringTableColumn(int iModelIndex, String sName, int cxWidth, String[] saSuggestedValues) {
        this(iModelIndex, sName, cxWidth, saSuggestedValues, saSuggestedValues[0]);
    }

    public WsStringTableColumn(int iModelIndex, String sName, int cxWidth, String[] saSuggestedValues, String sDefault) {
        this(iModelIndex, sName, cxWidth, Integer.MAX_VALUE, saSuggestedValues, sDefault);
    }

    public WsStringTableColumn(int iModelIndex, String sName, int cxWidth, int nMaximum, String[] saSuggestedValues, String sDefault) {
        super(iModelIndex, sName, cxWidth);
        this.m_nMaximum = nMaximum;
        this.m_sDefault = sDefault;
        this.m_saValues = saSuggestedValues;
        this.setColumnClass(String.class);
        this.setIconColumn(-1);
    }

    @Override
    public Object createDefaultValue() {
        return this.m_sDefault;
    }

    @Override
    public TableCellEditor createCellEditor() {
        WsDefaultCellEditor edt;
        if (this.m_saValues == null) {
            WATextField txt = new WATextField();
            if (this.m_nMaximum != Integer.MAX_VALUE) {
                txt.setMaxCharacters(this.m_nMaximum);
            }
            edt = new WsDefaultCellEditor(txt);
        } else {
            WAComboBox cmb = new WAComboBox(this.m_saValues, this.m_bSorted);
            cmb.setEditable(true);
            if (this.m_nMaximum != Integer.MAX_VALUE) {
                ((WATextField)cmb.getEditor().getEditorComponent()).setMaxCharacters(this.m_nMaximum);
            }
            edt = new WsDefaultCellEditor(cmb);
        }
        return edt;
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new cIconStringCellRenderer();
    }

    public void setMaximumCharacters(int nMaximum) {
        this.m_nMaximum = nMaximum;
    }

    public int getMaximumCharacters() {
        return this.m_nMaximum;
    }

    public void setDefaultValue(String sDefault) {
        this.m_sDefault = sDefault;
    }

    public String getDefaultValue() {
        return this.m_sDefault;
    }

    public void setSuggestedValues(String[] saValues) {
        DefaultCellEditor edt;
        Component cmp;
        this.m_saValues = saValues;
        if (this.m_sDefault.length() == 0) {
            this.m_sDefault = saValues[0];
        }
        if (this.m_edtCell != null && (cmp = (edt = (DefaultCellEditor)this.m_edtCell).getComponent()) instanceof JComboBox) {
            JComboBox cmb = (JComboBox)cmp;
            cmb.removeAllItems();
            int nValues = saValues.length;
            for (int iValue = 0; iValue < nValues; ++iValue) {
                cmb.addItem(saValues[iValue]);
            }
        }
    }

    public String[] getSuggestedValues() {
        return this.m_saValues;
    }

    public void setSorted(boolean bSorted) {
        DefaultCellEditor edt;
        Component cmp;
        this.m_bSorted = bSorted;
        if (this.m_edtCell != null && (cmp = (edt = (DefaultCellEditor)this.m_edtCell).getComponent()) instanceof WAComboBox) {
            WAComboBox cmb = (WAComboBox)cmp;
            cmb.setSorted(bSorted);
        }
    }

    public boolean isSorted() {
        return this.m_bSorted;
    }

    public void setIconColumn(int iIconColumn) {
        this.m_iIconColumn = iIconColumn;
    }

    public int getIconColumn() {
        return this.m_iIconColumn;
    }

    protected class cIconStringCellRenderer
    extends WsDefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        protected cIconStringCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
            super.getTableCellRendererComponent(tbl, value, bSelected, bFocused, iRow, iCol);
            if (WsStringTableColumn.this.m_iIconColumn != -1) {
                if (tbl instanceof TableView) {
                    iRow = ((TableView)tbl).convertRowIndexToModel(iRow);
                }
                this.setIcon((Icon)tbl.getModel().getValueAt(iRow, WsStringTableColumn.this.m_iIconColumn));
            }
            return this;
        }
    }
}

