/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextField;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsMessageDisplayer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.text.JTextComponent;

public class WsStatusBar
extends WAPanel
implements WsMessageDisplayer {
    private static final long serialVersionUID = 1L;
    public static final String MAIN = "Main";
    public static final String PROGRESS = "Progress";
    public static final String STATUS = "Status";
    private Map m_mapPanels = new HashMap();
    private Map m_mapStatusIcons;
    private boolean m_bProgressShown = true;

    public WsStatusBar() {
        this.setLayout(new GridBagLayout());
        this.addPanel(MAIN);
        if (this.isProgressShown()) {
            this.addProgressBar();
        }
    }

    public WsStatusBar(String strMessage) {
        this();
        this.setText(strMessage);
    }

    public void addPanel(String strName) {
        this.addPanel(strName, 0);
    }

    public void addPanel(String strName, int cxWidth) {
        WATextField tfPanel = new WATextField();
        tfPanel.setBehavior(1);
        tfPanel.setMargin(new Insets(0, 2, 0, 2));
        if (cxWidth != 0) {
            Dimension dim = tfPanel.getPreferredSize();
            dim.width = cxWidth;
            tfPanel.setPreferredSize(dim);
        }
        this.addPanel(strName, tfPanel, cxWidth == 0 ? 1.0 : 0.0);
    }

    public void addPanel(String strName, JComponent cmp) {
        this.addPanel(strName, cmp, 1.0);
    }

    public void addPanel(String strName, JComponent cmp, double xWeight) {
        cmp.setBorder(new cPanelBorder(new Insets(0, 2, 0, 2)));
        this.m_mapPanels.put(strName, cmp);
        int nPanels = this.m_mapPanels.size();
        int cxLeftInset = nPanels == 1 ? 0 : 2;
        this.add((Component)cmp, new GridBagConstraints(nPanels - 1, 0, 1, 1, xWeight, 0.0, 10, 1, new Insets(3, cxLeftInset, 0, 0), 10, 0));
    }

    public void removePanel(String sName) {
        JComponent cmp = this.getPanel(sName);
        this.m_mapPanels.remove(sName);
        this.remove(cmp);
    }

    public boolean isPanelShown(String strName) {
        return this.m_mapPanels.containsKey(strName);
    }

    public JComponent getPanel(String sName) {
        JComponent cmp = (JComponent)this.m_mapPanels.get(sName);
        if (cmp == null) {
            throw new IllegalArgumentException("Panel not found.");
        }
        return cmp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPanelText(final String sName, final String sText) {
        if (SwingUtilities.isEventDispatchThread()) {
            JComponent cmp = this.getPanel(sName);
            cmp.setToolTipText(sText);
            if (cmp instanceof JTextComponent) {
                JTextComponent txt = (JTextComponent)cmp;
                if (txt.getText().equals(sText)) return;
                txt.setText(sText);
                txt.setCaretPosition(0);
                return;
            } else {
                if (!(cmp instanceof JLabel)) throw new UnsupportedOperationException("Cannot set text on a panel that is not a text component.");
                JLabel lbl = (JLabel)cmp;
                if (lbl.getText().equals(sText)) return;
                lbl.setText(sText);
            }
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    WsStatusBar.this.setPanelText(sName, sText);
                }
            });
            return;
        }
        catch (InterruptedException ex) {
            Workspace.getDefaultLogger().error((Object)"", ex);
            return;
        }
        catch (InvocationTargetException ex) {
            Workspace.getDefaultLogger().error((Object)"", ex);
        }
    }

    @Override
    public void displayMessage(String sMessage) {
        this.setText(sMessage);
    }

    public void setText(String sText) {
        this.setPanelText(MAIN, sText);
    }

    public void clear() {
        this.setPanelText(MAIN, "");
        if (this.isProgressShown()) {
            JProgressBar barProgress = (JProgressBar)this.getPanel(PROGRESS);
            barProgress.setValue(0);
        }
    }

    public void setProgressShown(boolean bProgressShown) {
        if (this.m_bProgressShown != bProgressShown) {
            this.m_bProgressShown = bProgressShown;
            if (bProgressShown) {
                this.addProgressBar();
            } else {
                this.removeProgressBar();
            }
        }
    }

    public boolean isProgressShown() {
        return this.m_bProgressShown;
    }

    protected void addProgressBar() {
        this.addPanel(PROGRESS, new JProgressBar(), 0.0);
    }

    protected void removeProgressBar() {
        this.removePanel(PROGRESS);
    }

    public void incrementProgress() {
        if (!this.isProgressShown()) {
            return;
        }
        JProgressBar barProgress = (JProgressBar)this.getPanel(PROGRESS);
        int value = barProgress.getValue();
        value = value == 100 ? 0 : (value += 5);
        barProgress.setValue(value);
    }

    public void addStatusPanel() {
        if (this.isStatusPanelShown()) {
            return;
        }
        this.m_mapStatusIcons = new HashMap();
        JPanel pnlStatus = new JPanel();
        this.m_mapPanels.put(STATUS, pnlStatus);
        pnlStatus.setLayout(new GridBagLayout());
        pnlStatus.setBorder(new cPanelBorder(new Insets(0, 2, 0, 2)));
        this.add((Component)pnlStatus, new GridBagConstraints(99, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 2, 0, 0), 0, 0));
    }

    public boolean isStatusPanelShown() {
        return this.m_mapPanels.containsKey(STATUS);
    }

    public void removeStatusPanel() {
        this.removePanel(STATUS);
    }

    public void addStatusIcon(String strName, JComponent cmpIcon) {
        if (this.isStatusPanelShown()) {
            this.m_mapStatusIcons.put(strName, cmpIcon);
            JPanel pnlStatus = (JPanel)this.getPanel(STATUS);
            int nIcons = this.m_mapStatusIcons.size();
            int cxLeftInset = nIcons == 1 ? 0 : 2;
            pnlStatus.add((Component)cmpIcon, new GridBagConstraints(nIcons - 1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, cxLeftInset, 0, 0), 0, 0));
        }
    }

    public JComponent getStatusIcon(String strName) {
        JComponent cmp = (JComponent)this.m_mapStatusIcons.get(strName);
        if (cmp == null) {
            throw new IllegalArgumentException("Status icon not found.");
        }
        return cmp;
    }

    public boolean isStatusIconShown(String strName) {
        return this.m_mapStatusIcons.containsKey(strName);
    }

    public void removeStatusIcon(String strName) {
        JComponent cmpIcon = this.getStatusIcon(strName);
        this.m_mapStatusIcons.remove(strName);
        JPanel pnlStatus = (JPanel)this.getPanel(STATUS);
        pnlStatus.remove(cmpIcon);
    }

    public static class cPanelBorder
    extends BasicBorders.FieldBorder {
        private static final long serialVersionUID = 1L;
        protected Insets m_insMargin;

        public cPanelBorder(Insets insMargin) {
            super(UIManager.getColor("TextField.shadow"), UIManager.getColor("TextField.darkShadow"), UIManager.getColor("TextField.light"), UIManager.getColor("TextField.highlight"));
            this.m_insMargin = insMargin;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 2 + this.m_insMargin.top;
            insets.left = 2 + this.m_insMargin.left;
            insets.bottom = 2 + this.m_insMargin.bottom;
            insets.right = 2 + this.m_insMargin.right;
            return insets;
        }
    }
}

