/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.beans.PropertyChangeEvent;
import com.sas.editor.LogListHolder;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerEvent;
import com.sas.workspace.WsAppServerEventListener;
import com.sas.workspace.WsAppServerFailException;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class WsServerRequest {
    private static WAdminResource bundle = WAdminResource.getBundle(WsServerRequest.class);
    public static final String DEFAULT_SERVER_ID = "AppServer.Default";
    protected Workspace m_workspace;
    protected WsAppServer m_WsAppServer;
    protected CMetadata m_oMetadata;
    protected String m_sExceptionMessage;
    protected String m_sSASCode;
    protected LogListHolder m_hldrLog;
    protected LogListHolder m_hldrOutput;
    protected String m_execDesc;
    protected String m_execTitle;
    private String m_sSubmitType;
    private List m_lEventListeners;
    protected Vector m_propChangeListeners;
    protected Properties m_properties;
    protected cRunCode m_runCode;
    protected DateFormat m_dateFormatter;
    protected WsAppServerEventListener m_lWsAppServerEventListener;
    public static final String APPSERVERSTATUS = "status";
    public static final String STARTTIME = "starttime";
    public static final String ENDTIME = "endtime";
    public static final String JOBSTATUS = "jobstatus";
    public static final String JOBNAME = "jobname";
    public static final String WSAPPSERVER = "wsappserver";
    public static final String METADATAFQID = "metadatafqid";
    public static final String JOBKILLED = bundle.getString("WsServerRequest.PropertyKilled.txt");
    public static final String JOBTERMINATED = bundle.getString("WsServerRequest.PropertyTerminated.txt");
    public static final String JOBRUNNING = bundle.getString("WsServerRequest.PropertyRunning.txt");
    public static final String JOBERRORED = bundle.getString("WsServerRequest.PropertyEndedWithErrors.txt");
    public static final String JOBSUCCESSFUL = bundle.getString("WsServerRequest.PropertyEndedSuccessfully.txt");
    public static final String JOBWARNING = bundle.getString("WsServerRequest.PropertyEndedWithWarning.txt");
    public static final String JOBABORTED = bundle.getString("WsServerRequest.PropertyEndedWithAbort.txt");
    public static final String JOBCANCELLED = bundle.getString("WsServerRequest.PropertyEndedWithCancel.txt");
    public static final String DISPOSED = bundle.getString("WsServerRequest.Disposed.txt");
    public static final String JOBCANCELINPROGRESS = bundle.getString("WsServerRequest.PropertyCancelInProgress.txt");
    public static final Date MISSING_DATE = new Date(Long.MAX_VALUE);
    private HashMap m_WsAppServerCredentials = new HashMap();
    protected boolean m_searchLogForError = false;

    public WsServerRequest(CMetadata oMetadata) {
        this.m_oMetadata = oMetadata;
        this.m_properties = new Properties();
        this.m_propChangeListeners = new Vector();
        this.m_lEventListeners = new ArrayList();
        this.m_dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        try {
            if (oMetadata != null) {
                this.setPropertyString(METADATAFQID, oMetadata.getFQID());
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        this.setPropertyString(JOBSTATUS, "");
    }

    public WsServerRequest(CMetadata oMetadata, boolean searchLogForError) {
        this(oMetadata);
        this.m_searchLogForError = searchLogForError;
    }

    public void setWsAppServer(WsAppServer newWsAppServer) {
        this.m_workspace = Workspace.getWorkspace();
        if (this.m_WsAppServer != null && this.m_lWsAppServerEventListener != null) {
            this.m_WsAppServer.removeWsAppServerEventListener(this.m_lWsAppServerEventListener);
            this.m_lWsAppServerEventListener = null;
        }
        this.m_WsAppServer = newWsAppServer;
    }

    public String getDefaultWsAppServerId() {
        WorkspaceFile ws = Workspace.getWorkspace().getWorkspaceFile();
        return ws.getPropertyString(DEFAULT_SERVER_ID);
    }

    public String getWsAppServerName() throws MdException, RemoteException {
        if (this.m_WsAppServer != null) {
            return this.m_WsAppServer.getServerName();
        }
        return null;
    }

    public static String getDefaultWsAppServerName() throws MdException, RemoteException {
        WorkspaceFile ws = Workspace.getWorkspace().getWorkspaceFile();
        String WsAppServerID = ws.getPropertyString(DEFAULT_SERVER_ID);
        if (WsAppServerID != null && WsAppServerID.length() > 0) {
            ArrayList<String> lAttrs = new ArrayList<String>();
            lAttrs.add("Name");
            List lValues = Workspace.getMdFactory().getOMIUtil().getMetadataSimple("ServerContext", WsAppServerID, lAttrs);
            return (String)lValues.get(0);
        }
        ws.setPropertyString(DEFAULT_SERVER_ID, "");
        return bundle.getString("WsServerRequest.NoWsAppServerTitle.txt");
    }

    public void setWsAppServerUserID(String userid, String WsAppServerID) {
        String key = "AppServerUser." + WsAppServerID;
        this.m_WsAppServerCredentials.put(key, userid);
    }

    public void setSubmitType(String sSubmitType) {
        this.m_sSubmitType = sSubmitType;
    }

    public String getSubmitType() {
        return this.m_sSubmitType;
    }

    public void setWsAppServerPassword(String password, String WsAppServerPW) {
        String key = "AppServerPassword." + WsAppServerPW;
        this.m_WsAppServerCredentials.put(key, password);
    }

    public String getWsAppServerUserID(String WsAppServerID) {
        String key = "AppServerUser." + WsAppServerID;
        return (String)this.m_WsAppServerCredentials.get(key);
    }

    public String getWsAppServerPassword(String WsAppServerPW) {
        String key = "AppServerPassword." + WsAppServerPW;
        return (String)this.m_WsAppServerCredentials.get(key);
    }

    public WsAppServer getWsAppServer() {
        return this.m_WsAppServer;
    }

    public void killWsAppServer() {
        if (this.m_WsAppServer != null && !this.m_WsAppServer.isKilled()) {
            this.m_WsAppServer.kill();
        }
    }

    public void termWsServerRequest() {
        EventListener client;
        int iClient;
        this.firePropertyChange(DISPOSED, null, DISPOSED);
        if (this.m_WsAppServer != null) {
            if (this.m_lWsAppServerEventListener != null) {
                this.m_WsAppServer.removeWsAppServerEventListener(this.m_lWsAppServerEventListener);
                this.m_lWsAppServerEventListener = null;
            }
            this.m_WsAppServer.dispose();
            this.m_WsAppServer = null;
        }
        for (iClient = 0; iClient < this.m_lEventListeners.size(); ++iClient) {
            client = (WsAppServerEventListener)this.m_lEventListeners.get(iClient);
            this.removecWsAppServerEventListener((WsAppServerEventListener)client);
        }
        for (iClient = 0; iClient < this.m_propChangeListeners.size(); ++iClient) {
            client = (PropertyChangeListener)this.m_propChangeListeners.get(iClient);
            this.removePropertyChangeListener((PropertyChangeListener)client);
        }
    }

    public String getMessage() {
        if (this.m_sExceptionMessage != null) {
            return this.m_sExceptionMessage;
        }
        return null;
    }

    public void setPropertyString(String strKeyName, String strValue) {
        this.m_properties.setProperty(strKeyName, strValue);
        this.firePropertyChange(strKeyName, null, strValue);
    }

    public String getPropertyString(String strKeyName) {
        try {
            String strValue = this.m_properties.getProperty(strKeyName);
            if (strValue == null) {
                return "";
            }
            return strValue;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", e);
            return "";
        }
    }

    public String getPropertyString(String sKey, String sDefault) {
        String sValue = this.m_properties.getProperty(sKey);
        if (sValue == null) {
            this.setPropertyString(sKey, sDefault);
            sValue = sDefault;
        }
        return sValue;
    }

    public int getPropertyInt(String sKey) {
        String sValue = this.m_properties.getProperty(sKey);
        if (sValue != null && sValue.length() != 0) {
            return Integer.parseInt(sValue);
        }
        return this.getPropertyInt(APPSERVERSTATUS, -999);
    }

    public int getPropertyInt(String sKey, int iDefault) {
        String sValue = this.m_properties.getProperty(sKey);
        if (sValue != null && sValue.length() != 0) {
            return Integer.parseInt(sValue);
        }
        this.setPropertyInt(sKey, iDefault);
        return iDefault;
    }

    public void setPropertyInt(String sKey, int iValue) {
        this.m_properties.setProperty(sKey, Integer.toString(iValue));
        this.firePropertyChange(sKey, null, new Integer(iValue));
    }

    public Date getPropertyDate(String sKey) {
        String sValue = this.m_properties.getProperty(sKey);
        if (sValue != null && sValue.length() != 0) {
            try {
                return this.m_dateFormatter.parse(sValue);
            }
            catch (ParseException pe) {
                return MISSING_DATE;
            }
        }
        return MISSING_DATE;
    }

    public Date getPropertyDate(String sKey, Date bDefault) {
        String sValue = this.m_properties.getProperty(sKey);
        if (sValue != null && sValue.length() != 0) {
            try {
                return this.m_dateFormatter.parse(sValue);
            }
            catch (ParseException pe) {
                this.setPropertyDate(sKey, bDefault);
                return bDefault;
            }
        }
        this.setPropertyDate(sKey, bDefault);
        return bDefault;
    }

    public void setPropertyDate(String sKey, Date bValue) {
        String sDate = this.m_dateFormatter.format(bValue);
        this.m_properties.setProperty(sKey, sDate);
        this.firePropertyChange(sKey, null, sDate);
    }

    public void removeProperty(String sKey) {
        this.m_properties.remove(sKey);
    }

    public String getMetadataName() {
        try {
            return this.m_oMetadata == null ? null : this.m_oMetadata.getName();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
    }

    public String getMetadataFQID() {
        try {
            return this.m_oMetadata == null ? null : this.m_oMetadata.getFQID();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
    }

    public void createJobObject(String oMetadataFQID) {
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            MdObjectStore m_store = factory.createObjectStore(null, "WsServerRequest Store");
            m_store.setIsObjectCopiedFromParentOnCreation(false);
            CMetadata oMetadata = m_store.getObject(oMetadataFQID);
            if (oMetadata instanceof Job) {
                this.m_oMetadata = factory.createComplexMetadataObject(m_store, oMetadata);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public CMetadata getMetadata() {
        if (this.m_oMetadata == null) {
            this.createJobObject(this.getPropertyString(METADATAFQID));
        }
        return this.m_oMetadata;
    }

    public LogListHolder getLogText() throws WsAppServerFailException {
        return this.m_WsAppServer.getLog();
    }

    public LogListHolder getOutputText() throws WsAppServerFailException {
        return this.m_WsAppServer.getOutput();
    }

    public WsAppServer getAppServer() {
        if (this.m_WsAppServer == null) {
            this.m_WsAppServer = WsAppServer.createDefaultAppServer();
        }
        return this.m_WsAppServer;
    }

    public void startCodeSubmit() {
        this.getAppServer();
        if (this.m_WsAppServer == null) {
            return;
        }
        try {
            this.setPropertyString(WSAPPSERVER, this.getWsAppServerName());
            this.m_WsAppServer.open();
            this.setPropertyDate(STARTTIME, new Date());
            this.removeProperty(ENDTIME);
            this.setPropertyString(JOBSTATUS, JOBRUNNING);
            if (this.m_oMetadata != null) {
                this.setPropertyString(JOBNAME, this.m_oMetadata.getName());
            }
            this.m_runCode = new cRunCode();
            if (this.m_oMetadata != null) {
                this.m_runCode.setName("SubmitThread:" + this.m_oMetadata.getName());
            }
            if (this.m_lWsAppServerEventListener == null) {
                this.m_lWsAppServerEventListener = new cWsAppServerEventListener();
                this.m_WsAppServer.addWsAppServerEventListener(this.m_lWsAppServerEventListener);
            }
            this.m_runCode.start();
        }
        catch (MdException ex) {
            this.setPropertyString(JOBSTATUS, JOBCANCELLED);
            MessageUtil.displayMetadataExceptionMessage(ex, "Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        catch (WsAppServerFailException ex) {
            this.setPropertyString(JOBSTATUS, JOBCANCELLED);
            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
        }
    }

    public void setCodeToSubmit(String sascode) {
        this.m_sSASCode = sascode;
    }

    public WsAppServer refreshWsAppServer() {
        if (this.m_WsAppServer != null) {
            if (this.m_lWsAppServerEventListener != null) {
                this.m_WsAppServer.removeWsAppServerEventListener(this.m_lWsAppServerEventListener);
                this.m_lWsAppServerEventListener = null;
            }
            this.m_WsAppServer.close();
        }
        String sAppServerID = WsAppServer.getDefaultAppServerFQID();
        if (this.m_WsAppServer != null && sAppServerID != null && sAppServerID.length() > 0) {
            this.m_WsAppServer.setServerFQID(sAppServerID);
        }
        return this.m_WsAppServer;
    }

    protected void terminateRunningSasCodeSubmit() {
        this.setPropertyString(JOBSTATUS, JOBCANCELINPROGRESS);
        cCancelCodeSubmit cancelCode = new cCancelCodeSubmit();
        cancelCode.start();
    }

    public void terminateRunningSasCode() {
        this.terminateRunningSasCodeSubmit();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.m_propChangeListeners.contains(listener)) {
            this.m_propChangeListeners.addElement(listener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.m_propChangeListeners.contains(listener)) {
            this.m_propChangeListeners.removeElement(listener);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue);
        for (PropertyChangeListener client : this.m_propChangeListeners) {
            client.propertyChange((java.beans.PropertyChangeEvent)evt);
        }
    }

    public synchronized void addcWsAppServerEventListener(WsAppServerEventListener listener) {
        if (!this.m_lEventListeners.contains(listener)) {
            this.m_lEventListeners.add(listener);
        }
    }

    public synchronized void removecWsAppServerEventListener(WsAppServerEventListener listener) {
        if (this.m_lEventListeners.contains(listener)) {
            this.m_lEventListeners.remove(listener);
        }
    }

    public void fireWsAppServerEvent(WsAppServerEvent evt) {
        for (int iListener = this.m_lEventListeners.size() - 1; iListener >= 0; --iListener) {
            WsAppServerEventListener listener = (WsAppServerEventListener)this.m_lEventListeners.get(iListener);
            listener.eventHappened(evt);
        }
    }

    protected class cWsAppServerEventListener
    implements WsAppServerEventListener {
        protected cWsAppServerEventListener() {
        }

        @Override
        public void eventHappened(WsAppServerEvent evt) {
            WsServerRequest.this.fireWsAppServerEvent(evt);
        }
    }

    protected class cCancelCodeSubmit
    extends Thread {
        @Override
        public void run() {
            try {
                if (WsServerRequest.this.m_WsAppServer != null) {
                    WsServerRequest.this.m_WsAppServer.cancelRunningSASCode();
                }
            }
            catch (WsAppServerFailException wsAppServerFailException) {
                // empty catch block
            }
        }
    }

    protected class cRunCode
    extends Thread {
        public static final int SUCCESSSTATUS = 0;
        public static final int CODEERRORSTATUS = -1;
        public static final int SERVERERRORSTATUS = -2;
        public static final int SERVERKILLEDSTATUS = -3;

        @Override
        public void run() {
            try {
                WsServerRequest.this.m_sExceptionMessage = null;
                WsServerRequest.this.m_WsAppServer.submitSASCode(WsServerRequest.this.m_sSASCode, true);
                SwingUtilities.invokeLater(new cEndCodeSubmit(0, 0, null));
            }
            catch (WsAppServerCodeException ex) {
                WsServerRequest.this.m_sExceptionMessage = ex.getMessage();
                int type = ex.getType();
                if (WsServerRequest.this.m_WsAppServer.isKilled()) {
                    SwingUtilities.invokeLater(new cEndCodeSubmit(-3, 0, null));
                } else {
                    SwingUtilities.invokeLater(new cEndCodeSubmit(-1, type, WsServerRequest.this.m_sExceptionMessage));
                }
            }
            catch (WsAppServerFailException e) {
                if (WsServerRequest.this.m_WsAppServer != null && WsServerRequest.this.m_WsAppServer.isKilled()) {
                    SwingUtilities.invokeLater(new cEndCodeSubmit(-3, 0, null));
                }
                WsServerRequest.this.m_sExceptionMessage = e.getMessage();
                Workspace.getDefaultLogger().error((Object)"", e);
                SwingUtilities.invokeLater(new cEndCodeSubmit(-2, -1, WsServerRequest.this.m_sExceptionMessage));
            }
        }

        protected class cEndCodeSubmit
        implements Runnable {
            protected int m_jobState;
            protected int m_appServerStatus;
            protected String m_errorMessage;

            cEndCodeSubmit(int jobState, int appServerStatus, String errorMessage) {
                this.m_jobState = jobState;
                this.m_appServerStatus = appServerStatus;
                this.m_errorMessage = errorMessage;
            }

            @Override
            public void run() {
                WsServerRequest.this.setPropertyInt(WsServerRequest.APPSERVERSTATUS, this.m_appServerStatus);
                if (this.m_jobState == 0) {
                    WsServerRequest.this.setPropertyDate(WsServerRequest.ENDTIME, new Date());
                    WsServerRequest.this.setPropertyString(WsServerRequest.JOBSTATUS, JOBSUCCESSFUL);
                } else if (this.m_jobState == -1) {
                    WsServerRequest.this.setPropertyDate(WsServerRequest.ENDTIME, new Date());
                    if (this.m_appServerStatus == 3) {
                        WsServerRequest.this.setPropertyString(WsServerRequest.JOBSTATUS, JOBABORTED);
                    } else if (this.m_appServerStatus == 2) {
                        WsServerRequest.this.setPropertyString(WsServerRequest.JOBSTATUS, JOBTERMINATED);
                    } else {
                        WsServerRequest.this.setPropertyString(WsServerRequest.JOBSTATUS, JOBERRORED);
                    }
                } else if (this.m_jobState == -2) {
                    WsServerRequest.this.setPropertyString(WsServerRequest.JOBSTATUS, JOBERRORED);
                } else if (this.m_jobState == -3) {
                    WsServerRequest.this.setPropertyString(WsServerRequest.JOBSTATUS, JOBKILLED);
                }
            }
        }
    }
}

