/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdStore;
import com.sas.workspace.ReposDependencyObject;
import com.sas.workspace.Repository;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WsRepositoryUtil {
    public static final int DEPENDENCY_USES = 1;
    public static final int DEPENDENCY_USEDBY = 2;
    public static final int DEPENDENCY_REPLACE = 4;

    public static String getRepositoryType(IOMI omiConnection, String strReposId) {
        String repositoryType;
        block4: {
            if (omiConnection == null) {
                omiConnection = Workspace.getWorkspace().getCMRHandle();
            }
            StringHolder outXML = new StringHolder();
            String options = "<XMLSELECT search=\"@ID='" + strReposId + "'\"/>";
            int flags = 392;
            repositoryType = "UNKNOWN";
            try {
                omiConnection.GetMetadataObjects("A0000001.A0000001", "RepositoryBase", outXML, "REPOS", flags, options);
                String outXMLString = outXML.value.toString();
                Document mainDoc = Workspace.getMdFactory().getOMIUtil().parseXML(outXMLString);
                if (mainDoc == null) break block4;
                Node firstNode = mainDoc.getFirstChild();
                NodeList nodeList = firstNode.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node currentNode = nodeList.item(i);
                    NamedNodeMap nodeMap = currentNode.getAttributes();
                    if (nodeMap.getNamedItem("RepositoryType") == null) continue;
                    repositoryType = nodeMap.getNamedItem("RepositoryType").getNodeValue();
                    break;
                }
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error("Result of getRepositoryType:" + e.getMessage());
            }
        }
        return repositoryType;
    }

    public static String getRepositoryType(MdFactory m_Factory, String strReposId) {
        String repositoryType;
        block7: {
            IOMI omiConnection = null;
            repositoryType = "UNKNOWN";
            try {
                omiConnection = m_Factory.getConnection().getCMRHandle();
            }
            catch (RemoteException re) {
                return repositoryType;
            }
            StringHolder outXML = new StringHolder();
            String options = "<XMLSELECT search=\"@ID='" + strReposId + "'\"/>";
            int flags = 392;
            try {
                omiConnection.GetMetadataObjects("A0000001.A0000001", "RepositoryBase", outXML, "REPOS", flags, options);
                String outXMLString = outXML.value.toString();
                Document mainDoc = m_Factory.getOMIUtil().parseXML(outXMLString);
                if (mainDoc == null) break block7;
                Node firstNode = mainDoc.getFirstChild();
                NodeList nodeList = firstNode.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node currentNode = nodeList.item(i);
                    NamedNodeMap nodeMap = currentNode.getAttributes();
                    if (nodeMap.getNamedItem("RepositoryType") == null) continue;
                    repositoryType = nodeMap.getNamedItem("RepositoryType").getNodeValue();
                    break;
                }
            }
            catch (Exception e) {
                try {
                    m_Factory.getUtil().printOutputln("Result of getRepositoryType:" + e.getMessage());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        return repositoryType;
    }

    public static Vector getRepositoryDependencies(IOMI omiConnection, String strReposid) throws Exception {
        return WsRepositoryUtil.getRepositoryDependencies(omiConnection, strReposid, 3);
    }

    public static Vector getRepositoryDependencies(MdFactory m_Factory, String strReposid) throws Exception {
        return WsRepositoryUtil.getRepositoryDependencies(m_Factory, strReposid, 3);
    }

    public static Vector getRepositoryDependencies(String strReposid) throws Exception {
        IOMI omiConnection = Workspace.getMdFactory().getConnection().getCMRHandle();
        return WsRepositoryUtil.getRepositoryDependencies(omiConnection, strReposid);
    }

    public static Vector getRepositoryDependencies(IOMI omiConnection, String strReposid, int dependencyType) throws Exception {
        Vector<ReposDependencyObject> dependencyList = null;
        if (strReposid != null) {
            dependencyList = new Vector<ReposDependencyObject>(0);
            StringBuffer inXMLBuffer = new StringBuffer("<RepositoryBase Id=\"" + strReposid + "\">");
            switch (dependencyType) {
                case 1: {
                    inXMLBuffer.append("<DependencyUses/>");
                    break;
                }
                case 2: {
                    inXMLBuffer.append("<DependencyUsedBy/>");
                    break;
                }
                default: {
                    inXMLBuffer.append("<DependencyUses/>");
                    inXMLBuffer.append("<DependencyUsedBy/>");
                }
            }
            inXMLBuffer.append("</RepositoryBase>");
            StringHolder outXML = new StringHolder();
            String inXML = inXMLBuffer.toString();
            omiConnection.GetMetadata(inXML, outXML, "REPOS", 8, "");
            String outXMLString = outXML.value;
            Document mainDoc = Workspace.getMdFactory().getOMIUtil().parseXML(outXMLString);
            if (mainDoc != null) {
                Node firstNode = mainDoc.getFirstChild();
                NodeList nodeList = firstNode.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node currentNode = nodeList.item(i);
                    NodeList childList = currentNode.getChildNodes();
                    for (int j = 0; j < childList.getLength(); ++j) {
                        Node childNode = childList.item(j);
                        NamedNodeMap childNodeMap = childNode.getAttributes();
                        ReposDependencyObject dependencyObj = new ReposDependencyObject();
                        Repository dependentRepos = new Repository(omiConnection);
                        dependentRepos.setName(childNodeMap.getNamedItem("Name").getNodeValue());
                        dependentRepos.setDesc(childNodeMap.getNamedItem("Desc").getNodeValue());
                        dependentRepos.setFQID(childNodeMap.getNamedItem("Id").getNodeValue());
                        String strAccess = childNodeMap.getNamedItem("Access").getNodeValue();
                        if (strAccess.equals("0")) {
                            dependentRepos.setAccess(false);
                        } else {
                            dependentRepos.setAccess(true);
                        }
                        dependentRepos.setEngine(childNodeMap.getNamedItem("Engine").getNodeValue());
                        dependentRepos.setPath(childNodeMap.getNamedItem("Path").getNodeValue());
                        dependentRepos.setOptions(childNodeMap.getNamedItem("Options").getNodeValue());
                        dependencyObj.setRepository(dependentRepos);
                        if (currentNode.getNodeName().equalsIgnoreCase("DependencyUses")) {
                            dependencyObj.setRelationship(1);
                        } else {
                            dependencyObj.setRelationship(2);
                        }
                        dependencyList.add(dependencyObj);
                    }
                }
            }
        }
        return dependencyList;
    }

    public static Vector getRepositoryDependencies(MdFactory m_Factory, String strReposid, int dependencyType) throws Exception {
        Vector<ReposDependencyObject> dependencyList = null;
        if (strReposid != null) {
            dependencyList = new Vector<ReposDependencyObject>(0);
            StringBuffer inXMLBuffer = new StringBuffer("<RepositoryBase Id=\"" + strReposid + "\">");
            switch (dependencyType) {
                case 1: {
                    inXMLBuffer.append("<DependencyUses/>");
                    break;
                }
                case 2: {
                    inXMLBuffer.append("<DependencyUsedBy/>");
                    break;
                }
                default: {
                    inXMLBuffer.append("<DependencyUses/>");
                    inXMLBuffer.append("<DependencyUsedBy/>");
                }
            }
            inXMLBuffer.append("</RepositoryBase>");
            IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
            StringHolder outXML = new StringHolder();
            String inXML = inXMLBuffer.toString();
            omiConnection.GetMetadata(inXML, outXML, "REPOS", 8, "");
            String outXMLString = outXML.value;
            Document mainDoc = m_Factory.getOMIUtil().parseXML(outXMLString);
            if (mainDoc != null) {
                Node firstNode = mainDoc.getFirstChild();
                NodeList nodeList = firstNode.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node currentNode = nodeList.item(i);
                    NodeList childList = currentNode.getChildNodes();
                    for (int j = 0; j < childList.getLength(); ++j) {
                        Node childNode = childList.item(j);
                        NamedNodeMap childNodeMap = childNode.getAttributes();
                        ReposDependencyObject dependencyObj = new ReposDependencyObject();
                        Repository dependentRepos = new Repository(omiConnection);
                        dependentRepos.setName(childNodeMap.getNamedItem("Name").getNodeValue());
                        dependentRepos.setDesc(childNodeMap.getNamedItem("Desc").getNodeValue());
                        dependentRepos.setFQID(childNodeMap.getNamedItem("Id").getNodeValue());
                        String strAccess = childNodeMap.getNamedItem("Access").getNodeValue();
                        if (strAccess.equals("0")) {
                            dependentRepos.setAccess(false);
                        } else {
                            dependentRepos.setAccess(true);
                        }
                        dependentRepos.setEngine(childNodeMap.getNamedItem("Engine").getNodeValue());
                        dependentRepos.setPath(childNodeMap.getNamedItem("Path").getNodeValue());
                        dependentRepos.setOptions(childNodeMap.getNamedItem("Options").getNodeValue());
                        dependencyObj.setRepository(dependentRepos);
                        if (currentNode.getNodeName().equalsIgnoreCase("DependencyUses")) {
                            dependencyObj.setRelationship(1);
                        } else {
                            dependencyObj.setRelationship(2);
                        }
                        dependencyList.add(dependencyObj);
                    }
                }
            }
        }
        return dependencyList;
    }

    public static boolean isChangeManagedRepository(String strReposId) {
        String options = "<XMLSELECT search=\"@Name='ChangeManagement'\"/>";
        try {
            int objCount = Workspace.getMdFactory().getOMIUtil().doesObjectExist(strReposId, "Group", options);
            return objCount > 0;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error("Result of isChangeManagedRepository:" + e.getMessage());
            return false;
        }
    }

    public static boolean isChangeManagedRepository(MdFactory m_Factory, String strReposId) {
        String options = "<XMLSELECT search=\"@Name='ChangeManagement'\"/>";
        try {
            int objCount = m_Factory.getOMIUtil().doesObjectExist(strReposId, "Group", options);
            return objCount > 0;
        }
        catch (Exception e) {
            try {
                m_Factory.getUtil().printOutputln("Result of isChangeManagedRepository:" + e.getMessage());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return false;
        }
    }

    public static boolean BIPTreeExists(String strReposId) throws Exception {
        String type = "SoftwareComponent";
        String options = "<XMLSELECT search=\"@ClassIdentifier='E5F27790-2149-11D6-8828-AA0004006D06'\"/>";
        int objCount = Workspace.getMdFactory().getOMIUtil().doesObjectExist(strReposId, type, options);
        return objCount > 0;
    }

    public static boolean BIPTreeExists(MdFactory m_Factory, String strReposId) throws Exception {
        String type = "SoftwareComponent";
        String options = "<XMLSELECT search=\"@ClassIdentifier='E5F27790-2149-11D6-8828-AA0004006D06'\"/>";
        int objCount = m_Factory.getOMIUtil().doesObjectExist(strReposId, type, options);
        return objCount > 0;
    }

    public static Identity getRepositoryOwner(IOMI omiConnection, String strReposId) {
        List extensions = null;
        if (omiConnection == null) {
            omiConnection = Workspace.getWorkspace().getCMRHandle();
        }
        String options = "<XMLSELECT search=\"@Name='ProjectRepository' AND @Value='" + strReposId + "'\"/>";
        int flags = 392;
        try {
            Vector dependencies = WsRepositoryUtil.getRepositoryDependencies(omiConnection, strReposId);
            if (dependencies.size() > 0) {
                extensions = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)Workspace.getMdFactory().getStore(), strReposId, "Extension", flags |= 0x2000, options, false);
            } else {
                extensions = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)Workspace.getMdFactory().getStore(), strReposId, "Extension", flags, options, false);
                Repository[] repositories = Repository.getRepositories(omiConnection);
                for (int i = 0; i < repositories.length; ++i) {
                    Repository repository = repositories[i];
                    if (!repository.getType().equalsIgnoreCase("FOUNDATION") || repository.getFQID().equalsIgnoreCase(strReposId)) continue;
                    List subList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)Workspace.getMdFactory().getStore(), repository.getFQID(), "Extension", flags, options, false);
                    if (extensions != null) {
                        extensions.addAll(subList);
                        break;
                    }
                    extensions = subList;
                    break;
                }
            }
            if (extensions.size() > 0) {
                return (Identity)((Extension)extensions.get(0)).getOwningObject();
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error("Result of getRepositoryOwner:" + e);
        }
        return null;
    }

    public static Identity getRepositoryOwner(MdFactory m_Factory, String strReposId) {
        List extensions = null;
        String options = "<XMLSELECT search=\"@Name='ProjectRepository' AND @Value='" + strReposId + "'\"/>";
        int flags = 392;
        try {
            Vector dependencies = WsRepositoryUtil.getRepositoryDependencies(m_Factory, strReposId);
            if (dependencies.size() > 0) {
                extensions = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)m_Factory.getStore(), strReposId, "Extension", flags |= 0x2000, options, false);
            } else {
                extensions = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)m_Factory.getStore(), strReposId, "Extension", flags, options, false);
                Repository[] repositories = Repository.getRepositories(m_Factory);
                for (int i = 0; i < repositories.length; ++i) {
                    Repository repository = repositories[i];
                    if (!repository.getType().equalsIgnoreCase("FOUNDATION") || repository.getFQID().equalsIgnoreCase(strReposId)) continue;
                    List subList = m_Factory.getOMIUtil().getMetadataObjectsSubset((MdStore)m_Factory.getStore(), repository.getFQID(), "Extension", flags, options, false);
                    if (extensions != null) {
                        extensions.addAll(subList);
                        break;
                    }
                    extensions = subList;
                    break;
                }
            }
            if (extensions.size() > 0) {
                return (Identity)((Extension)extensions.get(0)).getOwningObject();
            }
        }
        catch (Exception e) {
            try {
                m_Factory.getUtil().printOutputln("Result of getRepositoryOwner:" + e.getMessage());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }
}

