/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.ILogger;
import com.sas.workspace.Workspace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

class WsLogger
implements ILogger {
    public static final String DEFAULT_LOGGING_CONTEXT = Workspace.getMainLoggingContext();
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_PATTERN = "%d [%t] %-5p %c - %m%n";
    private static Map<String, WsLogger> s_mapLoggers = new HashMap<String, WsLogger>();
    private static WsLogger s_rootLogger;
    private Logger m_log4j;

    public static WsLogger getRootLogger() {
        if (s_rootLogger == null) {
            s_rootLogger = new WsLogger(DEFAULT_LOGGING_CONTEXT);
            if (Workspace.isDebug()) {
                s_rootLogger.setLevel(DEBUG);
            }
        }
        return s_rootLogger;
    }

    public static WsLogger getLogger(String sContext) {
        WsLogger logger = s_mapLoggers.get(sContext);
        if (logger == null) {
            logger = new WsLogger(sContext);
            s_mapLoggers.put(sContext, logger);
        }
        return logger;
    }

    private WsLogger() {
        String context = DEFAULT_LOGGING_CONTEXT;
        this.m_log4j = LogManager.getLogger((String)context);
        if (this.m_log4j == null) {
            System.err.println("Error getting logger for context: " + context);
        }
    }

    private WsLogger(String sContext) {
        this.m_log4j = LogManager.getLogger((String)sContext);
        if (this.m_log4j == null) {
            System.err.println("Error getting logger for context: " + sContext);
        }
    }

    private static Level convertIntToLevel(int level) {
        if (Level.DEBUG.intLevel() == level) {
            return Level.DEBUG;
        }
        if (Level.INFO.intLevel() == level) {
            return Level.INFO;
        }
        if (Level.WARN.intLevel() == level) {
            return Level.WARN;
        }
        if (Level.ERROR.intLevel() == level) {
            return Level.ERROR;
        }
        if (Level.FATAL.intLevel() == level) {
            return Level.FATAL;
        }
        return Level.INFO;
    }

    @Override
    public void log(int level, Object message) {
        this.m_log4j.log(WsLogger.convertIntToLevel(level), message);
    }

    @Override
    public void log(int level, Object message, Throwable t) {
        this.m_log4j.log(WsLogger.convertIntToLevel(level), message, t);
    }

    @Override
    public void log(int level, Object message, String loggingContext) {
        Logger logger = LogManager.getLogger((String)loggingContext);
        logger.log(WsLogger.convertIntToLevel(level), message);
    }

    @Override
    public void log(int level, Object message, String loggingContext, Throwable t) {
        Logger logger = LogManager.getLogger((String)loggingContext);
        logger.log(WsLogger.convertIntToLevel(level), message, t);
    }

    @Override
    public boolean isLevelEnabled(int level) {
        return this.m_log4j.isEnabled(WsLogger.convertIntToLevel(level));
    }

    @Override
    public boolean isLevelEnabled(int level, String loggingContext) {
        return this.m_log4j.isEnabled(WsLogger.convertIntToLevel(level));
    }

    @Override
    public void debug(Object message) {
        this.m_log4j.debug(message);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.m_log4j.debug(message, t);
    }

    @Override
    public void debug(Object message, String loggingContext) {
        this.log(Level.DEBUG.intLevel(), message, loggingContext);
    }

    @Override
    public void debug(Object message, String loggingContext, Throwable t) {
        this.log(Level.DEBUG.intLevel(), message, loggingContext, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.m_log4j.isDebugEnabled();
    }

    @Override
    public boolean isDebugEnabled(String loggingContext) {
        return LogManager.getLogger((String)loggingContext).isDebugEnabled();
    }

    @Override
    public void info(Object message) {
        this.m_log4j.info(message);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.m_log4j.info(message, t);
    }

    @Override
    public void info(Object message, String loggingContext) {
        this.log(Level.INFO.intLevel(), message, loggingContext);
    }

    @Override
    public void info(Object message, String loggingContext, Throwable t) {
        this.log(Level.INFO.intLevel(), message, loggingContext, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.m_log4j.isInfoEnabled();
    }

    @Override
    public boolean isInfoEnabled(String loggingContext) {
        return LogManager.getLogger((String)loggingContext).isInfoEnabled();
    }

    @Override
    public void warn(Object message) {
        this.m_log4j.warn(message);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.m_log4j.warn(message, t);
    }

    @Override
    public void warn(Object message, String loggingContext) {
        LogManager.getLogger((String)loggingContext).warn(message);
    }

    @Override
    public void warn(Object message, String loggingContext, Throwable t) {
        LogManager.getLogger((String)loggingContext).warn(message, t);
    }

    @Override
    public void error(Object message) {
        this.m_log4j.error(message);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.m_log4j.error(message, t);
    }

    @Override
    public void error(Object message, String loggingContext) {
        this.log(Level.ERROR.intLevel(), message, loggingContext);
    }

    @Override
    public void error(Object message, String loggingContext, Throwable t) {
        this.log(Level.ERROR.intLevel(), message, loggingContext, t);
    }

    @Override
    public void fatal(Object message) {
        this.m_log4j.fatal(message);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.m_log4j.fatal(message, t);
    }

    @Override
    public void fatal(Object message, String loggingContext) {
        this.log(Level.FATAL.intLevel(), message, loggingContext);
    }

    @Override
    public void fatal(Object message, String loggingContext, Throwable t) {
        this.log(Level.FATAL.intLevel(), message, loggingContext, t);
    }

    @Override
    public void setLevel(int level) {
        Configurator.setLevel((String)this.m_log4j.getName(), (Level)WsLogger.convertIntToLevel(level));
    }

    @Override
    public int getLevel() {
        return this.m_log4j.getLevel().intLevel();
    }

    public static void setLoggerPriority(List loggingContexts, int priority) {
        if (loggingContexts != null) {
            for (Object object : loggingContexts) {
                if (object instanceof String) {
                    String loggingContext = (String)object;
                    WsLogger.setLoggerPriority(loggingContext, priority);
                    continue;
                }
                System.err.println("Error setting logging priority for context of " + object);
            }
        }
    }

    public static void setLoggerPriority(String loggingContext, int priority) {
        Logger log4jLogger = LogManager.getLogger((String)loggingContext);
        if (log4jLogger != null) {
            Configurator.setLevel((String)log4jLogger.getName(), (Level)WsLogger.convertIntToLevel(priority));
        } else {
            System.err.println("Error setting logger priority for context: " + loggingContext);
        }
    }

    private static void setLoggerFile(String loggingContext, String logFileName, String pattern) {
        Logger log4jLogger = LogManager.getLogger((String)loggingContext);
        if (log4jLogger != null) {
            LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = lc.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig(log4jLogger.getName());
            if (loggerConfig.getName().equals(log4jLogger.getName())) {
                loggerConfig.removeAppender(logFileName);
            }
            lc.updateLoggers();
            PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern(pattern).build();
            FileAppender fp1 = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName(logFileName)).withFileName(logFileName).setLayout((Layout)layout)).setConfiguration(config)).build();
            fp1.start();
            config.addAppender((Appender)fp1);
            lc.getLogger(log4jLogger.getName()).addAppender((Appender)fp1);
            lc.updateLoggers();
        } else {
            System.err.println("Error setting logger priority for context: " + loggingContext);
        }
    }

    public static void setLoggerFile(String loggingContext, String logFileName) {
        WsLogger.setLoggerFile(loggingContext, logFileName, DEFAULT_PATTERN);
    }

    public static void addFileOutput(WsLogger logger, String logFileName) {
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern(DEFAULT_PATTERN).build();
        FileAppender fp1 = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName(logFileName)).withFileName(logFileName).setLayout((Layout)layout)).setConfiguration(config)).build();
        fp1.start();
        config.addAppender((Appender)fp1);
        lc.getLogger(logger.m_log4j.getName()).addAppender((Appender)fp1);
        lc.updateLoggers();
    }

    private static void setConsoleLogging(String loggingContext, boolean enabled, String pattern) {
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        Logger log4jLogger = LogManager.getLogger((String)loggingContext);
        if (log4jLogger != null) {
            Appender consoleApp = null;
            ArrayList consoleAppenders = new ArrayList();
            WsLogger.getAllConsoleAppenders(log4jLogger, consoleAppenders);
            if (consoleAppenders.size() > 0) {
                consoleApp = (Appender)consoleAppenders.get(0);
            }
            if (consoleApp == null && enabled) {
                PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern(pattern).build();
                ConsoleAppender consoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("System.out")).setConfiguration(config)).setLayout((Layout)layout)).build();
                consoleAppender.start();
                config.addAppender((Appender)consoleAppender);
                lc.getRootLogger().addAppender((Appender)consoleAppender);
                lc.getLogger(log4jLogger.getName()).addAppender((Appender)consoleAppender);
                lc.updateLoggers();
            }
            if (consoleApp != null && !enabled) {
                Appender removeApp = WsLogger.getAppender(log4jLogger, "System.out");
                if (removeApp == null) {
                    removeApp = WsLogger.getAppender(log4jLogger, "SASConsoleAppender");
                }
                if (removeApp != null) {
                    LoggerConfig loggerConfig = config.getLoggerConfig(log4jLogger.getName());
                    if (loggerConfig.getName().equals(log4jLogger.getName())) {
                        loggerConfig.removeAppender(consoleApp.getName());
                    }
                    lc.updateLoggers();
                }
            }
            if (consoleAppenders.size() > 1) {
                ArrayList<String> names = new ArrayList<String>();
                for (Appender app : consoleAppenders) {
                    names.add(app.getName());
                }
                System.err.println("Multiple console appenders " + names + " found for " + loggingContext);
            }
        }
    }

    public static void setConsoleLogging(String loggingContext, boolean enabled) {
        WsLogger.setConsoleLogging(loggingContext, enabled, DEFAULT_PATTERN);
    }

    private static Appender getAppender(Logger logger, String appenderName) {
        LoggerContext lc;
        Configuration config;
        LoggerConfig loggerConfig;
        Map appenders;
        Appender returnValue = null;
        if (logger != null && (returnValue = (Appender)(appenders = (loggerConfig = (config = (lc = (LoggerContext)LogManager.getContext((boolean)false)).getConfiguration()).getLoggerConfig(logger.getName())).getAppenders()).get(appenderName)) == null && lc.getLogger(logger.getName()).isAdditive()) {
            returnValue = WsLogger.getAppender((Logger)lc.getLogger(logger.getName()).getParent(), appenderName);
        }
        return returnValue;
    }

    private static void getAllConsoleAppenders(Logger logger, List allApps) {
        if (logger != null) {
            LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = lc.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
            Map appenders = loggerConfig.getAppenders();
            for (Appender appender : appenders.values()) {
                if (!(appender instanceof ConsoleAppender) || allApps.contains(appender)) continue;
                allApps.add(appender);
            }
            if (lc.getLogger(logger.getName()).isAdditive()) {
                WsLogger.getAllConsoleAppenders((Logger)lc.getLogger(logger.getName()).getParent(), allApps);
            }
        }
    }

    public static void setLoggerFormat(String loggingContext, String patternLayout) {
        Logger log4jLogger = LogManager.getLogger((String)loggingContext);
        if (log4jLogger != null) {
            LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = lc.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig(log4jLogger.getName());
            Map appenders = loggerConfig.getAppenders();
            for (Appender logAppender : appenders.values()) {
                if (logAppender instanceof ConsoleAppender) {
                    WsLogger.setConsoleLogging(loggingContext, true, patternLayout);
                }
                if (!(logAppender instanceof FileAppender)) continue;
                WsLogger.setLoggerFile(loggingContext, logAppender.getName(), patternLayout);
            }
        } else {
            System.err.println("Error setting logger priority for context: " + loggingContext);
        }
    }

    public static void setAdditivityAppenders(String loggingContext, boolean value) {
        Logger log4jLogger = LogManager.getLogger((String)loggingContext);
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        lc.getLogger(log4jLogger.getName()).setAdditive(value);
    }
}

