/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.Workspace;
import java.util.HashMap;
import java.util.Map;

public class WsLockManager {
    private static WsLockManager s_instance;
    private Map m_mapLocks = new HashMap();

    public static WsLockManager getInstance() {
        if (s_instance == null) {
            s_instance = new WsLockManager();
        }
        return s_instance;
    }

    private WsLockManager() {
    }

    public void addLock(String sID) {
        Lock lock = (Lock)this.m_mapLocks.get(sID);
        if (lock == null) {
            lock = new Lock();
            this.m_mapLocks.put(sID, lock);
        }
        lock.increment();
    }

    public void removeLock(String sID) {
        Lock lock = (Lock)this.m_mapLocks.get(sID);
        if (lock == null) {
            Workspace.getDefaultLogger().error("WsLockManager: removeLock error " + sID + " not locked");
            return;
        }
        lock.decrement();
        if (lock.getCount() == 0) {
            this.m_mapLocks.remove(sID);
        }
    }

    public boolean isLocked(String sID) {
        return this.m_mapLocks.get(sID) != null;
    }

    public int getLockCount(String sID) {
        Lock lock = (Lock)this.m_mapLocks.get(sID);
        return lock == null ? 0 : lock.getCount();
    }

    public void clearLocks() {
        this.m_mapLocks.clear();
    }

    public String toString() {
        return this.m_mapLocks.toString();
    }

    private static class Lock {
        private int m_nLocks = 0;

        public void increment() {
            ++this.m_nLocks;
        }

        public void decrement() {
            --this.m_nLocks;
        }

        public int getCount() {
            return this.m_nLocks;
        }

        public String toString() {
            return Integer.toString(this.m_nLocks);
        }
    }
}

