/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WATextField;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsEditableListModel;
import com.sas.workspace.WsListCellEditor;
import com.sas.workspace.WsListUI;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

public class WsList
extends JList {
    private static final String UI_CLASS_ID = "WsListUI";
    private boolean m_bEditable;
    private boolean m_bKeyboardEditEnabled;
    private WsListCellEditor m_edtDefault;
    private WsListCellEditor m_edtCurrent;
    private Component m_cmpEditor;
    private int m_iEditRow;
    private CellEditorListener m_lsnrEditor;

    public WsList() {
        this.initializeComponent();
    }

    public WsList(Object[] listData) {
        super(listData);
        this.initializeComponent();
    }

    public WsList(Vector listData) {
        super(listData);
        this.initializeComponent();
    }

    public WsList(ListModel dataModel) {
        super(dataModel);
        this.initializeComponent();
    }

    protected void initializeComponent() {
        this.setKeyboardEditEnabled(false);
        this.setEditable(true);
        this.setEditingRow(-1);
        this.setDefaultCellEditor(this.createDefaultCellEditor());
        this.m_lsnrEditor = new ListCellEditorListener();
    }

    protected WsListCellEditor createDefaultCellEditor() {
        return new WsDefaultCellEditor(new WATextField());
    }

    @Override
    public String getUIClassID() {
        if (!UIManager.getDefaults().containsKey(UI_CLASS_ID)) {
            UIManager.put(UI_CLASS_ID, WsListUI.class.getName());
        }
        return UI_CLASS_ID;
    }

    public void setKeyboardEditEnabled(boolean bEnabled) {
        this.m_bKeyboardEditEnabled = bEnabled;
    }

    public boolean isKeyboardEditEnabled() {
        return this.m_bKeyboardEditEnabled;
    }

    public void setEditable(boolean bEditable) {
        if (this.m_bEditable == bEditable) {
            return;
        }
        this.m_bEditable = bEditable;
        this.firePropertyChange("editable", !bEditable, bEditable);
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    public boolean editCellAt(int iRow) {
        return this.editCellAt(iRow, null);
    }

    public boolean editCellAt(int iRow, EventObject ev) {
        if (this.m_edtCurrent != null && !this.m_edtCurrent.stopCellEditing()) {
            return false;
        }
        if (iRow < 0 || iRow >= this.getModel().getSize()) {
            throw new IndexOutOfBoundsException("row is out of bounds " + iRow);
        }
        if (!this.isCellEditable(iRow)) {
            return false;
        }
        WsListCellEditor editor = this.getCellEditor(iRow);
        if (editor != null && editor.isCellEditable(ev)) {
            this.m_cmpEditor = this.prepareEditor(editor, iRow);
            if (this.m_cmpEditor == null) {
                this.removeEditor();
                return false;
            }
            this.m_cmpEditor.setBounds(this.getCellBounds(iRow, iRow));
            this.add(this.m_cmpEditor);
            this.m_cmpEditor.validate();
            this.m_cmpEditor.requestFocus();
            this.setCurrentCellEditor(editor);
            this.setEditingRow(iRow);
            editor.addCellEditorListener(this.m_lsnrEditor);
            return true;
        }
        return false;
    }

    public boolean isEditing() {
        return this.m_edtCurrent != null;
    }

    public boolean stopCellEditing() {
        if (!this.isEditing()) {
            return true;
        }
        return this.getCurrentCellEditor().stopCellEditing();
    }

    public void cancelCellEditing() {
        if (!this.isEditing()) {
            return;
        }
        this.getCurrentCellEditor().cancelCellEditing();
    }

    public Component getEditorComponent() {
        return this.m_cmpEditor;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent ev, int condition, boolean pressed) {
        if (super.processKeyBinding(ks, ev, condition, pressed)) {
            return true;
        }
        if (condition == 1 && this.hasFocus() && this.isKeyboardEditEnabled()) {
            Component cmpEditor = this.getEditorComponent();
            if (cmpEditor == null) {
                if (ev.getID() != 400) {
                    return false;
                }
                if (Character.isISOControl(ev.getKeyChar())) {
                    return false;
                }
                int iRow = this.getSelectionModel().getAnchorSelectionIndex();
                if (iRow != -1 && !this.isEditing() && !this.editCellAt(iRow)) {
                    return false;
                }
                cmpEditor = this.getEditorComponent();
                if (cmpEditor == null) {
                    return false;
                }
            }
            cmpEditor.requestFocus();
            if (cmpEditor instanceof JComponent) {
                InputMap mapInput = ((JComponent)cmpEditor).getInputMap(0);
                ActionMap mapActions = ((JComponent)cmpEditor).getActionMap();
                if (mapInput == null || mapActions == null || !cmpEditor.isEnabled()) {
                    return false;
                }
                Object binding = mapInput.get(ks);
                if (binding == null) {
                    return false;
                }
                Action action = mapActions.get(binding);
                if (action == null) {
                    return false;
                }
                return SwingUtilities.notifyAction(action, ks, ev, cmpEditor, ev.getModifiers());
            }
        }
        return false;
    }

    protected Component prepareEditor(WsListCellEditor edt, int iValue) {
        JComponent jcmp;
        Object value = this.getModel().getElementAt(iValue);
        Component cmp = edt.getListCellEditorComponent(this, value, this.isSelectedIndex(iValue), iValue);
        if (cmp instanceof JComponent && (jcmp = (JComponent)cmp).getNextFocusableComponent() == null) {
            jcmp.setNextFocusableComponent(this);
        }
        return cmp;
    }

    protected void removeEditor() {
        WsListCellEditor edt = this.getCurrentCellEditor();
        if (edt != null) {
            edt.removeCellEditorListener(this.m_lsnrEditor);
            if (this.m_cmpEditor != null) {
                this.remove(this.m_cmpEditor);
            }
            this.setCurrentCellEditor(null);
            this.setEditingRow(-1);
            this.m_cmpEditor = null;
            this.requestFocus();
        }
    }

    public WsListCellEditor getCurrentCellEditor() {
        return this.m_edtCurrent;
    }

    public void setCurrentCellEditor(WsListCellEditor editor) {
        WsListCellEditor editorOld = this.m_edtCurrent;
        this.m_edtCurrent = editor;
        this.firePropertyChange("listCellEditor", editorOld, editor);
    }

    public void setDefaultCellEditor(WsListCellEditor editor) {
        if (editor == null) {
            editor = this.createDefaultCellEditor();
        }
        this.m_edtDefault = editor;
    }

    public WsListCellEditor getDefaultCellEditor() {
        return this.m_edtDefault;
    }

    public boolean isCellEditable(int iRow) {
        if (!this.isEditable()) {
            return false;
        }
        ListModel mdlList = this.getModel();
        if (mdlList instanceof WsEditableListModel) {
            return ((WsEditableListModel)mdlList).isCellEditable(iRow);
        }
        return false;
    }

    public WsListCellEditor getCellEditor(int iRow) {
        return this.getDefaultCellEditor();
    }

    public void setEditingRow(int iRow) {
        this.m_iEditRow = iRow;
    }

    public int getEditingRow() {
        return this.m_iEditRow;
    }

    protected class ListCellEditorListener
    implements CellEditorListener {
        protected ListCellEditorListener() {
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            WsListCellEditor editor = WsList.this.getCurrentCellEditor();
            if (editor != null) {
                Object value = editor.getCellEditorValue();
                ((WsEditableListModel)WsList.this.getModel()).setValueAt(WsList.this.m_iEditRow, value);
                WsList.this.removeEditor();
            }
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            WsList.this.removeEditor();
        }
    }
}

