/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsMessageDisplayer;
import com.sas.workspace.WsTextComponentAdapter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class WsLimitedPlainDocument
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    protected static WsMessageDisplayer s_msgDisplayer;
    private static WAdminResource bundle;
    protected int m_maxCharacters = Integer.MAX_VALUE;
    protected boolean m_bMessage = false;
    protected boolean m_bSingleLine = false;

    public static void setMessageDisplayer(WsMessageDisplayer msgDisplayer) {
        s_msgDisplayer = msgDisplayer;
    }

    public static WsMessageDisplayer getMessageDisplayer() {
        return s_msgDisplayer;
    }

    public void setMaxCharacters(int maxCharacters) {
        this.m_maxCharacters = maxCharacters;
    }

    public int getMaxCharacters() {
        return this.m_maxCharacters;
    }

    public void setSingleLine(boolean bSingleLine) {
        this.m_bSingleLine = bSingleLine;
    }

    public boolean isSingleLine() {
        return this.m_bSingleLine;
    }

    public void hideMessage() {
        if (this.m_bMessage) {
            s_msgDisplayer.displayMessage("");
            this.m_bMessage = false;
        }
    }

    @Override
    public void insertString(int iText, String sText, AttributeSet a) throws BadLocationException {
        if (sText == null || sText.length() == 0) {
            return;
        }
        if (this.m_bSingleLine) {
            StringBuffer sbText = new StringBuffer();
            int iStart = 0;
            int iReturn = sText.indexOf(10);
            while (iReturn >= 0) {
                if (iStart != iReturn) {
                    sbText.append(sText.substring(iStart, iReturn));
                }
                iStart = iReturn + 1;
                iReturn = sText.indexOf(10, iStart);
            }
            sbText.append(sText.substring(iStart));
            sText = sbText.toString();
        }
        if (this.m_maxCharacters >= 0 && this.m_maxCharacters != Integer.MAX_VALUE && this.getLength() + sText.length() > this.m_maxCharacters) {
            if (s_msgDisplayer != null) {
                String sMessage = bundle.formatString("Common.TextIsLimitedErrorMessage.txt", new Integer(this.m_maxCharacters));
                s_msgDisplayer.displayMessage(sMessage);
                this.m_bMessage = true;
            }
            sText = sText.substring(0, this.m_maxCharacters - this.getLength());
        }
        super.insertString(iText, sText, a);
    }

    @Override
    public void remove(int iText, int lText) throws BadLocationException {
        this.hideMessage();
        super.remove(iText, lText);
    }

    static {
        bundle = WAdminResource.getBundle(WsTextComponentAdapter.class);
    }
}

