/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class WsHotSpotIcon
extends JLabel {
    private static final long serialVersionUID = 1L;
    protected Icon m_iconBase;
    protected ArrayList m_alHotSpots;
    protected HotSpot m_CurrentHotSpot;

    public WsHotSpotIcon(Icon iconBase) {
        super(iconBase);
        this.m_iconBase = iconBase;
        this.m_alHotSpots = new ArrayList();
        cMouseListener ml = new cMouseListener();
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void addHotSpot(HotSpot hotspot) {
        this.m_alHotSpots.add(hotspot);
    }

    public void removeHotSpot(HotSpot hotspot) {
        if (this.m_CurrentHotSpot == hotspot) {
            this.setCurrentHotSpot(null);
        }
        this.m_alHotSpots.remove(hotspot);
    }

    public HotSpot getHotSpotAt(int x, int y) {
        int nHotSpots = this.m_alHotSpots.size();
        for (int iHotSpot = 0; iHotSpot < nHotSpots; ++iHotSpot) {
            HotSpot hotspot = (HotSpot)this.m_alHotSpots.get(iHotSpot);
            if (!hotspot.m_rHotSpot.contains(x, y)) continue;
            return hotspot;
        }
        return null;
    }

    public void setCurrentHotSpot(HotSpot hotspot) {
        if (this.m_CurrentHotSpot != hotspot) {
            this.m_CurrentHotSpot = hotspot;
            Icon icon = null;
            if (this.m_CurrentHotSpot != null) {
                icon = this.m_CurrentHotSpot.m_icon;
            }
            if (icon == null) {
                icon = this.m_iconBase;
            }
            this.setIcon(icon);
            this.fireChangeEvent();
        }
    }

    public HotSpot getCurrentHotSpot() {
        return this.m_CurrentHotSpot;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.m_iconBase.getIconWidth(), this.m_iconBase.getIconHeight());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        HotSpot hotspot = this.getHotSpotAt(e.getX(), e.getY());
        if (hotspot == null) {
            return super.getToolTipText(e);
        }
        return hotspot.m_sToolTip;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionEvent() {
        ActionEvent e = new ActionEvent(this, this.m_alHotSpots.indexOf(this.m_CurrentHotSpot), "");
        Object[] oaListeners = this.listenerList.getListenerList();
        for (int iListener = oaListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (oaListeners[iListener] != ActionListener.class) continue;
            ((ActionListener)oaListeners[iListener + 1]).actionPerformed(e);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        Object[] oaListeners = this.listenerList.getListenerList();
        for (int iListener = oaListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (oaListeners[iListener] != ChangeListener.class) continue;
            ((ChangeListener)oaListeners[iListener + 1]).stateChanged(e);
        }
    }

    protected class cMouseListener
    extends MouseInputAdapter {
        boolean m_bMouseIn = false;
        boolean m_bMouseDown = false;

        protected cMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            HotSpot hotspot = WsHotSpotIcon.this.getHotSpotAt(e.getX(), e.getY());
            WsHotSpotIcon.this.setCurrentHotSpot(hotspot);
            if (hotspot != null) {
                e.consume();
                WsHotSpotIcon.this.fireActionEvent();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            HotSpot hotspot = WsHotSpotIcon.this.getHotSpotAt(e.getX(), e.getY());
            WsHotSpotIcon.this.setCurrentHotSpot(hotspot);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            WsHotSpotIcon.this.setCurrentHotSpot(null);
        }
    }

    public static class HotSpot {
        protected Rectangle m_rHotSpot;
        protected Icon m_icon;
        protected String m_sToolTip;

        public HotSpot(int x, int y, int width, int height) {
            this(new Rectangle(x, y, width, height), null, null);
        }

        public HotSpot(int x, int y, int width, int height, Icon icon) {
            this(new Rectangle(x, y, width, height), icon, null);
        }

        public HotSpot(int x, int y, int width, int height, Icon icon, String sToolTip) {
            this(new Rectangle(x, y, width, height), icon, sToolTip);
        }

        public HotSpot(Rectangle rHotSpot) {
            this(rHotSpot, null, null);
        }

        public HotSpot(Rectangle rHotSpot, Icon icon) {
            this(rHotSpot, icon, null);
        }

        public HotSpot(Rectangle rHotSpot, Icon icon, String sToolTip) {
            this.m_rHotSpot = rHotSpot;
            this.m_icon = icon;
            this.m_sToolTip = sToolTip;
        }
    }
}

