/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.border.AbstractBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WsFlatButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private static Insets NO_MARGIN = new Insets(0, 0, 0, 0);
    private boolean m_bToggle;

    public WsFlatButton() {
        this.initialize();
    }

    public WsFlatButton(Action act) {
        super(act);
        this.initialize();
    }

    public WsFlatButton(String sText) {
        super(sText);
        this.initialize();
    }

    public WsFlatButton(Icon icon) {
        super(icon);
        this.initialize();
    }

    public WsFlatButton(String sText, Icon icon) {
        super(sText, icon);
        this.initialize();
    }

    protected void initialize() {
        this.setMargin(NO_MARGIN);
        this.setFocusPainted(false);
        this.setBorder(new cBevelBorder(2));
        this.setRolloverEnabled(true);
        this.addChangeListener(new cChangeListener());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.getModel().setRollover(false);
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    public void setToggleStyle(boolean bToggle) {
        if (this.m_bToggle != bToggle) {
            this.m_bToggle = bToggle;
            DefaultButtonModel mdlNew = bToggle ? new JToggleButton.ToggleButtonModel() : new DefaultButtonModel();
            mdlNew.setMnemonic(this.getMnemonic());
            mdlNew.setEnabled(this.isEnabled());
            this.setModel(mdlNew);
        }
    }

    public boolean isToggleStyle() {
        return this.m_bToggle;
    }

    protected class cChangeListener
    implements ChangeListener {
        protected cChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            cBevelBorder border;
            Color clrBackground = SystemColor.control;
            ButtonModel mdl = WsFlatButton.this.getModel();
            if (mdl.isSelected()) {
                border = new cBevelBorder(1);
                if (!mdl.isPressed() && !mdl.isRollover()) {
                    float[] rgbDark = new float[3];
                    float[] rgbLight = new float[3];
                    SystemColor.control.getColorComponents(rgbDark);
                    SystemColor.controlLtHighlight.getColorComponents(rgbLight);
                    clrBackground = new Color((rgbDark[0] + rgbLight[0]) / 2.0f, (rgbDark[1] + rgbLight[1]) / 2.0f, (rgbDark[2] + rgbLight[2]) / 2.0f);
                }
            } else {
                border = mdl.isPressed() && mdl.isRollover() ? new cBevelBorder(1) : (mdl.isPressed() || mdl.isRollover() ? new cBevelBorder(0) : new cBevelBorder(2));
            }
            WsFlatButton.this.setBorder(border);
            WsFlatButton.this.setBackground(clrBackground);
        }
    }

    protected static class cBevelBorder
    extends AbstractBorder {
        private static final long serialVersionUID = 1L;
        public static final int RAISED = 0;
        public static final int LOWERED = 1;
        public static final int FLAT = 2;
        protected int m_eBevelType;
        protected Color m_clrHighlight;
        protected Color m_clrShadow;

        public cBevelBorder(int eBevelType) {
            this.m_eBevelType = eBevelType;
            switch (this.m_eBevelType) {
                case 0: {
                    this.m_clrHighlight = SystemColor.controlLtHighlight;
                    this.m_clrShadow = SystemColor.controlShadow;
                    break;
                }
                case 1: {
                    this.m_clrHighlight = SystemColor.controlShadow;
                    this.m_clrShadow = SystemColor.controlLtHighlight;
                }
            }
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color clrOld = g.getColor();
            Color clrBack = c.getBackground();
            if (this.m_eBevelType == 2) {
                this.m_clrHighlight = clrBack;
                this.m_clrShadow = clrBack;
            }
            int h = height;
            int w = width;
            g.translate(x, y);
            g.setColor(this.m_clrHighlight);
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(1, 0, w - 1, 0);
            g.setColor(this.m_clrShadow);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.setColor(clrBack);
            g.drawRect(1, 1, w - 3, h - 3);
            g.translate(-x, -y);
            g.setColor(clrOld);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 3, 3, 3);
        }

        public int getBevelType() {
            return this.m_eBevelType;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

