/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class WsExtensionFileFilter
extends FileFilter {
    protected String m_sDescription;
    protected String[] m_saExtensions;

    public WsExtensionFileFilter(String sExtension, String sDescription) {
        this.m_saExtensions = new String[1];
        this.m_saExtensions[0] = sExtension;
        this.m_sDescription = sDescription;
    }

    public WsExtensionFileFilter(String[] saExtensions, String sDescription) {
        this.m_saExtensions = saExtensions;
        this.m_sDescription = sDescription;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String sExt = this.getExtension(file);
        if (sExt == null) {
            return false;
        }
        int nExtensions = this.m_saExtensions.length;
        for (int iExtension = 0; iExtension < nExtensions; ++iExtension) {
            if (!sExt.equalsIgnoreCase(this.m_saExtensions[iExtension])) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.m_sDescription;
    }

    protected String getExtension(File file) {
        String sName = file.getName();
        int iExt = sName.lastIndexOf(46);
        if (iExt > 1) {
            return sName.substring(iExt + 1);
        }
        return null;
    }
}

