/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WATextField;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsForwardInputMap;
import com.sas.workspace.WsLimitedPlainDocument;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Document;

public class WsDropMenuTableCellEditor
extends WsDefaultCellEditor {
    protected JTable m_tbl;
    protected int m_iRow;
    protected int m_iColumn;
    protected JPanel m_pnl;
    protected JButton m_btn = WsUIUtilities.createDropMenuButton();
    protected WATextField m_txt;
    protected JPopupMenu m_mnu;
    protected boolean m_bStopEditingOnMenuClose;
    private boolean m_bMultiLineEdit;
    private boolean m_bTextEditable = true;

    public WsDropMenuTableCellEditor() {
        this.m_btn.addActionListener(new cShowDropMenuAction());
        cBackTabAction actBackTab = new cBackTabAction();
        this.m_btn.getActionMap().put(actBackTab, actBackTab);
        this.m_btn.getInputMap().put(KeyStroke.getKeyStroke(9, 1), actBackTab);
        this.m_txt = new WATextField();
        this.initialize(this.m_txt, (WsDefaultCellEditor.cEditorDelegate)new cDelegate((JTextField)this.m_txt));
        cTabAction actTab = new cTabAction();
        this.m_txt.getActionMap().put(actTab, actTab);
        this.m_txt.getInputMap().put(KeyStroke.getKeyStroke(9, 0), actTab);
        cShowDropMenuAction actDown = new cShowDropMenuAction();
        this.m_txt.getActionMap().put(actDown, actDown);
        this.m_txt.getInputMap().put(KeyStroke.getKeyStroke(40, 0), actDown);
        this.m_pnl = new JPanel(new BorderLayout()){

            @Override
            public void requestFocus() {
                if (WsDropMenuTableCellEditor.this.m_bTextEditable) {
                    WsDropMenuTableCellEditor.this.m_txt.requestFocus();
                } else {
                    WsDropMenuTableCellEditor.this.m_btn.requestFocus();
                }
            }
        };
        this.m_pnl.add((Component)this.m_txt, "Center");
        this.m_pnl.add((Component)this.m_btn, "East");
        WsForwardInputMap.install(this.m_pnl, this.m_txt);
        this.m_cmpEditor = this.m_pnl;
    }

    @Override
    public JComponent getComponent() {
        return this.m_txt;
    }

    public void setDropMenu(JPopupMenu mnu) {
        this.m_mnu = mnu;
    }

    public JPopupMenu getDropMenu() {
        return this.m_mnu;
    }

    public void setMaxCharacters(int nMaxCharacters) {
        this.m_txt.setMaxCharacters(nMaxCharacters);
    }

    public int getMaxCharacters() {
        return this.m_txt.getMaxCharacters();
    }

    public void setStopEditingOnMenuClose(boolean bStopEditingOnMenuClose) {
        this.m_bStopEditingOnMenuClose = bStopEditingOnMenuClose;
    }

    public boolean isStopEditingOnMenuClose() {
        return this.m_bStopEditingOnMenuClose;
    }

    public void setMultiLineEdit(boolean bMultiLineEdit) {
        this.m_bMultiLineEdit = bMultiLineEdit;
        Document doc = this.m_txt.getDocument();
        doc.putProperty("filterNewlines", new Boolean(!bMultiLineEdit));
        if (doc instanceof WsLimitedPlainDocument) {
            ((WsLimitedPlainDocument)doc).setSingleLine(!bMultiLineEdit);
        }
    }

    public boolean isMultiLineEdit() {
        return this.m_bMultiLineEdit;
    }

    public void setTextEditable(boolean bEditable) {
        this.m_bTextEditable = bEditable;
        this.m_txt.setEditable(bEditable);
    }

    public boolean isTextEditable() {
        return this.m_bTextEditable;
    }

    protected class cShowDropMenuAction
    extends AbstractAction {
        protected cShowDropMenuAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WsDropMenuTableCellEditor.this.m_mnu != null) {
                Point btnLocation = WsDropMenuTableCellEditor.this.m_btn.getLocation();
                Dimension btnSize = WsDropMenuTableCellEditor.this.m_btn.getSize();
                btnLocation.y += btnSize.height;
                WsDropMenuTableCellEditor.this.m_mnu.show(WsDropMenuTableCellEditor.this.m_btn.getParent(), btnLocation.x, btnLocation.y);
            }
        }
    }

    protected class cTabAction
    extends AbstractAction {
        protected cTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsDropMenuTableCellEditor.this.m_btn.requestFocus();
        }
    }

    protected class cBackTabAction
    extends AbstractAction {
        protected cBackTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsDropMenuTableCellEditor.this.m_txt.requestFocus();
        }
    }

    protected class cDelegate
    extends WsDefaultCellEditor.cTextFieldDelegate {
        public cDelegate(JTextField txtEditor) {
            super(txtEditor);
        }

        @Override
        public void layout(JTable table, int iRow, int iColumn) {
            WsDropMenuTableCellEditor.this.m_tbl = table;
            WsDropMenuTableCellEditor.this.m_iRow = iRow;
            WsDropMenuTableCellEditor.this.m_iColumn = iColumn;
        }
    }
}

