/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WsObjectListModel;
import com.sas.workspace.WsObjectListModelEvent;
import com.sas.workspace.WsObjectListModelListener;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;

public class WsDefaultObjectListModel
implements WsObjectListModel {
    protected EventListenerList m_listListeners = new EventListenerList();
    protected ArrayList m_alObjects = new ArrayList();

    @Override
    public boolean contains(Object obj) {
        return this.m_alObjects.contains(obj);
    }

    @Override
    public void add(Object obj) {
        this.m_alObjects.add(obj);
        this.fireObjectAddedEvent(obj);
    }

    @Override
    public void remove(Object obj) {
        this.m_alObjects.remove(obj);
        this.fireObjectRemovedEvent(obj);
    }

    @Override
    public void remove(int iObj) {
        Object obj = this.m_alObjects.get(iObj);
        this.m_alObjects.remove(iObj);
        this.fireObjectRemovedEvent(obj);
    }

    @Override
    public void removeAll() {
        ArrayList alObjects = this.m_alObjects;
        this.m_alObjects = new ArrayList();
        int nObjects = alObjects.size();
        for (int iObject = 0; iObject < nObjects; ++iObject) {
            this.fireObjectRemovedEvent(alObjects.get(iObject));
        }
    }

    @Override
    public int size() {
        return this.m_alObjects.size();
    }

    @Override
    public Object get(int iObj) {
        return this.m_alObjects.get(iObj);
    }

    @Override
    public int indexOf(Object obj) {
        return this.m_alObjects.indexOf(obj);
    }

    @Override
    public void addObjectListModelListener(WsObjectListModelListener l) {
        this.m_listListeners.add(WsObjectListModelListener.class, l);
    }

    @Override
    public void removeObjectListModelListener(WsObjectListModelListener l) {
        this.m_listListeners.remove(WsObjectListModelListener.class, l);
    }

    protected void fireObjectAddedEvent(Object obj) {
        Object[] alListeners = this.m_listListeners.getListenerList();
        WsObjectListModelEvent e = null;
        for (int iListener = alListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (alListeners[iListener] != WsObjectListModelListener.class) continue;
            if (e == null) {
                e = new WsObjectListModelEvent(this, obj);
            }
            ((WsObjectListModelListener)alListeners[iListener + 1]).objectAdded(e);
        }
    }

    protected void fireObjectRemovedEvent(Object obj) {
        Object[] alListeners = this.m_listListeners.getListenerList();
        WsObjectListModelEvent e = null;
        for (int iListener = alListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (alListeners[iListener] != WsObjectListModelListener.class) continue;
            if (e == null) {
                e = new WsObjectListModelEvent(this, obj);
            }
            ((WsObjectListModelListener)alListeners[iListener + 1]).objectRemoved(e);
        }
    }
}

