/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class WsComponentPrinter
implements Pageable,
Printable {
    private JComponent m_cmp;
    protected PageFormat m_page;
    protected int m_nPages;
    protected int m_nPagesX;
    protected int m_nPagesY;

    public static WsComponentPrinter createPrinter(JComponent cmp, PageFormat page) {
        return WsComponentPrinter.createPrinter(cmp, page, true);
    }

    public static WsComponentPrinter createPrinter(JComponent cmp, PageFormat page, boolean bAsIs) {
        if (cmp instanceof JTree) {
            return new cTreePrinter((JTree)cmp, page, bAsIs);
        }
        return new WsComponentPrinter(cmp, page);
    }

    public WsComponentPrinter(JComponent cmp, PageFormat page) {
        this.m_cmp = cmp;
        this.m_page = page;
    }

    public void dispose() {
    }

    @Override
    public int getNumberOfPages() {
        if (this.m_nPages == 0) {
            this.calculateNumberOfPages();
        }
        return this.m_nPages;
    }

    @Override
    public PageFormat getPageFormat(int iPage) throws IndexOutOfBoundsException {
        this.validatePageIndex(iPage);
        return this.m_page;
    }

    @Override
    public Printable getPrintable(int iPage) throws IndexOutOfBoundsException {
        this.validatePageIndex(iPage);
        return this;
    }

    protected void validatePageIndex(int iPage) throws IndexOutOfBoundsException {
        if (iPage < 0 || iPage >= this.getNumberOfPages()) {
            throw new IndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print(Graphics g, PageFormat page, int iPage) throws PrinterException {
        if (page instanceof Printable) {
            ((Printable)((Object)page)).print(g, page, iPage);
        }
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            int xPage = (int)page.getImageableX();
            int yPage = (int)page.getImageableY();
            g2d.translate(xPage, yPage);
            this.initializeGCForPage(g2d, iPage);
            this.m_cmp.printAll(g2d);
        }
        finally {
            g2d.dispose();
        }
        return 0;
    }

    protected void calculateNumberOfPages() {
        Dimension dimPrint = this.getPrintableDimensions();
        int cxPrint = dimPrint.width;
        int cyPrint = dimPrint.height;
        int cxPage = this.getPageWidth();
        int cyPage = this.getPageHeight();
        this.m_nPagesX = (cxPrint + cxPage - 1) / cxPage;
        this.m_nPagesY = (cyPrint + cyPage - 1) / cyPage;
        this.m_nPages = this.m_nPagesX * this.m_nPagesY;
    }

    protected Dimension getPrintableDimensions() {
        Dimension dimPrint = this.m_cmp.getSize();
        if (dimPrint.width == 0 && dimPrint.height == 0) {
            dimPrint = this.m_cmp.getPreferredSize();
            this.m_cmp.setSize(dimPrint);
        }
        return dimPrint;
    }

    protected void initializeGCForPage(Graphics2D gc, int iPage) {
        int cxPage = this.getPageWidth();
        int cyPage = this.getPageHeight();
        int xOrigin = iPage % this.m_nPagesX * cxPage;
        int yOrigin = iPage / this.m_nPagesX * cyPage;
        gc.setClip(0, 0, cxPage, cyPage);
        gc.translate(-xOrigin, -yOrigin);
    }

    protected int getPageWidth() {
        return (int)this.m_page.getImageableWidth();
    }

    protected int getPageHeight() {
        return (int)this.m_page.getImageableHeight();
    }

    protected static class cTreePrinter
    extends WsComponentPrinter {
        private JTree m_tree;
        private boolean m_bReset;
        private Color m_clrBackground;
        private Color m_clrBackgroundSelection;
        private Color m_clrBackgroundNonSelection;
        private Color m_clrTextSelection;
        private Color m_clrTextNonSelection;
        private Color m_clrBorderSelection;

        public cTreePrinter(JTree tree, PageFormat page, boolean bAsIs) {
            super(tree, page);
            TreeCellRenderer rdr;
            this.m_tree = tree;
            if (!bAsIs && (rdr = tree.getCellRenderer()) instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer rdrDefault = (DefaultTreeCellRenderer)rdr;
                this.m_clrBackground = tree.getBackground();
                this.m_clrBackgroundSelection = rdrDefault.getBackgroundSelectionColor();
                this.m_clrBackgroundNonSelection = rdrDefault.getBackgroundNonSelectionColor();
                this.m_clrTextSelection = rdrDefault.getTextSelectionColor();
                this.m_clrTextNonSelection = rdrDefault.getTextNonSelectionColor();
                this.m_clrBorderSelection = rdrDefault.getBorderSelectionColor();
                this.m_bReset = true;
                tree.setBackground(Color.white);
                rdrDefault.setBackgroundSelectionColor(Color.white);
                rdrDefault.setBackgroundNonSelectionColor(Color.white);
                rdrDefault.setTextSelectionColor(Color.black);
                rdrDefault.setTextNonSelectionColor(Color.black);
                rdrDefault.setBorderSelectionColor(Color.white);
            }
        }

        @Override
        public void dispose() {
            if (this.m_bReset) {
                this.m_tree.setBackground(this.m_clrBackground);
                DefaultTreeCellRenderer rdr = (DefaultTreeCellRenderer)this.m_tree.getCellRenderer();
                rdr.setBackgroundSelectionColor(this.m_clrBackgroundSelection);
                rdr.setBackgroundNonSelectionColor(this.m_clrBackgroundNonSelection);
                rdr.setTextSelectionColor(this.m_clrTextSelection);
                rdr.setTextNonSelectionColor(this.m_clrTextNonSelection);
                rdr.setBorderSelectionColor(this.m_clrBorderSelection);
            }
        }
    }
}

