/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsFlatButton;
import com.sas.workspace.WsUIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class WsColorChooserTool
extends WsFlatButton {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WsColorChooserTool.class);
    protected static final Dimension DEFAULT_SIZE = new Dimension(16, 16);
    protected static final Insets DEFAULT_INSETS = new Insets(2, 2, 2, 2);
    public static final String SELECTED_COLOR = "selectedColor";
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color GRAY = new Color(128, 128, 128);
    public static final Color MAROON = new Color(128, 0, 0);
    public static final Color OLIVE = new Color(128, 128, 0);
    public static final Color GREEN = new Color(0, 128, 0);
    public static final Color TEAL = new Color(0, 128, 128);
    public static final Color NAVY = new Color(0, 0, 128);
    public static final Color PURPLE = new Color(128, 0, 128);
    public static final Color WHITE = new Color(255, 255, 255);
    public static final Color SILVER = new Color(192, 192, 192);
    public static final Color RED = new Color(255, 0, 0);
    public static final Color YELLOW = new Color(255, 255, 0);
    public static final Color LIME = new Color(0, 255, 0);
    public static final Color AQUA = new Color(0, 255, 255);
    public static final Color BLUE = new Color(0, 0, 255);
    public static final Color FUSCHIA = new Color(255, 0, 255);

    public WsColorChooserTool() {
        this.setIcon(new ColorSwatch(Color.white, DEFAULT_SIZE, DEFAULT_INSETS));
        this.setSelectedColor(Color.white);
        this.addMouseListener(this.createTriggerMouseListener());
    }

    public void setSelectedColor(Color clr) {
        Color clrOld = this.getSelectedColor();
        if (!clrOld.equals(clr)) {
            this.getColorSwatch().setColor(clr);
            this.repaint();
            this.firePropertyChange(SELECTED_COLOR, clrOld, clr);
        }
    }

    public Color getSelectedColor() {
        return this.getColorSwatch().getColor();
    }

    protected MouseListener createTriggerMouseListener() {
        return new TriggerMouseListener();
    }

    protected ColorSwatch getColorSwatch() {
        return (ColorSwatch)this.getIcon();
    }

    private static class ColorSwatch
    implements Icon {
        private static Insets NO_INSETS = new Insets(0, 0, 0, 0);
        private Color m_clr;
        private Dimension m_dim;
        private Insets m_insets;
        private boolean m_bDrawBorder;

        public ColorSwatch(Color clr, Dimension dim) {
            this(clr, dim, NO_INSETS);
        }

        public ColorSwatch(Color clr, Dimension dim, Insets insets) {
            this.m_clr = clr;
            this.m_dim = dim;
            this.m_insets = insets;
            this.m_bDrawBorder = true;
        }

        public void setColor(Color clr) {
            this.m_clr = clr;
        }

        public Color getColor() {
            return this.m_clr;
        }

        public void setInsets(Insets insets) {
            if (insets == null) {
                insets = NO_INSETS;
            }
            this.m_insets = insets;
        }

        public Insets getInsets() {
            return this.m_insets;
        }

        public void setDrawBorder(boolean bDraw) {
            this.m_bDrawBorder = bDraw;
        }

        public boolean isDrawBorder() {
            return this.m_bDrawBorder;
        }

        @Override
        public int getIconHeight() {
            return this.m_dim.height;
        }

        @Override
        public int getIconWidth() {
            return this.m_dim.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color clrOld = g.getColor();
            x += this.m_insets.left;
            y += this.m_insets.top;
            int cx = this.m_dim.width - this.m_insets.left - this.m_insets.right;
            int cy = this.m_dim.height - this.m_insets.top - this.m_insets.bottom;
            if (this.m_bDrawBorder) {
                g.setColor(Color.black);
                g.drawRect(x, y, cx - 1, cy - 1);
                ++x;
                ++y;
                cx -= 2;
                cy -= 2;
            }
            g.setColor(this.m_clr);
            g.fillRect(x, y, cx, cy);
            g.setColor(clrOld);
        }
    }

    protected class ColorsPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;
        private ActionListener m_lsnrAction = this.createColorActionListener();

        public ColorsPopupMenu() {
            JToolBar pnlColors = WsUIUtilities.createToolBar();
            pnlColors.setLayout(new GridLayout(2, 8));
            pnlColors.add(this.createColorButton(BLACK, bundle.getString("WsColorChooserTool.Color.Black.txt")));
            pnlColors.add(this.createColorButton(GRAY, bundle.getString("WsColorChooserTool.Color.Gray.txt")));
            pnlColors.add(this.createColorButton(MAROON, bundle.getString("WsColorChooserTool.Color.Maroon.txt")));
            pnlColors.add(this.createColorButton(OLIVE, bundle.getString("WsColorChooserTool.Color.Olive.txt")));
            pnlColors.add(this.createColorButton(GREEN, bundle.getString("WsColorChooserTool.Color.Green.txt")));
            pnlColors.add(this.createColorButton(TEAL, bundle.getString("WsColorChooserTool.Color.Teal.txt")));
            pnlColors.add(this.createColorButton(NAVY, bundle.getString("WsColorChooserTool.Color.Navy.txt")));
            pnlColors.add(this.createColorButton(PURPLE, bundle.getString("WsColorChooserTool.Color.Purple.txt")));
            pnlColors.add(this.createColorButton(WHITE, bundle.getString("WsColorChooserTool.Color.White.txt")));
            pnlColors.add(this.createColorButton(SILVER, bundle.getString("WsColorChooserTool.Color.Silver.txt")));
            pnlColors.add(this.createColorButton(RED, bundle.getString("WsColorChooserTool.Color.Red.txt")));
            pnlColors.add(this.createColorButton(YELLOW, bundle.getString("WsColorChooserTool.Color.Yellow.txt")));
            pnlColors.add(this.createColorButton(LIME, bundle.getString("WsColorChooserTool.Color.Lime.txt")));
            pnlColors.add(this.createColorButton(AQUA, bundle.getString("WsColorChooserTool.Color.Aqua.txt")));
            pnlColors.add(this.createColorButton(BLUE, bundle.getString("WsColorChooserTool.Color.Blue.txt")));
            pnlColors.add(this.createColorButton(FUSCHIA, bundle.getString("WsColorChooserTool.Color.Fuschia.txt")));
            JToolBar barMore = WsUIUtilities.createToolBar();
            barMore.add(this.createMoreColorsButton());
            this.add(pnlColors);
            this.addSeparator();
            this.add(barMore);
        }

        protected JButton createColorButton(Color clr, String sTip) {
            JButton btn = WsUIUtilities.isXPThemeActive() ? new JButton(new ColorSwatch(clr, DEFAULT_SIZE, DEFAULT_INSETS)) : new WsFlatButton(new ColorSwatch(clr, DEFAULT_SIZE, DEFAULT_INSETS));
            btn.setToolTipText(sTip);
            btn.addActionListener(this.m_lsnrAction);
            return btn;
        }

        protected JButton createMoreColorsButton() {
            JButton btn = WsUIUtilities.isXPThemeActive() ? new JButton(this.createMoreColorsAction()) : new WsFlatButton(this.createMoreColorsAction());
            btn.setHorizontalAlignment(10);
            btn.setAlignmentX(0.5f);
            btn.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            return btn;
        }

        protected ActionListener createColorActionListener() {
            return new ColorActionListener();
        }

        protected Action createMoreColorsAction() {
            return new MoreColorsAction();
        }

        protected class MoreColorsAction
        extends WsAbstractAction {
            private static final long serialVersionUID = 1L;

            public MoreColorsAction() {
                super(bundle, "WsColorChooserTool.Action.MoreColors", 256);
                this.setIcon(new ColorSwatch(WsColorChooserTool.this.getSelectedColor(), DEFAULT_SIZE, DEFAULT_INSETS));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorsPopupMenu.this.setVisible(false);
                String sTitle = WsColorChooserTool.this.getToolTipText();
                Color clr = JColorChooser.showDialog(WsColorChooserTool.this, sTitle, WsColorChooserTool.this.getSelectedColor());
                if (clr != null) {
                    WsColorChooserTool.this.setSelectedColor(clr);
                }
            }
        }

        protected class ColorActionListener
        implements ActionListener {
            protected ColorActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton btn = (JButton)e.getSource();
                ColorSwatch icon = (ColorSwatch)btn.getIcon();
                WsColorChooserTool.this.setSelectedColor(icon.getColor());
                ColorsPopupMenu.this.setVisible(false);
            }
        }
    }

    protected class TriggerMouseListener
    extends MouseAdapter {
        protected TriggerMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            new ColorsPopupMenu().show(WsColorChooserTool.this, 0, WsColorChooserTool.this.getHeight());
        }
    }
}

