/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import java.util.HashMap;
import java.util.Map;

public abstract class WsAbstractVersionedObjectManager {
    private static UsageVersion DEFAULT_MIN_USAGE_VERSION = new UsageVersion(0, 0);
    protected Map m_MinimumVersionMapping = new HashMap();
    protected Map m_CurrentVersionMapping = new HashMap();
    private static WsAbstractVersionedObjectManager m_instance = null;

    public static WsAbstractVersionedObjectManager getInstance() {
        if (m_instance == null) {
            m_instance = new DefaultVersionedObjectManager();
        }
        return m_instance;
    }

    public void registerVersion(String publicType, UsageVersion defaultMinimum, UsageVersion defaultCurrent) {
        if (publicType != null && publicType.length() > 0 && !this.isRegistered(publicType)) {
            if (defaultMinimum != null) {
                this.m_MinimumVersionMapping.put(publicType, defaultMinimum);
            }
            if (defaultCurrent != null) {
                this.m_CurrentVersionMapping.put(publicType, defaultCurrent);
            }
            Workspace.getDefaultLogger().debug("Registered " + publicType + " with versions min " + defaultMinimum.toString() + " and current " + defaultCurrent.toString());
        }
    }

    public static void setInstance(WsAbstractVersionedObjectManager instance) {
        if (instance != null) {
            m_instance = instance;
        }
    }

    public UsageVersion getMinimumSupportedVersion(String publicType) {
        UsageVersion returnValue = DEFAULT_MIN_USAGE_VERSION;
        if (publicType != null) {
            returnValue = (UsageVersion)this.m_MinimumVersionMapping.get(publicType);
        }
        return returnValue;
    }

    public boolean isVersionSupported(String publicType, UsageVersion instanceVersion) {
        boolean returnValue = true;
        UsageVersion min = this.getMinimumSupportedVersion(publicType);
        if (min != null && instanceVersion != null && instanceVersion.compareMajorMinor(min) < 0) {
            returnValue = false;
        }
        return returnValue;
    }

    public UsageVersion getCurrentVersion(String publicType) {
        UsageVersion returnValue = null;
        if (publicType != null) {
            returnValue = (UsageVersion)this.m_CurrentVersionMapping.get(publicType);
        }
        return returnValue;
    }

    public boolean isRegistered(String publicType) {
        boolean returnValue = false;
        if (this.m_CurrentVersionMapping.containsKey(publicType)) {
            returnValue = true;
        }
        if (!returnValue && this.m_MinimumVersionMapping.containsKey(publicType)) {
            returnValue = true;
        }
        return returnValue;
    }

    public static boolean isSupportedForVersioning(SimpleObject sObject) {
        boolean returnValue = true;
        String publicType = sObject.getPublicType();
        if (publicType != null && publicType.length() > 0) {
            WsAbstractVersionedObjectManager vMgr = WsAbstractVersionedObjectManager.getInstance();
            if (vMgr != null) {
                UsageVersion uv = vMgr.getMinimumSupportedVersion(publicType);
                if (uv == null) {
                    returnValue = false;
                }
            } else {
                returnValue = false;
            }
        }
        return returnValue;
    }

    public static boolean isUpgradeable(String publicType, UsageVersion version) {
        boolean returnValue = false;
        UsageVersion minSupported = WsAbstractVersionedObjectManager.getInstance().getMinimumSupportedVersion(publicType);
        if (version.compareMajorMinor(minSupported) < 0) {
            returnValue = true;
        }
        return returnValue;
    }

    private static class DefaultVersionedObjectManager
    extends WsAbstractVersionedObjectManager {
    }
}

