/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class WsAbstractTablePropertyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(WsAbstractTablePropertyTab.class);
    protected Root m_oData;
    protected WsAbstractTableModel m_mdl;
    protected WsTable m_tbl;
    protected JScrollPane m_scr;
    protected JButton m_btnNew;
    protected JButton m_btnDelete;
    protected JButton m_btnMoveUp;
    protected JButton m_btnMoveDown;
    protected JPanel m_pnlButtons;
    protected WsAbstractAction m_actNew;
    protected WsAbstractAction m_actDelete;
    protected WsAbstractAction m_actMoveUp;
    protected WsAbstractAction m_actMoveDown;
    protected boolean m_bOrderChanged;
    protected boolean m_bReorderingComponentsVisible;
    protected boolean m_bWillPromptToSaveNewOrder;

    public WsAbstractTablePropertyTab() {
        this((Root)null);
    }

    public WsAbstractTablePropertyTab(Root oData) {
        this(oData, false);
    }

    public WsAbstractTablePropertyTab(Root oData, boolean bReorderingComponentsVisible) {
        this.m_oData = oData;
        this.m_bReorderingComponentsVisible = bReorderingComponentsVisible;
        this.setWillPromptToSaveNewOrder(bReorderingComponentsVisible);
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("shared");
        this.setHelpTopic("columns_tab");
    }

    @Override
    protected void initialize() {
        this.createActions();
        this.m_mdl = this.createTableModel(this.m_oData);
        this.m_mdl.addTableModelListener(this.createTableModelListener());
        this.createTable();
        this.createButtonsPanel();
    }

    protected abstract WsAbstractTableModel createTableModel(Root var1);

    protected void createTable() {
        this.m_tbl = new WsTable(this.m_mdl);
        this.m_scr = new JScrollPane((Component)((Object)this.m_tbl));
        this.m_scr.setPreferredSize(new Dimension(400, 300));
        this.m_tbl.setToolTipText("");
        this.m_tbl.setUndoManager(this.waum);
        this.m_tbl.setRowHeaderPopupMenuRequestListener(this.createRowHeaderPopupMenuRequestListener());
        this.m_tbl.setTablePopupMenuRequestListener(this.createTablePopupMenuRequestListener());
        this.m_tbl.setViewportPopupMenuRequestListener(this.createViewportPopupMenuRequestListener());
        this.m_tbl.getSelectionModel().addListSelectionListener(this.createTableSelectionListener());
        ((WsDefaultTableRowModel)this.m_tbl.getRowModel()).addRowModelListener(this.createTableRowModelListener());
        this.m_tbl.getActionMap().put(this.m_actDelete, this.m_actDelete);
        this.m_tbl.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
    }

    protected void createButtonsPanel() {
        this.m_btnNew = WsUIUtilities.createTextButton(this.m_actNew);
        this.m_btnDelete = WsUIUtilities.createTextButton(this.m_actDelete);
        this.m_btnMoveUp = WsUIUtilities.createToolButton(this.m_actMoveUp);
        this.m_btnMoveDown = WsUIUtilities.createToolButton(this.m_actMoveDown);
        JPanel pnlLeft = new JPanel(new WsButtonsLayout());
        JPanel pnlRight = new JPanel(new WsButtonsLayout());
        pnlLeft.add(this.m_btnMoveUp);
        pnlLeft.add(this.m_btnMoveDown);
        pnlRight.add(this.m_btnNew);
        pnlRight.add(this.m_btnDelete);
        this.m_pnlButtons = new JPanel(new BorderLayout(10, 0));
        if (this.m_bReorderingComponentsVisible) {
            this.m_pnlButtons.add((Component)pnlLeft, "West");
        }
        this.m_pnlButtons.add((Component)pnlRight, "East");
    }

    @Override
    protected void layoutWidgets() {
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this.m_scr, "Center");
        this.add((Component)this.m_pnlButtons, "South");
    }

    public void setMetadata(Root oData) {
        this.m_oData = oData;
    }

    public Root getMetadata() {
        return this.m_oData;
    }

    public void setWillPromptToSaveNewOrder(boolean bWillPrompt) {
        this.m_bWillPromptToSaveNewOrder = bWillPrompt;
    }

    public boolean willPromptToSaveNewOrder() {
        return this.m_bWillPromptToSaveNewOrder;
    }

    public void setTableToolTip(String sToolTip) {
        this.m_tbl.setToolTipText(sToolTip);
    }

    public void setNewToolTip(String sToolTip) {
        this.m_actNew.putValue("ShortDescription", sToolTip);
    }

    public void setDeleteToolTip(String sToolTip) {
        this.m_actDelete.putValue("ShortDescription", sToolTip);
    }

    public void setMoveUpToolTip(String sToolTip) {
        this.m_actMoveUp.putValue("ShortDescription", sToolTip);
    }

    public void setMoveDownToolTip(String sToolTip) {
        this.m_actMoveDown.putValue("ShortDescription", sToolTip);
    }

    @Override
    public boolean validateData() {
        if (!this.m_tbl.stopCellEditing()) {
            return false;
        }
        if (!this.m_bWillPromptToSaveNewOrder) {
            return true;
        }
        if (this.m_bOrderChanged && !this.m_tbl.isOriginalOrder()) {
            int eAnswer = MessageUtil.displayMessage(bundle.getString("WsAbstractTablePropertyTab.SaveOrderMessage.txt"), bundle.getString("WsAbstractTablePropertyTab.SaveOrderTitle.txt"), 2, 1);
            switch (eAnswer) {
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case -1: {
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)this.m_tbl.getRowModel();
        this.m_mdl.setRowMappings(mdlRows.getRowMappings());
        return true;
    }

    @Override
    public void setStorePopulated(boolean bStorePopulated) {
        super.setStorePopulated(bStorePopulated);
        if (!bStorePopulated) {
            this.m_mdl.setStorePopulated(bStorePopulated);
        }
    }

    @Override
    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.m_mdl.populateStore();
        this.setStorePopulated(true);
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_mdl.moveDataToModel();
        if (this.m_mdl.getRowCount() > 0) {
            this.m_tbl.selectCell(0, 0);
        }
        this.setListeningForChanges(true);
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        this.m_mdl.moveDataToStore();
        this.m_mdl.setRowMappings(null);
        this.setDataChanged(false);
        this.m_bOrderChanged = false;
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (bSaveToModel) {
            this.populateStore();
            this.moveDataToView();
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actNew.setActive(bActive);
        this.m_actDelete.setActive(bActive);
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tbl.setEditable(bEditable);
        this.m_tbl.setRowsReorderable(bEditable);
        this.m_tbl.setSortingEnabled(bEditable);
        this.updateActions();
    }

    @Override
    public void saveSettingsAndCleanUp() {
    }

    @Override
    public void setWAUndoManager(WAUndoManager mgrUndo) {
        super.setWAUndoManager(mgrUndo);
        this.m_tbl.setUndoManager(mgrUndo);
    }

    protected void doNew() {
        this.m_tbl.undoableInsertNewRowAfterLastSelectedRow();
    }

    protected void doDelete() {
        this.m_tbl.undoableDeleteSelectedRows();
    }

    protected ListSelectionListener createTableSelectionListener() {
        return new cTableSelectionListener();
    }

    protected WsTableRowModelListener createTableRowModelListener() {
        return new cTableRowModelListener();
    }

    protected TableModelListener createTableModelListener() {
        return new cTableModelListener();
    }

    protected WsPopupMenuRequestListener createRowHeaderPopupMenuRequestListener() {
        return new cRowHeaderPopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createTablePopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createViewportPopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    protected void createActions() {
        this.m_actNew = this.createNewAction();
        this.m_actDelete = this.createDeleteAction();
        this.m_actMoveUp = this.createMoveUpAction();
        this.m_actMoveDown = this.createMoveDownAction();
    }

    protected void updateActions() {
        boolean bSelected;
        int[] aSelectedRows = this.m_tbl.getSelectedRowsFromSelectedCells();
        boolean bEditable = this.isEditable();
        boolean bNotFirst = bSelected = aSelectedRows.length > 0;
        boolean bNotLast = bSelected;
        int iLastRow = this.m_tbl.getRowCount() - 1;
        int nSelectedRows = aSelectedRows.length;
        for (int iSelectedRow = 0; iSelectedRow < nSelectedRows; ++iSelectedRow) {
            if (aSelectedRows[iSelectedRow] == 0) {
                bNotFirst = false;
            }
            if (aSelectedRows[iSelectedRow] != iLastRow) continue;
            bNotLast = false;
        }
        this.m_actNew.setEnabled(bEditable);
        this.m_actDelete.setEnabled(bEditable && bSelected);
        this.m_actMoveUp.setEnabled(bEditable && bNotFirst);
        this.m_actMoveDown.setEnabled(bEditable && bNotLast);
    }

    protected WsAbstractAction createNewAction() {
        return new cNewAction();
    }

    protected WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    protected WsAbstractAction createMoveUpAction() {
        return new cMoveUpAction();
    }

    protected WsAbstractAction createMoveDownAction() {
        return new cMoveDownAction();
    }

    protected class cMoveDownAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cMoveDownAction() {
            super(bundle, "WsAbstractTablePropertyTab.MoveDown", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsAbstractTablePropertyTab.this.m_tbl.undoableMoveSelectedRows(1);
            WsAbstractTablePropertyTab.this.setDataChanged(true);
            WsAbstractTablePropertyTab.this.m_bOrderChanged = true;
        }
    }

    protected class cMoveUpAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cMoveUpAction() {
            super(bundle, "WsAbstractTablePropertyTab.MoveUp", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsAbstractTablePropertyTab.this.m_tbl.undoableMoveSelectedRows(-1);
            WsAbstractTablePropertyTab.this.setDataChanged(true);
            WsAbstractTablePropertyTab.this.m_bOrderChanged = true;
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cDeleteAction() {
            super(bundle, "WsAbstractTablePropertyTab.Delete", true);
            this.setMenuSupportId("delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsAbstractTablePropertyTab.this.doDelete();
        }
    }

    protected class cNewAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cNewAction() {
            super(bundle, "WsAbstractTablePropertyTab.New", true);
            this.setMenuSupportId("new");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsAbstractTablePropertyTab.this.doNew();
        }
    }

    public class cTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        @Override
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem(WsAbstractTablePropertyTab.this.m_actNew));
            mnuPopup.add(new JMenuItem(WsAbstractTablePropertyTab.this.m_actDelete));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    public class cRowHeaderPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        @Override
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = WsAbstractTablePropertyTab.this.m_tbl.createRowHeaderPopupMenu();
            WsUIUtilities.addSpaceIconToPopupMenu(mnuPopup);
            if (mnuPopup.getComponentCount() != 0) {
                mnuPopup.addSeparator();
            }
            mnuPopup.add(new JMenuItem(WsAbstractTablePropertyTab.this.m_actNew));
            mnuPopup.add(new JMenuItem(WsAbstractTablePropertyTab.this.m_actDelete));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cTableModelListener
    implements TableModelListener {
        protected cTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (WsAbstractTablePropertyTab.this.isListeningForChanges()) {
                WsAbstractTablePropertyTab.this.setDataChanged(true);
            }
        }
    }

    protected class cTableRowModelListener
    implements WsTableRowModelListener {
        protected cTableRowModelListener() {
        }

        @Override
        public void rowDragged(TableRowModelEvent e) {
            WsAbstractTablePropertyTab.this.setDataChanged(true);
            WsAbstractTablePropertyTab.this.m_bOrderChanged = true;
        }

        @Override
        public void rowsHidden(WsTableRowModelEvent e) {
        }

        @Override
        public void rowsShown(WsTableRowModelEvent e) {
        }

        @Override
        public void rowsRemapped(ChangeEvent e) {
            WsAbstractTablePropertyTab.this.setDataChanged(true);
            WsAbstractTablePropertyTab.this.m_bOrderChanged = true;
        }
    }

    protected class cTableSelectionListener
    implements ListSelectionListener {
        protected cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            WsAbstractTablePropertyTab.this.updateActions();
        }
    }
}

