/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.MdException;
import com.sas.table.TableDataValidationInterface;
import com.sas.workspace.WsAbstractTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public abstract class WsAbstractTableModel
extends AbstractTableModel
implements TableDataValidationInterface {
    protected List m_lData = new ArrayList();
    protected int m_nRowInstances;
    protected int[] m_aRowMappings;
    protected boolean m_bStorePopulated;
    protected WsAbstractTableColumn[] m_aColumns;
    protected WsAbstractTableColumn[] m_aHiddenColumns;

    @Override
    public int getRowCount() {
        return this.m_lData.size();
    }

    @Override
    public int getColumnCount() {
        return this.m_aColumns.length;
    }

    @Override
    public String getColumnName(int iCol) {
        return this.m_aColumns[iCol].getName();
    }

    public Class getColumnClass(int iCol) {
        return this.m_aColumns[iCol].getColumnClass();
    }

    @Override
    public boolean isCellEditable(int iRow, int iCol) {
        return this.m_aColumns[iCol].isEditable();
    }

    @Override
    public Object getValueAt(int iRow, int iCol) {
        List lRow = (List)this.m_lData.get(iRow);
        return lRow.get(iCol);
    }

    @Override
    public void setValueAt(Object value, int iRow, int iCol) {
        List lRow = (List)this.m_lData.get(iRow);
        lRow.set(iCol, value);
        this.fireTableCellUpdated(iRow, iCol);
    }

    public String getToolTipAt(int iRow, int iCol) {
        return null;
    }

    public WsAbstractTableColumn getColumn(int iColumn) {
        return this.m_aColumns[iColumn];
    }

    public int getHiddenColumnCount() {
        return 0;
    }

    public int getDefaultEditColumnIndex() {
        return 0;
    }

    public void setStorePopulated(boolean bStorePopulated) {
        this.m_bStorePopulated = bStorePopulated;
    }

    public boolean isStorePopulated() {
        return this.m_bStorePopulated;
    }

    public void setRowInstanceCount(int nRowInstances) {
        this.m_nRowInstances = nRowInstances;
    }

    public int getRowInstanceCount() {
        return this.m_nRowInstances;
    }

    public void setRowMappings(int[] aRowMappings) {
        this.m_aRowMappings = aRowMappings;
    }

    public int[] getRowMappings() {
        return this.m_aRowMappings;
    }

    public abstract void populateStore() throws MdException, RemoteException;

    public abstract void moveDataToModel() throws MdException, RemoteException;

    public abstract void moveDataToStore() throws MdException, RemoteException;

    public void clear() {
        int nRows = this.m_lData.size();
        if (nRows > 0) {
            this.m_lData.clear();
            this.fireTableRowsDeleted(0, nRows - 1);
        }
    }

    public void insertRow(int iRow, List lRowValues) {
        if (!(lRowValues instanceof Cloneable)) {
            throw new IllegalArgumentException("List of values must be Cloneable");
        }
        this.m_lData.add(iRow + 1, lRowValues);
        this.fireTableRowsInserted(iRow + 1, iRow + 1);
    }

    public void deleteRow(int iRow) {
        List lDeletedRowValues = (List)this.m_lData.remove(iRow);
        this.fireTableRowDeleted(iRow, lDeletedRowValues);
    }

    public List getRowValues(int iRow) {
        ArrayList alValues = (ArrayList)this.m_lData.get(iRow);
        return (List)alValues.clone();
    }

    public void setRowValues(int iRow, List lRowValues) {
        List lData = (List)this.m_lData.get(iRow);
        lData.clear();
        lData.addAll(lRowValues);
        this.fireTableRowsUpdated(iRow, iRow);
    }

    public List createDefaultRowValues() {
        ++this.m_nRowInstances;
        int nColumns = this.getColumnCount() + this.getHiddenColumnCount();
        ArrayList<Object> lRow = new ArrayList<Object>(nColumns);
        for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
            lRow.add(this.m_aColumns[iColumn].createDefaultValue());
        }
        return lRow;
    }

    public boolean validateValueAt(Object oValue, int iRow, int iCol) {
        return this.m_aColumns[iCol].validateValue(oValue, this, iRow);
    }

    public boolean validate(Object value, int row, int col) {
        return this.validateValueAt(value, row, col);
    }

    public void fireTableModelPopulated() {
        int nRows = this.m_lData.size();
        if (nRows > 0) {
            this.fireTableRowsInserted(0, nRows - 1);
        }
    }

    public void fireTableRowDeleted(int iRow, List lData) {
        this.fireTableChanged(this.createDeletedRowTableModelEvent(this, iRow, lData));
    }

    public int[] findRows(int iColumn, Object testee) {
        return this.findRows(new cFilter(iColumn, testee));
    }

    public int[] findRows(Object filter) {
        int nRows = this.getRowCount();
        int[] aRowsFound = new int[nRows];
        int nRowsFound = 0;
        for (int iRow = 0; iRow < nRows; ++iRow) {
            if (!filter.equals(this.getRowValues(iRow))) continue;
            aRowsFound[nRowsFound] = iRow;
            ++nRowsFound;
        }
        int[] aRowsReturned = new int[nRowsFound];
        for (int iRowFound = 0; iRowFound < nRowsFound; ++iRowFound) {
            aRowsReturned[iRowFound] = aRowsFound[iRowFound];
        }
        return aRowsReturned;
    }

    protected TableModelEvent createDeletedRowTableModelEvent(TableModel mdl, int iRow, List lRowData) {
        return new cDeletedRowTableModelEvent(mdl, iRow, lRowData);
    }

    protected class cFilter {
        protected int m_iColumn;
        protected Object m_oValue;

        public cFilter(int iColumn, Object oValue) {
            this.m_iColumn = iColumn;
            this.m_oValue = oValue;
        }

        public boolean equals(Object oValue) {
            List lValues = (List)oValue;
            return this.m_oValue.equals(lValues.get(this.m_iColumn));
        }

        public int hashcode() {
            return super.hashCode();
        }
    }

    public class cDeletedRowTableModelEvent
    extends TableModelEvent {
        private static final long serialVersionUID = 1L;
        List m_lRowData;

        public cDeletedRowTableModelEvent(TableModel mdl, int iRow, List lRow) {
            super(mdl, iRow, iRow, -1, -1);
            this.m_lRowData = lRow;
        }

        public List getRowData() {
            return this.m_lRowData;
        }
    }
}

