/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsComparatorFactory;
import java.util.Comparator;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class WsAbstractTableColumn {
    public static final int DEFAULT_WIDTH = 75;
    protected int m_iModelIndex;
    protected int m_cxWidth;
    protected String m_sName;
    protected Class m_clsValue;
    protected boolean m_bEditable = true;
    protected TableCellEditor m_edtCell;
    protected TableCellRenderer m_rdrCell;
    private Comparator m_comparator;

    public WsAbstractTableColumn() {
        this(0);
    }

    public WsAbstractTableColumn(int iModelIndex) {
        this(iModelIndex, 75);
    }

    public WsAbstractTableColumn(int iModelIndex, int cxWidth) {
        this(iModelIndex, "", cxWidth);
    }

    public WsAbstractTableColumn(int iModelIndex, String sName, int cxWidth) {
        this.m_iModelIndex = iModelIndex;
        this.m_cxWidth = cxWidth;
        this.m_sName = sName;
    }

    public abstract Object createDefaultValue();

    protected abstract TableCellEditor createCellEditor();

    protected abstract TableCellRenderer createCellRenderer();

    public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
        return true;
    }

    public void setModelIndex(int iModelIndex) {
        this.m_iModelIndex = iModelIndex;
    }

    public int getModelIndex() {
        return this.m_iModelIndex;
    }

    public void setWidth(int cxWidth) {
        this.m_cxWidth = cxWidth;
    }

    public int getWidth() {
        return this.m_cxWidth;
    }

    public void setName(String sName) {
        this.m_sName = sName;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setColumnClass(Class clsValue) {
        this.m_clsValue = clsValue;
    }

    public Class getColumnClass() {
        return this.m_clsValue;
    }

    public void setEditable(boolean bEditable) {
        this.m_bEditable = bEditable;
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    public void setComparator(Comparator comparator) {
        this.m_comparator = comparator;
    }

    public Comparator getComparator() {
        if (this.m_comparator == null) {
            this.m_comparator = WsComparatorFactory.createComparator(this.getColumnClass());
        }
        return this.m_comparator;
    }

    public void setCellEditor(TableCellEditor edtCell) {
        this.m_edtCell = edtCell;
    }

    public TableCellEditor getCellEditor() {
        if (this.m_edtCell == null) {
            this.m_edtCell = this.createCellEditor();
        }
        return this.m_edtCell;
    }

    public void setCellRenderer(TableCellRenderer rdrCell) {
        this.m_rdrCell = rdrCell;
    }

    public TableCellRenderer getCellRenderer() {
        if (this.m_rdrCell == null) {
            this.m_rdrCell = this.createCellRenderer();
        }
        return this.m_rdrCell;
    }

    public TableColumn getTableColumn() {
        TableColumn col = new TableColumn(this.m_iModelIndex, this.m_cxWidth);
        col.setHeaderValue(this.getName());
        col.setCellEditor(this.getCellEditor());
        col.setCellRenderer(this.getCellRenderer());
        return col;
    }
}

