/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAComboBox;
import com.sas.workspace.WATextField;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsEnumeratedTableColumn;
import java.awt.Color;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;

public abstract class WsAbstractPopulateOnDemandTableColumn
extends WsEnumeratedTableColumn {
    private boolean m_bEditorEditable;
    private int m_nMaximum = Integer.MAX_VALUE;

    protected abstract void populate(JTable var1, int var2, int var3);

    public WsAbstractPopulateOnDemandTableColumn() {
    }

    public WsAbstractPopulateOnDemandTableColumn(int iModelIndex) {
        super(iModelIndex);
    }

    public WsAbstractPopulateOnDemandTableColumn(int iModelIndex, int cxWidth) {
        super(iModelIndex, cxWidth);
    }

    public WsAbstractPopulateOnDemandTableColumn(int iModelIndex, String sName, int cxWidth) {
        super(iModelIndex, sName, cxWidth);
    }

    public WsAbstractPopulateOnDemandTableColumn(int iModelIndex, String sName, int cxWidth, String sDefault) {
        super(iModelIndex, sName, cxWidth, sDefault);
    }

    public WsAbstractPopulateOnDemandTableColumn(int iModelIndex, String sName, int cxWidth, String[] saValues) {
        super(iModelIndex, sName, cxWidth, saValues);
    }

    public WsAbstractPopulateOnDemandTableColumn(int iModelIndex, String sName, int cxWidth, String[] saValues, String sDefault) {
        super(iModelIndex, sName, cxWidth, sDefault);
        this.setEditorEditable(false);
        this.setMaximumCharacters(Integer.MAX_VALUE);
    }

    public void setEditorEditable(boolean bEditable) {
        this.m_bEditorEditable = bEditable;
    }

    public boolean isEditorEditable() {
        return this.m_bEditorEditable;
    }

    public void setMaximumCharacters(int nMaximum) {
        this.m_nMaximum = nMaximum;
    }

    public int getMaximumCharacters() {
        return this.m_nMaximum;
    }

    @Override
    public TableCellEditor createCellEditor() {
        WAComboBox cmb = new WAComboBox(this.m_saValues, this.m_bSorted);
        cmb.setEditable(this.isEditorEditable());
        cmb.setBorder(new LineBorder(Color.black));
        if (this.m_nMaximum != Integer.MAX_VALUE) {
            ((WATextField)cmb.getEditor().getEditorComponent()).setMaxCharacters(this.m_nMaximum);
        }
        PopulateOnDemandEditor editor = new PopulateOnDemandEditor(cmb);
        return editor;
    }

    @Override
    public void setPossibleValues(String[] saValues) {
        this.m_saValues = saValues;
        if (this.m_sDefault == null) {
            this.m_sDefault = saValues[0];
        }
        if (this.m_edtCell != null) {
            PopulateOnDemandEditor editor = (PopulateOnDemandEditor)this.m_edtCell;
            JComboBox comboBox = (JComboBox)editor.getComponent();
            comboBox.removeAllItems();
            for (int valueIndex = 0; valueIndex < saValues.length; ++valueIndex) {
                comboBox.addItem(saValues[valueIndex]);
            }
        }
    }

    protected class PopulateOnDemandEditor
    extends WsDefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public PopulateOnDemandEditor(WAComboBox comboBox) {
            super(comboBox);
        }

        @Override
        public void notify(JTable table, int row, int column) {
            super.notify(table, row, column);
            WsAbstractPopulateOnDemandTableColumn.this.populate(table, row, column);
        }
    }
}

