/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.ILogger;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;

public abstract class WsAbstractApplicationActionsManager {
    private static WsAbstractApplicationActionsManager s_instance;
    public static final String NEWFOLDER_ACTION = "Common:NewFolder";
    public static final String SAVE_ACTION = "Common:Save";
    public static final String PRINT_ACTION = "Common:Print";
    public static final String EXPAND_ACTION = "Common:Expand";
    public static final String COLLAPSE_ACTION = "Common:Collapse";
    public static final String UNDO_ACTION = "Common:Undo";
    public static final String REDO_ACTION = "Common:Redo";
    public static final String CUT_ACTION = "Common:Cut";
    public static final String COPY_ACTION = "Common:Copy";
    public static final String PASTE_ACTION = "Common:Paste";
    public static final String PASTESPECIAL_ACTION = "Common:PasteSpecial";
    public static final String RENAME_ACTION = "Common:Rename";
    public static final String DELETE_ACTION = "Common:Delete";
    public static final String FIND_ACTION = "Common:Find";
    public static final String PROPERTIES_ACTION = "Common:Properties";
    public static final String REFRESH_ACTION = "Common:Refresh";
    public static final String RUN_ACTION = "Common:Run";
    public static final String STOP_ACTION = "Common:Stop";
    public static final String CASCADE_ACTION = "Common:Cascade";
    public static final String ARRANGE_ACTION = "Common:Arrange";
    public static final String CLOSEALL_ACTION = "Common:CloseAll";
    public static final String IMPORT_ACTION = "Common:Import";
    public static final String EXPORT_ACTION = "Common:Export";
    public static final String HELP_ACTION = "Common:Help";
    public static final String SAVE_CURRENT_IMAGE_ACTION = "Common:SaveCurrentImage";
    public static final String APPLICATION_PROPERTIES_ACTION = "Application:Properties";
    public static final String APPLICATION_RUN_ACTION = "Application:Run";
    protected static final int NO_TEXT = 16;
    protected static final int NO_ICON = 0;
    protected static final int HAS_ICON = 2;
    protected static final int BLANK_ICON = 1;
    protected static final int NO_TIP = 256;
    protected static final int HAS_TIP = 0;
    private Map m_mapActions = new HashMap();
    private List m_lSelectionActions = new ArrayList();
    private JToolBar m_tools;
    private JMenuBar m_menu;
    private WsSelectionProvider m_provider;

    public static void setInstance(WsAbstractApplicationActionsManager instance) {
        s_instance = instance;
    }

    public static WsAbstractApplicationActionsManager getInstance() {
        return s_instance;
    }

    protected WsAbstractApplicationActionsManager() {
        this.createActions();
        s_instance = this;
    }

    public JToolBar getToolBar() {
        if (this.m_tools == null) {
            this.m_tools = this.createToolBar();
        }
        return this.m_tools;
    }

    public JMenuBar getMenuBar() {
        if (this.m_menu == null) {
            this.m_menu = this.createMenuBar();
        }
        return this.m_menu;
    }

    protected abstract void createActions();

    protected abstract JMenuBar createMenuBar();

    protected abstract JToolBar createToolBar();

    public abstract JPopupMenu createPopupMenuFor(WsActionContextInterface var1);

    public abstract void performDefaultActionFor(Object var1, Object var2, WsActionContextInterface var3);

    public void setSelectionProvider(WsSelectionProvider provider) {
        if (this.m_provider == provider) {
            return;
        }
        this.m_provider = provider;
        for (int iAction = 0; iAction < this.m_lSelectionActions.size(); ++iAction) {
            SelectionAction action = (SelectionAction)this.m_lSelectionActions.get(iAction);
            action.setSelectionProvider(provider);
        }
    }

    public WsSelectionProvider getSelectionProvider() {
        return this.m_provider;
    }

    protected void registerAction(String sActionKey, WsAbstractAction action) {
        this.m_mapActions.put(sActionKey, action);
        if (action instanceof SelectionAction) {
            this.m_lSelectionActions.add(action);
        }
    }

    protected void addToSelectionActionsList(SelectionAction action) {
        this.m_lSelectionActions.add(action);
    }

    public WsAbstractAction getAction(String sActionKey) {
        return (WsAbstractAction)this.m_mapActions.get(sActionKey);
    }

    protected WsAbstractToggleAction getToggleAction(String sActionKey) {
        return (WsAbstractToggleAction)this.getAction(sActionKey);
    }

    public Icon getActionIcon(String sActionKey) {
        WsAbstractAction act = this.getAction(sActionKey);
        return act != null ? act.getIcon() : null;
    }

    public void attachAction(String sActionKey, WsAbstractAction action, boolean bAttach) {
        Object obj = this.m_mapActions.get(sActionKey);
        if (obj != null && obj instanceof AttachableAction) {
            AttachableAction act = (AttachableAction)obj;
            if (bAttach) {
                act.attach(action);
            } else {
                act.detach(action);
            }
        }
    }

    protected WsAbstractAction createEmptyAction(String sActionKey, WAdminResource bundle, String sResourceKey, int fFlags) {
        EmptyAction act = new EmptyAction(bundle, sResourceKey, fFlags);
        this.registerAction(sActionKey, act);
        return act;
    }

    protected WsAbstractAction createAttachAction(String sActionKey, WAdminResource bundle, String sResourceKey, int fFlags) {
        AttachAction act = new AttachAction(bundle, sResourceKey, fFlags);
        this.registerAction(sActionKey, act);
        return act;
    }

    protected WsAbstractToggleAction createAttachToggleAction(String sActionKey, WAdminResource bundle, String sResourceKey, int fFlags) {
        AttachToggleAction act = new AttachToggleAction(bundle, sResourceKey, fFlags);
        this.registerAction(sActionKey, act);
        return act;
    }

    protected JMenu createMenu(String sActionKey) {
        return WsUIUtilities.createMenu(this.getAction(sActionKey));
    }

    protected JMenuItem createMenuItem(String sActionKey) {
        return WsUIUtilities.createMenuItem(this.getAction(sActionKey));
    }

    protected JCheckBoxMenuItem createCheckBoxMenuItem(String sActionKey) {
        return WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.getAction(sActionKey));
    }

    protected JRadioButtonMenuItem createRadioButtonMenuItem(String sActionKey) {
        return WsUIUtilities.createRadioButtonMenuItem((WsAbstractToggleAction)this.getAction(sActionKey));
    }

    protected JButton createToolButton(String sActionKey) {
        return WsUIUtilities.createFlatToolButton(this.getAction(sActionKey));
    }

    protected JButton createToggleToolButton(String sActionKey) {
        return WsUIUtilities.createFlatToggleToolButton((WsAbstractToggleAction)this.getAction(sActionKey));
    }

    protected JButton createTextIconButton(String sActionKey) {
        return WsUIUtilities.createFlatTextIconButton(this.getAction(sActionKey));
    }

    protected JButton createToggleTextIconButton(String sActionKey) {
        return WsUIUtilities.createFlatToggleTextIconButton((WsAbstractToggleAction)this.getAction(sActionKey));
    }

    protected void verifyMnemonics(JComponent mnu, String sPath) {
        ArrayList<MnemonicTracker> lMnemonics = new ArrayList<MnemonicTracker>();
        for (int iComponent = 0; iComponent < mnu.getComponentCount(); ++iComponent) {
            Component cmp = mnu.getComponent(iComponent);
            if (!(cmp instanceof JMenuItem)) continue;
            JMenuItem mi = (JMenuItem)cmp;
            char mnem = (char)mi.getMnemonic();
            boolean bFound = false;
            for (int iMnemonic = 0; iMnemonic < lMnemonics.size(); ++iMnemonic) {
                MnemonicTracker mnemonic = (MnemonicTracker)lMnemonics.get(iMnemonic);
                if (mnemonic.getMnemonic() != mnem) continue;
                mnemonic.add(mi);
                bFound = true;
                break;
            }
            if (!bFound) {
                lMnemonics.add(new MnemonicTracker((JMenuItem)cmp));
            }
            if (!(cmp instanceof JMenu)) continue;
            JPopupMenu popup = ((JMenu)mi).getPopupMenu();
            this.verifyMnemonics(popup, sPath + "." + mi.getText());
        }
        for (int iMnemonic = 0; iMnemonic < lMnemonics.size(); ++iMnemonic) {
            MnemonicTracker mnemonic = (MnemonicTracker)lMnemonics.get(iMnemonic);
            JMenuItem[] aItems = mnemonic.getMenuItems();
            ILogger logger = Workspace.getDefaultLogger();
            if (aItems.length <= 1) continue;
            StringBuilder out = new StringBuilder("Duplicate Mnemonics found in ");
            out.append(sPath);
            out.append(" :");
            out.append(mnemonic.getMnemonic());
            out.append(": List contains[");
            for (int iItem = 0; iItem < aItems.length; ++iItem) {
                out.append(aItems[iItem].getText());
                if (iItem >= aItems.length) continue;
                out.append(",");
            }
            out.append("]");
            if (logger == null) continue;
            logger.debug(out.toString());
        }
    }

    private static class ActionPropertyChangeListener
    implements PropertyChangeListener {
        private WsAbstractAction m_actNormal;
        private WsAbstractToggleAction m_actToggle;

        public ActionPropertyChangeListener(WsAbstractAction act) {
            this.m_actNormal = act;
        }

        public ActionPropertyChangeListener(WsAbstractToggleAction act) {
            this.m_actNormal = act;
            this.m_actToggle = act;
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String sProperty = ev.getPropertyName();
            if ("enabled".equals(sProperty)) {
                this.m_actNormal.setEnabled((Boolean)ev.getNewValue());
            } else if ("Selected".equals(sProperty) && this.m_actToggle != null) {
                this.m_actToggle.setSelected((Boolean)ev.getNewValue());
            }
        }
    }

    private static class AttachToggleAction
    extends WsAbstractToggleAction
    implements AttachableAction,
    ContextualAction {
        private static final long serialVersionUID = 1L;
        private WsAbstractToggleAction m_actAttached;
        private PropertyChangeListener m_lsnrProperties;

        public AttachToggleAction(WAdminResource bundle, String sResourceKey, int fFlags) {
            super(bundle, sResourceKey, fFlags);
            this.setEnabled(false);
        }

        @Override
        public void attach(WsAbstractAction act) {
            if (this.m_actAttached != null) {
                throw new UnsupportedOperationException("Only one action can be attached to " + this.getText() + " at a time: " + act.getText());
            }
            if (!(act instanceof WsAbstractToggleAction)) {
                throw new UnsupportedOperationException("Only a WsAbstractToggleAction can be attached to " + this.getText() + ": " + act.getText());
            }
            if (this.m_lsnrProperties == null) {
                this.m_lsnrProperties = new ActionPropertyChangeListener(this);
            }
            this.m_actAttached = (WsAbstractToggleAction)act;
            this.setEnabled(this.m_actAttached.isEnabled());
            this.setSelected(this.m_actAttached.isSelected());
            this.m_actAttached.addPropertyChangeListener(this.m_lsnrProperties);
        }

        @Override
        public void detach(WsAbstractAction act) {
            if (this.m_actAttached != act) {
                throw new UnsupportedOperationException("Only current action can be detached from + " + this.getText() + ": " + act.getText());
            }
            this.m_actAttached.removePropertyChangeListener(this.m_lsnrProperties);
            this.m_actAttached = null;
            this.setEnabled(false);
            this.setSelected(false);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (this.m_actAttached == null) {
                throw new UnsupportedOperationException("Action performed occurred when no action is attached");
            }
            this.m_actAttached.setSelected(this.isSelected());
            this.m_actAttached.actionPerformed(ev);
        }

        @Override
        public boolean isValidForContext(WsActionContextInterface context) {
            if (this.m_actAttached instanceof ContextualAction) {
                return ((ContextualAction)((Object)this.m_actAttached)).isValidForContext(context);
            }
            return false;
        }

        @Override
        public void setSelected(boolean bSelected) {
            super.setSelected(bSelected);
            if (this.m_actAttached != null) {
                this.m_actAttached.setSelected(bSelected);
            }
        }
    }

    private static class AttachAction
    extends WsAbstractAction
    implements AttachableAction,
    ContextualAction {
        private static final long serialVersionUID = 1L;
        private WsAbstractAction m_actAttached;
        private PropertyChangeListener m_lsnrProperties;

        public AttachAction(WAdminResource bundle, String sResourceKey, int fFlags) {
            super(bundle, sResourceKey, fFlags);
            this.setEnabled(false);
        }

        @Override
        public void attach(WsAbstractAction act) {
            if (this.m_actAttached != null) {
                throw new UnsupportedOperationException("Only one action can be attached to " + this.getText() + " at a time: " + act.getText());
            }
            if (this.m_lsnrProperties == null) {
                this.m_lsnrProperties = new ActionPropertyChangeListener(this);
            }
            this.m_actAttached = act;
            this.setEnabled(this.m_actAttached.isEnabled());
            this.m_actAttached.addPropertyChangeListener(this.m_lsnrProperties);
        }

        @Override
        public void detach(WsAbstractAction act) {
            if (this.m_actAttached != act) {
                throw new UnsupportedOperationException("Only current action can be detached from + " + this.getText() + ": " + act.getText());
            }
            this.m_actAttached.removePropertyChangeListener(this.m_lsnrProperties);
            this.m_actAttached = null;
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (this.m_actAttached == null) {
                throw new UnsupportedOperationException("Action performed occurred when no action is attached");
            }
            this.m_actAttached.actionPerformed(ev);
        }

        @Override
        public boolean isValidForContext(WsActionContextInterface context) {
            if (this.m_actAttached instanceof ContextualAction) {
                return ((ContextualAction)((Object)this.m_actAttached)).isValidForContext(context);
            }
            return false;
        }
    }

    private static class EmptyAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public EmptyAction(WAdminResource bundle, String sResourceKey, int fFlags) {
            super(bundle, sResourceKey, fFlags);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
        }
    }

    public static interface SelectionAction {
        public void setSelectionProvider(WsSelectionProvider var1);
    }

    public static interface ContextualAction
    extends Action {
        public boolean isValidForContext(WsActionContextInterface var1);
    }

    public static interface AttachableAction
    extends Action {
        public void attach(WsAbstractAction var1);

        public void detach(WsAbstractAction var1);
    }

    private static class MnemonicTracker {
        private List m_lItems = new ArrayList(1);
        private int m_mnem;

        public MnemonicTracker(JMenuItem mi) {
            this.m_lItems.add(mi);
            this.m_mnem = mi.getMnemonic();
        }

        public char getMnemonic() {
            return (char)this.m_mnem;
        }

        public void add(JMenuItem mi) {
            this.m_lItems.add(mi);
        }

        public JMenuItem[] getMenuItems() {
            return this.m_lItems.toArray(new JMenuItem[this.m_lItems.size()]);
        }
    }
}

