/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class WorkspaceUtil {
    protected static ImageIcon m_typeCharIcon;
    protected static ImageIcon m_typeNumIcon;
    protected static ImageIcon m_typeDateIcon;
    protected static ImageIcon m_typeTimeIcon;
    protected static ImageIcon m_typeTimeStampIcon;
    private static WAdminResource bundle;

    public static void fixupDialogIcons() {
        ImageIcon qIcon = bundle.getImageIcon("qIcon");
        JDialog parentLess = new JDialog();
        Frame sharedHiddenParentFrame = (Frame)parentLess.getParent();
        sharedHiddenParentFrame.setIconImage(qIcon.getImage());
    }

    public static final void busyOn(JComponent c) {
        c.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
    }

    public static final void busyOff(JComponent c) {
        c.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
    }

    public static final void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public static void center(Window window) {
        Dimension size = window.getSize();
        Dimension screenSize = window.getToolkit().getScreenSize();
        window.setLocation(screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
    }

    public static void centerFourth(Window window) {
        Dimension size = window.getSize();
        Dimension screenSize = window.getToolkit().getScreenSize();
        window.setLocation(screenSize.width / 4 - size.width / 4, screenSize.height / 4 - size.height / 4);
    }

    public static void centerOver(Window window, Component component) {
        int amountOver;
        if (!window.isShowing()) {
            WorkspaceUtil.center(window);
        }
        Point location = component.getLocationOnScreen();
        Dimension componentSize = component.getSize();
        location.x += componentSize.width / 2;
        location.y += componentSize.height / 2;
        Dimension size = window.getSize();
        int x = location.x - size.width / 2;
        int y = location.y - size.height / 2;
        Dimension screenSize = window.getToolkit().getScreenSize();
        if (x + size.width > screenSize.width && (amountOver = x + size.width - screenSize.width) > 0 && x - amountOver > 0) {
            x -= amountOver;
        }
        if (y + size.height > screenSize.height && (amountOver = y + size.height - screenSize.height) > 0 && y - amountOver > 0) {
            y -= amountOver;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        window.setLocation(x, y);
    }

    public static void centerOverWindow(Window window, Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        if (component != null) {
            WorkspaceUtil.centerOver(window, component);
        }
    }

    public static Frame getParentFrame(Component comp) {
        Frame parentFrame = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof Frame) {
                parentFrame = (Frame)parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentFrame;
    }

    public static Window getParentWindow(Component comp) {
        Window parentWindow = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof Window) {
                parentWindow = (Window)parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentWindow;
    }

    public static void fixupJComboBox(JComboBox c) {
        c.setBackground(SystemColor.window);
        c.setRenderer(new BetterComboRenderer());
        c.setBorder(BorderFactory.createBevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow));
    }

    public static Dimension getBestWindowSize(Dimension x) {
        Toolkit tkt = Toolkit.getDefaultToolkit();
        Dimension realSize = tkt.getScreenSize();
        Dimension retDim = new Dimension(x);
        if (x.height > realSize.height || x.width > realSize.width) {
            retDim.height = realSize.height;
            retDim.width = realSize.width;
        }
        return retDim;
    }

    public static void setDeepEnabled(Component comp, boolean state) {
        comp.setEnabled(state);
        if (comp instanceof Container) {
            Container container = (Container)comp;
            Component[] compArray = container.getComponents();
            for (int index = 0; index < compArray.length; ++index) {
                WorkspaceUtil.setDeepEnabled(compArray[index], state);
            }
        }
    }

    public static void printStackTrace() {
        try {
            throw new Throwable();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
    }

    static {
        bundle = WAdminResource.getBundle(WorkspaceUtil.class);
    }

    static class BetterComboRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public BetterComboRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                this.setText(value.toString());
            }
            this.setBackground(isSelected ? SystemColor.textHighlight : SystemColor.window);
            this.setForeground(isSelected ? SystemColor.textHighlightText : SystemColor.textText);
            return this;
        }
    }
}

