/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsTreeNode;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class WorkspaceTreeUI
extends BasicTreeUI {
    private TreeModelListener m_lsnrModel;

    public static ComponentUI createUI(JComponent cmp) {
        return new WorkspaceTreeUI();
    }

    private WorkspaceTree getWorkspaceTree() {
        return (WorkspaceTree)this.tree;
    }

    @Override
    protected MouseListener createMouseListener() {
        return new cMouseListener();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.m_lsnrModel == null) {
            this.m_lsnrModel = new cModelListener();
        }
        if (this.treeModel != null) {
            this.treeModel.addTreeModelListener(this.m_lsnrModel);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.treeModel != null) {
            this.treeModel.removeTreeModelListener(this.m_lsnrModel);
        }
        this.m_lsnrModel = null;
    }

    @Override
    protected void setModel(TreeModel model) {
        if (this.treeModel != null && this.m_lsnrModel != null) {
            this.treeModel.removeTreeModelListener(this.m_lsnrModel);
        }
        super.setModel(model);
        if (this.treeModel != null && this.m_lsnrModel != null) {
            this.treeModel.addTreeModelListener(this.m_lsnrModel);
        }
    }

    protected class cModelListener
    implements TreeModelListener {
        protected cModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent ev) {
            WorkspaceTreeUI.this.getWorkspaceTree().updateActions();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent ev) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent ev) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent ev) {
        }
    }

    protected class cMouseListener
    extends BasicTreeUI.MouseHandler {
        protected cMouseListener() {
            super(WorkspaceTreeUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!WorkspaceTreeUI.this.getWorkspaceTree().isEnabled()) {
                return;
            }
            if (e.isPopupTrigger()) {
                this.triggerPopup(e);
                return;
            }
            if (WorkspaceTreeUI.this.getWorkspaceTree().getSelectionCount() > 1 && !e.isControlDown() && !e.isShiftDown() && this.isPointOnSelectedPath(e.getPoint())) {
                WorkspaceTreeUI.this.getWorkspaceTree().requestFocus();
            } else {
                super.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!WorkspaceTreeUI.this.getWorkspaceTree().isEnabled()) {
                return;
            }
            if (e.isPopupTrigger()) {
                this.triggerPopup(e);
                return;
            }
            if (WorkspaceTreeUI.this.getWorkspaceTree().getSelectionCount() > 1 && !e.isControlDown() && !e.isShiftDown() && this.isPointOnSelectedPath(e.getPoint())) {
                MouseEvent ePressed = new MouseEvent((Component)e.getSource(), 501, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), false, e.getButton());
                super.mousePressed(ePressed);
            }
            if (e.getClickCount() == 2) {
                WorkspaceTree treeWork;
                WsTreeNode nodeSelected;
                TreePath[] aSelectedPaths;
                TreePath path = WorkspaceTreeUI.this.tree.getPathForLocation(e.getX(), e.getY());
                if (WorkspaceTreeUI.this.tree.isPathSelected(path) && (aSelectedPaths = WorkspaceTreeUI.this.tree.getSelectionPaths()).length == 1 && (nodeSelected = (treeWork = WorkspaceTreeUI.this.getWorkspaceTree()).getSelectedNode()).isLeaf()) {
                    Action actUserDefault = treeWork.getUserDefaultAction();
                    if (actUserDefault != null) {
                        if (actUserDefault.isEnabled()) {
                            actUserDefault.actionPerformed(new ActionEvent(WorkspaceTreeUI.this.tree, 1, "default"));
                        }
                    } else if (treeWork.isDefaultActionEnabled()) {
                        nodeSelected.doDefaultAction();
                    }
                }
            }
            super.mouseReleased(e);
        }

        protected boolean isPointOnSelectedPath(Point pt) {
            TreePath path = WorkspaceTreeUI.this.getWorkspaceTree().getPathForLocation(pt.x, pt.y);
            return path != null && WorkspaceTreeUI.this.getWorkspaceTree().isPathSelected(path);
        }

        protected void triggerPopup(MouseEvent e) {
            if (!e.isShiftDown() && !e.isControlDown()) {
                TreePath path = WorkspaceTreeUI.this.getWorkspaceTree().getPathForLocation(e.getX(), e.getY());
                if (!WorkspaceTreeUI.this.getWorkspaceTree().isPathSelected(path)) {
                    WorkspaceTreeUI.this.getWorkspaceTree().setSelectionPath(path);
                }
            }
            WorkspaceTreeUI.this.getWorkspaceTree().showPopupMenu(e);
        }
    }
}

