/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.workspace.CustomLayoutFocusTraversalPolicy;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.ProjectUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WARootPane;
import com.sas.workspace.WASimpleWizardModel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WizardTabInfo;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.WsMetadataUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class WAWizardDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    public static final int FINISH = 3;
    public static final String FOLDER = "FOLDER";
    private static final WAdminResource bundle = WAdminResource.getBundle(WAWizardDialog.class);
    public static final Icon DEFAULT_BANNER_ICON = bundle.getImageIcon("WAWizardDialog.Banner.image");
    public static final Icon DEFAULT_SIDEBAR_ICON = bundle.getImageIcon("WAWizardDialog.Sidebar.image");
    private static boolean s_bNewStyle = false;
    protected boolean m_bNextValid = true;
    protected cWizardPanel m_pnlWizard;
    protected JButton m_btnFinish;
    protected JButton m_btnNext;
    protected JButton m_btnBack;
    protected MdObjectStore m_parentStore = null;
    protected boolean m_fStoreWasPassedIn = false;
    protected WAWizardModel m_WizardModel;
    protected HashMap m_wizardData = new HashMap(10);
    protected CMetadata m_oMetadata = null;
    private boolean m_bFinishEarly = true;
    private Icon m_iconBanner;
    private Icon m_iconSidebar;
    protected List m_lTabsToCleanupOnCancel;
    protected Icon m_DefaultImage;

    public static void setUsingNewStyle(boolean bNewStyle) {
        s_bNewStyle = bNewStyle;
    }

    public static boolean isUsingNewStyle() {
        return s_bNewStyle;
    }

    public WAWizardDialog(Dialog dlgOwner) {
        this(dlgOwner, false, null);
    }

    public WAWizardDialog(Dialog dlgOwner, boolean bModal) {
        this(dlgOwner, (String)null, bModal, (MdObjectStore)null);
    }

    public WAWizardDialog(Dialog dlgOwner, String sTitle) {
        this(dlgOwner, sTitle, false, (MdObjectStore)null);
    }

    public WAWizardDialog(Dialog dlgOwner, String sTitle, boolean bModal) {
        this(dlgOwner, sTitle, bModal, (MdObjectStore)null);
    }

    public WAWizardDialog(Frame frmOwner) {
        this(frmOwner, false, null);
    }

    public WAWizardDialog(Frame frmOwner, boolean bModal) {
        this(frmOwner, (String)null, bModal, (MdObjectStore)null);
    }

    public WAWizardDialog(Frame frmOwner, String sTitle) {
        this(frmOwner, sTitle, false, (MdObjectStore)null);
    }

    public WAWizardDialog(Frame frmOwner, String sTitle, boolean bModal) {
        this(frmOwner, sTitle, bModal, (MdObjectStore)null);
    }

    public WAWizardDialog(Dialog dlgOwner, MdObjectStore store) {
        this(dlgOwner, false, store);
    }

    public WAWizardDialog(Dialog dlgOwner, boolean bModal, MdObjectStore store) {
        this(dlgOwner, null, bModal, store);
    }

    public WAWizardDialog(Dialog dlgOwner, String sTitle, MdObjectStore store) {
        this(dlgOwner, sTitle, false, store);
    }

    public WAWizardDialog(Dialog dlgOwner, String sTitle, boolean bModal, MdObjectStore store, boolean createStore) {
        super(dlgOwner, sTitle, bModal);
        this.m_WizardModel = new WASimpleWizardModel();
        this.m_pnlWizard = new cWizardPanel();
        this.setMainPanel(this.m_pnlWizard);
        this.setBannerIcon(DEFAULT_BANNER_ICON);
        this.setSidebarIcon(DEFAULT_SIDEBAR_ICON);
        if (store == null && createStore) {
            try {
                this.m_parentStore = Workspace.getMdFactory().createObjectStore();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
            this.m_fStoreWasPassedIn = false;
        } else {
            this.m_parentStore = store;
            this.m_fStoreWasPassedIn = true;
        }
        this.addWizardData("FINISHINFO", "");
        this.addWizardData("OBJECTSTORE", this.m_parentStore);
        this.addWizardData("REPOSITORY", Workspace.getWorkspace().getDefaultRepository());
        if (Workspace.getWorkspace().getProjectRepository() != null) {
            this.addWizardData("PROJECTREPOSITORY", Workspace.getWorkspace().getProjectRepository());
        }
    }

    public WAWizardDialog(Dialog dlgOwner, String sTitle, boolean bModal, MdObjectStore store) {
        super(dlgOwner, sTitle, bModal);
        this.m_WizardModel = new WASimpleWizardModel();
        this.m_pnlWizard = new cWizardPanel();
        this.setMainPanel(this.m_pnlWizard);
        this.setBannerIcon(DEFAULT_BANNER_ICON);
        this.setSidebarIcon(DEFAULT_SIDEBAR_ICON);
        if (store == null) {
            try {
                this.m_parentStore = Workspace.getMdFactory().createObjectStore();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
            this.m_fStoreWasPassedIn = false;
        } else {
            this.m_parentStore = store;
            this.m_fStoreWasPassedIn = true;
        }
        this.addWizardData("FINISHINFO", "");
        this.addWizardData("OBJECTSTORE", this.m_parentStore);
        this.addWizardData("REPOSITORY", Workspace.getWorkspace().getDefaultRepository());
        if (Workspace.getWorkspace().getProjectRepository() != null) {
            this.addWizardData("PROJECTREPOSITORY", Workspace.getWorkspace().getProjectRepository());
        }
    }

    public WAWizardDialog(Frame frmOwner, MdObjectStore store) {
        this(frmOwner, false, store);
    }

    public WAWizardDialog(Frame frmOwner, boolean bModal, MdObjectStore store) {
        this(frmOwner, null, bModal, store);
    }

    public WAWizardDialog(Frame frmOwner, String sTitle, MdObjectStore store) {
        this(frmOwner, sTitle, false, store);
    }

    public WAWizardDialog(Frame frmOwner, String sTitle, boolean bModal, MdObjectStore store) {
        this(frmOwner, sTitle, bModal, store, true);
    }

    public WAWizardDialog(Frame frmOwner, String sTitle, boolean bModal, MdObjectStore store, boolean createStore) {
        super(frmOwner, sTitle, bModal);
        this.m_WizardModel = new WASimpleWizardModel();
        this.m_pnlWizard = new cWizardPanel();
        this.setMainPanel(this.m_pnlWizard);
        this.setBannerIcon(DEFAULT_BANNER_ICON);
        this.setSidebarIcon(DEFAULT_SIDEBAR_ICON);
        if (store == null && createStore) {
            try {
                this.m_parentStore = Workspace.getMdFactory().createObjectStore();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
            this.m_fStoreWasPassedIn = false;
        } else if (createStore) {
            this.m_parentStore = store;
            this.m_fStoreWasPassedIn = true;
        }
        this.addWizardData("FINISHINFO", "");
        this.addWizardData("OBJECTSTORE", this.m_parentStore);
        this.addWizardData("REPOSITORY", Workspace.getWorkspace().getDefaultRepository());
        if (Workspace.getWorkspace().getProjectRepository() != null) {
            this.addWizardData("PROJECTREPOSITORY", Workspace.getWorkspace().getProjectRepository());
        }
    }

    @Override
    public void show() {
        WizardTabInfo info = this.m_WizardModel.getCurrent();
        this.getParent().setCursor(Cursor.getPredefinedCursor(3));
        this.doDataExchangeOnCurrentPanel(false);
        this.getParent().setCursor(Cursor.getDefaultCursor());
        if (!WAWizardDialog.isUsingNewStyle()) {
            this.setTitle(info.getTitle());
        }
        this.m_pnlWizard.showPanel(info);
        super.show();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        w = Math.max(w, 600);
        h = Math.max(h, 450);
        super.setBounds(x, y, w, h);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_btnFinish = new JButton();
        this.m_btnNext = new JButton();
        this.m_btnBack = new JButton();
        this.m_btnBack.setText(bundle.getString("Common.Back.txt"));
        this.m_btnNext.setText(bundle.getString("Common.Next.txt"));
        this.m_btnFinish.setText(bundle.getString("Common.Finish.txt"));
        this.m_btnBack.setMnemonic(bundle.getString("Common.Back.mnem").charAt(0));
        this.m_btnNext.setMnemonic(bundle.getString("Common.Next.mnem").charAt(0));
        this.m_btnFinish.setMnemonic(bundle.getString("Common.Finish.mnem").charAt(0));
        this.m_btnBack.addActionListener(this);
        this.m_btnNext.addActionListener(this);
        this.m_btnFinish.addActionListener(this);
    }

    @Override
    protected void createMainPanelBorder() {
        if (!s_bNewStyle) {
            super.createMainPanelBorder();
        }
    }

    @Override
    protected void restoreMainPanelBorder() {
        if (!s_bNewStyle) {
            super.restoreMainPanelBorder();
        }
    }

    @Override
    protected void updateButtonsPanel() {
        if (s_bNewStyle) {
            this.m_pnlButtons.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        }
        this.removeKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
        this.m_pnlButtons.removeAll();
        this.m_pnlButtons.setLayout(new cWizardButtonsPaneLayout());
        this.m_pnlButtons.add(this.m_btnHelp);
        this.m_pnlButtons.add(this.m_btnCancel);
        this.m_pnlButtons.add(this.m_btnBack);
        this.m_pnlButtons.add(this.m_btnNext);
        this.m_pnlButtons.add(this.m_btnFinish);
        this.addKeyListeners(this.m_pnlButtons, new WAStandardDialog.cKeyHandler());
        this.updateNavigationButtons();
    }

    public boolean addWizardData(String key, Object value) {
        this.m_wizardData.put(key, value);
        return true;
    }

    public void replaceWizardData(String key, Object value) {
        this.m_wizardData.put(key, value);
    }

    public Object getWizardData(String key) {
        return this.m_wizardData.get(key);
    }

    public void removeWizardData(String key) {
        this.m_wizardData.remove(key);
    }

    public WizardTabInfo addTab(String sTitle, WAPropertyTab tab) {
        return this.addTab(sTitle, null, tab, null, null, false);
    }

    public WizardTabInfo addTab(String sTitle, String sTabName, WAPropertyTab tab) {
        return this.addTab(sTitle, sTabName, tab, null, null, false);
    }

    public WizardTabInfo addTab(String sTitle, String sTabName, WAPropertyTab tab, String sImageName, Icon image) {
        return this.addTab(sTitle, sTabName, tab, sImageName, image, false);
    }

    public WizardTabInfo addTab(String sTitle, String sTabName, WAPropertyTab tab, String sImageName, Icon image, boolean bFinish) {
        if (sTabName == null) {
            sTabName = sTitle;
        }
        if (image == null) {
            if (this.m_DefaultImage == null) {
                this.m_DefaultImage = bundle.getImageIcon("WAWizardDialog.DefaultImage.image");
            }
            image = this.m_DefaultImage;
            sImageName = "importgif.gif";
        }
        WizardTabInfo info = new WizardTabInfo(sTitle, sTabName, tab, sImageName, image, bFinish);
        this.m_pnlWizard.addPanel(info);
        this.m_WizardModel.addPanel(info);
        return info;
    }

    public WizardTabInfo addTab(String sTitle, String sTabName, WAPropertyTab tab, boolean bFinish) {
        if (sTabName == null) {
            sTabName = sTitle;
        }
        WizardTabInfo info = new WizardTabInfo(sTitle, sTabName, tab, null, null, bFinish);
        this.m_pnlWizard.addPanel(info);
        this.m_WizardModel.addPanel(info);
        return info;
    }

    public WAWizardModel getWizardModel() {
        return this.m_WizardModel;
    }

    public void setWizardModel(WAWizardModel model) {
        this.m_WizardModel = model;
    }

    public void setCanFinishEarly(boolean bFinishEarly) {
        this.m_bFinishEarly = bFinishEarly;
    }

    public boolean canFinishEarly() {
        return this.m_bFinishEarly;
    }

    public void setBannerIcon(Icon iconBanner) {
        this.m_iconBanner = iconBanner;
    }

    public Icon getBannerIcon() {
        return this.m_iconBanner;
    }

    public void setSidebarIcon(Icon iconSidebar) {
        this.m_iconSidebar = iconSidebar;
    }

    public Icon getSidebarIcon() {
        return this.m_iconSidebar;
    }

    public void addTabToCleanupOnCancel(WAPropertyTab tab) {
        if (this.m_lTabsToCleanupOnCancel == null) {
            this.m_lTabsToCleanupOnCancel = new ArrayList();
        }
        this.m_lTabsToCleanupOnCancel.add(tab);
    }

    public void removeTabToCleanupOnCancel(WAPropertyTab tab) {
        if (this.m_lTabsToCleanupOnCancel != null) {
            this.m_lTabsToCleanupOnCancel.remove(tab);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Object src = e.getSource();
        if (src == this.m_btnFinish) {
            if (this.onFinish()) {
                this.dispose();
            }
        } else if (src == this.m_btnNext) {
            this.onNext();
            if (this.m_bNextValid) {
                this.updateNavigationButtons();
            }
        } else if (src == this.m_btnBack) {
            this.onBack();
            this.updateNavigationButtons();
        }
    }

    @Override
    protected boolean onCancel() {
        boolean brc = super.onCancel();
        if (!brc) {
            return false;
        }
        if (this.m_parentStore != null && !this.m_fStoreWasPassedIn) {
            try {
                this.m_parentStore.dispose();
                Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)"WAWizardDialog.onCancel", ex);
            }
        }
        this.termAppServer();
        Workspace.getWorkspace().clearStatusText();
        return brc;
    }

    private void termAppServer() {
        WsAppServer appServer = (WsAppServer)this.getWizardData("AppServer");
        String sAutoTerm = (String)this.getWizardData("AutoTermAppServer");
        if ((sAutoTerm == null || sAutoTerm.equalsIgnoreCase("YES")) && appServer != null) {
            appServer.dispose();
        }
    }

    public boolean doCleanup() {
        super.onOK();
        if (this.m_parentStore != null && !this.m_fStoreWasPassedIn) {
            try {
                this.m_parentStore.dispose();
                Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)"WAWizardDialog.doCleanup", ex);
            }
            this.m_parentStore = null;
        }
        this.termAppServer();
        Workspace.getWorkspace().clearStatusText();
        return true;
    }

    public boolean doDisposeOfStore() {
        if (this.m_parentStore != null && !this.m_fStoreWasPassedIn) {
            try {
                this.m_parentStore.dispose();
                Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)"WAWizardDialog.doDisposeOfStore", ex);
            }
            this.m_parentStore = null;
        }
        return true;
    }

    protected boolean onFinish() {
        int iRC;
        Workspace workspace = Workspace.getWorkspace();
        if (workspace.isServerStatusCheckEnabled() && workspace.getCMRHandle() != null && workspace.isConnected() && ((iRC = workspace.checkMetadataServerStatus(true)) == Workspace.SERVERSTATUS_ERROR || iRC == Workspace.SERVERSTATUS_PAUSED)) {
            return false;
        }
        CMetadata projectRepository = (CMetadata)this.getWizardData("PROJECTREPOSITORY");
        if (projectRepository != null) {
            try {
                ProjectUtil.addObjects((MdObjectStore)this.getWizardData("OBJECTSTORE"), projectRepository);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage(e, "Reading");
                e.printStackTrace();
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
        }
        boolean brc = super.onOK();
        this.termAppServer();
        return brc;
    }

    protected void onNext() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            WAPropertyTab tabCurrent = this.m_WizardModel.getCurrent().getTab();
            this.m_bNextValid = tabCurrent.validateData();
            if (!this.m_bNextValid) {
                return;
            }
            tabCurrent.onNext();
            WizardTabInfo info = this.m_WizardModel.next();
            if (!s_bNewStyle) {
                this.setTitle(info.getTitle());
            }
            this.m_pnlWizard.showPanel(info);
            this.doDataExchangeOnCurrentPanel(false);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void onBack() {
        this.m_WizardModel.getCurrent().getTab().onBack();
        WizardTabInfo info = this.m_WizardModel.prev();
        if (!s_bNewStyle) {
            this.setTitle(info.getTitle());
        }
        this.m_pnlWizard.showPanel(info);
    }

    protected void updateNavigationButtons() {
        boolean bFinish = this.m_WizardModel.canBeFinish();
        this.m_btnBack.setEnabled(this.m_WizardModel.hasPrev());
        this.m_btnNext.setEnabled(this.m_WizardModel.hasNext());
        this.m_btnFinish.setEnabled(bFinish);
        if (!this.canFinishEarly() && WAWizardDialog.isUsingNewStyle()) {
            this.m_btnNext.setVisible(!bFinish);
            this.m_btnFinish.setVisible(bFinish);
            if (this.m_btnNext.isEnabled() && bFinish) {
                System.err.println("both next and finish are enabled in a non-early finish wizard");
            }
        }
        if (!this.m_btnNext.isEnabled()) {
            ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnFinish);
        } else {
            ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnNext);
        }
        Component cmp = this.getDefaultFocusComponent();
        if (cmp != null) {
            cmp.requestFocus();
        }
    }

    protected boolean doDataExchangeOnCurrentPanel(boolean bSaveToModel) {
        try {
            return this.m_WizardModel.getCurrent().getTab().doDataExchange(bSaveToModel);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
            return false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
            return false;
        }
    }

    public void reconstructWizard() {
        this.m_pnlWizard = new cWizardPanel();
        this.setMainPanel(this.m_pnlWizard);
    }

    protected void writeMetadata() {
        this.m_oMetadata = (CMetadata)this.getWizardData("MASTEROBJECT");
        try {
            if (this.m_oMetadata instanceof Root) {
                WsMetadataUtil.updateModifiedByFor((Root)this.m_oMetadata);
            }
            String str1 = bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt");
            String str2 = bundle.getString("WriteMetadataProgressIndicator.Msg.Title");
            String str3 = bundle.getString("WriteMetadataProgressIndicator.Msg.Cancel.txt");
            OpRequestUI request = new OpRequestUI(Workspace.getWorkspace(), str1, str2, str3);
            request.setDelayBeforeProgressCancelDialog(200);
            Runnable write = new Runnable(){

                @Override
                public void run() {
                    WAWizardDialog.this.doThreadedWrite();
                }
            };
            request.execute(write);
            Workspace.getDefaultLogger().debug("Finished waiting on write");
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Writing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        catch (Exception ge) {
            Workspace.getDefaultLogger().error("Error encountered while writing data" + ge.getMessage());
        }
    }

    public void doThreadedWrite() {
        Workspace.getDefaultLogger().debug("Starting write");
        try {
            this.m_oMetadata.updateMetadataAll();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Writing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        Workspace.getDefaultLogger().debug("Finished write");
        CMetadata projectRepository = (CMetadata)this.getWizardData("PROJECTREPOSITORY");
        if (projectRepository != null) {
            try {
                ProjectUtil.addObjects((MdObjectStore)this.m_oMetadata.getObjectStore(), projectRepository);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage(e, "Reading");
                e.printStackTrace();
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
        }
        if (this.m_parentStore != null && !this.m_fStoreWasPassedIn) {
            try {
                Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
                this.m_parentStore.dispose();
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
            this.m_parentStore = null;
        }
    }

    public void runFinish() {
        WizardTabInfo[] aoInfos = this.m_WizardModel.getVisitedPanels();
        int nInfos = aoInfos.length;
        String finishString = "";
        for (int iInfo = 0; iInfo < nInfos; ++iInfo) {
            String temp = aoInfos[iInfo].getTab().createFinishString();
            if (temp == null) continue;
            finishString = finishString + temp;
        }
        this.addWizardData("FINISHINFO", finishString);
    }

    public void setMasterObject(CMetadata object) {
        try {
            if (this.getWizardData("MASTEROBJECT") == null) {
                this.addWizardData("MASTEROBJECT", object);
                object.addElementToChangeList(object);
            } else {
                CMetadata master = (CMetadata)this.getWizardData("MASTEROBJECT");
                master.addElementToChangeList(object);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public void fixupID(CMetadata object, String primaryID) {
        try {
            if (object.getFQID().indexOf(36) == -1) {
                return;
            }
            CMetadata projectRepository = Workspace.getWorkspace().getProjectRepository();
            if (projectRepository != null) {
                String projectReposID = projectRepository.getFQID();
                ((MdObjectStore)object.getObjectStore()).updateChangeListObjectIDs(projectReposID, projectReposID, Workspace.getWorkspace().getCheckinRepository().getFQID());
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public void fixupID(CMetadata object) {
        try {
            if (object.getFQID().indexOf(36) == -1) {
                return;
            }
            CMetadata projectRepository = Workspace.getWorkspace().getProjectRepository();
            if (projectRepository != null) {
                String projectReposID = projectRepository.getFQID();
                ((MdObjectStore)object.getObjectStore()).updateChangeListObjectIDs(projectReposID, projectReposID, Workspace.getWorkspace().getCheckinRepository().getFQID());
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    private static class cSummaryPage
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public cSummaryPage(JComponent cmp, String sTitle, Icon icon) {
            Font fnt = WsUIUtilities.getSystemDefaultFont();
            JLabel lblTitle = new JLabel(sTitle);
            lblTitle.setFont(fnt.deriveFont(1, (float)fnt.getSize() * 1.125f));
            this.setBackground(SystemColor.window);
            JLabel lblIcon = new JLabel(icon);
            lblIcon.setVerticalAlignment(1);
            Dimension dim = lblIcon.getPreferredSize();
            dim.height = 0;
            lblIcon.setPreferredSize(dim);
            this.setBackground(SystemColor.window);
            cmp.setBackground(SystemColor.window);
            this.setLayout(new GridBagLayout());
            this.add((Component)lblIcon, new GridBagConstraints(0, 0, 1, 3, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 2), 0, 0));
            this.add((Component)lblTitle, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 12), 0, 0));
            this.add((Component)cmp, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 0, 13, 12), 0, 0));
        }
    }

    private static class cIntroductionPage
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public cIntroductionPage(JComponent cmp, String sTitle, Icon icon) {
            Font fnt = WsUIUtilities.getSystemDefaultFont();
            JLabel lblTitle = new JLabel(sTitle);
            lblTitle.setFont(fnt.deriveFont(1, (float)fnt.getSize() * 1.5f));
            this.setBackground(SystemColor.window);
            JLabel lblIcon = new JLabel(icon);
            lblIcon.setVerticalAlignment(1);
            Dimension dim = lblIcon.getPreferredSize();
            dim.height = 0;
            lblIcon.setPreferredSize(dim);
            this.setBackground(SystemColor.window);
            cmp.setBackground(SystemColor.window);
            this.setLayout(new GridBagLayout());
            this.add((Component)lblIcon, new GridBagConstraints(0, 0, 1, 3, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 2), 0, 0));
            this.add((Component)lblTitle, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(9, 0, 0, 12), 0, 0));
            this.add((Component)cmp, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 0, 13, 12), 0, 0));
        }
    }

    private static class cContentPage
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private WATextArea m_txtDescription;

        public cContentPage(JComponent cmp, String sTitle, String sDescr, Icon icon) {
            Font fnt = WsUIUtilities.getSystemDefaultFont();
            JLabel lblTitle = new JLabel(sTitle);
            lblTitle.setFont(fnt.deriveFont(1, (float)fnt.getSize() * 1.125f));
            this.m_txtDescription = new WATextArea();
            this.m_txtDescription.setBehavior(1);
            this.m_txtDescription.setFont(fnt);
            this.m_txtDescription.setRows(2);
            this.m_txtDescription.setLineWrap(true);
            this.m_txtDescription.setWrapStyleWord(true);
            this.m_txtDescription.setText(sDescr);
            JLabel lblIcon = new JLabel(icon);
            lblIcon.setVerticalAlignment(1);
            Dimension dim = lblIcon.getPreferredSize();
            dim.height = 0;
            lblIcon.setMinimumSize(dim);
            lblIcon.setPreferredSize(dim);
            JPanel pnlTitle = new JPanel(new GridBagLayout());
            pnlTitle.setBackground(SystemColor.window);
            pnlTitle.add((Component)lblTitle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(7, 12, 0, 0), 0, 0));
            pnlTitle.add((Component)this.m_txtDescription, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 12, 7, 0), 0, 0));
            pnlTitle.add((Component)lblIcon, new GridBagConstraints(1, 0, 1, 2, 0.0, 1.0, 17, 3, new Insets(0, 12, 0, 0), 0, 0));
            this.setLayout(new GridBagLayout());
            this.add((Component)pnlTitle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JSeparator(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)cmp, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(12, 12, 13, 12), 0, 0));
            cmp.addPropertyChangeListener("description", new DescriptionChangeListener());
        }

        private class DescriptionChangeListener
        implements PropertyChangeListener {
            private DescriptionChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                cContentPage.this.m_txtDescription.setText((String)ev.getNewValue());
            }
        }
    }

    protected class cWizardButtonsPaneLayout
    implements LayoutManager {
        protected static final int cxSmallButtonGap = 7;
        protected static final int cxLargeButtonGap = 20;
        protected static final int cxTotalButtonGap = 67;
        private static final int wTinyButtonGap = 0;
        private static final int wLargeButtonGap = 14;
        private static final int wSmallButtonGap = 7;

        protected cWizardButtonsPaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int wTotalButtonGap = 67;
            int nButtons = 5;
            if (WAWizardDialog.isUsingNewStyle()) {
                if (!WAWizardDialog.this.canFinishEarly()) {
                    --nButtons;
                    wTotalButtonGap = 21;
                } else {
                    wTotalButtonGap = 35;
                }
            }
            Dimension dimButton = this.getPreferredButtonSize();
            Dimension dimLayout = new Dimension(dimButton.width * nButtons + wTotalButtonGap, dimButton.height);
            Insets insContainer = c.getInsets();
            dimLayout.width += insContainer.left + insContainer.right;
            dimLayout.height += insContainer.top + insContainer.bottom;
            return dimLayout;
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            Insets insContainer = c.getInsets();
            boolean bLeftToRight = WAWizardDialog.this.getComponentOrientation().isLeftToRight();
            int cxPanel = c.getWidth();
            Dimension dimButton = this.getPreferredButtonSize();
            int cxButton = dimButton.width;
            int cyButton = dimButton.height;
            if (!WAWizardDialog.isUsingNewStyle()) {
                int xBtn = bLeftToRight ? insContainer.left : cxPanel - insContainer.right - cxButton;
                WAWizardDialog.this.m_btnHelp.setBounds(xBtn, insContainer.top, cxButton, cyButton);
                xBtn = bLeftToRight ? cxPanel - insContainer.right - cxButton : insContainer.left;
                WAWizardDialog.this.m_btnFinish.setBounds(xBtn, insContainer.top, cxButton, cyButton);
                WAWizardDialog.this.m_btnNext.setBounds(xBtn += bLeftToRight ? -(cxButton + 20) : cxButton + 20, insContainer.top, cxButton, cyButton);
                WAWizardDialog.this.m_btnBack.setBounds(xBtn += bLeftToRight ? -(cxButton + 7) : cxButton + 7, insContainer.top, cxButton, cyButton);
                WAWizardDialog.this.m_btnCancel.setBounds(xBtn += bLeftToRight ? -(cxButton + 20) : cxButton + 20, insContainer.top, cxButton, cyButton);
            } else {
                int xBtn = bLeftToRight ? cxPanel - insContainer.right - cxButton : insContainer.left;
                WAWizardDialog.this.m_btnHelp.setBounds(xBtn, insContainer.top, cxButton, cyButton);
                WAWizardDialog.this.m_btnCancel.setBounds(xBtn += bLeftToRight ? -(cxButton + 7) : cxButton + 7, insContainer.top, cxButton, cyButton);
                WAWizardDialog.this.m_btnFinish.setBounds(xBtn += bLeftToRight ? -(cxButton + 14) : cxButton + 14, insContainer.top, cxButton, cyButton);
                if (WAWizardDialog.this.canFinishEarly()) {
                    xBtn += bLeftToRight ? -(cxButton + 14) : cxButton + 14;
                }
                WAWizardDialog.this.m_btnNext.setBounds(xBtn, insContainer.top, cxButton, cyButton);
                WAWizardDialog.this.m_btnBack.setBounds(xBtn += bLeftToRight ? -(cxButton + 0) : cxButton + 0, insContainer.top, cxButton, cyButton);
            }
        }

        protected Dimension getPreferredButtonSize() {
            cMaxDimension dim = new cMaxDimension(0, 0);
            dim.max(WAWizardDialog.this.m_btnHelp.getPreferredSize());
            dim.max(WAWizardDialog.this.m_btnNext.getPreferredSize());
            dim.max(WAWizardDialog.this.m_btnBack.getPreferredSize());
            dim.max(WAWizardDialog.this.m_btnFinish.getPreferredSize());
            dim.max(WAWizardDialog.this.m_btnCancel.getPreferredSize());
            return dim;
        }

        protected class cMaxDimension
        extends Dimension {
            private static final long serialVersionUID = 1L;

            public cMaxDimension(int Width, int Height) {
                super(Width, Height);
            }

            public void max(Dimension dim) {
                this.width = Math.max(this.width, dim.width);
                this.height = Math.max(this.height, dim.height);
            }
        }
    }

    protected class cWizardPanel
    extends WAPanel {
        private static final long serialVersionUID = 1L;
        protected JPanel m_pnlWizardPanes;
        protected JPanel m_pnlImages;
        protected CardLayout m_cardsWizardPanes;
        protected CardLayout m_cardsImages;
        protected JSeparator m_separator;

        public cWizardPanel() {
            this.initialize();
            this.layoutWidgets();
        }

        @Override
        protected void initialize() {
            this.m_pnlWizardPanes = new JPanel();
            this.m_cardsWizardPanes = new CardLayout();
            this.m_pnlWizardPanes.setLayout(this.m_cardsWizardPanes);
            if (!WAWizardDialog.isUsingNewStyle()) {
                this.m_pnlImages = new JPanel();
                this.m_cardsImages = new CardLayout();
                this.m_pnlImages.setLayout(this.m_cardsImages);
            }
            this.m_separator = new JSeparator();
        }

        @Override
        protected void layoutWidgets() {
            if (WAWizardDialog.isUsingNewStyle()) {
                this.setLayout(new BorderLayout());
                this.add(this.m_pnlWizardPanes);
                this.add((Component)this.m_separator, "South");
            } else {
                this.setLayout(new GridBagLayout());
                this.add((Component)this.m_pnlImages, new GridBagConstraints(0, 0, 1, 3, 0.0, 1.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this.m_pnlWizardPanes, new GridBagConstraints(1, 0, 3, 3, 1.0, 1.0, 18, 1, new Insets(0, 12, 0, 0), 0, 0));
                this.add((Component)this.m_separator, new GridBagConstraints(0, 3, 4, 1, 1.0, 0.0, 16, 1, new Insets(15, 0, 0, 0), 0, 0));
            }
        }

        public void addPanel(WizardTabInfo info) {
            if (WAWizardDialog.isUsingNewStyle()) {
                JPanel pnlPage;
                int eType;
                WAPropertyTab panel = info.getTab();
                String sDescr = null;
                if (panel instanceof WsDescriptionWizardTab) {
                    sDescr = ((WsDescriptionWizardTab)panel).getDescription();
                }
                if ((eType = panel.getWizardPageType()) == 0) {
                    pnlPage = new cIntroductionPage(panel, info.getTitle(), WAWizardDialog.this.getSidebarIcon());
                } else if (eType == 2) {
                    if (sDescr == null) {
                        sDescr = info.getTitle();
                    }
                    pnlPage = new cSummaryPage(panel, sDescr, WAWizardDialog.this.getSidebarIcon());
                } else {
                    pnlPage = new cContentPage(panel, info.getTitle(), sDescr, WAWizardDialog.this.getBannerIcon());
                }
                this.m_pnlWizardPanes.add((Component)pnlPage, info.getTabName());
                WAWizardDialog.this.addKeyListeners(panel, WAWizardDialog.this.m_KeyHandler);
            } else {
                JPanel panel;
                Icon image = info.getImage();
                if (image != null) {
                    JLabel lblImage = new JLabel(info.getImage());
                    JPanel pnlImage = new JPanel(new BorderLayout());
                    pnlImage.add((Component)lblImage, "Center");
                    this.m_pnlImages.add((Component)pnlImage, info.getImageName());
                    this.m_pnlImages.setBorder(BorderFactory.createBevelBorder(1));
                }
                if ((panel = info.getTab()) instanceof WsDescriptionWizardTab) {
                    panel = ((WsDescriptionWizardTab)panel).getRealPanel();
                }
                this.m_pnlWizardPanes.add((Component)panel, info.getTabName());
                WAWizardDialog.this.addKeyListeners(panel, WAWizardDialog.this.m_KeyHandler);
            }
        }

        public void showPanel(WizardTabInfo info) {
            this.m_cardsWizardPanes.show(this.m_pnlWizardPanes, info.getTabName());
            if (!WAWizardDialog.isUsingNewStyle() && info.getImageName() != null) {
                this.m_cardsImages.show(this.m_pnlImages, info.getImageName());
            }
        }

        @Override
        public boolean validateData() {
            return WAWizardDialog.this.m_WizardModel.getCurrent().getTab().validateData();
        }

        @Override
        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            if (bSaveToModel) {
                WizardTabInfo[] aoInfos = WAWizardDialog.this.m_WizardModel.getVisitedPanels();
                int nInfos = aoInfos.length;
                for (int iInfo = 0; iInfo < nInfos; ++iInfo) {
                    aoInfos[iInfo].getTab().doDataExchange(bSaveToModel);
                }
                if (WAWizardDialog.this.getWizardData("MASTEROBJECT") != null) {
                    WAWizardDialog.this.writeMetadata();
                }
            }
            return true;
        }

        @Override
        public void saveSettingsAndCleanUp() {
            WizardTabInfo[] aoInfos = WAWizardDialog.this.m_WizardModel.getVisitedPanels();
            int nInfos = aoInfos.length;
            for (int iInfo = 0; iInfo < nInfos; ++iInfo) {
                aoInfos[iInfo].getTab().saveSettingsAndCleanUp();
            }
        }

        @Override
        public ClassLoader getHelpClassLoader() {
            return WAWizardDialog.this.m_WizardModel.getCurrent().getTab().getHelpClassLoader();
        }

        @Override
        public String getHelpTopic() {
            return WAWizardDialog.this.m_WizardModel.getCurrent().getTab().getHelpTopic();
        }

        @Override
        public String getHelpProduct() {
            return WAWizardDialog.this.m_WizardModel.getCurrent().getTab().getHelpProduct();
        }

        @Override
        public Component getDefaultFocusComponent() {
            WAPropertyTab tab = WAWizardDialog.this.m_WizardModel.getCurrent().getTab();
            return CustomLayoutFocusTraversalPolicy.getDefaultFocusComponent(tab);
        }

        @Override
        public boolean canClose() {
            WAPropertyTab tab = WAWizardDialog.this.m_WizardModel.getCurrent().getTab();
            return tab.canClose();
        }

        @Override
        public void onParentOK() {
            this.cleanUpUnvisitedPanels();
        }

        @Override
        public void onParentCancel() {
            this.cleanUpUnvisitedPanels();
        }

        private void cleanUpUnvisitedPanels() {
            int i;
            if (WAWizardDialog.this.m_lTabsToCleanupOnCancel == null) {
                return;
            }
            WizardTabInfo[] aTabInfo = WAWizardDialog.this.m_WizardModel.getVisitedPanels();
            ArrayList<WAPropertyTab> aPropertyTabs = new ArrayList<WAPropertyTab>(aTabInfo.length);
            for (i = 0; i < aTabInfo.length; ++i) {
                aPropertyTabs.add(aTabInfo[i].getTab());
            }
            for (i = 0; i < WAWizardDialog.this.m_lTabsToCleanupOnCancel.size(); ++i) {
                WAPropertyTab propertyTab = (WAPropertyTab)WAWizardDialog.this.m_lTabsToCleanupOnCancel.get(i);
                if (aPropertyTabs.contains(propertyTab)) continue;
                propertyTab.saveSettingsAndCleanUp();
            }
        }
    }
}

