/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAUndoable;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public abstract class WATableModel
extends AbstractTableModel {
    protected ArrayList data = new ArrayList();
    protected ArrayList columnNames = new ArrayList();
    protected int instanceCount = 1;
    protected boolean undoFlag = false;
    protected boolean undoableSet = false;
    protected WAUndoable persistedUndo = null;
    protected boolean m_bStorePopulated;

    public void setStorePopulated(boolean bStorePopulated) {
        this.m_bStorePopulated = bStorePopulated;
    }

    public boolean isStorePopulated() {
        return this.m_bStorePopulated;
    }

    public String[] getColumnChoices(int col) {
        return new String[0];
    }

    public String[] getCellChoices(int row, int col) {
        return this.getColumnChoices(col);
    }

    public Class getColumnClass(int col) {
        if (this.data.size() > 0) {
            ArrayList member = (ArrayList)this.data.get(0);
            Object o = member.get(col);
            if (o != null) {
                return o.getClass();
            }
            return Object.class;
        }
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int col) {
        return (String)this.columnNames.get(col);
    }

    public int getCount() {
        return this.instanceCount;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            ArrayList member = (ArrayList)this.data.get(row);
            return member.get(col);
        }
        catch (IndexOutOfBoundsException iobe) {
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public ArrayList getDataVector() {
        return this.data;
    }

    public boolean insertBlankRow(int row) {
        ++row;
        ArrayList<Object> memberRow = new ArrayList<Object>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String[] choices = this.getColumnChoices(i);
            if (choices == null || choices.length == 0) {
                Object defaultObject = this.getDefaultObject(this.getColumnClass(i), i);
                memberRow.add(defaultObject);
                continue;
            }
            memberRow.add(choices[0]);
        }
        this.data.add(row, memberRow);
        ++this.instanceCount;
        this.fireTableRowsInserted(row, row);
        return true;
    }

    public void appendBlankRow() {
        ArrayList<Object> memberRow = new ArrayList<Object>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String[] choices = this.getColumnChoices(i);
            if (choices == null || choices.length == 0) {
                Object defaultObject = this.getDefaultObject(this.getColumnClass(i), i);
                memberRow.add(defaultObject);
                continue;
            }
            memberRow.add(choices[0]);
        }
        this.data.add(memberRow);
        ++this.instanceCount;
        this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
    }

    public boolean deleteRow(int row) {
        ArrayList delValue = (ArrayList)this.data.remove(row);
        this.fireTableRowDeleted(row, delValue);
        return true;
    }

    public void fireTableRowDeleted(int iRow, ArrayList alData) {
        this.fireTableChanged(new DeletedRowTableModelEvent(this, iRow, alData));
    }

    public void sync(Object[] oarray) {
        this.data.clear();
        for (int i = 0; i < oarray.length; ++i) {
            this.data.add(oarray[i]);
        }
        this.fireTableRowsUpdated(0, oarray.length - 1);
    }

    public WAUndoable undoableSetValueAt(Object o, int row, int col) {
        try {
            ArrayList member = (ArrayList)this.data.get(row);
            Object b = member.get(col);
            member.set(col, o);
            UndoableSet us = new UndoableSet(o, b, row, col);
            this.fireTableCellUpdated(row, col);
            return us;
        }
        catch (IndexOutOfBoundsException iobe) {
            return null;
        }
    }

    public WAUndoable undoableInsertBlankRow(int row) {
        if (row < this.data.size()) {
            ++row;
        }
        ArrayList<Object> memberRow = new ArrayList<Object>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String[] choices = this.getColumnChoices(i);
            if (choices == null || choices.length == 0) {
                Object defaultObject = this.getDefaultObject(this.getColumnClass(i), i);
                memberRow.add(defaultObject);
                continue;
            }
            memberRow.add(choices[0]);
        }
        this.data.add(row, memberRow);
        UndoableInsertRow wau = new UndoableInsertRow(memberRow, row);
        ++this.instanceCount;
        this.fireTableRowsInserted(row, row);
        return wau;
    }

    public WAUndoable undoableAppendBlankRow() {
        ArrayList<Object> memberRow = new ArrayList<Object>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String[] choices = this.getColumnChoices(i);
            if (choices == null || choices.length == 0) {
                Object defaultObject = this.getDefaultObject(this.getColumnClass(i), i);
                memberRow.add(defaultObject);
                continue;
            }
            memberRow.add(choices[0]);
        }
        this.data.add(memberRow);
        UndoableInsertRow wau = new UndoableInsertRow(memberRow, this.data.size() - 1);
        ++this.instanceCount;
        this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        return wau;
    }

    public WAUndoable undoableDeleteRow(int row) {
        ArrayList oldRow = (ArrayList)this.data.remove(row);
        UndoableDelete wau = new UndoableDelete(oldRow, row);
        this.fireTableRowDeleted(row, oldRow);
        return wau;
    }

    protected Object getDefaultObject(Class c, int col) {
        if (c == Integer.class) {
            return new Integer(0);
        }
        if (c == String.class) {
            return "Default";
        }
        if (c == Double.class) {
            return new Double(0.0);
        }
        if (c == Character.class) {
            return new Character(' ');
        }
        if (c == Float.class) {
            return new Float(0.0);
        }
        if (c == Boolean.class) {
            return new Boolean(true);
        }
        if (c == Long.class) {
            return new Long(0L);
        }
        if (c == Short.class) {
            short s = 0;
            return new Short(s);
        }
        return "";
    }

    public boolean getUndoableSet() {
        return this.undoableSet;
    }

    public void resetUndoableSet() {
        this.undoableSet = false;
    }

    public WAUndoable getPersistedUndo() {
        return this.persistedUndo;
    }

    public void resetPersistedUndo() {
        this.persistedUndo = null;
    }

    @Override
    public void setValueAt(Object a, int row, int col) {
        this.undoableSet = true;
        this.resetPersistedUndo();
        this.persistedUndo = this.undoableSetValueAt(a, row, col);
    }

    public boolean justUndid() {
        return this.undoFlag;
    }

    public void resetUndo() {
        this.undoFlag = false;
    }

    public class DeletedRowTableModelEvent
    extends TableModelEvent {
        private static final long serialVersionUID = 1L;
        ArrayList m_alData;

        public DeletedRowTableModelEvent(TableModel mdl, int iRow, ArrayList alData) {
            super(mdl, iRow, iRow, -1, -1);
            this.m_alData = alData;
        }

        public ArrayList getData() {
            return this.m_alData;
        }
    }

    public class UndoableInsertRow
    extends WAUndoable {
        private static final long serialVersionUID = 1L;
        ArrayList row = null;
        int index = 0;

        public UndoableInsertRow(ArrayList r, int i) {
            this.index = i;
            this.row = r;
        }

        @Override
        public void undo() {
            super.undo();
            WATableModel.this.data.remove(this.index);
            WATableModel.this.fireTableRowDeleted(this.index, this.row);
        }

        @Override
        public void redo() {
            super.redo();
            WATableModel.this.data.add(this.index, this.row);
            WATableModel.this.fireTableRowsInserted(this.index, this.index);
        }
    }

    public class UndoableSet
    extends WAUndoable {
        private static final long serialVersionUID = 1L;
        Object oldO = null;
        Object newO = null;
        int row = 0;
        int col = 0;

        public UndoableSet(Object n, Object o, int r, int c) {
            this.oldO = o;
            this.newO = n;
            this.row = r;
            this.col = c;
        }

        @Override
        public void undo() {
            super.undo();
            ArrayList m = (ArrayList)WATableModel.this.data.get(this.row);
            m.set(this.col, this.oldO);
            WATableModel.this.fireTableCellUpdated(this.row, this.col);
        }

        @Override
        public void redo() {
            super.redo();
            ArrayList m = (ArrayList)WATableModel.this.data.get(this.row);
            m.set(this.col, this.newO);
            WATableModel.this.fireTableCellUpdated(this.row, this.col);
        }

        public Object getOldValue() {
            return this.oldO;
        }

        public Object getNewValue() {
            return this.newO;
        }
    }

    public class UndoableDelete
    extends WAUndoable {
        private static final long serialVersionUID = 1L;
        ArrayList row = null;
        int i = 0;

        public UndoableDelete(ArrayList delRow, int index) {
            this.row = delRow;
            this.i = index;
        }

        @Override
        public void undo() {
            super.undo();
            WATableModel.this.undoFlag = true;
            WATableModel.this.data.add(this.i, this.row);
            WATableModel.this.fireTableRowsInserted(this.i, this.i);
        }

        @Override
        public void redo() {
            super.redo();
            WATableModel.this.data.remove(this.i);
            WATableModel.this.fireTableRowDeleted(this.i, this.row);
        }
    }
}

