/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WATable;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.table.TableColumn;

public class WATableMenu
extends JPopupMenu
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WATableMenu.class);
    JMenu subMenu = null;
    JLabel hideLabel = null;
    JLabel menuLabel = null;
    TableMenuItem cb = new TableMenuItem(bundle.getString("WATable.hideSel.txt"));
    JLabel sortLabel = null;
    Point currentPoint = null;
    WATable parent = null;
    boolean hide = true;
    ArrayList hidden = null;

    public WATableMenu(WATable _parent) {
        super(bundle.getString("WATable.tableactions.txt"));
        this.cb.setMnemonic(bundle.getString("WATable.hideSel.mnem").charAt(0));
        this.cb.setActionCommand("hideCol");
        this.cb.addActionListener(this);
        this.add(this.cb);
        this.subMenu = new JMenu(bundle.getString("WATableMenu.show.txt"));
        this.subMenu.setMnemonic(bundle.getString("WATableMenu.show.mnem").charAt(0));
        this.add(this.subMenu);
        this.addSeparator();
        this.cb = new TableMenuItem(bundle.getString("WATable.showAll.txt"));
        this.cb.setMnemonic(bundle.getString("WATable.showAll.mnem").charAt(0));
        this.cb.setActionCommand("showAll");
        this.cb.addActionListener(this);
        this.cb.setEnabled(false);
        this.subMenu.add(this.cb);
        this.cb = new TableMenuItem(bundle.getString("WATable.ascend.txt"));
        this.cb.setMnemonic(bundle.getString("WATable.ascend.mnem").charAt(0));
        this.cb.setActionCommand("sortAscend");
        this.cb.addActionListener(this);
        this.add(this.cb);
        this.cb = new TableMenuItem(bundle.getString("WATable.descend.txt"));
        this.cb.setMnemonic(bundle.getString("WATable.descend.mnem").charAt(0));
        this.cb.setActionCommand("sortDescend");
        this.cb.addActionListener(this);
        this.add(this.cb);
        this.cb = new TableMenuItem(bundle.getString("WATable.original.txt"));
        this.cb.setMnemonic(bundle.getString("WATable.original.mnem").charAt(0));
        this.cb.setActionCommand("revert");
        this.cb.addActionListener(this);
        this.add(this.cb);
        this.parent = _parent;
    }

    public void postPopup(int x, int y) {
        this.currentPoint = new Point(x, y);
        JViewport view = null;
        JViewport jvp = (JViewport)this.parent.getParent();
        JScrollPane jsp = (JScrollPane)jvp.getParent();
        view = jsp.getColumnHeader();
        if (view instanceof JViewport) {
            Point cornerPoint = view.getViewPosition();
            Point transPoint = view.toViewCoordinates(this.currentPoint);
            int x_prime = Math.abs(transPoint.x - cornerPoint.x);
            this.show(view, x_prime, this.currentPoint.y);
        } else {
            this.show(this.parent, x, y);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int columnNum = -1;
        columnNum = this.parent.getColumnModel().getColumnIndexAtX(this.currentPoint.x);
        TableColumn tmp = this.parent.getColumnModel().getColumn(columnNum);
        int idx = tmp.getModelIndex();
        if (e.getActionCommand().equals("hideCol")) {
            this.cb = new TableMenuItem((String)this.parent.getColumnModel().getColumn(columnNum).getHeaderValue());
            this.parent.hideColumn(idx);
            this.cb.setActionCommand("unhideCol");
            this.cb.addActionListener(this);
            this.cb.setId(idx);
            this.subMenu.add((Component)this.cb, 0);
            this.subMenu.getItem(this.subMenu.getItemCount() - 1).setEnabled(true);
            if (this.parent.getColumnCount() == 1) {
                ((TableMenuItem)this.getComponent(0)).setEnabled(false);
            }
        } else if (e.getActionCommand().equals("unhideCol")) {
            TableMenuItem f = (TableMenuItem)e.getSource();
            int id = f.getId();
            int pos = this.subMenu.getPopupMenu().getComponentIndex(f);
            this.parent.unhideColumn(id, columnNum);
            ((TableMenuItem)this.getComponent(0)).setEnabled(true);
            this.subMenu.remove(pos);
            if (this.subMenu.getItemCount() == 1) {
                this.subMenu.getItem(this.subMenu.getItemCount() - 1).setEnabled(false);
            }
        } else if (e.getActionCommand().equals("showAll")) {
            int k = this.subMenu.getItemCount();
            for (int i = k - 2; i >= 0; --i) {
                TableMenuItem f = (TableMenuItem)this.subMenu.getItem(i);
                int id = f.getId();
                int pos = this.subMenu.getPopupMenu().getComponentIndex(f);
                this.parent.unhideColumn(id);
                this.subMenu.remove(pos);
            }
            this.subMenu.getItem(0).setEnabled(false);
            ((TableMenuItem)this.getComponent(0)).setEnabled(true);
        } else if (e.getActionCommand().equals("sortAscend")) {
            this.parent.sort(idx, true);
        } else if (e.getActionCommand().equals("sortDescend")) {
            this.parent.sort(idx, false);
        } else if (e.getActionCommand().equals("revert")) {
            this.parent.revert();
        }
    }

    public void addHiddenColumn(TableColumn foo, int index) {
        this.cb = new TableMenuItem((String)foo.getHeaderValue());
        this.cb.setActionCommand("unhideCol");
        this.cb.addActionListener(this);
        this.cb.setId(index);
        this.subMenu.add((Component)this.cb, 0);
        this.subMenu.getItem(this.subMenu.getItemCount() - 1).setEnabled(true);
        if (this.parent.getColumnCount() == 1) {
            ((TableMenuItem)this.getComponent(0)).setEnabled(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.postPopup(e.getX(), e.getY());
        }
    }

    class TableMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        int u_id;
        int pos;

        public TableMenuItem(String s) {
            super(s);
            this.u_id = -1;
            this.pos = -1;
        }

        public int getPos() {
            return this.pos;
        }

        public void setPos(int i) {
            this.pos = i;
        }

        public int getId() {
            return this.u_id;
        }

        public void setId(int i) {
            this.u_id = i;
        }
    }
}

