/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.IndexTableSorter;
import com.sas.workspace.WAColumnModelListener;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAHMAdapter;
import com.sas.workspace.WAHeaderMouse;
import com.sas.workspace.WAKeyAdapter;
import com.sas.workspace.WARowTable;
import com.sas.workspace.WATableCellRenderer;
import com.sas.workspace.WATableChangeListener;
import com.sas.workspace.WATableMenu;
import com.sas.workspace.WATableModel;
import com.sas.workspace.WATableUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class WATable
extends JTable
implements FocusListener {
    private static final long serialVersionUID = 1L;
    protected IndexTableSorter sorter = null;
    WARowTable rowTable = null;
    boolean displayRows = false;
    boolean renumber = false;
    WATableModel realModel = null;
    protected DefaultTableColumnModel hiddenColumns = new DefaultTableColumnModel();
    static final int MOUSE_TOLERANCE = 10;
    private boolean sortFlag = true;
    boolean tabFlag = false;
    boolean editFlag = false;
    boolean noEditFocusListener = false;
    private boolean changeInsert = false;
    private boolean changeDelete = false;
    protected boolean m_bEditable = true;
    int delRow = -1;
    int insRow = -1;
    DefaultIDBehavior didb = null;
    WATableMenu watcm = null;
    WAKeyAdapter waka = null;
    WAHMAdapter wahma = null;
    EditFocusListener efl = null;
    int toolTipColumn = -1;

    public WATable(WATableModel m) {
        this(m, false, true, 4);
    }

    public WATable(WATableModel m, boolean rows) {
        this(m, rows, true, 4);
    }

    public WATable(WATableModel m, boolean rows, boolean sorting) {
        this(m, rows, sorting, 4);
    }

    public WATable(WATableModel m, int maxCols) {
        this(m, false, true, maxCols);
    }

    public WATable(WATableModel m, boolean rows, int maxCols) {
        this(m, rows, true, 4);
    }

    public WATable(WATableModel m, boolean rows, boolean sorting, int maxCols) {
        super(m);
        this.sortFlag = sorting;
        this.realModel = m;
        this.sorter = new IndexTableSorter(m);
        if (this.sortFlag) {
            this.sorter.addMouseListenerToHeaderInTable(this);
        }
        super.setModel(this.sorter);
        this.setShowGrid(true);
        final int maxWidth = Math.max(35, maxCols * 9);
        DefaultTableColumnModel rm = new DefaultTableColumnModel(){
            private static final long serialVersionUID = 1L;
            boolean first = true;

            @Override
            public void addColumn(TableColumn tc) {
                if (this.first) {
                    tc.setMaxWidth(maxWidth);
                    tc.setPreferredWidth(maxWidth);
                    tc.setResizable(false);
                    super.addColumn(tc);
                    this.first = false;
                }
            }
        };
        this.rowTable = new WARowTable((TableModel)this.sorter, (TableColumnModel)rm, this);
        this.rowTable.createDefaultColumnsFromModel();
        this.setSelectionModel(this.rowTable.getSelectionModel());
        this.rowTable.setupRenderer();
        this.setUI(new WATableUI(this.rowTable));
        this.setDefaultRenderer(Object.class, new WATableCellRenderer());
        this.setDefaultRenderer(Integer.class, new WATableCellRenderer());
        if (this.sortFlag) {
            this.sorter.addMouseListenerToRowHeaderInTable(this.rowTable);
        }
        this.createColumnComboBox();
        this.setDefaultEditBehavior(1);
        this.waka = new WAKeyAdapter(this);
        this.addKeyListener(this.waka);
        this.didb = new DefaultIDBehavior();
        m.addTableModelListener(this.didb);
        this.getColumnModel().addColumnModelListener(new WAColumnModelListener(this));
        this.getTableHeader().addMouseMotionListener(new WAHeaderMouse(this));
        this.setCellSelectionEnabled(true);
        this.displayRows = rows;
        this.addFocusListener(this);
        this.sorter.addTableModelListener(new SortMonitor());
    }

    protected WATable() {
    }

    public void setNoEditFocusListener(boolean f) {
        this.noEditFocusListener = f;
    }

    public boolean getNoEditFocusListener() {
        return this.noEditFocusListener;
    }

    public boolean getRenumber() {
        return this.renumber;
    }

    public void setEditable(boolean bEditable) {
        this.m_bEditable = bEditable;
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    public void enableDefaultKeyTraversal(boolean f) {
        if (f) {
            if (this.waka == null) {
                this.waka = new WAKeyAdapter(this);
            }
            this.addKeyListener(this.waka);
        } else {
            if (this.waka == null) {
                return;
            }
            this.removeKeyListener(this.waka);
        }
    }

    public void enableHeaderMenu(boolean f) {
        if (f) {
            if (this.watcm == null) {
                this.watcm = new WATableMenu(this);
            }
            this.getTableHeader().addMouseListener(this.watcm);
        } else {
            if (this.watcm == null) {
                return;
            }
            this.getTableHeader().removeMouseListener(this.watcm);
        }
    }

    public void enableSorting(boolean f) {
        if (f) {
            this.sorter.addMouseListenerToHeaderInTable(this);
            this.sorter.addMouseListenerToRowHeaderInTable(this.rowTable);
        } else {
            this.sorter.removeMouseListenerFromHeaderInTable(this);
            this.sorter.removeMouseListenerFromRowHeaderInTable(this.rowTable);
            this.rowTable.setColumnSelectionAllowed(true);
        }
    }

    public void enableWAInsertDeleteBehavior(boolean f) {
        if (f) {
            if (this.didb == null) {
                this.didb = new DefaultIDBehavior();
            }
            this.realModel.addTableModelListener(this.didb);
        } else {
            this.realModel.removeTableModelListener(this.didb);
        }
    }

    public void enableHeaderColumnSelection(boolean f) {
        if (f) {
            if (this.wahma == null) {
                this.wahma = new WAHMAdapter(this);
            }
            JTableHeader jth = this.getTableHeader();
            jth.removeMouseListener(this.wahma);
            jth.addMouseListener(this.wahma);
        } else if (this.wahma != null) {
            JTableHeader jth = this.getTableHeader();
            jth.removeMouseListener(this.wahma);
            this.wahma = null;
        }
    }

    public WATableMenu getHeaderMenu() {
        return this.watcm;
    }

    @Override
    public boolean isFocusable() {
        if (this.getRowCount() == 0) {
            return false;
        }
        this.tabFlag = true;
        return true;
    }

    @Override
    public boolean isRequestFocusEnabled() {
        return this.getRowCount() > 0 && super.isRequestFocusEnabled();
    }

    public ActionMap getRowTableActionMap() {
        if (this.rowTable != null) {
            return this.rowTable.getActionMap();
        }
        return null;
    }

    public InputMap getRowTableInputMap() {
        if (this.rowTable != null) {
            return this.rowTable.getInputMap();
        }
        return null;
    }

    public void sort(int index, boolean direction) {
        this.sorter.sortByColumn(index, direction);
    }

    public void revert() {
        this.sorter.revert();
    }

    public boolean orderChanged() {
        if (this.sorter != null) {
            return this.sorter.getChangeFlag();
        }
        return false;
    }

    public void setOrderChanged(boolean f) {
        if (this.sorter != null) {
            this.sorter.setChangeFlag(f);
        }
    }

    @Override
    public void setColumnSelectionAllowed(boolean f) {
        super.setColumnSelectionAllowed(f);
        if (this.rowTable != null && f) {
            this.rowTable.setColumnSelectionFlag(f);
        }
    }

    public void setDefaultEditBehavior(int numClicksToStart) {
        DefaultCellEditor dce = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableCellEditor tce = this.getCellEditor(0, i);
            if (!(tce instanceof DefaultCellEditor) || (dce = (DefaultCellEditor)tce) == null) continue;
            dce.setClickCountToStart(numClicksToStart);
        }
    }

    public void autoResizeColumns(boolean colHeader, boolean colCells, boolean rowHeader) {
        TableCellRenderer cRender;
        int width;
        int i;
        TableColumn column = null;
        Component comp = null;
        int cols = this.getColumnCount();
        int rows = this.getRowCount();
        for (i = 0; i < cols; ++i) {
            width = -1;
            column = this.getTableHeader().getColumnModel().getColumn(i);
            if (colHeader && (cRender = this.getTableHeader().getDefaultRenderer()) != null && (comp = cRender.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, 0)) != null) {
                width = Math.max(width, comp.getPreferredSize().width);
            }
            if (colCells && this.sorter.getColumnClass(i) != null) {
                for (int j = 0; j < rows; ++j) {
                    cRender = column.getCellRenderer();
                    if (cRender == null || (comp = cRender.getTableCellRendererComponent(this, this.sorter.getValueAt(j, i), false, false, j, i)) == null) continue;
                    width = Math.max(width, comp.getPreferredSize().width);
                }
            }
            if (width <= -1) continue;
            column.setPreferredWidth(width + this.getColumnModel().getColumnMargin() + 6);
        }
        if (rowHeader) {
            width = -1;
            cRender = this.rowTable.getDefaultRenderer(this.rowTable.getModel().getColumnClass(0));
            for (i = 0; i < rows && cRender != null; ++i) {
                comp = cRender.getTableCellRendererComponent(this.rowTable, this.getModel().getValueAt(i, 0), false, false, i, 0);
                if (comp == null) continue;
                width = Math.max(width, comp.getPreferredSize().width);
            }
            if (width > -1) {
                this.rowTable.getColumnModel().getColumn(0).setPreferredWidth(width + this.getColumnModel().getColumnMargin() + 6);
            }
        }
        this.repaint();
    }

    public void setRowMouseListener(MouseListener l) {
        this.rowTable.addMouseListener(l);
    }

    public void setRowHeaderWidth(int width) {
        this.rowTable.getColumnModel().getColumn(0).setPreferredWidth(width);
    }

    public int moveRow(int row, int targetRow) {
        return this.sorter.moveRow(row, targetRow);
    }

    public void setModel(WATableModel m) {
        if (this.sorter == null) {
            this.sorter = new IndexTableSorter(m);
        } else {
            this.sorter.setModel(m);
        }
    }

    @Override
    public TableModel getModel() {
        if (this.sorter == null) {
            return super.getModel();
        }
        return this.sorter.getModel();
    }

    public WATableModel getSorter() {
        return this.sorter;
    }

    @Override
    public int convertRowIndexToModel(int i) {
        if (this.sorter != null) {
            return this.sorter.getRowIndex(i);
        }
        return i;
    }

    @Override
    public int convertRowIndexToView(int i) {
        if (i < 0) {
            return i;
        }
        for (int k = 0; k < this.sorter.getRowCount(); ++k) {
            int j = this.sorter.getRowIndex(k);
            if (j != i) continue;
            return k;
        }
        return -1;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.sorter != null) {
            return this.sorter.getValueAt(row, this.convertColumnIndexToModel(col));
        }
        return super.getModel().getValueAt(row, col);
    }

    @Override
    public void setValueAt(Object o, int row, int col) {
        if (this.sorter != null) {
            this.sorter.setValueAt(o, row, this.convertColumnIndexToModel(col));
        } else {
            super.getModel().setValueAt(o, row, col);
        }
    }

    @Override
    public boolean isCellEditable(int iRow, int iCol) {
        if (!this.m_bEditable) {
            return false;
        }
        if (this.sorter != null) {
            return this.sorter.isCellEditable(iRow, iCol);
        }
        return this.getModel().isCellEditable(iRow, iCol);
    }

    @Override
    public int getSelectedRow() {
        int j = 0;
        int i = super.getSelectedRow();
        j = i > -1 ? this.sorter.getRowIndex(i) : i;
        return j;
    }

    @Override
    public int[] getSelectedRows() {
        int[] sels = super.getSelectedRows();
        int[] realSels = new int[sels.length];
        for (int i = 0; i < sels.length; ++i) {
            realSels[i] = this.sorter.getRowIndex(sels[i]);
        }
        return realSels;
    }

    public ArrayList getHiddenColumns() {
        ArrayList<TableColumn> hc = new ArrayList<TableColumn>();
        for (int i = 0; i < this.hiddenColumns.getColumnCount(); ++i) {
            hc.add(this.hiddenColumns.getColumn(i));
        }
        return hc;
    }

    public void hideColumns(Vector cols) {
        TableColumnModel tableList = this.getColumnModel();
        block0: for (int i = 0; i < cols.size(); ++i) {
            int index = cols.get(i) instanceof Integer ? (Integer)cols.get(i) : -1;
            for (int j = 0; j < tableList.getColumnCount(); ++j) {
                TableColumn col = tableList.getColumn(j);
                if (col.getModelIndex() != index) continue;
                tableList.removeColumn(col);
                this.hiddenColumns.addColumn(col);
                continue block0;
            }
        }
    }

    public void hideColumn(int col) {
        TableColumnModel tableList = this.getColumnModel();
        for (int i = 0; i < tableList.getColumnCount(); ++i) {
            TableColumn column = tableList.getColumn(i);
            if (column.getModelIndex() != col) continue;
            tableList.removeColumn(column);
            this.hiddenColumns.addColumn(column);
            break;
        }
    }

    public void unhideColumns(Vector cols) {
        TableColumnModel tableList = this.getColumnModel();
        block0: for (int i = 0; i < cols.size(); ++i) {
            int index = cols.get(i) instanceof Integer ? (Integer)cols.get(i) : -1;
            for (int j = 0; j < this.hiddenColumns.getColumnCount(); ++j) {
                TableColumn col = this.hiddenColumns.getColumn(j);
                if (col.getModelIndex() != index) continue;
                this.hiddenColumns.removeColumn(col);
                tableList.addColumn(col);
                continue block0;
            }
        }
    }

    public void unhideColumn(int col) {
        TableColumnModel tableList = this.getColumnModel();
        for (int i = 0; i < this.hiddenColumns.getColumnCount(); ++i) {
            TableColumn column = this.hiddenColumns.getColumn(i);
            if (column.getModelIndex() != col) continue;
            this.hiddenColumns.removeColumn(column);
            tableList.addColumn(column);
            tableList.moveColumn(tableList.getColumnCount() - 1, 0);
            break;
        }
    }

    public void unhideColumn(int col, int pos) {
        boolean allCols = false;
        int[] sRows = this.getSelectedRows();
        int[] sCols = this.getSelectedColumns();
        if (sRows.length > 0 && sCols.length == this.getColumnCount()) {
            allCols = true;
        }
        TableColumnModel tableList = this.getColumnModel();
        for (int i = 0; i < this.hiddenColumns.getColumnCount(); ++i) {
            TableColumn column = this.hiddenColumns.getColumn(i);
            if (column.getModelIndex() != col) continue;
            this.hiddenColumns.removeColumn(column);
            tableList.addColumn(column);
            tableList.moveColumn(tableList.getColumnCount() - 1, pos);
            break;
        }
        if (allCols) {
            this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
        }
    }

    public void displayRowNumbers(JScrollPane p) {
        JViewport jv = new JViewport();
        jv.setView(this.rowTable);
        jv.setBackground(Color.white);
        jv.setForeground(Color.white);
        jv.setPreferredSize(this.rowTable.getMaximumSize());
        this.rowTable.setAutoResizeMode(0);
        p.setRowHeader(jv);
        this.displayRows = true;
    }

    public void setRowRenumber(boolean flag) {
        this.renumber = flag;
    }

    public boolean getRowRenumber() {
        return this.renumber;
    }

    public void setToolTipColumn(int columnNumber) {
        this.toolTipColumn = columnNumber;
    }

    public int getToolTipColumn() {
        return this.toolTipColumn;
    }

    public boolean editCellAt(int r, int c, boolean f) {
        boolean t = super.editCellAt(r, c, null);
        if (f && t) {
            Component comp = this.getEditorComponent();
            this.changeSelection(r, c, false, false);
            if (this.efl == null) {
                this.efl = new EditFocusListener();
            }
            comp.removeFocusListener(this.efl);
            comp.addFocusListener(this.efl);
            if (comp instanceof JTextField) {
                ((JTextField)comp).requestFocus();
                ((JTextField)comp).selectAll();
            }
        }
        return t;
    }

    @Override
    public boolean editCellAt(int r, int c) {
        return this.editCellAt(r, c, null);
    }

    @Override
    public boolean editCellAt(int r, int c, EventObject e) {
        this.editFlag = true;
        boolean f = super.editCellAt(r, c, e);
        if (f) {
            Component comp = this.getEditorComponent();
            this.changeSelection(r, c, false, false);
            comp.requestFocus();
            if (this.efl == null) {
                this.efl = new EditFocusListener();
            }
            comp.removeFocusListener(this.efl);
            comp.addFocusListener(this.efl);
            if (comp instanceof JTextField) {
                ((JTextField)comp).requestFocus();
                ((JTextField)comp).selectAll();
            }
        }
        return f;
    }

    public void setRowRenderer(TableCellRenderer tcr) {
        TableColumn t = this.rowTable.getColumnModel().getColumn(0);
        t.setCellRenderer(tcr);
    }

    public void rowMouseDrag(MouseEvent e) {
        Container grandParent;
        Container parent = this.getParent();
        if (parent instanceof JViewport && (grandParent = parent.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)grandParent;
            JScrollBar vertBar = scrollPane.getVerticalScrollBar();
            if (vertBar != null && e.getY() < vertBar.getValue() + 10) {
                vertBar.setValue(vertBar.getValue() - vertBar.getUnitIncrement(-1));
            }
            if (vertBar != null && e.getY() > vertBar.getValue() + parent.getBounds().height - 10) {
                vertBar.setValue(vertBar.getValue() + vertBar.getUnitIncrement(1));
            }
        }
    }

    public int buildColumnsMask() {
        int mask = 0;
        Enumeration<TableColumn> columns = this.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn c = columns.nextElement();
            String id = (String)c.getIdentifier();
            for (int i = 1; i <= this.sorter.getColumnCount(); ++i) {
                if (!id.equals(this.sorter.getColumnName(i - 1))) continue;
                Integer y = new Integer(i - 1);
                Double res = new Double(Math.pow(2.0, y.doubleValue()));
                mask |= res.intValue();
            }
        }
        return mask;
    }

    public void parseColumnsMask(int mask) {
        WATableMenu watcm1 = this.getHeaderMenu();
        if (watcm1 == null) {
            return;
        }
        TableColumn foo = null;
        for (int i = this.getColumnCount(); i > 0; --i) {
            int k = 0;
            Integer x = new Integer(i - 1);
            Double res = new Double(Math.pow(2.0, x.doubleValue()));
            k = res.intValue();
            if ((mask & k) != 0) continue;
            foo = this.getColumnModel().getColumn(i - 1);
            this.hideColumn(i - 1);
            watcm1.addHiddenColumn(foo, i - 1);
        }
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        Component c = this.getEditorComponent();
        if (c != null && this.efl != null) {
            c.removeFocusListener(this.efl);
        }
        super.editingStopped(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.tabFlag = false;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.getRowCount() > 0 && this.tabFlag && !this.editFlag && this.getSelectedRow() == -1) {
            this.changeSelection(0, 0, false, false);
        }
        this.tabFlag = false;
        this.editFlag = false;
    }

    public void setChangeInsert(boolean i) {
        this.changeInsert = i;
    }

    public boolean getChangeInsert() {
        return this.changeInsert;
    }

    public void setChangeDelete(boolean i) {
        this.changeDelete = i;
    }

    public boolean getChangeDelete() {
        return this.changeDelete;
    }

    public int getInsRow() {
        return this.insRow;
    }

    public void setInsRow(int i) {
        this.insRow = i;
    }

    public void setDelRow(int i) {
        this.delRow = i;
    }

    public int getDelRow() {
        return this.delRow;
    }

    protected void mouseDrag(MouseEvent e) {
        Container grandParent;
        Container parent = this.getParent();
        if (parent instanceof JViewport && (grandParent = parent.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)grandParent;
            JScrollBar horzBar = scrollPane.getHorizontalScrollBar();
            JScrollBar vertBar = scrollPane.getVerticalScrollBar();
            if (vertBar != null && e.getY() < vertBar.getValue() + 10) {
                vertBar.setValue(vertBar.getValue() - vertBar.getUnitIncrement(-1));
            }
            if (vertBar != null && e.getY() > vertBar.getValue() + parent.getBounds().height - 10) {
                vertBar.setValue(vertBar.getValue() + vertBar.getUnitIncrement(1));
            }
            if (horzBar != null && e.getX() < horzBar.getValue() + 10) {
                horzBar.setValue(horzBar.getValue() - horzBar.getUnitIncrement(-1));
            }
            if (horzBar != null && e.getX() > horzBar.getValue() + parent.getBounds().width - 10) {
                horzBar.setValue(horzBar.getValue() + horzBar.getUnitIncrement(1));
            }
        }
    }

    protected void createColumnComboBox() {
        this.efl = new EditFocusListener();
        WATableModel dm = (WATableModel)this.getModel();
        for (int i = 0; i < dm.getColumnCount(); ++i) {
            Object[] choices = dm.getColumnChoices(i);
            if (choices.length <= 0) continue;
            WAComboBox cb = new WAComboBox(choices);
            cb.addFocusListener(this.efl);
            cb.setEditable(false);
            this.getColumnModel().getColumn(i).setCellEditor(new DefaultCellEditor(cb));
        }
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            Border border;
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            scrollPane.setColumnHeaderView(this.getTableHeader());
            viewport.addChangeListener(new WATableChangeListener(this));
            if (this.displayRows) {
                JViewport jv = new JViewport();
                jv.setView(this.rowTable);
                jv.setBackground(Color.white);
                jv.setForeground(Color.white);
                jv.addChangeListener(new WATableChangeListener(this.rowTable));
                jv.setPreferredSize(this.rowTable.getMaximumSize());
                this.rowTable.setAutoResizeMode(0);
                scrollPane.setRowHeader(jv);
                scrollPane.setCorner("UPPER_LEFT_CORNER", this.rowTable.getTableHeader());
            }
            if ((border = scrollPane.getBorder()) == null || border instanceof UIResource) {
                scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
            viewport.setBackground(Color.white);
            viewport.setForeground(Color.white);
            scrollPane.addMouseListener(new PaneListener());
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        InputMap map = this.getInputMap(condition);
        ActionMap am = this.getActionMap();
        if (map != null && am != null && this.isEnabled()) {
            Action action;
            Object binding = map.get(ks);
            Action action2 = action = binding == null ? null : am.get(binding);
            if (action != null) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        }
        if (e.getModifiers() > 0 && e.getKeyCode() > 0) {
            return false;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    @Override
    public void removeEditor() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.removeCellEditorListener(this);
            if (this.editorComp != null) {
                if (this.editorComp.hasFocus()) {
                    this.requestFocus();
                }
            } else {
                this.requestFocus();
            }
            if (this.editorComp != null) {
                this.remove(this.editorComp);
            }
            Rectangle cellRect = this.getCellRect(this.editingRow, this.editingColumn, false);
            this.setCellEditor(null);
            this.setEditingColumn(-1);
            this.setEditingRow(-1);
            this.editorComp = null;
            this.repaint(cellRect);
        }
    }

    class SortMonitor
    implements TableModelListener {
        SortMonitor() {
        }

        @Override
        public void tableChanged(TableModelEvent tme) {
            int i = 0;
            int[] r = WATable.this.sorter.getRowRange();
            int[] c = WATable.this.sorter.getColumnRange();
            if (r != null && r.length > 0) {
                WATable.this.clearSelection();
                for (i = 0; i < r.length; ++i) {
                    WATable.this.addRowSelectionInterval(WATable.this.convertRowIndexToView(r[i]), WATable.this.convertRowIndexToView(r[i]));
                }
                WATable.this.sorter.setRowRange(null);
            }
            if (c != null && c.length > 0) {
                WATable.this.setColumnSelectionInterval(WATable.this.convertColumnIndexToView(c[0]), WATable.this.convertColumnIndexToView(c[c.length - 1]));
                WATable.this.sorter.setColumnRange(null);
            }
        }
    }

    class PaneListener
    extends MouseAdapter {
        PaneListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point p = e.getPoint();
            int row = WATable.this.rowAtPoint(p);
            int column = WATable.this.columnAtPoint(p);
            if (row == -1 || column == -1) {
                WATable.this.clearSelection();
            }
        }
    }

    class DefaultIDBehavior
    implements TableModelListener {
        DefaultIDBehavior() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            switch (e.getType()) {
                case -1: {
                    int j = e.getFirstRow();
                    int k = e.getLastRow();
                    int jk = Math.max(j, k);
                    WATable.this.delRow = WATable.this.convertRowIndexToView(jk);
                    if (WATable.this.delRow == -1 || WATable.this.delRow >= WATable.this.getRowCount()) {
                        WATable.this.delRow = WATable.this.getRowCount() - 1;
                    }
                    WATable.this.changeDelete = true;
                    break;
                }
                case 1: {
                    int jk;
                    WATable.this.changeInsert = true;
                    int j = e.getFirstRow();
                    int k = e.getLastRow();
                    if (j != k) {
                        WATable.this.changeInsert = false;
                        break;
                    }
                    WATable.this.insRow = jk = Math.min(j, k);
                    break;
                }
                case 0: {
                    if (e.getColumn() < 0 || e.getFirstRow() != e.getLastRow()) break;
                    int c = e.getColumn();
                    int r = e.getFirstRow();
                    WATable.this.requestFocus();
                    r = WATable.this.convertRowIndexToView(r);
                    c = WATable.this.convertColumnIndexToView(c);
                    if (r > -1 && r < WATable.this.getRowCount()) {
                        WATable.this.setRowSelectionInterval(r, r);
                    }
                    if (c >= WATable.this.getColumnCount() || c <= -1) break;
                    WATable.this.setColumnSelectionInterval(c, c);
                }
            }
        }
    }

    class EditFocusListener
    implements FocusListener {
        EditFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            WATable.this.editFlag = true;
        }

        @Override
        public void focusGained(FocusEvent e) {
            WATable.this.editFlag = true;
        }
    }
}

