/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreListener;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataUtil;
import java.awt.Dialog;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.Icon;

public class WAPropertyDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WAPropertyDialog.class);
    public static final String RefreshViewsProperty = "RefreshViews";
    public static final int AlwaysRefreshViews = 0;
    public static final int PromptForRefreshViews = 1;
    public static final int NeverRefreshViews = 2;
    protected CMetadata m_oMetadata;
    protected MdObjectStore m_oStore;
    private MetadataInterface m_stupidObject;
    protected WATabbedPanel m_pnlTabs = this.createMainPanel();
    protected VetoableChangeListener m_lsnrVetoableChanges;
    protected MdStoreListener m_lsnrStoreChanges;
    protected boolean m_bUpdateToServer = true;

    public WAPropertyDialog(Dialog Owner) {
        this(Owner, "", false);
    }

    public WAPropertyDialog(Dialog Owner, boolean bModal) {
        this(Owner, "", bModal);
    }

    public WAPropertyDialog(Dialog Owner, String sTitle) {
        this(Owner, sTitle, false);
    }

    public WAPropertyDialog(Dialog Owner, String sTitle, boolean bModal) {
        super(Owner, sTitle, bModal);
        this.setMainPanel(this.m_pnlTabs);
        this.m_lsnrVetoableChanges = this.createVetoableChangeListener();
    }

    public WAPropertyDialog(Frame owner) {
        this(owner, "", false);
    }

    public WAPropertyDialog(Frame Owner, boolean bModal) {
        this(Owner, "", bModal);
    }

    public WAPropertyDialog(Frame Owner, String sTitle) {
        this(Owner, sTitle, false);
    }

    public WAPropertyDialog(Frame Owner, String sTitle, boolean bModal) {
        super(Owner, sTitle, bModal);
        this.setMainPanel(this.m_pnlTabs);
        this.m_lsnrVetoableChanges = this.createVetoableChangeListener();
    }

    @Override
    public void setMainPanel(WAPanel pnlMain) {
        super.setMainPanel(pnlMain);
        if (pnlMain instanceof WATabbedPanel) {
            this.m_pnlTabs = (WATabbedPanel)pnlMain;
        }
    }

    protected WATabbedPanel createMainPanel() {
        return new WATabbedPanel();
    }

    public void addTab(WAPropertyTab tab) {
        this.addTab(tab.getName(), null, tab, null);
    }

    public void addTab(String sTitle, WAPropertyTab tab) {
        this.addTab(sTitle, null, tab, null);
    }

    public void addTab(String sTitle, Icon icon, WAPropertyTab tab, String sToolTipText) {
        this.addKeyListeners(tab, this.m_KeyHandler);
        this.m_pnlTabs.addTab(sTitle, icon, tab, sToolTipText);
        tab.setEditable(this.isEditable());
    }

    public void showTab(WAPropertyTab tab) {
        this.m_pnlTabs.setSelectedTab(tab);
    }

    public void removeTabAt(int iTab) {
        WAPropertyTab tab = this.m_pnlTabs.getTabAt(iTab);
        this.removeKeyListeners(tab, this.m_KeyHandler);
        this.m_pnlTabs.removeTabAt(iTab);
    }

    public void removeTab(WAPropertyTab tab) {
        this.removeKeyListeners(tab, this.m_KeyHandler);
        this.m_pnlTabs.removeTab(tab);
    }

    public void removeAllTabs() {
        int nTabs = this.m_pnlTabs.getTabCount();
        for (int iTab = 0; iTab < nTabs; ++iTab) {
            WAPropertyTab tab = this.m_pnlTabs.getTabAt(iTab);
            this.removeKeyListeners(tab, this.m_KeyHandler);
        }
        this.m_pnlTabs.removeAllTabs();
    }

    public int getTabCount() {
        return this.m_pnlTabs.getTabCount();
    }

    @Override
    protected boolean onOK() {
        if (!super.onOK()) {
            return false;
        }
        if ((this.m_stupidObject != null || this.m_oMetadata != null) && this.isEditable()) {
            int iRC;
            if (Workspace.getWorkspace().isServerStatusCheckEnabled() && ((iRC = Workspace.getWorkspace().checkMetadataServerStatus(true)) == Workspace.SERVERSTATUS_ERROR || iRC == Workspace.SERVERSTATUS_PAUSED)) {
                return false;
            }
            this.writeMetadata(true);
            return false;
        }
        return true;
    }

    @Override
    protected boolean onApply() {
        if (!super.onApply()) {
            return false;
        }
        if ((this.m_stupidObject != null || this.m_oMetadata != null) && this.isEditable()) {
            this.writeMetadata(false);
        }
        return true;
    }

    protected void writeMetadata(boolean bCleanUp) {
        try {
            if (this.m_oMetadata instanceof Root) {
                WsMetadataUtil.updateModifiedByFor((Root)this.m_oMetadata);
            }
            if (!this.m_bUpdateToServer) {
                this.uninstallStoreListeners();
                this.m_oStore.flushUpdatesToParentStore();
                this.installStoreListeners();
                if (bCleanUp) {
                    this.dispose();
                }
            } else {
                String str1 = bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt");
                String str2 = bundle.getString("WriteMetadataProgressIndicator.Msg.Title");
                String str3 = bundle.getString("WriteMetadataProgressIndicator.Msg.Cancel.txt");
                OpRequestUI request = new OpRequestUI(Workspace.getWorkspace(), str1, str2, str3);
                request.setDelayBeforeProgressCancelDialog(200);
                Runnable runWrite = new Runnable(){

                    @Override
                    public void run() {
                        WAPropertyDialog.this.doThreadedWrite();
                    }
                };
                Runnable runCleanUp = bCleanUp ? new Runnable(){

                    @Override
                    public void run() {
                        WAPropertyDialog.this.dispose();
                    }
                } : null;
                request.execute(runWrite, runCleanUp);
                Workspace.getDefaultLogger().debug("Finished waiting on write");
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Writing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        catch (Exception ge) {
            Workspace.getDefaultLogger().debug("Error encountered while writing data" + ge.getMessage());
        }
    }

    public void doThreadedWrite() {
        if (this.m_stupidObject != null) {
            Workspace.getDefaultLogger().debug("Starting write");
            try {
                this.m_stupidObject.update();
            }
            catch (ServiceException ex) {
                Workspace.handleServiceException(ex);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
            Workspace.getDefaultLogger().debug("Finished write");
            return;
        }
        this.uninstallStoreListeners();
        Workspace.getDefaultLogger().debug("Starting write");
        try {
            this.m_oMetadata.updateMetadataAll();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Writing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        Workspace.getDefaultLogger().debug("Finished write");
        this.installStoreListeners();
    }

    @Override
    public void dispose() {
        MdObjectStore store = this.m_oStore;
        this.setMetadataObject(null);
        super.dispose();
        if (store != null) {
            try {
                store.dispose();
                Workspace.getMdFactory().dumpDetailHashMap();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        }
        if (this.m_stupidObject != null) {
            try {
                this.m_stupidObject.rollback();
            }
            catch (ServiceException ex) {
                Workspace.handleServiceException(ex);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
            this.m_stupidObject = null;
        }
    }

    public void setMetadataObject(CMetadata oMetadata) {
        if (this.m_oStore != null) {
            this.uninstallStoreListeners();
        }
        this.m_oMetadata = oMetadata;
        if (this.m_oMetadata != null) {
            try {
                this.m_oStore = (MdObjectStore)this.m_oMetadata.getObjectStore();
                this.installStoreListeners();
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)"WAPropertyDialog.setMetadataObject", ex);
                this.m_oStore = null;
            }
        } else {
            this.m_oStore = null;
        }
        Workspace work = Workspace.getWorkspace();
        boolean bEditable = true;
        if (this.m_oMetadata != null) {
            bEditable = work.isObjectEditable(this.m_oMetadata);
        }
        if (!bEditable) {
            this.setEditable(false);
        }
    }

    public CMetadata getMetadataObject() {
        return this.m_oMetadata;
    }

    public void setObjectStore(MdObjectStore oStore) {
        if (this.m_oStore != null) {
            this.m_oMetadata = null;
        }
        this.m_oStore = oStore;
    }

    public MdObjectStore getObjectStore() {
        return this.m_oStore;
    }

    public void setMetadataServiceObject(MetadataInterface object) {
        this.m_stupidObject = object;
        if (this.m_stupidObject != null) {
            try {
                boolean bEditable = this.m_stupidObject != null ? Workspace.getWorkspace().isObjectEditable((CMetadata)this.m_stupidObject.getRepositoryEntity()) : true;
                this.setEditable(bEditable);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        }
    }

    public MetadataInterface getMetadataServiceObject() {
        return this.m_stupidObject;
    }

    public boolean getUpdateToServer() {
        return this.m_bUpdateToServer;
    }

    public void setUpdateToServer(boolean fUpdate) {
        this.m_bUpdateToServer = fUpdate;
    }

    protected VetoableChangeListener createVetoableChangeListener() {
        return new cVetoableChangeListener();
    }

    protected MdStoreListener createStoreChangeListener() {
        return new cStoreChangeListener();
    }

    protected void installStoreListeners() {
        try {
            this.m_oStore.addVetoableChangeListener(this.m_lsnrVetoableChanges);
            this.m_oStore.addMdStoreListener(this.m_lsnrStoreChanges);
        }
        catch (RemoteException ex) {
            Workspace.getDefaultLogger().error((Object)"WAPropertyDialog.installStoreListeners", ex);
        }
    }

    protected void uninstallStoreListeners() {
        try {
            this.m_oStore.removeVetoableChangeListener(this.m_lsnrVetoableChanges);
            this.m_oStore.removeMdStoreListener(this.m_lsnrStoreChanges);
        }
        catch (RemoteException ex) {
            Workspace.getDefaultLogger().error((Object)"WAPropertyDialog.uninstallStoreListeners", ex);
        }
    }

    protected class cStoreChangeListener
    implements MdStoreListener {
        protected cStoreChangeListener() {
        }

        public void MdObjectsAdded(MdEvent e, List lObjects) {
        }

        public void MdObjectsRemoved(MdEvent e, List lObjects) {
        }

        public void MdObjectsModified(MdEvent e, List lObjects) {
            try {
                if (WAPropertyDialog.this.m_pnlMain != null) {
                    WAPropertyDialog.this.m_pnlMain.moveDataToView();
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage(ex, "Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
        }
    }

    protected class cVetoableChangeListener
    implements VetoableChangeListener {
        protected Object m_oNew;
        protected Object m_oOld;

        protected cVetoableChangeListener() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (e.getNewValue() == this.m_oOld && e.getOldValue() == this.m_oNew) {
                this.m_oNew = null;
                this.m_oOld = null;
                return;
            }
            this.m_oNew = e.getNewValue();
            this.m_oOld = e.getOldValue();
            int iRefresh = Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt(WAPropertyDialog.RefreshViewsProperty, 0);
            if (iRefresh == 0) {
                return;
            }
            if (iRefresh == 2) {
                throw new PropertyVetoException("Changes always rejected", e);
            }
            int eAnswer = MessageUtil.displayMessage(bundle.getString("Common.RefreshData.Message.txt"), WAPropertyDialog.this.getTitle(), 2, 0);
            if (eAnswer == 1) {
                throw new PropertyVetoException("Changes rejected by user", e);
            }
        }
    }
}

